/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.content;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.version.common.VersionHistoryImpl;
import org.alfresco.repo.web.scripts.FileTypeImageUtils;
import org.alfresco.service.cmr.ml.ContentFilterLanguagesService;
import org.alfresco.service.cmr.ml.EditionService;
import org.alfresco.service.cmr.ml.MultilingualContentService;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.DownloadContentServlet;
import org.alfresco.web.bean.BrowseBean;
import org.alfresco.web.bean.repository.MapNode;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.UIActionLink;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.extensions.surf.util.ParameterCheck;

public class VersionedDocumentDetailsDialog
implements Serializable {
    private static final long serialVersionUID = 1575175076564595262L;
    private transient VersionService versionService;
    private transient EditionService editionService;
    private transient NodeService nodeService;
    private transient MultilingualContentService multilingualContentService;
    private transient ContentFilterLanguagesService contentFilterLanguagesService;
    private static final Comparator<Version> VERSION_COMPARATOR_DESC = new VersionHistoryImpl.VersionComparatorDesc();
    private boolean fromPreviousEditon;
    private Version documentVersion;
    private VersionHistory versionHistory;
    private Version documentEdition;
    private VersionHistory editionHistory;
    private BrowseBean browseBean;

    public void init() {
        this.fromPreviousEditon = false;
        this.documentVersion = null;
        this.versionHistory = null;
        this.documentEdition = null;
        this.editionHistory = null;
    }

    public void setBrowseBean(BrowseBean browseBean) {
        this.browseBean = browseBean;
    }

    public void setBrowsingVersion(ActionEvent event) {
        this.init();
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String versionLabel = params.get("versionLabel");
        String id = params.get("id");
        String lang = params.get("lang");
        this.setBrowsingVersion(id, versionLabel, lang);
    }

    private void setBrowsingVersion(String id, String versionLabel, String lang) {
        ParameterCheck.mandatoryString((String)"The id of the node", (String)id);
        ParameterCheck.mandatoryString((String)"The version of the node", (String)versionLabel);
        try {
            NodeRef currentNodeRef = new NodeRef(Repository.getStoreRef(), id);
            if (this.getNodeService().getType(currentNodeRef).equals((Object)ContentModel.TYPE_MULTILINGUAL_CONTAINER)) {
                ParameterCheck.mandatoryString((String)"The lang of the node", (String)lang);
                this.fromPreviousEditon = true;
                versionLabel = this.cleanVersionLabel(versionLabel);
                this.editionHistory = this.getEditionService().getEditions(currentNodeRef);
                this.documentEdition = this.editionHistory.getVersion(versionLabel);
                this.documentVersion = this.getBrowsingVersionForMLContainer(currentNodeRef, versionLabel, lang);
            } else {
                this.fromPreviousEditon = false;
                this.versionHistory = this.getVersionService().getVersionHistory(currentNodeRef);
                this.documentVersion = this.getBrowsingVersionForDocument(currentNodeRef, versionLabel);
            }
        }
        catch (InvalidNodeRefException refErr) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_noderef"), id));
        }
    }

    public void nextItem(ActionEvent event) {
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String versionLabel = params.get("versionLabel");
        if (versionLabel == null) {
            ArrayList nextVersions = new ArrayList(this.versionHistory.getSuccessors(this.documentVersion));
            if (nextVersions == null || nextVersions.size() < 1) {
                this.documentVersion = this.versionHistory.getRootVersion();
            } else {
                Collections.sort(nextVersions, VERSION_COMPARATOR_DESC);
                this.documentVersion = (Version)nextVersions.get(0);
            }
        } else {
            this.documentVersion = this.versionHistory.getVersion(versionLabel);
        }
    }

    public void previousItem(ActionEvent event) {
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String versionLabel = params.get("versionLabel");
        if (versionLabel == null) {
            Version prevVersion = this.versionHistory.getPredecessor(this.documentVersion);
            if (prevVersion == null) {
                ArrayList allVersions = new ArrayList(this.versionHistory.getAllVersions());
                this.documentVersion = (Version)allVersions.get(0);
            } else {
                this.documentVersion = prevVersion;
            }
        } else {
            this.documentVersion = this.versionHistory.getVersion(versionLabel);
        }
    }

    public List getTranslations() {
        Map<Locale, NodeRef> translationNodeRef;
        List translationsList = this.getEditionService().getVersionedTranslations(this.documentEdition);
        if (translationsList.size() == 0) {
            translationNodeRef = this.getMultilingualContentService().getTranslations(this.documentEdition.getVersionedNodeRef());
        } else {
            translationNodeRef = new HashMap(translationsList.size());
            for (VersionHistory history : translationsList) {
                ArrayList orderedVersions = new ArrayList(history.getAllVersions());
                Version lastVersion = (Version)orderedVersions.get(0);
                if (lastVersion == null) continue;
                NodeRef versionNodeRef = lastVersion.getFrozenStateNodeRef();
                Locale locale = (Locale)this.getNodeService().getProperty(versionNodeRef, ContentModel.PROP_LOCALE);
                translationNodeRef.put(locale, versionNodeRef);
            }
        }
        ArrayList<MapNode> translations = new ArrayList<MapNode>(translationNodeRef.size());
        for (Map.Entry entry : translationNodeRef.entrySet()) {
            Locale locale = (Locale)entry.getKey();
            NodeRef nodeRef = (NodeRef)entry.getValue();
            MapNode mapNode = new MapNode(nodeRef);
            String lgge = locale != null ? this.getContentFilterLanguagesService().convertToNewISOCode(locale.getLanguage()).toUpperCase() : null;
            mapNode.put("name", (Object)this.getNodeService().getProperty(nodeRef, ContentModel.PROP_NAME));
            mapNode.put("language", (Object)lgge);
            mapNode.put("url", (Object)DownloadContentServlet.generateBrowserURL(nodeRef, mapNode.getName()));
            mapNode.put("notEmpty", (Object)new Boolean(!this.getNodeService().hasAspect(nodeRef, ContentModel.ASPECT_MULTILINGUAL_EMPTY_TRANSLATION)));
            translations.add(mapNode);
        }
        return translations;
    }

    public List getVersionHistory() {
        ArrayList<MapNode> versions = new ArrayList<MapNode>();
        for (Version version : this.versionHistory.getAllVersions()) {
            MapNode clientVersion = new MapNode(version.getFrozenStateNodeRef());
            clientVersion.put("versionLabel", (Object)version.getVersionLabel());
            clientVersion.put("notes", (Object)version.getDescription());
            clientVersion.put("author", (Object)version.getCreator());
            clientVersion.put("versionDate", (Object)version.getCreatedDate());
            if (this.getFrozenStateDocument().hasAspect(ContentModel.ASPECT_MULTILINGUAL_EMPTY_TRANSLATION)) {
                clientVersion.put("url", (Object)null);
            } else {
                clientVersion.put("url", (Object)DownloadContentServlet.generateBrowserURL(version.getFrozenStateNodeRef(), clientVersion.getName()));
            }
            versions.add(clientVersion);
        }
        return versions;
    }

    public boolean isFromPreviousEditon() {
        return this.fromPreviousEditon;
    }

    public String getUrl() {
        return DownloadContentServlet.generateBrowserURL(this.getFrozenStateNodeRef(), this.getName());
    }

    public Node getFrozenStateDocument() {
        Node node = new Node(this.getFrozenStateNodeRef());
        node.addPropertyResolver("mimetype", this.browseBean.resolverMimetype);
        node.addPropertyResolver("encoding", this.browseBean.resolverEncoding);
        node.addPropertyResolver("size", this.browseBean.resolverSize);
        return node;
    }

    public NodeRef getFrozenStateNodeRef() {
        return this.documentVersion.getFrozenStateNodeRef();
    }

    public Node getMultilingualContainerDocument() {
        return new Node(this.documentEdition.getFrozenStateNodeRef());
    }

    public String getName() {
        String name = (String)((Object)this.getNodeService().getProperty(this.getFrozenStateNodeRef(), ContentModel.PROP_NAME));
        return name;
    }

    public String getFileType32() {
        String fileType = FileTypeImageUtils.getFileTypeImage((String)this.getName(), (boolean)false);
        return fileType;
    }

    public boolean isEmptyTranslation() {
        return this.getNodeService().hasAspect(this.getFrozenStateNodeRef(), ContentModel.ASPECT_MULTILINGUAL_EMPTY_TRANSLATION);
    }

    public Version getVersion() {
        return this.documentVersion;
    }

    public String getOutcome() {
        return this.fromPreviousEditon ? "dialog:showMLContainerDetails" : "dialog:showDocDetails";
    }

    private String cleanVersionLabel(String versionLabel) {
        int idx = versionLabel.indexOf(32);
        if (idx > -1) {
            versionLabel = versionLabel.substring(0, idx);
        }
        return versionLabel;
    }

    private Version getBrowsingVersionForDocument(NodeRef document, String versionLabel) {
        return this.getVersionService().getVersionHistory(document).getVersion(versionLabel);
    }

    private Version getBrowsingCurrentVersionForMLContainer(NodeRef document, String lang) {
        NodeRef translation = this.getMultilingualContentService().getTranslationForLocale(document, I18NUtil.parseLocale((String)lang));
        this.versionHistory = this.getVersionService().getVersionHistory(translation);
        return this.getVersionService().getCurrentVersion(translation);
    }

    private Version getBrowsingVersionForMLContainer(NodeRef document, String editionLabel, String lang) {
        List translations = this.getEditionService().getVersionedTranslations(this.documentEdition);
        if (translations.size() == 0) {
            return this.getBrowsingCurrentVersionForMLContainer(document, lang);
        }
        Version versionToReturn = null;
        for (VersionHistory history : translations) {
            Map properties;
            Locale locale;
            ArrayList orderedVersions = new ArrayList(history.getAllVersions());
            Version lastVersion = (Version)orderedVersions.get(0);
            if (lastVersion == null || !(locale = (Locale)(properties = this.getEditionService().getVersionedMetadatas(lastVersion)).get(ContentModel.PROP_LOCALE)).getLanguage().equalsIgnoreCase(lang)) continue;
            versionToReturn = lastVersion;
            this.versionHistory = history;
            break;
        }
        return versionToReturn;
    }

    public void setVersionService(VersionService versionService) {
        this.versionService = versionService;
    }

    protected VersionService getVersionService() {
        if (this.versionService == null) {
            this.versionService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getVersionService();
        }
        return this.versionService;
    }

    public void setEditionService(EditionService editionService) {
        this.editionService = editionService;
    }

    protected EditionService getEditionService() {
        if (this.editionService == null) {
            this.editionService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getEditionService();
        }
        return this.editionService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    protected NodeService getNodeService() {
        if (this.nodeService == null) {
            this.nodeService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getNodeService();
        }
        return this.nodeService;
    }

    public void setContentFilterLanguagesService(ContentFilterLanguagesService contentFilterLanguagesService) {
        this.contentFilterLanguagesService = contentFilterLanguagesService;
    }

    protected ContentFilterLanguagesService getContentFilterLanguagesService() {
        if (this.contentFilterLanguagesService == null) {
            this.contentFilterLanguagesService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getContentFilterLanguagesService();
        }
        return this.contentFilterLanguagesService;
    }

    public void setMultilingualContentService(MultilingualContentService multilingualContentService) {
        this.multilingualContentService = multilingualContentService;
    }

    protected MultilingualContentService getMultilingualContentService() {
        if (this.multilingualContentService == null) {
            this.multilingualContentService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getMultilingualContentService();
        }
        return this.multilingualContentService;
    }
}

