/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.dashboard;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.faces.context.FacesContext;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.dashboard.Column;
import org.alfresco.web.bean.dashboard.Page;
import org.alfresco.web.bean.dashboard.PageConfig;
import org.alfresco.web.bean.repository.PreferencesService;
import org.alfresco.web.config.DashboardsConfigElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.ConfigService;

public class DashboardManager
implements Serializable {
    private static final long serialVersionUID = 6160628072764689380L;
    public static final String BEAN_NAME = "DashboardManager";
    private static Log logger = LogFactory.getLog(DashboardManager.class);
    private static final String PREF_DASHBOARD = "dashboard";
    private static final String LAYOUT_DEFAULT = "default";
    private static final String DASHLET_STARTEDDEFAULT = "getting-started";
    private static final String DASHLET_TASKSDEFAULT = "tasks-todo";
    private static final String JSP_DUMMY = "/jsp/dashboards/dummy.jsp";
    private PageConfig pageConfig = null;
    private transient DashletRenderingList renderingList = null;
    private transient DashletTitleList titleList = null;

    public String getLayoutPage() {
        String layout = null;
        Page page = this.getPageConfig().getCurrentPage();
        if (page != null) {
            layout = page.getLayoutDefinition().JSPPage;
        }
        return layout;
    }

    public void initDashboard() {
        this.renderingList = null;
        this.titleList = null;
    }

    public List getDashletAvailable() {
        if (this.renderingList == null) {
            this.renderingList = new DashletRenderingList(this.getPageConfig());
        }
        return this.renderingList;
    }

    public List getDashletTitle() {
        if (this.titleList == null) {
            this.titleList = new DashletTitleList(this.getPageConfig());
        }
        return this.titleList;
    }

    public String getDashletPage(int index) {
        String page = JSP_DUMMY;
        DashboardsConfigElement.DashletDefinition def = DashboardManager.getDashletDefinitionByIndex(this.getPageConfig(), index);
        if (def != null) {
            page = def.JSPPage;
        }
        return page;
    }

    public PageConfig getPageConfig() {
        if (this.pageConfig == null) {
            PageConfig pageConfig;
            DashboardsConfigElement config = DashboardManager.getDashboardConfig();
            String xml = (String)((Object)PreferencesService.getPreferences().getValue(PREF_DASHBOARD));
            if (xml != null && xml.length() != 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("PageConfig found: " + xml));
                }
                pageConfig = new PageConfig();
                pageConfig.fromXML(config, xml);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"No PageConfig found, creating default instance.");
                }
                pageConfig = new PageConfig();
                DashboardsConfigElement.LayoutDefinition layout = config.getLayoutDefinition(LAYOUT_DEFAULT);
                if (layout != null) {
                    Page page = new Page(LAYOUT_DEFAULT, layout);
                    Column defaultColumn = new Column();
                    if (config.getDefaultDashlets() != null) {
                        for (String id : config.getDefaultDashlets()) {
                            DashboardsConfigElement.DashletDefinition dashlet = config.getDashletDefinition(id);
                            if (dashlet == null) continue;
                            defaultColumn.addDashlet(dashlet);
                        }
                    }
                    page.addColumn(defaultColumn);
                    pageConfig.addPage(page);
                }
            }
            this.pageConfig = pageConfig;
        }
        return this.pageConfig;
    }

    public void savePageConfig(PageConfig config) {
        this.pageConfig = config;
        this.initDashboard();
        PreferencesService.getPreferences().setValue(PREF_DASHBOARD, (Serializable)((Object)this.pageConfig.toXML()));
    }

    public static DashboardsConfigElement getDashboardConfig() {
        ConfigService service = Application.getConfigService(FacesContext.getCurrentInstance());
        DashboardsConfigElement config = (DashboardsConfigElement)service.getConfig((Object)"Dashboards").getConfigElement("dashboards");
        return config;
    }

    private static DashboardsConfigElement.DashletDefinition getDashletDefinitionByIndex(PageConfig config, int index) {
        List<DashboardsConfigElement.DashletDefinition> dashlets;
        DashboardsConfigElement.DashletDefinition def = null;
        DashboardsConfigElement.LayoutDefinition layoutDef = config.getCurrentPage().getLayoutDefinition();
        int selectedColumn = index / layoutDef.ColumnLength;
        List<Column> columns = config.getCurrentPage().getColumns();
        int columnCount = columns.size();
        if (selectedColumn < columnCount && index % layoutDef.ColumnLength < (dashlets = columns.get(selectedColumn).getDashlets()).size()) {
            def = dashlets.get(index % layoutDef.ColumnLength);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Searching for dashlet at index: " + index + " and found " + (def != null ? def.JSPPage : null)));
        }
        return def;
    }

    private static abstract class JSFHelperList
    implements List,
    Serializable {
        private JSFHelperList() {
        }

        public void add(int arg0, Object arg1) {
        }

        public boolean add(Object arg0) {
            return false;
        }

        public boolean addAll(Collection arg0) {
            return false;
        }

        public boolean addAll(int arg0, Collection arg1) {
            return false;
        }

        public void clear() {
        }

        public boolean contains(Object arg0) {
            return false;
        }

        public boolean containsAll(Collection arg0) {
            return false;
        }

        public int indexOf(Object arg0) {
            return 0;
        }

        public boolean isEmpty() {
            return false;
        }

        public Iterator iterator() {
            return null;
        }

        public int lastIndexOf(Object arg0) {
            return 0;
        }

        public ListIterator listIterator() {
            return null;
        }

        public ListIterator listIterator(int arg0) {
            return null;
        }

        public Object remove(int arg0) {
            return null;
        }

        public boolean remove(Object arg0) {
            return false;
        }

        public boolean removeAll(Collection arg0) {
            return false;
        }

        public boolean retainAll(Collection arg0) {
            return false;
        }

        public Object set(int arg0, Object arg1) {
            return null;
        }

        public int size() {
            return 0;
        }

        public List subList(int arg0, int arg1) {
            return null;
        }

        public Object[] toArray() {
            return null;
        }

        public Object[] toArray(Object[] arg0) {
            return null;
        }
    }

    private static class DashletTitleList
    extends JSFHelperList {
        private static final long serialVersionUID = 3522065600475233262L;
        PageConfig config;

        public DashletTitleList(PageConfig config) {
            this.config = config;
        }

        public Object get(int index) {
            String result = "";
            DashboardsConfigElement.DashletDefinition def = DashboardManager.getDashletDefinitionByIndex(this.config, index);
            if (def != null) {
                if (def.LabelId != null) {
                    result = Application.getMessage(FacesContext.getCurrentInstance(), def.LabelId);
                } else if (def.Label != null) {
                    result = def.Label;
                }
            }
            return result;
        }
    }

    private static class DashletRenderingList
    extends JSFHelperList {
        private static final long serialVersionUID = -8611864902847833088L;
        PageConfig config;

        public DashletRenderingList(PageConfig config) {
            this.config = config;
        }

        public Object get(int index) {
            return DashboardManager.getDashletDefinitionByIndex(this.config, index) != null;
        }
    }
}

