/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.dialog;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.context.UIContextService;
import org.alfresco.web.bean.BrowseBean;
import org.alfresco.web.bean.NavigationBean;
import org.alfresco.web.bean.dialog.IDialogBean;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.config.DialogsConfigElement;
import org.alfresco.web.ui.common.ReportedException;
import org.alfresco.web.ui.common.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseDialogBean
implements IDialogBean,
Serializable {
    protected Map<String, String> parameters;
    protected boolean isFinished = false;
    protected BrowseBean browseBean;
    protected NavigationBean navigator;
    private transient TransactionService transactionService;
    private transient NodeService nodeService;
    private transient FileFolderService fileFolderService;
    private transient SearchService searchService;
    private transient DictionaryService dictionaryService;
    private transient NamespaceService namespaceService;

    @Override
    public void init(Map<String, String> parameters) {
        UIContextService.getInstance(FacesContext.getCurrentInstance()).notifyBeans();
        this.parameters = parameters;
        if (this.parameters == null) {
            this.parameters = Collections.emptyMap();
        }
        this.isFinished = false;
    }

    @Override
    public void restored() {
    }

    @Override
    public String cancel() {
        FacesContext.getCurrentInstance().getExternalContext().getSessionMap().remove("externalDialogContainer");
        return this.getDefaultCancelOutcome();
    }

    @Override
    public String finish() {
        final FacesContext context = FacesContext.getCurrentInstance();
        final String defaultOutcome = this.getDefaultFinishOutcome();
        String outcome = null;
        if (!this.isFinished) {
            this.isFinished = true;
            RetryingTransactionHelper txnHelper = Repository.getRetryingTransactionHelper(context);
            RetryingTransactionHelper.RetryingTransactionCallback<String> callback = new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

                public String execute() throws Throwable {
                    return BaseDialogBean.this.finishImpl(context, defaultOutcome);
                }
            };
            try {
                outcome = (String)txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, false, true);
                outcome = this.doPostCommitProcessing(context, outcome);
                context.getExternalContext().getSessionMap().remove("externalDialogContainer");
            }
            catch (Throwable e) {
                this.isFinished = false;
                outcome = this.getErrorOutcome(e);
                if (!(e instanceof ReportedException)) {
                    Utils.addErrorMessage(this.formatErrorMessage(e), e);
                }
                ReportedException.throwIfNecessary(e);
            }
        } else {
            Utils.addErrorMessage(Application.getMessage(context, "error_wizard_completed_already"));
        }
        return outcome;
    }

    @Override
    public boolean isFinished() {
        return this.isFinished;
    }

    @Override
    public List<DialogsConfigElement.DialogButtonConfig> getAdditionalButtons() {
        return null;
    }

    @Override
    public String getCancelButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), "cancel");
    }

    @Override
    public String getFinishButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), "ok");
    }

    @Override
    public boolean getFinishButtonDisabled() {
        return true;
    }

    @Override
    public String getContainerTitle() {
        return null;
    }

    @Override
    public String getContainerSubTitle() {
        return null;
    }

    @Override
    public String getContainerDescription() {
        return null;
    }

    @Override
    public Object getActionsContext() {
        if (this.navigator == null) {
            throw new AlfrescoRuntimeException("To use actions in the dialog the 'navigator' property must be injected with an instance of NavigationBean!");
        }
        return this.navigator.getCurrentNode();
    }

    @Override
    public String getActionsConfigId() {
        return null;
    }

    @Override
    public String getMoreActionsConfigId() {
        return null;
    }

    public void setBrowseBean(BrowseBean browseBean) {
        this.browseBean = browseBean;
    }

    public void setNavigator(NavigationBean navigator) {
        this.navigator = navigator;
    }

    protected TransactionService getTransactionService() {
        if (this.transactionService == null) {
            this.transactionService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getTransactionService();
        }
        return this.transactionService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    protected NodeService getNodeService() {
        if (this.nodeService == null) {
            this.nodeService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getNodeService();
        }
        return this.nodeService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    protected FileFolderService getFileFolderService() {
        if (this.fileFolderService == null) {
            this.fileFolderService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getFileFolderService();
        }
        return this.fileFolderService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    protected SearchService getSearchService() {
        if (this.searchService == null) {
            this.searchService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getSearchService();
        }
        return this.searchService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    protected DictionaryService getDictionaryService() {
        if (this.dictionaryService == null) {
            this.dictionaryService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getDictionaryService();
        }
        return this.dictionaryService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    protected NamespaceService getNamespaceService() {
        if (this.namespaceService == null) {
            this.namespaceService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getNamespaceService();
        }
        return this.namespaceService;
    }

    protected String getDefaultCancelOutcome() {
        return "dialog:close";
    }

    protected String getDefaultFinishOutcome() {
        return "dialog:close";
    }

    protected abstract String finishImpl(FacesContext var1, String var2) throws Throwable;

    protected String doPostCommitProcessing(FacesContext context, String outcome) {
        return outcome;
    }

    protected String getErrorMessageId() {
        return "error_generic";
    }

    protected String getErrorOutcome(Throwable exception) {
        return null;
    }

    protected String formatErrorMessage(Throwable exception) {
        return MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), this.getErrorMessageId()), exception.getMessage());
    }
}

