/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.forums;

import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.model.ForumModel;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.spaces.DeleteSpaceDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteForumsDialog
extends DeleteSpaceDialog {
    private static final long serialVersionUID = -1673691210425371041L;
    protected boolean reDisplayForums;

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.reDisplayForums = false;
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        Node node = this.browseBean.getActionSpace();
        ChildAssociationRef assoc = this.getNodeService().getPrimaryParent(node.getNodeRef());
        if (assoc != null) {
            NodeRef parent = assoc.getParentRef();
            QName parentType = this.getNodeService().getType(parent);
            if (parentType.equals((Object)ForumModel.TYPE_FORUMS)) {
                this.reDisplayForums = true;
            }
        }
        return super.finishImpl(context, outcome);
    }

    @Override
    protected String doPostCommitProcessing(FacesContext context, String outcome) {
        outcome = super.doPostCommitProcessing(context, outcome);
        if (this.reDisplayForums) {
            return "dialog:close:forumsDeleted";
        }
        return outcome;
    }
}

