/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.repository;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.context.FacesContext;
import org.alfresco.model.ContentModel;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.lock.LockStatus;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespacePrefixResolverProvider;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.repository.NodePropertyResolver;
import org.alfresco.web.bean.repository.QNameNodeMap;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.repository.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node
implements Serializable,
NamespacePrefixResolverProvider {
    private static final long serialVersionUID = 3544390322739034170L;
    protected NodeRef nodeRef;
    protected String name;
    protected QName type;
    protected Path path;
    protected String id;
    protected Set<QName> aspects = null;
    protected Map<String, Boolean> permissions;
    protected Boolean locked = null;
    protected Boolean workingCopyOwner = null;
    protected QNameNodeMap<String, Object> properties;
    protected boolean propsRetrieved = false;
    protected transient ServiceRegistry services = null;
    protected boolean childAssocsRetrieved = false;
    protected QNameNodeMap childAssociations;
    protected boolean assocsRetrieved = false;
    protected QNameNodeMap associations;
    private Map<String, Map<String, ChildAssociationRef>> childAssociationsAdded;
    private Map<String, Map<String, ChildAssociationRef>> childAssociationsRemoved;
    private Map<String, Map<String, AssociationRef>> associationsAdded;
    private Map<String, Map<String, AssociationRef>> associationsRemoved;

    public Node(NodeRef nodeRef) {
        if (nodeRef == null) {
            throw new IllegalArgumentException("NodeRef must be supplied for creation of a Node.");
        }
        this.nodeRef = nodeRef;
        this.id = nodeRef.getId();
        this.properties = new QNameNodeMap(this, this);
    }

    public Map<String, Object> getProperties() {
        if (!this.propsRetrieved) {
            Map props = this.getServiceRegistry().getNodeService().getProperties(this.nodeRef);
            for (QName qname : props.keySet()) {
                ArrayList propValue = (ArrayList)props.get(qname);
                if (propValue instanceof List) {
                    propValue = new ArrayList(propValue);
                }
                this.properties.put(qname.toString(), propValue);
            }
            this.propsRetrieved = true;
        }
        return this.properties;
    }

    public final Map getAssociations() {
        if (!this.assocsRetrieved) {
            this.associations = new QNameNodeMap(this, this);
            List assocs = this.getServiceRegistry().getNodeService().getTargetAssocs(this.nodeRef, RegexQNamePattern.MATCH_ALL);
            for (AssociationRef assocRef : assocs) {
                String assocName = assocRef.getTypeQName().toString();
                ArrayList<AssociationRef> list = (ArrayList<AssociationRef>)this.associations.get(assocName);
                if (list == null) {
                    list = new ArrayList<AssociationRef>();
                    this.associations.put(assocName, list);
                }
                list.add(assocRef);
            }
            this.assocsRetrieved = true;
        }
        return this.associations;
    }

    public final Map<String, Map<String, AssociationRef>> getAddedAssociations() {
        if (this.associationsAdded == null) {
            this.associationsAdded = new HashMap<String, Map<String, AssociationRef>>();
        }
        return this.associationsAdded;
    }

    public final Map<String, Map<String, AssociationRef>> getRemovedAssociations() {
        if (this.associationsRemoved == null) {
            this.associationsRemoved = new HashMap<String, Map<String, AssociationRef>>();
        }
        return this.associationsRemoved;
    }

    public final Map getChildAssociations() {
        if (!this.childAssocsRetrieved) {
            this.childAssociations = new QNameNodeMap(this, this);
            List assocs = this.getServiceRegistry().getNodeService().getChildAssocs(this.nodeRef);
            for (ChildAssociationRef assocRef : assocs) {
                String assocName = assocRef.getTypeQName().toString();
                ArrayList<ChildAssociationRef> list = (ArrayList<ChildAssociationRef>)this.childAssociations.get(assocName);
                if (list == null) {
                    list = new ArrayList<ChildAssociationRef>();
                    this.childAssociations.put(assocName, list);
                }
                list.add(assocRef);
            }
            this.childAssocsRetrieved = true;
        }
        return this.childAssociations;
    }

    public final Map<String, Map<String, ChildAssociationRef>> getAddedChildAssociations() {
        if (this.childAssociationsAdded == null) {
            this.childAssociationsAdded = new HashMap<String, Map<String, ChildAssociationRef>>();
        }
        return this.childAssociationsAdded;
    }

    public final Map<String, Map<String, ChildAssociationRef>> getRemovedChildAssociations() {
        if (this.childAssociationsRemoved == null) {
            this.childAssociationsRemoved = new HashMap<String, Map<String, ChildAssociationRef>>();
        }
        return this.childAssociationsRemoved;
    }

    public final void addPropertyResolver(String name, NodePropertyResolver resolver) {
        this.properties.addPropertyResolver(name, resolver);
    }

    public final boolean containsPropertyResolver(String name) {
        return this.properties.containsPropertyResolver(name);
    }

    public final boolean hasProperty(String propertyName) {
        return this.getProperties().containsKey(propertyName);
    }

    public final NodeRef getNodeRef() {
        return this.nodeRef;
    }

    public final String getNodeRefAsString() {
        return this.nodeRef.toString();
    }

    public QName getType() {
        if (this.type == null) {
            this.type = this.getServiceRegistry().getNodeService().getType(this.nodeRef);
        }
        return this.type;
    }

    public String getName() {
        if (this.name == null) {
            this.name = (String)this.getProperties().get("cm:name");
            if (this.name == null) {
                this.name = this.getServiceRegistry().getNodeService().getPrimaryParent(this.nodeRef).getQName().getLocalName();
            }
        }
        return this.name;
    }

    public final Set<QName> getAspects() {
        if (this.aspects == null) {
            this.aspects = this.getServiceRegistry().getNodeService().getAspects(this.nodeRef);
        }
        return this.aspects;
    }

    public final boolean hasAspect(QName aspect) {
        Set<QName> aspects = this.getAspects();
        return aspects.contains(aspect);
    }

    public boolean hasPermission(String permission) {
        Boolean valid = null;
        if (this.permissions != null) {
            valid = this.permissions.get(permission);
        } else {
            this.permissions = new HashMap<String, Boolean>(8, 1.0f);
        }
        if (valid == null) {
            PermissionService service = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getPermissionService();
            valid = service.hasPermission(this.nodeRef, permission) == AccessStatus.ALLOWED;
            this.permissions.put(permission, valid);
        }
        return valid;
    }

    public final String getId() {
        return this.id;
    }

    public String getPath() {
        return this.getNodePath().toString();
    }

    public Path getNodePath() {
        if (this.path == null) {
            this.path = this.getServiceRegistry().getNodeService().getPath(this.nodeRef);
        }
        return this.path;
    }

    public final boolean isLocked() {
        if (this.locked == null) {
            LockStatus lockStatus;
            this.locked = Boolean.FALSE;
            if (this.hasAspect(ContentModel.ASPECT_LOCKABLE) && ((lockStatus = this.getServiceRegistry().getLockService().getLockStatus(this.getNodeRef())) == LockStatus.LOCKED || lockStatus == LockStatus.LOCK_OWNER)) {
                this.locked = Boolean.TRUE;
            }
        }
        return this.locked;
    }

    public final boolean isWorkingCopyOwner() {
        if (this.workingCopyOwner == null) {
            User user;
            Object obj;
            this.workingCopyOwner = Boolean.FALSE;
            if (this.hasAspect(ContentModel.ASPECT_WORKING_COPY) && (obj = this.getProperties().get(ContentModel.PROP_WORKING_COPY_OWNER)) instanceof String && ((String)obj).equals((user = Application.getCurrentUser(FacesContext.getCurrentInstance())).getUserName())) {
                this.workingCopyOwner = Boolean.TRUE;
            }
        }
        return this.workingCopyOwner;
    }

    public void reset() {
        this.name = null;
        this.type = null;
        this.path = null;
        this.locked = null;
        this.workingCopyOwner = null;
        this.properties.clear();
        this.propsRetrieved = false;
        this.aspects = null;
        this.permissions = null;
        this.associations = null;
        this.associationsAdded = null;
        this.associationsRemoved = null;
        this.assocsRetrieved = false;
        this.childAssociations = null;
        this.childAssociationsAdded = null;
        this.childAssociationsRemoved = null;
        this.childAssocsRetrieved = false;
    }

    public String toString() {
        if (this.getServiceRegistry().getNodeService() != null) {
            if (this.getServiceRegistry().getNodeService().exists(this.nodeRef)) {
                return "Node Type: " + this.getType() + "\nNode Properties: " + this.getProperties().toString() + "\nNode Aspects: " + this.getAspects().toString();
            }
            return "Node no longer exists: " + this.nodeRef;
        }
        return super.toString();
    }

    protected ServiceRegistry getServiceRegistry() {
        if (this.services == null) {
            this.services = Repository.getServiceRegistry(FacesContext.getCurrentInstance());
        }
        return this.services;
    }

    public NamespacePrefixResolver getNamespacePrefixResolver() {
        return this.getServiceRegistry().getNamespaceService();
    }
}

