/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.repository;

import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.SessionUser;
import org.alfresco.repo.configuration.ConfigurableService;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.bean.repository.Preferences;
import org.alfresco.web.bean.repository.Repository;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.jsf.FacesContextUtils;

public final class User
implements SessionUser {
    private static final long serialVersionUID = -90577901805847829L;
    private String companyRootId;
    private String homeSpaceId;
    private String userName;
    private String ticket;
    private NodeRef person;
    private String fullName = null;
    private Boolean administrator = null;
    private Preferences preferences = null;

    public User(String userName, String ticket, NodeRef person) {
        if (userName == null || ticket == null || person == null) {
            throw new IllegalArgumentException("All user details are mandatory!");
        }
        this.userName = userName;
        this.ticket = ticket;
        this.person = person;
    }

    public void reset() {
        this.fullName = null;
        this.administrator = null;
        this.preferences = null;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getFullName(NodeService service) {
        if (this.fullName == null) {
            String lastName = (String)((Object)service.getProperty(this.person, ContentModel.PROP_LASTNAME));
            this.fullName = service.getProperty(this.person, ContentModel.PROP_FIRSTNAME) + (lastName != null ? " " + lastName : "");
        }
        return this.fullName;
    }

    public String getHomeSpaceId() {
        return this.homeSpaceId;
    }

    public void setHomeSpaceId(String homeSpaceId) {
        this.homeSpaceId = homeSpaceId;
    }

    public String getCompanyRootId() {
        return this.companyRootId;
    }

    public void setCompanyRootId(String companyRootId) {
        this.companyRootId = companyRootId;
    }

    public String getTicket() {
        return this.ticket;
    }

    public NodeRef getPerson() {
        return this.person;
    }

    public boolean isAdmin() {
        if (this.administrator == null) {
            this.administrator = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAuthorityService().hasAdminAuthority();
        }
        return this.administrator;
    }

    Preferences getPreferences(FacesContext fc) {
        if (this.preferences == null) {
            this.preferences = new Preferences(this.getUserPreferencesRef(FacesContextUtils.getRequiredWebApplicationContext((FacesContext)fc)));
        }
        return this.preferences;
    }

    Preferences getPreferences(ServletContext sc) {
        if (this.preferences == null) {
            this.preferences = new Preferences(this.getUserPreferencesRef(WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)sc)));
        }
        return this.preferences;
    }

    synchronized NodeRef getUserPreferencesRef(WebApplicationContext context) {
        ServiceRegistry registry = (ServiceRegistry)context.getBean("ServiceRegistry");
        final NodeService nodeService = registry.getNodeService();
        final SearchService searchService = registry.getSearchService();
        final NamespaceService namespaceService = registry.getNamespaceService();
        final ConfigurableService configurableService = (ConfigurableService)context.getBean("ConfigurableService");
        RetryingTransactionHelper txnHelper = registry.getRetryingTransactionHelper();
        return (NodeRef)txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Throwable {
                NodeRef configRef;
                NodeRef prefRef = null;
                NodeRef person = User.this.getPerson();
                if (!nodeService.hasAspect(person, ApplicationModel.ASPECT_CONFIGURABLE)) {
                    configurableService.makeConfigurable(person);
                }
                if ((configRef = configurableService.getConfigurationFolder(person)) == null) {
                    throw new IllegalStateException("Unable to find associated 'configurations' folder for node: " + person);
                }
                String xpath = "app:preferences";
                List nodes = searchService.selectNodes(configRef, xpath, null, (NamespacePrefixResolver)namespaceService, false);
                if (nodes.size() == 1) {
                    prefRef = (NodeRef)nodes.get(0);
                } else {
                    ChildAssociationRef childRef = nodeService.createNode(configRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)"preferences"), ContentModel.TYPE_CMOBJECT);
                    prefRef = childRef.getChildRef();
                }
                return prefRef;
            }
        });
    }

    public static String getFullName(NodeService nodeService, NodeRef user) {
        Map props = nodeService.getProperties(user);
        String firstName = (String)props.get(ContentModel.PROP_FIRSTNAME);
        String lastName = (String)props.get(ContentModel.PROP_LASTNAME);
        String fullName = firstName + (lastName != null && lastName.length() > 0 ? " " + lastName : "");
        return fullName;
    }

    public static String getFullNameAndUserId(NodeService nodeService, NodeRef user) {
        String fullName = User.getFullName(nodeService, user);
        String userId = (String)nodeService.getProperties(user).get(ContentModel.PROP_USERNAME);
        StringBuilder nameAndId = new StringBuilder();
        if (fullName != null && fullName.length() > 0 && !fullName.equals("null")) {
            nameAndId.append(fullName);
            nameAndId.append(" ");
        }
        nameAndId.append("[");
        nameAndId.append(userId);
        nameAndId.append("]");
        return nameAndId.toString();
    }
}

