/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.rules.handlers;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.rules.CreateRuleWizard;
import org.alfresco.web.bean.rules.handlers.BaseConditionHandler;
import org.alfresco.web.bean.wizard.IWizardBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareMimeTypeHandler
extends BaseConditionHandler {
    private static final long serialVersionUID = 6421611697032505073L;
    protected static final String PROP_MIMETYPE = "mimetype";

    @Override
    public String getJSPPath() {
        return this.getJSPPath("compare-mime-type");
    }

    @Override
    public void prepareForSave(Map<String, Serializable> conditionProps, Map<String, Serializable> repoProps) {
        String mimeType = (String)((Object)conditionProps.get(PROP_MIMETYPE));
        repoProps.put("value", (Serializable)((Object)mimeType));
    }

    @Override
    public void prepareForEdit(Map<String, Serializable> conditionProps, Map<String, Serializable> repoProps) {
        String mimeType = (String)((Object)repoProps.get("value"));
        conditionProps.put(PROP_MIMETYPE, (Serializable)((Object)mimeType));
    }

    @Override
    public String generateSummary(FacesContext context, IWizardBean wizard, Map<String, Serializable> conditionProps) {
        Boolean not = (Boolean)conditionProps.get("notcondition");
        String msgId = not != false ? "condition_compare_mime_type_not" : "condition_compare_mime_type";
        String label = null;
        String mimetype = (String)((Object)conditionProps.get(PROP_MIMETYPE));
        for (SelectItem item : ((CreateRuleWizard)wizard).getMimeTypes()) {
            if (!item.getValue().equals(mimetype)) continue;
            label = item.getLabel();
            break;
        }
        return MessageFormat.format(Application.getMessage(context, msgId), label);
    }
}

