/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.spaces;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.transaction.UserTransaction;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.GuestTemplateContentServlet;
import org.alfresco.web.bean.BaseDetailsBean;
import org.alfresco.web.bean.dialog.NavigationSupport;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.UIActionLink;

public class SpaceDetailsDialog
extends BaseDetailsBean
implements NavigationSupport {
    private static final long serialVersionUID = -6066782024875635443L;
    private static final String MSG_HAS_FOLLOWING_CATEGORIES = "has_following_categories_space";
    private static final String MSG_NO_CATEGORIES_APPLIED = "no_categories_applied_space";
    private static final String MSG_ERROR_ASPECT_CLASSIFY = "error_aspect_classify_space";
    private static final String MSG_DETAILS_OF = "details_of";
    private static final String MSG_LOCATION = "location";
    private static final String MSG_CLOSE = "close";
    private static final String MSG_LEFT_QUOTE = "left_qoute";
    private static final String MSG_RIGHT_QUOTE = "right_quote";
    private String rssTemplate;

    public SpaceDetailsDialog() {
        this.panels.put("rules-panel", false);
        this.panels.put("dashboard-panel", false);
    }

    public Node getNode() {
        return this.browseBean.getActionSpace();
    }

    public Node getSpace() {
        return this.getNode();
    }

    public String getBrowseUrl() {
        return Utils.generateURL(FacesContext.getCurrentInstance(), this.getNode(), Utils.URLMode.BROWSE);
    }

    protected Node getLinkResolvedNode() {
        Node space = this.getSpace();
        if (ApplicationModel.TYPE_FOLDERLINK.equals((Object)space.getType())) {
            NodeRef destRef = (NodeRef)space.getProperties().get(ContentModel.PROP_LINK_DESTINATION);
            if (this.getNodeService().exists(destRef)) {
                space = new Node(destRef);
            }
        }
        return space;
    }

    public Map getTemplateModel() {
        HashMap<String, Object> model = new HashMap<String, Object>(1, 1.0f);
        model.put("space", this.getSpace().getNodeRef());
        model.put("imageresolver", this.imageResolver);
        return model;
    }

    protected String getPropertiesPanelId() {
        return "space-props";
    }

    public void nextItem(ActionEvent event) {
        boolean foundNextItem = false;
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String id = params.get("id");
        if (id != null && id.length() != 0) {
            NodeRef currNodeRef = new NodeRef(Repository.getStoreRef(), id);
            List<Node> nodes = this.browseBean.getParentNodes(currNodeRef);
            if (nodes.size() > 1) {
                for (int i = 0; i < nodes.size(); ++i) {
                    if (!id.equals(nodes.get(i).getId())) continue;
                    Node next = i != nodes.size() - 1 ? nodes.get(i + 1) : nodes.get(0);
                    this.browseBean.setupSpaceAction(next.getId(), false);
                    foundNextItem = true;
                }
            }
            if (!foundNextItem) {
                Node currNode = new Node(currNodeRef);
                this.navigator.setupDispatchContext(currNode);
            }
        }
    }

    public void previousItem(ActionEvent event) {
        boolean foundPreviousItem = false;
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String id = params.get("id");
        if (id != null && id.length() != 0) {
            NodeRef currNodeRef = new NodeRef(Repository.getStoreRef(), id);
            List<Node> nodes = this.browseBean.getParentNodes(currNodeRef);
            if (nodes.size() > 1) {
                for (int i = 0; i < nodes.size(); ++i) {
                    if (!id.equals(nodes.get(i).getId())) continue;
                    Node previous = i != 0 ? nodes.get(i - 1) : nodes.get(nodes.size() - 1);
                    this.browseBean.setupSpaceAction(previous.getId(), false);
                    foundPreviousItem = true;
                }
            }
            if (!foundPreviousItem) {
                Node currNode = new Node(currNodeRef);
                this.navigator.setupDispatchContext(currNode);
            }
        }
    }

    public String cancel() {
        this.navigator.resetCurrentNodeProperties();
        return super.cancel();
    }

    public boolean isCategorised() {
        return this.getSpace().hasAspect(ContentModel.ASPECT_GEN_CLASSIFIABLE);
    }

    public String getCategoriesOverviewHTML() {
        String html = null;
        if (this.isCategorised()) {
            Collection categories = (Collection)((Object)this.getNodeService().getProperty(this.getSpace().getNodeRef(), ContentModel.PROP_CATEGORIES));
            if (categories == null || categories.size() == 0) {
                html = Application.getMessage(FacesContext.getCurrentInstance(), MSG_NO_CATEGORIES_APPLIED);
            } else {
                StringBuilder builder = new StringBuilder(Application.getMessage(FacesContext.getCurrentInstance(), MSG_HAS_FOLLOWING_CATEGORIES));
                builder.append("<ul>");
                for (NodeRef ref : categories) {
                    if (!this.getNodeService().exists(ref)) continue;
                    builder.append("<li>");
                    builder.append(Repository.getNameForNode(this.getNodeService(), ref));
                    builder.append("</li>");
                }
                builder.append("</ul>");
                html = builder.toString();
            }
        }
        return html;
    }

    public void applyClassifiable() {
        UserTransaction tx = null;
        try {
            tx = Repository.getUserTransaction(FacesContext.getCurrentInstance());
            tx.begin();
            this.getNodeService().addAspect(this.getSpace().getNodeRef(), ContentModel.ASPECT_GEN_CLASSIFIABLE, null);
            tx.commit();
            this.getSpace().reset();
        }
        catch (Throwable e) {
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), MSG_ERROR_ASPECT_CLASSIFY), e.getMessage()), e);
        }
    }

    public boolean isLocked() {
        return this.getSpace().isLocked();
    }

    public boolean isRSSFeed() {
        return SpaceDetailsDialog.hasRSSFeed(this.getSpace());
    }

    public static boolean hasRSSFeed(Node space) {
        return space.hasAspect(ApplicationModel.ASPECT_FEEDSOURCE) && space.getProperties().get(ApplicationModel.PROP_FEEDTEMPLATE) != null;
    }

    public String getRSSFeedURL() {
        return SpaceDetailsDialog.buildRSSFeedURL(this.getSpace());
    }

    public static String buildRSSFeedURL(Node space) {
        return GuestTemplateContentServlet.generateURL(space.getNodeRef(), (NodeRef)space.getProperties().get(ApplicationModel.PROP_FEEDTEMPLATE)) + "/rss.xml?mimetype=text%2Fxml%3Bcharset=utf-8";
    }

    public String getRSSTemplate() {
        NodeRef ref = (NodeRef)this.getNode().getProperties().get(ApplicationModel.PROP_FEEDTEMPLATE);
        return ref != null ? ref.getId() : this.rssTemplate;
    }

    public void setRSSTemplate(String rssTemplate) {
        this.rssTemplate = rssTemplate;
    }

    public void applyRSSTemplate(ActionEvent event) {
        if (this.rssTemplate != null && !this.rssTemplate.equals("none")) {
            try {
                if (!this.getNode().hasAspect(ApplicationModel.ASPECT_FEEDSOURCE)) {
                    this.getNodeService().addAspect(this.getNode().getNodeRef(), ApplicationModel.ASPECT_FEEDSOURCE, null);
                }
                NodeRef templateRef = new NodeRef(Repository.getStoreRef(), this.rssTemplate);
                this.getNodeService().setProperty(this.getNode().getNodeRef(), ApplicationModel.PROP_FEEDTEMPLATE, (Serializable)templateRef);
                this.getNode().reset();
            }
            catch (Exception e) {
                Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_generic"), e.getMessage()), e);
            }
        }
    }

    public void removeRSSTemplate(ActionEvent event) {
        try {
            this.getNodeService().setProperty(this.getNode().getNodeRef(), ApplicationModel.PROP_FEEDTEMPLATE, null);
            this.getNodeService().removeAspect(this.getNode().getNodeRef(), ApplicationModel.ASPECT_FEEDSOURCE);
            this.getNode().reset();
        }
        catch (Exception e) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_generic"), e.getMessage()), e);
        }
    }

    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        return null;
    }

    public String getCurrentItemId() {
        return this.getId();
    }

    public String getCancelButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), MSG_CLOSE);
    }

    public String getContainerSubTitle() {
        return Application.getMessage(FacesContext.getCurrentInstance(), MSG_LOCATION) + ": " + this.getSpace().getNodePath().toDisplayPath(this.getNodeService(), this.getPermissionService());
    }

    public String getContainerTitle() {
        FacesContext fc = FacesContext.getCurrentInstance();
        return Application.getMessage(fc, MSG_DETAILS_OF) + " " + Application.getMessage(fc, MSG_LEFT_QUOTE) + this.getName() + Application.getMessage(fc, MSG_RIGHT_QUOTE);
    }

    public String getOutcome() {
        return "dialog:close:dialog:showSpaceDetails";
    }
}

