/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.trashcan;

import java.text.MessageFormat;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import org.alfresco.repo.node.archive.RestoreNodeReport;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.trashcan.TrashcanDialog;
import org.alfresco.web.ui.common.ReportedException;

public class TrashcanRecoverItemDialog
extends TrashcanDialog {
    private static final long serialVersionUID = -8237457079397611071L;
    private static final String RICHLIST_ID = "trashcan-list";
    private static final String RICHLIST_MSG_ID = "trashcan:trashcan-list";
    private static final String MSG_RECOVERED_ITEM_SUCCESS = "recovered_item_success";
    private static final String MSG_RECOVERED_ITEM_INTEGRITY = "recovered_item_integrity";
    private static final String MSG_RECOVERED_ITEM_PERMISSION = "recovered_item_permission";
    private static final String MSG_RECOVERED_ITEM_PARENT = "recovered_item_parent";
    private static final String MSG_RECOVERED_ITEM_FAILURE = "recovered_item_failure";
    private static final String MSG_LEFT_QUOTE = "left_qoute";
    private static final String MSG_RIGHT_QUOTE = "right_quote";
    private static final String MSG_RECOVER_ITEM = "recover_item";
    private static final String MSG_NO = "no";
    private static final String MSG_YES = "yes";

    private String recoverItem(FacesContext context, String outcome) {
        Node item = this.property.getItem();
        if (item != null) {
            FacesContext fc = context;
            try {
                FacesMessage errorfacesMsg = null;
                RestoreNodeReport report = this.property.getDestination() == null ? this.property.getNodeArchiveService().restoreArchivedNode(item.getNodeRef()) : this.property.getNodeArchiveService().restoreArchivedNode(item.getNodeRef(), this.property.getDestination(), null, null);
                switch (report.getStatus()) {
                    case SUCCESS: {
                        String msg = MessageFormat.format(Application.getMessage(fc, MSG_RECOVERED_ITEM_SUCCESS), item.getName());
                        FacesMessage facesMsg = new FacesMessage(FacesMessage.SEVERITY_INFO, msg, msg);
                        fc.addMessage(RICHLIST_MSG_ID, facesMsg);
                        break;
                    }
                    case FAILURE_INVALID_PARENT: {
                        String msg = MessageFormat.format(Application.getMessage(fc, MSG_RECOVERED_ITEM_PARENT), item.getName());
                        errorfacesMsg = new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, msg);
                        break;
                    }
                    case FAILURE_PERMISSION: {
                        String msg = MessageFormat.format(Application.getMessage(fc, MSG_RECOVERED_ITEM_PERMISSION), item.getName());
                        errorfacesMsg = new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, msg);
                        break;
                    }
                    case FAILURE_INTEGRITY: {
                        String msg = MessageFormat.format(Application.getMessage(fc, MSG_RECOVERED_ITEM_INTEGRITY), item.getName());
                        errorfacesMsg = new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, msg);
                        break;
                    }
                    default: {
                        String reason = report.getCause().getMessage();
                        String msg = MessageFormat.format(Application.getMessage(fc, MSG_RECOVERED_ITEM_FAILURE), item.getName(), reason);
                        errorfacesMsg = new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, msg);
                    }
                }
                if (errorfacesMsg != null) {
                    fc.addMessage(null, errorfacesMsg);
                }
            }
            catch (Throwable err) {
                String reason = err.getMessage();
                String msg = MessageFormat.format(Application.getMessage(fc, MSG_RECOVERED_ITEM_FAILURE), item.getName(), reason);
                FacesMessage facesMsg = new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, msg);
                fc.addMessage(null, facesMsg);
                ReportedException.throwIfNecessary(err);
            }
        }
        return "dialog:close";
    }

    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        return this.recoverItem(context, outcome);
    }

    public String getContainerTitle() {
        FacesContext fc = FacesContext.getCurrentInstance();
        return Application.getMessage(fc, MSG_RECOVER_ITEM) + " " + Application.getMessage(fc, MSG_LEFT_QUOTE) + this.property.getItem().getName() + Application.getMessage(fc, MSG_RIGHT_QUOTE);
    }

    public String getCancelButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), MSG_NO);
    }

    public boolean getFinishButtonDisabled() {
        return false;
    }

    public String getFinishButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), MSG_YES);
    }
}

