/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.io.FileNotFoundException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.SortedMap;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIParameter;
import javax.faces.component.html.HtmlCommandButton;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.model.SelectItem;
import javax.transaction.UserTransaction;
import org.alfresco.model.ContentModel;
import org.alfresco.model.WCMAppModel;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.web.scripts.FileTypeImageUtils;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avmsync.AVMSyncService;
import org.alfresco.service.cmr.repository.FileTypeImageSize;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.TemplateImageResolver;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.wcm.asset.AssetInfo;
import org.alfresco.wcm.sandbox.SandboxInfo;
import org.alfresco.wcm.sandbox.SandboxService;
import org.alfresco.wcm.util.WCMUtil;
import org.alfresco.wcm.webproject.WebProjectInfo;
import org.alfresco.wcm.webproject.WebProjectService;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.context.IContextListener;
import org.alfresco.web.app.context.UIContextService;
import org.alfresco.web.app.servlet.DownloadContentServlet;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.NavigationBean;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.repository.User;
import org.alfresco.web.bean.search.SearchContext;
import org.alfresco.web.bean.wcm.AVMNode;
import org.alfresco.web.bean.wcm.AVMUtil;
import org.alfresco.web.bean.wcm.AVMWorkflowUtil;
import org.alfresco.web.bean.wcm.DeploymentUtil;
import org.alfresco.web.bean.wcm.WebProject;
import org.alfresco.web.forms.FormInstanceData;
import org.alfresco.web.forms.FormNotFoundException;
import org.alfresco.web.forms.FormsService;
import org.alfresco.web.forms.Rendition;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.IBreadcrumbHandler;
import org.alfresco.web.ui.common.component.UIActionLink;
import org.alfresco.web.ui.common.component.UIBreadcrumb;
import org.alfresco.web.ui.common.component.UIModeList;
import org.alfresco.web.ui.common.component.data.UIRichList;
import org.alfresco.web.ui.wcm.component.UIUserSandboxes;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AVMBrowseBean
implements IContextListener {
    private static final long serialVersionUID = -2310105113473561134L;
    public static final String BEAN_NAME = "AVMBrowseBean";
    private static final Log logger = LogFactory.getLog(AVMBrowseBean.class);
    public static final String REQUEST_BEEN_DEPLOYED_RESULT = "_alfBeenDeployedResult";
    private static final String MSG_REVERT_SUCCESS = "revert_success";
    private static final String MSG_REVERT_SANDBOX = "revert_sandbox_success";
    private static final String MSG_SANDBOXTITLE = "sandbox_title";
    private static final String MSG_SANDBOXSTAGING = "sandbox_staging";
    private static final String MSG_CREATED_ON = "store_created_on";
    private static final String MSG_CREATED_BY = "store_created_by";
    private static final String MSG_WORKING_USERS = "store_working_users";
    private static final String MSG_SEARCH_FORM_CONTENT = "search_form_content";
    private static final String MSG_TARGET_IS_DELETED = "target_is_deleted";
    static final String COMPONENT_SANDBOXESPANEL = "sandboxes-panel";
    static final String FORM_ID = "website";
    private String snapshotDateFilter = "today";
    private String sandbox;
    private String username;
    private String webapp;
    private List<SelectItem> webapps;
    private String sandboxTitle = null;
    private String currentPath = null;
    private AVMNode currentPathNode = null;
    private boolean allItemsAction = false;
    private List<String> deploymentMonitorIds = new ArrayList<String>();
    private List<AVMNodeDescriptor> nodesForSubmit = Collections.emptyList();
    private UIRichList foldersRichList;
    private UIRichList filesRichList;
    private UIUserSandboxes userSandboxes;
    private List<Map> files = null;
    private List<Map> folders = null;
    private AVMNode avmNode = null;
    private String lastWebsiteId = null;
    private WebProject webProject = null;
    private List<IBreadcrumbHandler> location = null;
    private boolean showAllSandboxes = false;
    private int pageSizeFolders;
    private int pageSizeFiles;
    private String pageSizeFoldersStr;
    private String pageSizeFilesStr;
    private String websiteQuery;
    private SearchContext searchContext = null;
    private String searchOrigin;
    private transient NodeService nodeService;
    private transient WorkflowService workflowService;
    protected NavigationBean navigator;
    protected transient WebProjectService wpService;
    protected transient SandboxService sbService;
    protected transient AVMService avmService;
    protected transient AVMSyncService avmSyncService;
    protected transient ActionService actionService;
    protected transient FormsService formsService;
    private transient SearchService searchService;
    protected transient PermissionService permissionService;

    public AVMBrowseBean() {
        UIContextService.getInstance(FacesContext.getCurrentInstance()).registerBean(this);
        this.initFromClientConfig();
    }

    public void setWebProjectService(WebProjectService wpService) {
        this.wpService = wpService;
    }

    protected WebProjectService getWebProjectService() {
        if (this.wpService == null) {
            this.wpService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getWebProjectService();
        }
        return this.wpService;
    }

    public void setSandboxService(SandboxService sbService) {
        this.sbService = sbService;
    }

    protected SandboxService getSandboxService() {
        if (this.sbService == null) {
            this.sbService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getSandboxService();
        }
        return this.sbService;
    }

    public void setAvmService(AVMService avmService) {
        this.avmService = avmService;
    }

    protected AVMService getAvmService() {
        if (this.avmService == null) {
            this.avmService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAVMService();
        }
        return this.avmService;
    }

    public void setAvmSyncService(AVMSyncService avmSyncService) {
        this.avmSyncService = avmSyncService;
    }

    protected AVMSyncService getAvmSyncService() {
        if (this.avmSyncService == null) {
            this.avmSyncService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAVMSyncService();
        }
        return this.avmSyncService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public NodeService getNodeService() {
        if (this.nodeService == null) {
            this.nodeService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getNodeService();
        }
        return this.nodeService;
    }

    public void setWorkflowService(WorkflowService service) {
        this.workflowService = service;
    }

    protected WorkflowService getWorkflowService() {
        if (this.workflowService == null) {
            this.workflowService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getWorkflowService();
        }
        return this.workflowService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public SearchService getSearchService() {
        if (this.searchService == null) {
            this.searchService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getSearchService();
        }
        return this.searchService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    protected PermissionService getPermissionService() {
        if (this.permissionService == null) {
            this.permissionService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getPermissionService();
        }
        return this.permissionService;
    }

    public void setNavigationBean(NavigationBean navigator) {
        this.navigator = navigator;
    }

    public void setActionService(ActionService actionService) {
        this.actionService = actionService;
    }

    protected ActionService getActionService() {
        if (this.actionService == null) {
            this.actionService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getActionService();
        }
        return this.actionService;
    }

    public void setFormsService(FormsService formsService) {
        this.formsService = formsService;
    }

    protected FormsService getFormsService() {
        if (this.formsService == null) {
            this.formsService = (FormsService)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "FormsService");
        }
        return this.formsService;
    }

    public int getPageSizeFiles() {
        return this.pageSizeFiles;
    }

    public void setPageSizeFiles(int pageSizeContent) {
        this.pageSizeFiles = pageSizeContent;
        this.pageSizeFilesStr = Integer.toString(pageSizeContent);
    }

    public int getPageSizeFolders() {
        return this.pageSizeFolders;
    }

    public void setPageSizeFolders(int pageSizeSpaces) {
        this.pageSizeFolders = pageSizeSpaces;
        this.pageSizeFoldersStr = Integer.toString(pageSizeSpaces);
    }

    public String getPageSizeFilesStr() {
        return this.pageSizeFilesStr;
    }

    public void setPageSizeFilesStr(String pageSizeContentStr) {
        this.pageSizeFilesStr = pageSizeContentStr;
    }

    public String getPageSizeFoldersStr() {
        return this.pageSizeFoldersStr;
    }

    public void setPageSizeFoldersStr(String pageSizeSpacesStr) {
        this.pageSizeFoldersStr = pageSizeSpacesStr;
    }

    public String getStagingSummary() {
        StringBuilder summary = new StringBuilder(128);
        FacesContext fc = FacesContext.getCurrentInstance();
        ResourceBundle msg = Application.getBundle(fc);
        NodeRef wpNodeRef = this.getWebsite().getNodeRef();
        WebProjectInfo wpInfo = this.getWebProjectService().getWebProject(wpNodeRef);
        SandboxInfo sbInfo = this.getSandboxService().getStagingSandbox(wpInfo.getStoreId());
        if (sbInfo != null) {
            summary.append(msg.getString(MSG_CREATED_ON)).append(": ").append(Utils.getDateFormat(fc).format(sbInfo.getCreatedDate())).append("<p>");
            summary.append(msg.getString(MSG_CREATED_BY)).append(": ").append(sbInfo.getCreator()).append("<p>");
            int numUsers = this.getWebProjectService().getWebUserCount(wpNodeRef);
            summary.append(MessageFormat.format(msg.getString(MSG_WORKING_USERS), numUsers));
        }
        this.currentPath = null;
        return summary.toString();
    }

    public String getStagingStore() {
        return this.getWebProject().getStagingStore();
    }

    public String getStagingPreviewUrl() {
        return AVMUtil.getPreviewURI(this.getStagingStore(), "/www/avm_webapps/" + this.getWebapp());
    }

    public String getSandboxPreviewUrl() {
        return AVMUtil.getPreviewURI(this.getSandbox(), "/www/avm_webapps/" + this.getWebapp());
    }

    public void setFoldersRichList(UIRichList foldersRichList) {
        this.foldersRichList = foldersRichList;
    }

    public UIRichList getFoldersRichList() {
        return this.foldersRichList;
    }

    public UIRichList getFilesRichList() {
        return this.filesRichList;
    }

    public void setFilesRichList(UIRichList filesRichList) {
        this.filesRichList = filesRichList;
    }

    public UIUserSandboxes getUserSandboxes() {
        return this.userSandboxes;
    }

    public void setUserSandboxes(UIUserSandboxes userSandboxes) {
        this.userSandboxes = userSandboxes;
    }

    public String getSandbox() {
        return this.sandbox;
    }

    public void setSandbox(String sandbox) {
        this.sandbox = sandbox;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getWebapp() {
        WebProjectInfo wpInfo;
        Node wpNode;
        if (this.webapp == null && (wpNode = this.getWebsite()) != null && (wpInfo = this.getWebProjectService().getWebProject(wpNode.getNodeRef())) != null) {
            this.webapp = wpInfo.getDefaultWebApp();
        }
        return this.webapp;
    }

    public void setWebapp(String webapp) {
        this.webapp = webapp;
    }

    public List<String> getDeploymentMonitorIds() {
        return this.deploymentMonitorIds;
    }

    public void setDeploymentMonitorIds(List<String> deploymentMonitorIds) {
        this.deploymentMonitorIds = deploymentMonitorIds;
    }

    public List<AVMNodeDescriptor> getNodesForSubmit() {
        return this.nodesForSubmit;
    }

    public void setNodesForSubmit(List<AVMNodeDescriptor> nodesForSubmit) {
        this.nodesForSubmit = nodesForSubmit;
    }

    public List<SelectItem> getWebapps() {
        if (this.webapps == null) {
            List webAppNames = this.getWebProjectService().listWebApps(this.getWebsite().getNodeRef());
            ArrayList<SelectItem> webAppItems = new ArrayList<SelectItem>(webAppNames.size());
            for (String webAppName : webAppNames) {
                webAppItems.add(new SelectItem((Object)webAppName, webAppName));
            }
            this.webapps = webAppItems;
        }
        return this.webapps;
    }

    public int getWebappsSize() {
        return this.getWebapps().size();
    }

    public String getSandboxTitle() {
        if (this.sandboxTitle == null) {
            String forUser = this.username;
            if (forUser == null) {
                forUser = Application.getMessage(FacesContext.getCurrentInstance(), MSG_SANDBOXSTAGING);
            }
            this.sandboxTitle = MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), MSG_SANDBOXTITLE), this.getWebsite().getName(), forUser);
        }
        return this.sandboxTitle;
    }

    public void setSandboxTitle(String sandboxTitle) {
        this.sandboxTitle = sandboxTitle;
    }

    public String getSnapshotDateFilter() {
        return this.snapshotDateFilter;
    }

    public void setSnapshotDateFilter(String snapshotDateFilter) {
        this.snapshotDateFilter = snapshotDateFilter;
    }

    public String getWebsiteQuery() {
        return this.websiteQuery;
    }

    public void setWebsiteQuery(String websiteQuery) {
        this.websiteQuery = websiteQuery;
    }

    public String getIcon() {
        return this.username == null ? "/images/icons/sandbox_large.gif" : "/images/icons/user_sandbox_large.gif";
    }

    public Node getWebsite() {
        Node currentNode = this.navigator.getCurrentNode();
        if (!this.navigator.getCurrentNodeId().equals(this.lastWebsiteId) || !WCMAppModel.TYPE_AVMWEBFOLDER.equals((Object)currentNode.getType())) {
            this.lastWebsiteId = this.navigator.getCurrentNodeId();
            this.webapp = null;
            this.webapps = null;
            this.webProject = null;
        }
        return WCMAppModel.TYPE_AVMWEBFOLDER.equals((Object)currentNode.getType()) ? currentNode : null;
    }

    public WebProject getWebProject() {
        Node website = this.getWebsite();
        if (this.webProject == null && website != null) {
            this.webProject = new WebProject(website.getNodeRef());
        }
        return this.webProject;
    }

    public AVMNode getAvmActionNode() {
        return this.avmNode;
    }

    public void setAvmActionNode(AVMNode avmNode) {
        this.avmNode = avmNode;
    }

    public void setAVMActionNodeDescriptor(AVMNodeDescriptor avmRef) {
        AVMNode avmNode;
        if (avmRef == null) {
            throw new NullPointerException();
        }
        this.avmNode = avmNode = new AVMNode(avmRef);
    }

    public String getCurrentPath() {
        String webApp;
        if (this.currentPath == null && (webApp = this.getWebapp()) != null) {
            this.currentPath = AVMUtil.buildStoreWebappPath(this.getSandbox(), webApp);
        }
        return this.currentPath;
    }

    public void setCurrentPath(String path) {
        this.currentPath = path;
        if (path == null) {
            this.currentPathNode = null;
        }
        this.searchContext = null;
        UIContextService.getInstance(FacesContext.getCurrentInstance()).notifyBeans();
    }

    public AVMNode getCurrentPathNode() {
        if (this.currentPathNode == null) {
            AVMNodeDescriptor node = this.getAvmService().lookup(-1, this.getCurrentPath(), true);
            this.currentPathNode = new AVMNode(node);
        }
        return this.currentPathNode;
    }

    public List<IBreadcrumbHandler> getLocation() {
        if (this.location == null) {
            ArrayList<IBreadcrumbHandler> loc = new ArrayList<IBreadcrumbHandler>(8);
            loc.add(new AVMBreadcrumbHandler(this.getCurrentPath()));
            this.location = loc;
        }
        return this.location;
    }

    public void setLocation(List<IBreadcrumbHandler> location) {
        this.location = location;
    }

    public boolean getHasCustomView() {
        return this.getHasWebscriptView() || this.getHasTemplateView();
    }

    public boolean getHasTemplateView() {
        AVMNode node = this.getCurrentPathNode();
        if (node.hasAspect(ContentModel.ASPECT_TEMPLATABLE)) {
            NodeRef templateRef = (NodeRef)node.getProperties().get(ContentModel.PROP_TEMPLATE);
            return templateRef != null && this.getNodeService().exists(templateRef) && this.getPermissionService().hasPermission(templateRef, "Read") == AccessStatus.ALLOWED;
        }
        return false;
    }

    public boolean getHasWebscriptView() {
        AVMNode node = this.getCurrentPathNode();
        if (node.hasAspect(ContentModel.ASPECT_WEBSCRIPTABLE)) {
            return node.getProperties().get(ContentModel.PROP_WEBSCRIPT) != null;
        }
        return false;
    }

    public String getCurrentNodeTemplate() {
        NodeRef ref = (NodeRef)this.getCurrentPathNode().getProperties().get(ContentModel.PROP_TEMPLATE);
        return ref != null ? ref.toString() : null;
    }

    public String getCurrentNodeWebscript() {
        return (String)this.getCurrentPathNode().getProperties().get(ContentModel.PROP_WEBSCRIPT);
    }

    public Map getTemplateModel() {
        HashMap<String, Object> model = new HashMap<String, Object>(4, 1.0f);
        model.put("space", this.getCurrentPathNode().getNodeRef());
        model.put("path", this.getCurrentPathNode().getPath());
        model.put("imageresolver", new TemplateImageResolver(){

            public String resolveImagePathForName(String filename, FileTypeImageSize size) {
                return FileTypeImageUtils.getFileTypeImage((FacesContext)FacesContext.getCurrentInstance(), (String)filename, (FileTypeImageSize)size);
            }
        });
        return model;
    }

    public Map getCustomWebscriptContext() {
        HashMap<String, String> model = new HashMap<String, String>(2, 1.0f);
        model.put("path", this.getCurrentPathNode().getPath());
        return model;
    }

    public boolean getIsManagerRole() {
        Node wpNode = this.getWebsite();
        if (wpNode != null && this.nodeService.exists(wpNode.getNodeRef())) {
            return this.getWebProjectService().isContentManager(wpNode.getNodeRef());
        }
        return false;
    }

    public boolean getIsManagerOrPublisherRole() {
        Node wpNode = this.getWebsite();
        if (wpNode != null && this.nodeService.exists(wpNode.getNodeRef())) {
            User user = Application.getCurrentUser(FacesContext.getCurrentInstance());
            String userRole = this.getWebProjectService().getWebUserRole(wpNode.getNodeRef(), user.getUserName());
            return "ContentManager".equals(userRole) || "ContentPublisher".equals(userRole);
        }
        return false;
    }

    public boolean getShowAllSandboxes() {
        return this.showAllSandboxes;
    }

    public void setShowAllSandboxes(boolean value) {
        this.showAllSandboxes = value;
    }

    public boolean getHasDeployBeenAttempted() {
        Boolean result = null;
        FacesContext context = FacesContext.getCurrentInstance();
        Map request = context.getExternalContext().getRequestMap();
        if (request.get(REQUEST_BEEN_DEPLOYED_RESULT) == null) {
            if (!this.nodeService.exists(this.getWebsite().getNodeRef())) {
                result = false;
            } else {
                NodeRef webProjectRef = this.getWebsite().getNodeRef();
                String store = (String)((Object)this.getNodeService().getProperty(webProjectRef, WCMAppModel.PROP_AVMSTORE));
                List<NodeRef> deployAttempts = DeploymentUtil.findDeploymentAttempts(store);
                result = new Boolean(deployAttempts != null && deployAttempts.size() > 0);
            }
            request.put(REQUEST_BEEN_DEPLOYED_RESULT, result);
        } else {
            result = (Boolean)request.get(REQUEST_BEEN_DEPLOYED_RESULT);
        }
        return result;
    }

    public SearchContext getSearchContext() {
        return this.searchContext;
    }

    public List<Map> getFolders() {
        if (this.folders == null) {
            if (this.searchContext == null) {
                this.buildDirectoryNodes();
            } else {
                this.buildSearchNodes();
            }
        }
        return this.folders;
    }

    public List<Map> getFiles() {
        if (this.files == null) {
            if (this.searchContext == null) {
                this.buildDirectoryNodes();
            } else {
                this.buildSearchNodes();
            }
        }
        return this.files;
    }

    private void buildDirectoryNodes() {
        UserTransaction tx = null;
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            tx = Repository.getUserTransaction(context, true);
            tx.begin();
            SortedMap nodes = this.getAvmService().getDirectoryListing(-1, this.getCurrentPath());
            this.files = new ArrayList<Map>(nodes.size());
            this.folders = new ArrayList<Map>(nodes.size());
            for (String name : nodes.keySet()) {
                AVMNodeDescriptor avmRef = (AVMNodeDescriptor)nodes.get(name);
                this.addAVMNodeResult(avmRef);
            }
            tx.commit();
        }
        catch (Throwable err) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_generic"), err.getMessage()), err);
            this.folders = Collections.emptyList();
            this.files = Collections.emptyList();
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildSearchNodes() {
        String query = this.searchContext.buildQuery(AVMBrowseBean.getMinimumSearchLength());
        if (query == null) {
            this.folders = Collections.emptyList();
            this.files = Collections.emptyList();
            return;
        }
        UserTransaction tx = null;
        ResultSet results = null;
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            tx = Repository.getUserTransaction(context, true);
            tx.begin();
            SearchParameters sp = new SearchParameters();
            sp.setLanguage("lucene");
            sp.setQuery(query);
            sp.addStore(new StoreRef("avm", this.getStagingStore()));
            int searchLimit = Application.getClientConfig(context).getSearchMaxResults();
            if (searchLimit > 0) {
                sp.setLimitBy(LimitBy.FINAL_SIZE);
                sp.setLimit(searchLimit);
            }
            results = this.getSearchService().query(sp);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Search results returned: " + results.length()));
            }
            boolean isStagingStore = this.getIsStagingStore();
            int sandboxPathLength = AVMUtil.getSandboxPath(this.getCurrentPath()).length();
            this.files = new ArrayList<Map>(results.length());
            this.folders = new ArrayList<Map>(results.length());
            for (ResultSetRow row : results) {
                AVMNodeDescriptor avmRef;
                NodeRef nodeRef = row.getNodeRef();
                String path = (String)AVMNodeConverter.ToAVMVersionPath((NodeRef)nodeRef).getSecond();
                if (!isStagingStore) {
                    path = this.getSandbox() + ':' + AVMUtil.getStoreRelativePath(path);
                }
                if (path.length() <= sandboxPathLength || (avmRef = this.getAvmService().lookup(-1, path)) == null) continue;
                AVMNode node = this.addAVMNodeResult(avmRef);
                node.addPropertyResolver("displayPath", AVMNode.RESOLVER_DISPLAY_PATH);
                node.addPropertyResolver("parentPath", AVMNode.RESOLVER_PARENT_PATH);
            }
            tx.commit();
        }
        catch (Throwable err) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_generic"), err.getMessage()), err);
            this.folders = Collections.emptyList();
            this.files = Collections.emptyList();
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception tex) {
                // empty catch block
            }
        }
        finally {
            if (results != null) {
                results.close();
            }
        }
    }

    private AVMNode addAVMNodeResult(AVMNodeDescriptor avmRef) {
        AVMNode node = new AVMNode(avmRef);
        if (avmRef.isDirectory()) {
            node.getProperties().put("smallIcon", "space_small");
            String type = "";
            type = avmRef.getType() == 3 && avmRef.isPrimary() ? (this.getAvmService().lookup(avmRef.getIndirectionVersion(), avmRef.getIndirection()) != null || avmRef.getOpacity() ? Application.getMessage(FacesContext.getCurrentInstance(), "shared_folder") : Application.getMessage(FacesContext.getCurrentInstance(), "stale_shared_folder")) : Application.getMessage(FacesContext.getCurrentInstance(), "folder");
            node.getProperties().put("folderType", type);
            this.folders.add(node);
        } else {
            String type = "";
            type = avmRef.isLayeredFile() ? (this.getAvmService().lookup(avmRef.getIndirectionVersion(), avmRef.getIndirection()) != null ? Application.getMessage(FacesContext.getCurrentInstance(), "shared_file") : Application.getMessage(FacesContext.getCurrentInstance(), "stale_shared_file")) : Application.getMessage(FacesContext.getCurrentInstance(), "file");
            node.getProperties().put("fileType", type);
            node.getProperties().put("fileType16", FileTypeImageUtils.getFileTypeImage((String)avmRef.getName(), (boolean)true));
            node.getProperties().put("url", DownloadContentServlet.generateBrowserURL(AVMNodeConverter.ToNodeRef((int)-1, (String)avmRef.getPath()), avmRef.getName()));
            this.files.add(node);
        }
        node.addPropertyResolver("previewUrl", AVMNode.RESOLVER_PREVIEW_URL);
        return node;
    }

    public List<AVMNodeDescriptor> getSelectedSandboxItems() {
        return this.userSandboxes.getSelectedNodes(this.username);
    }

    public boolean getAllItemsAction() {
        return this.allItemsAction;
    }

    public boolean getIsStagingStore() {
        return AVMUtil.isMainStore(this.sandbox);
    }

    public void clickFolder(ActionEvent event) {
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String path = params.get("id");
        AVMNodeDescriptor avmNode = this.getAvmService().lookup(-1, path);
        if (avmNode.isLayeredDirectory() && avmNode.isPrimary() && this.getAvmService().lookup(avmNode.getIndirectionVersion(), avmNode.getIndirection()) == null && !avmNode.getOpacity() && this.getAvmService().getDirectoryListingDirect(avmNode, false).isEmpty()) {
            String pattern = Application.getMessage(FacesContext.getCurrentInstance(), MSG_TARGET_IS_DELETED);
            String folderName = path.substring(path.lastIndexOf("/") + 1);
            Utils.addErrorMessage(MessageFormat.format(pattern, folderName));
        } else {
            this.updateUILocation(path);
        }
    }

    public void snapshotDateFilterChanged(ActionEvent event) {
        UIModeList filterComponent = (UIModeList)event.getComponent();
        this.setSnapshotDateFilter(filterComponent.getValue().toString());
    }

    public void setupSandboxAction(ActionEvent event) {
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        this.setupSandboxAction(params.get("store"), params.get("username"));
    }

    public void setupSandboxAction(String store, String username) {
        this.setupSandboxActionImpl(store, null, username, true);
    }

    private void setupSandboxActionImpl(String store, String webapp, String username, boolean reset) {
        this.setUsername(username);
        this.setSandbox(store != null ? store : this.getStagingStore());
        if (webapp != null) {
            this.setWebapp(webapp);
        }
        if (reset) {
            this.sandboxTitle = null;
            this.location = null;
            this.setCurrentPath(null);
            this.setAvmActionNode(null);
            this.allItemsAction = false;
            this.searchOrigin = null;
        }
        this.websiteQuery = null;
    }

    public void setupContentAction(ActionEvent event) {
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        this.setupContentAction(params.get("id"), true);
    }

    void setupContentAction(String path, boolean refresh) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Setup content action for path: " + path));
        }
        if (path == null || path.length() == 0) {
            this.setAvmActionNode(null);
        } else {
            String storeName = AVMUtil.getStoreName(path);
            String storeId = AVMUtil.getStoreId(storeName);
            String webapp = AVMUtil.getWebapp(path);
            String username = AVMUtil.getUserName(storeName);
            if (username == null) {
                storeName = AVMUtil.isPreviewStore(storeName) ? AVMUtil.buildStagingPreviewStoreName(storeId) : AVMUtil.buildStagingStoreName(storeId);
                this.setupSandboxActionImpl(storeName, webapp, null, false);
            } else {
                storeName = AVMUtil.isPreviewStore(storeName) ? AVMUtil.buildUserPreviewStoreName(storeId, username) : AVMUtil.buildUserMainStoreName(storeId, username);
                this.setupSandboxActionImpl(storeName, webapp, username, false);
            }
            if (this.webProject == null) {
                this.webProject = new WebProject(path);
            }
            AVMNodeDescriptor avmNodeDesc = this.getAvmService().lookup(-1, path, true);
            this.setAVMActionNodeDescriptor(avmNodeDesc);
        }
        if (refresh) {
            UIContextService.getInstance(FacesContext.getCurrentInstance()).notifyBeans();
        }
    }

    public void setupEditAction(ActionEvent event) {
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        this.setupEditAction(params.get("id"));
    }

    public void setupEditAction(String path) {
        this.setupContentAction(path, true);
        String avmPath = this.getAvmActionNode().getPath();
        if (this.getAvmService().hasAspect(-1, avmPath, WCMAppModel.ASPECT_RENDITION)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(avmPath + " is a rendition, editing primary rendition instead"));
            }
            try {
                FormInstanceData fid = this.getFormsService().getRendition(-1, avmPath).getPrimaryFormInstanceData();
                avmPath = fid.getPath();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Editing primary form instance data " + avmPath));
                }
                this.setAvmActionNode(new AVMNode(this.getAvmService().lookup(-1, avmPath)));
            }
            catch (IllegalArgumentException iae) {
                logger.warn((Object)iae);
            }
            catch (FileNotFoundException fnfe) {
                logger.warn((Object)fnfe);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Editing AVM node: " + avmPath));
        }
        String outcome = null;
        if (this.getAvmService().hasAspect(-1, avmPath, WCMAppModel.ASPECT_FORM_INSTANCE_DATA)) {
            try {
                this.getFormsService().getFormInstanceData(-1, avmPath).getForm();
                outcome = "wizard:editWebContent";
            }
            catch (FormNotFoundException fnfe) {
                logger.warn((Object)fnfe);
                HashMap<String, String> params = new HashMap<String, String>(2, 1.0f);
                params.put("finishOutcome", "wizard:editWebContent");
                params.put("cancelOutcome", "dialog:editAvmFile");
                Application.getDialogManager().setupParameters(params);
                outcome = "dialog:promptForWebForm";
            }
        } else {
            outcome = "dialog:editAvmFile";
            this.getAvmService().forceCopy(avmPath);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("outcome " + outcome + " for path " + path));
        }
        FacesContext fc = FacesContext.getCurrentInstance();
        fc.getApplication().getNavigationHandler().handleNavigation(fc, null, outcome);
    }

    public void setupAllItemsAction(ActionEvent event) {
        this.setupSandboxAction(event);
        this.allItemsAction = true;
    }

    public void refreshSandbox(ActionEvent event) {
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String store = params.get("store");
        if (store == null) {
            store = this.getStagingStore();
        }
        String webappPath = AVMUtil.buildStoreWebappPath(store, this.getWebapp());
        AVMUtil.updateVServerWebapp(webappPath, true);
    }

    public void revertNode(ActionEvent event) {
        String avmPath = this.getPathFromEventArgs(event);
        String sbStoreId = WCMUtil.getSandboxStoreId((String)avmPath);
        LinkedList<String> namesForDisplayMsg = new LinkedList<String>();
        UserTransaction tx = null;
        FacesContext context = FacesContext.getCurrentInstance();
        try {
            tx = Repository.getUserTransaction(context, false);
            tx.begin();
            AVMNodeDescriptor node = this.getAvmService().lookup(-1, avmPath, true);
            if (node != null) {
                FormInstanceData fid = null;
                if (this.getAvmService().hasAspect(-1, avmPath, WCMAppModel.ASPECT_RENDITION)) {
                    fid = this.getFormsService().getRendition(-1, avmPath).getPrimaryFormInstanceData();
                } else if (this.getAvmService().hasAspect(-1, avmPath, WCMAppModel.ASPECT_FORM_INSTANCE_DATA)) {
                    fid = this.getFormsService().getFormInstanceData(-1, avmPath);
                }
                ArrayList<String> paths = new ArrayList<String>();
                if (fid != null) {
                    paths.add(WCMUtil.getStoreRelativePath((String)fid.getPath()));
                    namesForDisplayMsg.add(fid.getName());
                    for (Rendition r : fid.getRenditions()) {
                        paths.add(WCMUtil.getStoreRelativePath((String)r.getPath()));
                        namesForDisplayMsg.add(r.getName());
                    }
                } else {
                    paths.add(WCMUtil.getStoreRelativePath((String)avmPath));
                    namesForDisplayMsg.add(node.getName());
                }
                this.getSandboxService().revertList(sbStoreId, paths);
            }
            tx.commit();
            this.displayStatusMessage(context, MessageFormat.format(Application.getMessage(context, MSG_REVERT_SUCCESS), StringUtils.join((Object[])namesForDisplayMsg.toArray(), (String)", "), namesForDisplayMsg.size()));
        }
        catch (Throwable err) {
            err.printStackTrace(System.err);
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(context, "error_generic"), err.getMessage()), err);
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception tex) {
                // empty catch block
            }
        }
    }

    public void revertSnapshot(ActionEvent event) {
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String sandbox = params.get("sandbox");
        String strVersion = params.get("version");
        if (sandbox != null && strVersion != null && strVersion.length() != 0) {
            try {
                this.getSandboxService().revertSnapshot(sandbox, Integer.valueOf(strVersion).intValue());
                FacesContext context = FacesContext.getCurrentInstance();
                this.displayStatusMessage(context, MessageFormat.format(Application.getMessage(context, MSG_REVERT_SANDBOX), sandbox, strVersion));
            }
            catch (Throwable err) {
                err.printStackTrace(System.err);
                Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_generic"), err.getMessage()), err);
            }
        }
    }

    public void createFormContent(ActionEvent event) {
        this.setupSandboxAction(event);
        Application.getWizardManager().setupParameters(event);
        FacesContext fc = FacesContext.getCurrentInstance();
        fc.getApplication().getNavigationHandler().handleNavigation(fc, null, "wizard:createWebContent");
    }

    public void searchFormContent(ActionEvent event) {
        this.setupSandboxAction(event);
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String formName = params.get("form-name");
        StringBuilder query = new StringBuilder(256);
        query.append("+ASPECT:\"").append(WCMAppModel.ASPECT_FORM_INSTANCE_DATA).append("\"");
        query.append(" -ASPECT:\"").append(WCMAppModel.ASPECT_RENDITION).append("\"");
        query.append(" +@").append(Repository.escapeQName(WCMAppModel.PROP_PARENT_FORM_NAME)).append(":\"").append(formName).append("\"");
        FormSearchContext searchContext = new FormSearchContext();
        searchContext.setCannedQuery(query.toString(), formName);
        this.searchContext = searchContext;
        this.searchOrigin = "formContent";
    }

    public void promotePendingSubmission(ActionEvent event) {
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String taskId = params.get("taskId");
        UserTransaction tx = null;
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            tx = Repository.getUserTransaction(context, false);
            tx.begin();
            this.getWorkflowService().endTask(taskId, "launch");
            tx.commit();
        }
        catch (Throwable err) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_generic"), err.getMessage()), err);
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception tex) {
                // empty catch block
            }
        }
    }

    public void cancelPendingSubmission(ActionEvent event) {
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String workflowId = params.get("workflowInstanceId");
        UserTransaction tx = null;
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            tx = Repository.getUserTransaction(context, false);
            tx.begin();
            this.getWorkflowService().cancelWorkflow(workflowId);
            tx.commit();
        }
        catch (Throwable err) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_generic"), err.getMessage()), err);
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception tex) {
                // empty catch block
            }
        }
    }

    public void updateFoldersPageSize(ActionEvent event) {
        try {
            int size = Integer.parseInt(this.pageSizeFoldersStr);
            if (size >= 0) {
                this.pageSizeFolders = size;
            } else {
                this.pageSizeFoldersStr = Integer.toString(this.pageSizeFolders);
            }
        }
        catch (NumberFormatException err) {
            this.pageSizeFoldersStr = Integer.toString(this.pageSizeFolders);
        }
    }

    public void updateFilesPageSize(ActionEvent event) {
        try {
            int size = Integer.parseInt(this.pageSizeFilesStr);
            if (size >= 0) {
                this.pageSizeFiles = size;
            } else {
                this.pageSizeFilesStr = Integer.toString(this.pageSizeFiles);
            }
        }
        catch (NumberFormatException err) {
            this.pageSizeFilesStr = Integer.toString(this.pageSizeFiles);
        }
    }

    public void searchWebsite(ActionEvent event) {
        if (this.websiteQuery != null && this.websiteQuery.length() != 0) {
            SearchContext searchContext = new SearchContext();
            searchContext.setText(this.websiteQuery);
            this.searchContext = searchContext;
            this.resetFileFolderLists();
            if (searchContext.buildQuery(AVMBrowseBean.getMinimumSearchLength()) == null) {
                Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "search_minimum"), AVMBrowseBean.getMinimumSearchLength()));
            }
        }
    }

    public void closeSearch(ActionEvent event) {
        this.searchContext = null;
        this.resetFileFolderLists();
        if (this.searchOrigin != null) {
            this.searchOrigin = null;
            FacesContext fc = FacesContext.getCurrentInstance();
            fc.getApplication().getNavigationHandler().handleNavigation(fc, null, "browseWebsite");
        }
    }

    void displayStatusMessage(FacesContext context, String msg) {
        FacesMessage facesMsg = new FacesMessage(FacesMessage.SEVERITY_INFO, msg, msg);
        context.addMessage("website:sandboxes-panel", facesMsg);
    }

    boolean isCurrentPathNull() {
        return this.currentPath == null;
    }

    private void initFromClientConfig() {
        String strPageSize;
        ConfigElement pageConfig;
        ConfigElement viewsConfig;
        ConfigService config = Application.getConfigService(FacesContext.getCurrentInstance());
        ConfigElement wcmConfig = config.getGlobalConfig().getConfigElement("wcm");
        if (wcmConfig != null && (viewsConfig = wcmConfig.getChild("views")) != null && (pageConfig = viewsConfig.getChild("browse-page-size")) != null && (strPageSize = pageConfig.getValue()) != null) {
            int pageSize = Integer.valueOf(strPageSize.trim());
            this.setPageSizeFiles(pageSize);
            this.setPageSizeFolders(pageSize);
        }
    }

    private void updateUILocation(String path) {
        int sandboxPathLength = AVMUtil.getSandboxPath(path).length();
        String currentPath = path;
        this.location.clear();
        while (currentPath.length() != sandboxPathLength) {
            this.location.add(new AVMBreadcrumbHandler(currentPath));
            currentPath = AVMNodeConverter.SplitBase((String)currentPath)[0];
        }
        Collections.reverse(this.location);
        this.setCurrentPath(path);
    }

    private String getPathFromEventArgs(ActionEvent event) {
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        return params.get("id");
    }

    public static int getMinimumSearchLength() {
        return Application.getClientConfig(FacesContext.getCurrentInstance()).getSearchMinimum();
    }

    @Override
    public void contextUpdated() {
        this.resetFileFolderLists();
        this.webapps = null;
    }

    private void resetFileFolderLists() {
        if (this.foldersRichList != null) {
            this.foldersRichList.setValue(null);
        }
        if (this.filesRichList != null) {
            this.filesRichList.setValue(null);
        }
        this.files = null;
        this.folders = null;
        this.webProject = null;
    }

    @Override
    public void areaChanged() {
    }

    @Override
    public void spaceChanged() {
    }

    public void revertAllConflict(ActionEvent event) {
        HtmlCommandButton button = (HtmlCommandButton)event.getComponent();
        List params = button.getChildren();
        String userStorePath = null;
        for (Object obj : params) {
            UIParameter uip = (UIParameter)obj;
            if (!uip.getName().equals("userStorePath")) continue;
            userStorePath = (String)uip.getValue();
        }
        String[] storePath = WCMUtil.splitPath(userStorePath);
        List assets = this.sbService.listChanged(storePath[0], storePath[1], true);
        String sbStoreId = storePath[0];
        ArrayList<String> paths = new ArrayList<String>();
        for (AssetInfo asset : assets) {
            if (asset.getDiffCode() != 2 || AVMWorkflowUtil.isInActiveWorkflow(sbStoreId, asset.getPath())) continue;
            paths.add(asset.getPath());
        }
        this.sbService.revertList(sbStoreId, paths);
    }

    public class FormSearchContext
    extends SearchContext {
        private String cannedQuery = null;
        private String formName;

        public void setCannedQuery(String q, String formName) {
            this.cannedQuery = q;
            this.formName = formName;
        }

        public String buildQuery(int minimum) {
            return this.cannedQuery == null ? super.buildQuery(minimum) : this.cannedQuery;
        }

        public String getText() {
            return this.cannedQuery == null ? super.getText() : MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), AVMBrowseBean.MSG_SEARCH_FORM_CONTENT), this.formName);
        }
    }

    private class AVMBreadcrumbHandler
    implements IBreadcrumbHandler {
        private String path;

        AVMBreadcrumbHandler(String path) {
            this.path = path;
        }

        public String navigationOutcome(UIBreadcrumb breadcrumb) {
            AVMBrowseBean.this.setCurrentPath(this.path);
            AVMBrowseBean.this.setLocation((List)breadcrumb.getValue());
            return null;
        }

        public String toString() {
            if (AVMUtil.buildSandboxRootPath(AVMBrowseBean.this.getSandbox()).equals(this.path)) {
                String label = AVMBrowseBean.this.username;
                if (label == null) {
                    label = Application.getMessage(FacesContext.getCurrentInstance(), AVMBrowseBean.MSG_SANDBOXSTAGING);
                }
                return label;
            }
            return this.path.substring(this.path.lastIndexOf(47) + 1);
        }
    }
}

