/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.io.File;
import java.util.HashMap;
import javax.faces.context.FacesContext;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.content.AddContentDialog;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.AVMBrowseBean;
import org.alfresco.web.bean.wcm.AVMUtil;

public class AddAvmContentDialog
extends AddContentDialog {
    private static final long serialVersionUID = 4019639621892035132L;
    private static final String MSG_OK = "ok";
    private transient AVMService avmService;
    protected AVMBrowseBean avmBrowseBean;
    protected String path;

    public void setAvmService(AVMService avmService) {
        this.avmService = avmService;
    }

    protected AVMService getAvmService() {
        if (this.avmService == null) {
            this.avmService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAVMLockingAwareService();
        }
        return this.avmService;
    }

    public void setAvmBrowseBean(AVMBrowseBean avmBrowseBean) {
        this.avmBrowseBean = avmBrowseBean;
    }

    protected void saveContent(File fileContent, String strContent) throws Exception {
        String parent = this.avmBrowseBean.getCurrentPath();
        this.getAvmService().createFile(parent, this.fileName).close();
        this.path = parent + '/' + this.fileName;
        NodeRef fileNodeRef = AVMNodeConverter.ToNodeRef((int)-1, (String)this.path);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Created AVM file: " + this.path));
        }
        HashMap<QName, String> titledProps = new HashMap<QName, String>(2, 1.0f);
        titledProps.put(ContentModel.PROP_TITLE, this.title);
        titledProps.put(ContentModel.PROP_DESCRIPTION, this.description);
        this.getNodeService().addAspect(fileNodeRef, ContentModel.ASPECT_TITLED, titledProps);
        ContentWriter writer = this.getContentService().getWriter(fileNodeRef, ContentModel.PROP_CONTENT, true);
        writer.setMimetype(this.mimeType);
        writer.setEncoding(this.encoding);
        if (fileContent != null) {
            writer.putContent(fileContent);
        } else {
            writer.putContent(strContent == null ? "" : strContent);
        }
        this.createdNode = fileNodeRef;
    }

    protected String doPostCommitProcessing(FacesContext context, String outcome) {
        this.clearUpload();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Reloading virtualisation server on path: " + this.path));
        }
        AVMUtil.updateVServerWebapp(this.path, false);
        return outcome;
    }

    protected String getDefaultFinishOutcome() {
        return "dialog:close";
    }

    public String cancel() {
        super.cancel();
        return this.getDefaultCancelOutcome();
    }

    public String getFinishButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), MSG_OK);
    }
}

