/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avmsync.AVMSyncService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.wcm.sandbox.SandboxService;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.AVMBrowseBean;
import org.alfresco.web.bean.wcm.AVMUtil;
import org.alfresco.web.bean.wcm.WCMCompareUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompareSnapshotDialog
extends BaseDialogBean {
    private static final Log logger = LogFactory.getLog(CompareSnapshotDialog.class);
    private static final long serialVersionUID = 5483551383286687197L;
    private static final String MSG_CLOSE = "close";
    protected AVMBrowseBean avmBrowseBean;
    private transient SandboxService sandboxService;
    private transient AVMService avmService;
    private transient AVMSyncService avmSyncService;
    protected NodeRef websiteRef;
    protected String store;
    protected NodeRef webProjectRef;
    protected int version;
    protected String sandbox;
    protected String storeRoot;
    protected boolean finished = false;

    public abstract List<Map<String, String>> getComparedNodes();

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.sandbox = parameters.get("sandbox");
        String ver = parameters.get("version");
        this.version = ver != null && ver.length() > 0 ? Integer.parseInt(ver) : -1;
        this.store = parameters.get("store");
        this.storeRoot = AVMUtil.buildSandboxRootPath(this.sandbox);
        String webProject = parameters.get("webproject");
        this.webProjectRef = webProject == null ? this.avmBrowseBean.getWebsite().getNodeRef() : new NodeRef(webProject);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Initialising dialog compare snapshot: " + this.websiteRef));
        }
    }

    @Override
    public String getContainerDescription() {
        int prev = WCMCompareUtils.getPrevVersionID(this.getSandboxService(), this.sandbox, this.version);
        return MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), this.getDescription()), this.version, prev);
    }

    @Override
    public String getCancelButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), MSG_CLOSE);
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        return outcome;
    }

    public AVMBrowseBean getAvmBrowseBean() {
        return this.avmBrowseBean;
    }

    public void setAvmBrowseBean(AVMBrowseBean avmBrowseBean) {
        this.avmBrowseBean = avmBrowseBean;
    }

    public AVMService getAvmService() {
        if (this.avmService == null) {
            this.avmService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAVMService();
        }
        return this.avmService;
    }

    public SandboxService getSandboxService() {
        if (this.sandboxService == null) {
            this.sandboxService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getSandboxService();
        }
        return this.sandboxService;
    }

    public AVMSyncService getAvmSyncService() {
        if (this.avmSyncService == null) {
            this.avmSyncService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAVMSyncService();
        }
        return this.avmSyncService;
    }

    protected abstract String getDescription();

    public String getSandbox() {
        return this.sandbox;
    }
}

