/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;
import javax.faces.model.SelectItem;
import org.alfresco.model.ContentModel;
import org.alfresco.model.WCMAppModel;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.ExpiringValueCache;
import org.alfresco.wcm.preview.PreviewURIService;
import org.alfresco.wcm.webproject.WebProjectInfo;
import org.alfresco.wcm.webproject.WebProjectInfoImpl;
import org.alfresco.wcm.webproject.WebProjectService;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.AVMWorkflowUtil;
import org.alfresco.web.bean.wcm.DeploymentServerConfig;
import org.alfresco.web.bean.wcm.DescriptionAttributeHelper;
import org.alfresco.web.bean.wcm.InviteWebsiteUsersWizard;
import org.alfresco.web.bean.wcm.WorkflowConfiguration;
import org.alfresco.web.bean.wizard.BaseInviteUsersWizard;
import org.alfresco.web.bean.wizard.BaseWizardBean;
import org.alfresco.web.forms.Form;
import org.alfresco.web.forms.FormNotFoundException;
import org.alfresco.web.forms.FormsService;
import org.alfresco.web.forms.RenderingEngineTemplate;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.UIActionLink;
import org.alfresco.web.ui.common.component.UIListItem;
import org.alfresco.web.ui.common.component.UISelectList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateWebsiteWizard
extends BaseWizardBean {
    private static final long serialVersionUID = 6480869380508635173L;
    private static final String MSG_USERROLES = "create_website_summary_users";
    private static final String MSG_SERVER_ALREADY_EXIST = "server_already_exist";
    private static final String COMPONENT_FORMLIST = "form-list";
    private static final String COMPONENT_WORKFLOWLIST = "workflow-list";
    private static final String STEP_DETAILS = "details";
    private static final String STEP_DEPLOYMENT = "deployment";
    private static final String MATCH_DEFAULT = ".*";
    private static final String WEBAPP_DEFAULT = "ROOT";
    private static final String CREATE_EMPTY = "empty";
    private static final String CREATE_EXISTING = "existing";
    protected static final Log logger = LogFactory.getLog(CreateWebsiteWizard.class);
    protected boolean editMode = false;
    protected String dnsName;
    protected String title;
    protected String name;
    protected String description;
    protected String webapp = "ROOT";
    protected String createFrom = null;
    protected boolean isSource;
    protected String previewProvider;
    protected NodeRef wpNodeRef;
    protected String[] sourceWebProject = null;
    protected ExpiringValueCache<List<UIListItem>> webProjectsList;
    protected List<SelectItem> webappsList;
    protected List<SelectItem> previewProvidersList;
    protected boolean showAllSourceProjects;
    protected String websiteDescriptionAttribute;
    private transient WorkflowService workflowService;
    private transient PersonService personService;
    private transient FormsService formsService;
    private transient WebProjectService wpService;
    private transient PreviewURIService previewURIService;
    private boolean createFromValueChanged;
    private transient DataModel formsDataModel = null;
    protected List<UIListItem> formsList = null;
    protected List<FormWrapper> forms = null;
    protected FormWrapper actionForm = null;
    private transient DataModel workflowsDataModel = null;
    protected List<WorkflowWrapper> workflows = null;
    protected WorkflowConfiguration actionWorkflow = null;
    protected Map<String, DeploymentServerConfig> deployServersMap = null;
    protected List<DeploymentServerConfig> deployServersList = null;
    protected DeploymentServerConfig currentDeployServer = null;
    protected Map<String, Object> editedDeployServerProps = null;
    protected boolean inAddDeployServerMode = false;
    protected String addDeployServerType = "file";

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.name = null;
        this.dnsName = null;
        this.title = null;
        this.description = null;
        this.isSource = false;
        this.clearFormsWorkflowsDeploymentAndUsers();
        this.createFrom = CREATE_EMPTY;
        this.webProjectsList = new ExpiringValueCache(10000L);
        this.sourceWebProject = null;
        this.createFromValueChanged = false;
        this.showAllSourceProjects = false;
        this.websiteDescriptionAttribute = null;
    }

    private void clearFormsWorkflowsDeploymentAndUsers() {
        this.formsDataModel = null;
        this.forms = new ArrayList<FormWrapper>(8);
        this.workflowsDataModel = null;
        this.workflows = new ArrayList<WorkflowWrapper>(4);
        this.deployServersMap = new HashMap<String, DeploymentServerConfig>(4, 1.0f);
        this.deployServersList = new ArrayList<DeploymentServerConfig>(4);
        this.currentDeployServer = null;
        this.editedDeployServerProps = new HashMap<String, Object>(12, 1.0f);
        this.inAddDeployServerMode = false;
        this.addDeployServerType = "file";
        InviteWebsiteUsersWizard wiz = this.getInviteUsersWizard();
        wiz.init(null);
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        this.updateModelOnCreateFromChange();
        NodeRef sourceNodeRef = null;
        if (CREATE_EXISTING.equals(this.createFrom) && this.sourceWebProject != null && this.sourceWebProject.length != 0) {
            sourceNodeRef = new NodeRef(this.sourceWebProject[0]);
        }
        WebProjectInfo wpInfo = this.getWebProjectService().createWebProject((WebProjectInfo)new WebProjectInfoImpl(this.dnsName, this.name, this.title, this.description, this.webapp, this.isSource, sourceNodeRef, this.previewProvider));
        String avmStore = wpInfo.getStoreId();
        NodeRef wpNodeRef = wpInfo.getNodeRef();
        NodeRef websiteParent = this.getWebProjectService().getWebProjectsRoot();
        InviteWebsiteUsersWizard wiz = this.getInviteUsersWizard();
        wiz.reset();
        wiz.setNode(new Node(wpNodeRef));
        wiz.setAvmStore(avmStore);
        wiz.setStandalone(false);
        outcome = wiz.finishImpl(context, outcome);
        if (outcome != null) {
            this.saveWebProjectModel(wpNodeRef);
            this.navigator.setCurrentNodeId(websiteParent.getId());
            outcome = "wizard:close";
        }
        return outcome;
    }

    @Override
    public boolean getFinishButtonDisabled() {
        String stepName = Application.getWizardManager().getCurrentStepName();
        return STEP_DETAILS.equals(stepName);
    }

    protected void saveWebProjectModel(NodeRef nodeRef) {
        HashMap<QName, String> props = new HashMap<QName, String>(4, 1.0f);
        for (FormWrapper form : this.forms) {
            props.put(WCMAppModel.PROP_FORMNAME, form.getName());
            NodeRef formRef = this.getNodeService().createNode(nodeRef, WCMAppModel.ASSOC_WEBFORM, WCMAppModel.ASSOC_WEBFORM, WCMAppModel.TYPE_WEBFORM, props).getChildRef();
            props.clear();
            props.put(ContentModel.PROP_TITLE, form.getTitle());
            props.put(ContentModel.PROP_DESCRIPTION, form.getDescription());
            this.getNodeService().addAspect(formRef, ContentModel.ASPECT_TITLED, props);
            if (form.getOutputPathPattern() != null) {
                props.clear();
                props.put(WCMAppModel.PROP_OUTPUT_PATH_PATTERN, form.getOutputPathPattern());
                this.getNodeService().addAspect(formRef, WCMAppModel.ASPECT_OUTPUT_PATH_PATTERN, props);
            }
            if (form.getWorkflow() != null) {
                WorkflowWrapper workflow = form.getWorkflow();
                props.clear();
                props.put(WCMAppModel.PROP_WORKFLOW_NAME, workflow.getName());
                NodeRef workflowRef = this.getNodeService().createNode(formRef, WCMAppModel.ASSOC_WORKFLOWDEFAULTS, WCMAppModel.ASSOC_WORKFLOWDEFAULTS, WCMAppModel.TYPE_WORKFLOW_DEFAULTS, props).getChildRef();
                if (workflow.getParams() != null) {
                    AVMWorkflowUtil.serializeWorkflowParams((Serializable)((Object)workflow.getParams()), workflowRef);
                }
            }
            for (PresentationTemplate template : form.getTemplates()) {
                props.clear();
                props.put(WCMAppModel.PROP_BASE_RENDERING_ENGINE_TEMPLATE_NAME, template.getRenderingEngineTemplate().getName());
                NodeRef templateRef = this.getNodeService().createNode(formRef, WCMAppModel.ASSOC_WEBFORMTEMPLATE, WCMAppModel.ASSOC_WEBFORMTEMPLATE, WCMAppModel.TYPE_WEBFORMTEMPLATE, props).getChildRef();
                if (template.getOutputPathPattern() == null) continue;
                props.clear();
                props.put(WCMAppModel.PROP_OUTPUT_PATH_PATTERN, template.getOutputPathPattern());
                this.getNodeService().addAspect(templateRef, WCMAppModel.ASPECT_OUTPUT_PATH_PATTERN, props);
            }
        }
        for (WorkflowWrapper workflow : this.workflows) {
            props.clear();
            props.put(WCMAppModel.PROP_WORKFLOW_NAME, workflow.getName());
            NodeRef workflowRef = this.getNodeService().createNode(nodeRef, WCMAppModel.ASSOC_WEBWORKFLOWDEFAULTS, WCMAppModel.ASSOC_WEBWORKFLOWDEFAULTS, WCMAppModel.TYPE_WEBWORKFLOWDEFAULTS, props).getChildRef();
            if (workflow.getParams() != null) {
                AVMWorkflowUtil.serializeWorkflowParams((Serializable)((Object)workflow.getParams()), workflowRef);
            }
            if (workflow.getFilenamePattern() == null) continue;
            props.clear();
            props.put(WCMAppModel.PROP_FILENAMEPATTERN, workflow.getFilenamePattern());
            this.getNodeService().addAspect(workflowRef, WCMAppModel.ASPECT_FILENAMEPATTERN, props);
        }
        for (DeploymentServerConfig server : this.deployServersList) {
            Map<QName, Serializable> repoProps = server.getRepoProps();
            this.getNodeService().createNode(nodeRef, WCMAppModel.ASSOC_DEPLOYMENTSERVER, WCMAppModel.ASSOC_DEPLOYMENTSERVER, WCMAppModel.TYPE_DEPLOYMENTSERVER, repoProps);
            if (!logger.isDebugEnabled()) continue;
            HashMap<QName, Object> tempProps = new HashMap<QName, Object>(repoProps.size());
            tempProps.putAll(repoProps);
            tempProps.put(WCMAppModel.PROP_DEPLOYSERVERPASSWORD, "*****");
            logger.debug((Object)("Saved deploymentserver node using repo props: " + tempProps));
        }
    }

    protected void loadWebProjectModel(NodeRef nodeRef, boolean loadProperties, boolean loadUsers) {
        if (loadProperties) {
            WebProjectInfo wpInfo = this.getWebProjectService().getWebProject(nodeRef);
            this.name = wpInfo.getName();
            this.title = wpInfo.getTitle();
            this.description = wpInfo.getDescription();
            this.dnsName = wpInfo.getStoreId();
            this.webapp = wpInfo.getDefaultWebApp();
            this.isSource = wpInfo.isTemplate();
            this.wpNodeRef = wpInfo.getNodeRef();
            this.previewProvider = wpInfo.getPreviewProviderName();
        }
        if (loadUsers) {
            InviteWebsiteUsersWizard wiz = this.getInviteUsersWizard();
            wiz.reset();
            Map userRoles = this.getWebProjectService().listWebUsers(nodeRef);
            for (Map.Entry userRole : userRoles.entrySet()) {
                String username = (String)userRole.getKey();
                String userrole = (String)userRole.getValue();
                wiz.addAuthorityWithRole(username, userrole);
            }
        }
        List webFormRefs = this.getNodeService().getChildAssocs(nodeRef, (QNamePattern)WCMAppModel.ASSOC_WEBFORM, RegexQNamePattern.MATCH_ALL);
        for (ChildAssociationRef ref : webFormRefs) {
            NodeRef formRef = ref.getChildRef();
            String name = (String)((Object)this.getNodeService().getProperty(formRef, WCMAppModel.PROP_FORMNAME));
            try {
                Form formImpl = this.getFormsService().getWebForm(name);
                FormWrapper form = new FormWrapper(formImpl);
                form.setTitle((String)((Object)this.getNodeService().getProperty(formRef, ContentModel.PROP_TITLE)));
                form.setDescription((String)((Object)this.getNodeService().getProperty(formRef, ContentModel.PROP_DESCRIPTION)));
                form.setOutputPathPattern((String)((Object)this.getNodeService().getProperty(formRef, WCMAppModel.PROP_OUTPUT_PATH_PATTERN)));
                List workflowRefs = this.getNodeService().getChildAssocs(formRef, (QNamePattern)WCMAppModel.ASSOC_WORKFLOWDEFAULTS, RegexQNamePattern.MATCH_ALL);
                if (workflowRefs.size() == 1) {
                    NodeRef wfRef = ((ChildAssociationRef)workflowRefs.get(0)).getChildRef();
                    String wfName = (String)((Object)this.getNodeService().getProperty(wfRef, WCMAppModel.PROP_WORKFLOW_NAME));
                    WorkflowDefinition wfDef = this.getWorkflowService().getDefinitionByName(wfName);
                    if (wfDef != null) {
                        WorkflowWrapper wfWrapper = new WorkflowWrapper(wfName, wfDef.getTitle(), wfDef.getDescription());
                        wfWrapper.setParams((Map)((Object)AVMWorkflowUtil.deserializeWorkflowParams(wfRef)));
                        if (wfDef.getStartTaskDefinition() != null) {
                            wfWrapper.setType(wfDef.getStartTaskDefinition().metadata.getName());
                        }
                        form.setWorkflow(wfWrapper);
                    }
                }
                List templateRefs = this.getNodeService().getChildAssocs(formRef, (QNamePattern)WCMAppModel.ASSOC_WEBFORMTEMPLATE, RegexQNamePattern.MATCH_ALL);
                for (ChildAssociationRef tChildRef : templateRefs) {
                    NodeRef templateRef = tChildRef.getChildRef();
                    String renderingEngineTemplateName = (String)((Object)this.getNodeService().getProperty(templateRef, WCMAppModel.PROP_BASE_RENDERING_ENGINE_TEMPLATE_NAME));
                    RenderingEngineTemplate ret = formImpl.getRenderingEngineTemplate(renderingEngineTemplateName);
                    if (ret == null) continue;
                    String outputPathPattern = (String)((Object)this.getNodeService().getProperty(templateRef, WCMAppModel.PROP_OUTPUT_PATH_PATTERN));
                    form.addTemplate(new PresentationTemplate(ret, outputPathPattern));
                }
                this.forms.add(form);
            }
            catch (FormNotFoundException fnfe) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Unable to find Web Form named '" + fnfe.getFormName() + "' as referenced in web project: " + nodeRef.toString()));
            }
        }
        List workflowRefs = this.getNodeService().getChildAssocs(nodeRef, (QNamePattern)WCMAppModel.ASSOC_WEBWORKFLOWDEFAULTS, RegexQNamePattern.MATCH_ALL);
        for (ChildAssociationRef wChildRef : workflowRefs) {
            NodeRef wfRef = wChildRef.getChildRef();
            String wfName = (String)((Object)this.getNodeService().getProperty(wfRef, WCMAppModel.PROP_WORKFLOW_NAME));
            WorkflowDefinition wfDef = this.getWorkflowService().getDefinitionByName(wfName);
            if (wfDef == null) continue;
            WorkflowWrapper wfWrapper = new WorkflowWrapper(wfName, wfDef.getTitle(), wfDef.getDescription());
            wfWrapper.setParams((Map)((Object)AVMWorkflowUtil.deserializeWorkflowParams(wfRef)));
            wfWrapper.setFilenamePattern((String)((Object)this.getNodeService().getProperty(wfRef, WCMAppModel.PROP_FILENAMEPATTERN)));
            if (wfDef.getStartTaskDefinition() != null) {
                wfWrapper.setType(wfDef.getStartTaskDefinition().metadata.getName());
            }
            this.workflows.add(wfWrapper);
        }
        List serverRefs = this.getNodeService().getChildAssocs(nodeRef, (QNamePattern)WCMAppModel.ASSOC_DEPLOYMENTSERVER, RegexQNamePattern.MATCH_ALL);
        for (ChildAssociationRef sChildRef : serverRefs) {
            NodeRef serverRef = sChildRef.getChildRef();
            DeploymentServerConfig server = new DeploymentServerConfig(serverRef, this.getNodeService().getProperties(serverRef));
            this.deployServersList.add(server);
            this.deployServersMap.put(server.getId(), server);
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Loaded deploy server config: " + server));
        }
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    protected WorkflowService getWorkflowService() {
        if (this.workflowService == null) {
            this.workflowService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getWorkflowService();
        }
        return this.workflowService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    protected PersonService getPersonService() {
        if (this.personService == null) {
            this.personService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getPersonService();
        }
        return this.personService;
    }

    public void setFormsService(FormsService formsService) {
        this.formsService = formsService;
    }

    protected FormsService getFormsService() {
        if (this.formsService == null) {
            this.formsService = (FormsService)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "FormsService");
        }
        return this.formsService;
    }

    public void setWebProjectService(WebProjectService wpService) {
        this.wpService = wpService;
    }

    protected WebProjectService getWebProjectService() {
        if (this.wpService == null) {
            this.wpService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getWebProjectService();
        }
        return this.wpService;
    }

    public void setPreviewURIService(PreviewURIService previewURIService) {
        this.previewURIService = previewURIService;
    }

    protected PreviewURIService getPreviewURIService() {
        if (this.previewURIService == null) {
            this.previewURIService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getPreviewURIService();
        }
        return this.previewURIService;
    }

    public boolean getEditMode() {
        return this.editMode;
    }

    public void setEditMode(boolean editMode) {
        this.editMode = editMode;
    }

    protected NodeRef getWebProjectNodeRef() {
        return this.wpNodeRef;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDnsName() {
        return this.dnsName;
    }

    public void setDnsName(String dnsName) {
        this.dnsName = dnsName;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getWebapp() {
        return this.webapp;
    }

    public void setWebapp(String webapp) {
        this.webapp = webapp;
    }

    public String getPreviewProvider() {
        return this.previewProvider;
    }

    public void setPreviewProvider(String previewProvider) {
        this.previewProvider = previewProvider;
    }

    public String getCreateFrom() {
        return this.createFrom;
    }

    public void setCreateFrom(String createFrom) {
        if (createFrom != null && !createFrom.equals(this.createFrom)) {
            this.createFromValueChanged = true;
        }
        this.createFrom = createFrom;
    }

    public String[] getSourceWebProject() {
        return this.sourceWebProject;
    }

    public void setSourceWebProject(String[] existingWebProject) {
        if (this.sourceWebProject != null && this.sourceWebProject.length != 0) {
            if (existingWebProject == null || existingWebProject.length == 0 || !existingWebProject[0].equals(this.sourceWebProject[0])) {
                this.createFromValueChanged = true;
            }
        } else if (existingWebProject != null && existingWebProject.length != 0) {
            this.createFromValueChanged = true;
        }
        this.sourceWebProject = existingWebProject;
    }

    public String getSourceWebProjectName() {
        String name = null;
        if (CREATE_EXISTING.equals(this.createFrom) && this.sourceWebProject != null && this.sourceWebProject.length != 0) {
            NodeRef sourceNodeRef = new NodeRef(this.sourceWebProject[0]);
            name = (String)((Object)this.getNodeService().getProperty(sourceNodeRef, ContentModel.PROP_NAME));
        }
        return name;
    }

    public boolean isSource() {
        return this.isSource;
    }

    public void setSource(boolean isSource) {
        this.isSource = isSource;
    }

    public List<UIListItem> getWebProjectsList() {
        ArrayList<UIListItem> webProjects = (ArrayList<UIListItem>)this.webProjectsList.get();
        if (webProjects == null) {
            List wps = this.getWebProjectService().listWebProjects();
            webProjects = new ArrayList<UIListItem>(wps.size());
            for (WebProjectInfo wpInfo : wps) {
                if (!this.showAllSourceProjects && !wpInfo.isTemplate()) continue;
                UIListItem item = new UIListItem();
                item.setLabel(wpInfo.getName());
                item.setDescription(wpInfo.getDescription());
                item.setValue(wpInfo.getNodeRef().toString());
                item.setImage("/images/icons/website_large.gif");
                webProjects.add(item);
            }
            this.webProjectsList.put(webProjects);
        }
        return webProjects;
    }

    public void toggleWebProjectsList(ActionEvent event) {
        this.showAllSourceProjects = !this.showAllSourceProjects;
        this.webProjectsList.clear();
        this.createFromValueChanged = true;
    }

    public boolean getShowAllSourceProjects() {
        return this.showAllSourceProjects;
    }

    public List<SelectItem> getWebappsList() {
        if (this.webappsList == null) {
            this.webappsList = new ArrayList<SelectItem>(1);
            this.webappsList.add(new SelectItem((Object)WEBAPP_DEFAULT, WEBAPP_DEFAULT));
        }
        return this.webappsList;
    }

    public List<SelectItem> getPreviewProvidersList() {
        if (this.previewProvidersList == null) {
            String defaultPreviewProvider = this.getPreviewURIService().getDefaultProviderName();
            Set previewProviders = this.getPreviewURIService().getProviderNames();
            this.previewProvidersList = new ArrayList<SelectItem>(previewProviders.size());
            this.previewProvidersList.add(new SelectItem((Object)defaultPreviewProvider, defaultPreviewProvider));
            for (String previewProvider : previewProviders) {
                if (previewProvider.equals(defaultPreviewProvider)) continue;
                this.previewProvidersList.add(new SelectItem((Object)previewProvider, previewProvider));
            }
        }
        return this.previewProvidersList;
    }

    @Override
    public String next() {
        String stepName = Application.getWizardManager().getCurrentStepName();
        if (STEP_DEPLOYMENT.equals(stepName)) {
            this.updateModelOnCreateFromChange();
        }
        return super.next();
    }

    private void updateModelOnCreateFromChange() {
        if (this.createFromValueChanged) {
            if (CREATE_EXISTING.equals(this.createFrom)) {
                if (this.sourceWebProject != null && this.sourceWebProject.length != 0) {
                    this.clearFormsWorkflowsDeploymentAndUsers();
                    this.loadWebProjectModel(new NodeRef(this.sourceWebProject[0]), false, true);
                }
            } else {
                this.clearFormsWorkflowsDeploymentAndUsers();
            }
            this.createFromValueChanged = false;
        }
    }

    public String getSummary() {
        FacesContext fc = FacesContext.getCurrentInstance();
        StringBuilder buf = new StringBuilder(128);
        List invitedUserRoles = (List)this.getInviteUsersWizard().getUserRolesDataModel().getWrappedData();
        String currentUser = Application.getCurrentUser(fc).getUserName();
        boolean foundCurrentUser = false;
        for (BaseInviteUsersWizard.UserGroupRole userRole : invitedUserRoles) {
            if (currentUser.equals(userRole.getAuthority())) {
                foundCurrentUser = true;
            }
            buf.append(Utils.encode((String)userRole.getLabel()));
            buf.append("<br>");
        }
        if (!foundCurrentUser) {
            buf.append(this.getInviteUsersWizard().buildLabelForUserAuthorityRole(currentUser, "ContentManager"));
        }
        return this.buildSummary(new String[]{Application.getMessage(fc, MSG_USERROLES)}, new String[]{buf.toString()});
    }

    public List<UserWrapper> getInvitedUsers() {
        FacesContext fc = FacesContext.getCurrentInstance();
        List invitedUserRoles = (List)this.getInviteUsersWizard().getUserRolesDataModel().getWrappedData();
        LinkedList<UserWrapper> result = new LinkedList<UserWrapper>();
        String currentUser = Application.getCurrentUser(fc).getUserName();
        boolean foundCurrentUser = false;
        for (BaseInviteUsersWizard.UserGroupRole userRole : invitedUserRoles) {
            if (currentUser.equals(userRole.getAuthority())) {
                foundCurrentUser = true;
            }
            result.add(new UserWrapper(userRole.getAuthority(), userRole.getRole()));
        }
        if (!foundCurrentUser) {
            result.add(new UserWrapper(currentUser, "ContentManager"));
        }
        return result;
    }

    public boolean isInAddDeployServerMode() {
        return this.inAddDeployServerMode;
    }

    public String getAddDeployServerType() {
        return this.addDeployServerType;
    }

    public DeploymentServerConfig getCurrentDeployServer() {
        return this.currentDeployServer;
    }

    public Map<String, Object> getEditedDeployServerProperties() {
        return this.editedDeployServerProps;
    }

    public List<DeploymentServerConfig> getDeployServers() {
        return this.deployServersList;
    }

    public String addAlfrescoServerReceiver() {
        this.addDeployServerType = "alfresco";
        this.inAddDeployServerMode = true;
        this.currentDeployServer = new DeploymentServerConfig(this.addDeployServerType);
        this.editedDeployServerProps.clear();
        return null;
    }

    public String addFileSystemReceiver() {
        this.addDeployServerType = "file";
        this.inAddDeployServerMode = true;
        this.currentDeployServer = new DeploymentServerConfig(this.addDeployServerType);
        this.editedDeployServerProps.clear();
        return null;
    }

    public void editDeploymentServerConfig(ActionEvent event) {
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String id = params.get("id");
        if (id != null && id.length() != 0) {
            this.inAddDeployServerMode = false;
            this.currentDeployServer = this.deployServersMap.get(id);
            this.editedDeployServerProps.clear();
            this.editedDeployServerProps.putAll(this.currentDeployServer.getProperties());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Set current deploy server to: " + this.currentDeployServer));
            }
        }
    }

    public void deleteDeploymentServerConfig(ActionEvent event) {
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String id = params.get("id");
        if (id != null && id.length() != 0) {
            this.currentDeployServer = null;
            this.editedDeployServerProps.clear();
            this.inAddDeployServerMode = false;
            DeploymentServerConfig dsc = this.deployServersMap.get(id);
            if (dsc != null) {
                this.deployServersList.remove(dsc);
                this.deployServersMap.remove(dsc.getId());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Removed deploy server config with id: " + id));
                }
            }
        }
    }

    public String addDeploymentServerConfig() {
        this.deployServersList.add(this.currentDeployServer);
        this.deployServersMap.put(this.currentDeployServer.getId(), this.currentDeployServer);
        return this.saveDeploymentServerConfig();
    }

    public String saveDeploymentServerConfig() {
        String currentServerName = (String)this.editedDeployServerProps.get("name");
        if (currentServerName == null || currentServerName.length() == 0) {
            currentServerName = "" + this.editedDeployServerProps.get("host") + ":" + this.editedDeployServerProps.get("port");
        }
        for (DeploymentServerConfig server : this.deployServersList) {
            if (server.getId().equals(this.currentDeployServer.getId())) continue;
            Map<String, Object> serverProps = server.getProperties();
            String serverName = (String)serverProps.get("name");
            if (serverName == null || serverName.length() == 0) {
                serverName = "" + serverProps.get("host") + ":" + serverProps.get("port");
            }
            if (!currentServerName.equals(serverName)) continue;
            if (this.inAddDeployServerMode) {
                this.deployServersList.remove(this.currentDeployServer);
                this.deployServersMap.remove(this.currentDeployServer.getId());
            }
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), MSG_SERVER_ALREADY_EXIST), currentServerName));
            return null;
        }
        this.currentDeployServer.setProperties(this.editedDeployServerProps);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Saved transient deploy server config: " + this.currentDeployServer));
        }
        this.currentDeployServer = null;
        this.editedDeployServerProps.clear();
        this.inAddDeployServerMode = false;
        return null;
    }

    public String cancelDeploymentServerConfig() {
        this.currentDeployServer = null;
        this.editedDeployServerProps.clear();
        this.inAddDeployServerMode = false;
        return null;
    }

    public DataModel getFormsDataModel() {
        if (this.formsDataModel == null) {
            this.formsDataModel = new ListDataModel();
        }
        if (this.formsDataModel.getWrappedData() == null) {
            this.formsDataModel.setWrappedData(this.forms);
        }
        return this.formsDataModel;
    }

    public List<FormWrapper> getForms() {
        return this.forms;
    }

    public void setFormsDataModel(DataModel formsDataModel) {
        this.formsDataModel = formsDataModel;
    }

    public List<UIListItem> getFormsList() {
        Collection<Form> forms = this.getFormsService().getWebForms();
        ArrayList<UIListItem> items = new ArrayList<UIListItem>(forms.size());
        for (Form form : forms) {
            UIListItem item = new UIListItem();
            item.setValue(form);
            item.setLabel(form.getTitle());
            item.setDescription(form.getDescription());
            item.setImage("/images/icons/webform_large.gif");
            boolean skip = false;
            for (FormWrapper formWrapper : this.forms) {
                if (!formWrapper.getTitle().equals(form.getTitle())) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            items.add(item);
        }
        this.formsList = items;
        return items;
    }

    public void addForm(ActionEvent event) {
        UISelectList selectList = (UISelectList)event.getComponent().findComponent(COMPONENT_FORMLIST);
        int index = selectList.getRowIndex();
        if (index != -1 && index < this.formsList.size()) {
            Form form = (Form)this.formsList.get(index).getValue();
            FormWrapper wrapper = new FormWrapper(form);
            wrapper.setTitle(form.getTitle());
            wrapper.setDescription(form.getDescription());
            this.forms.add(wrapper);
        }
    }

    public void removeForm(ActionEvent event) {
        FormWrapper wrapper = (FormWrapper)this.getFormsDataModel().getRowData();
        if (wrapper != null) {
            this.forms.remove(wrapper);
        }
    }

    public void setupFormAction(ActionEvent event) {
        this.setActionForm((FormWrapper)this.getFormsDataModel().getRowData());
    }

    public FormWrapper getActionForm() {
        return this.actionForm;
    }

    public void setActionForm(FormWrapper actionForm) {
        this.actionForm = actionForm;
        if (actionForm != null) {
            this.setActionWorkflow(actionForm.getWorkflow());
        } else {
            this.setActionWorkflow(null);
        }
    }

    public void setupWorkflowAction(ActionEvent event) {
        this.setActionWorkflow((WorkflowConfiguration)this.getWorkflowsDataModel().getRowData());
    }

    public WorkflowConfiguration getActionWorkflow() {
        return this.actionWorkflow;
    }

    public void setActionWorkflow(WorkflowConfiguration actionWorkflow) {
        this.actionWorkflow = actionWorkflow;
    }

    public DataModel getWorkflowsDataModel() {
        if (this.workflowsDataModel == null) {
            this.workflowsDataModel = new ListDataModel();
        }
        if (this.workflowsDataModel.getWrappedData() == null) {
            this.workflowsDataModel.setWrappedData(this.workflows);
        }
        return this.workflowsDataModel;
    }

    public void setWorkflowsDataModel(DataModel workflowsDataModel) {
        this.workflowsDataModel = workflowsDataModel;
    }

    public List<WorkflowWrapper> getWorkflows() {
        return this.workflows;
    }

    public List<UIListItem> getWorkflowList() {
        List<WorkflowDefinition> workflowDefs = AVMWorkflowUtil.getConfiguredWorkflows();
        ArrayList<UIListItem> items = new ArrayList<UIListItem>(workflowDefs.size());
        for (WorkflowDefinition workflowDef : workflowDefs) {
            UIListItem item = new UIListItem();
            item.setValue(workflowDef);
            item.setLabel(workflowDef.title);
            item.setDescription(workflowDef.description);
            item.setImage("/images/icons/workflow_large.gif");
            boolean skip = false;
            for (WorkflowWrapper workflowWrapper : this.workflows) {
                if (!workflowWrapper.getTitle().equals(workflowDef.getTitle())) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            items.add(item);
        }
        return items;
    }

    public void addWorkflow(ActionEvent event) {
        UISelectList selectList = (UISelectList)event.getComponent().findComponent(COMPONENT_WORKFLOWLIST);
        int index = selectList.getRowIndex();
        List<UIListItem> workflowsList = this.getWorkflowList();
        if (index != -1 && index < workflowsList.size()) {
            WorkflowDefinition workflow = (WorkflowDefinition)workflowsList.get(index).getValue();
            this.workflows.add(new WorkflowWrapper(workflow.getName(), workflow.getTitle(), workflow.getDescription(), MATCH_DEFAULT));
        }
    }

    public void removeWorkflow(ActionEvent event) {
        WorkflowWrapper wrapper = (WorkflowWrapper)this.getWorkflowsDataModel().getRowData();
        if (wrapper != null) {
            this.workflows.remove(wrapper);
        }
    }

    public String getWebsiteDescriptionAttribute() {
        if (this.websiteDescriptionAttribute == null) {
            this.websiteDescriptionAttribute = this.buildWebsiteDescriptionAttribute();
        }
        return this.websiteDescriptionAttribute;
    }

    public String getWebsiteLabelAttribute() {
        StringBuilder builder = new StringBuilder("<b>");
        builder.append(Utils.encode((String)this.name));
        builder.append("</b>");
        return builder.toString();
    }

    private String buildWebsiteDescriptionAttribute() {
        FacesContext fc = FacesContext.getCurrentInstance();
        StringBuilder attribute = new StringBuilder(255);
        String sourceWebProjectName = this.getSourceWebProjectName();
        sourceWebProjectName = StringUtils.isEmpty((String)sourceWebProjectName) ? "" : "<tr><td>" + Application.getMessage(fc, "website_sourcewebsite") + ":</td><td>" + sourceWebProjectName + "</td></tr>";
        attribute.append(DescriptionAttributeHelper.getTableBegin());
        attribute.append(sourceWebProjectName);
        attribute.append(DescriptionAttributeHelper.getTableLine(fc, "website_dnsname", this.getDnsName()));
        attribute.append(DescriptionAttributeHelper.getTableLine(fc, "website_webapp", this.getWebapp()));
        attribute.append(DescriptionAttributeHelper.getTableLine(fc, "title", this.getTitle()));
        attribute.append(DescriptionAttributeHelper.getTableLine(fc, "description", DescriptionAttributeHelper.getDescriptionNotEmpty(fc, this.getDescription()), false));
        attribute.append(DescriptionAttributeHelper.getTableLine(fc, "website_preview_provider", this.getPreviewProvider()));
        attribute.append(DescriptionAttributeHelper.getTableEnd());
        return attribute.toString();
    }

    private InviteWebsiteUsersWizard getInviteUsersWizard() {
        return (InviteWebsiteUsersWizard)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "InviteWebsiteUsersWizard");
    }

    public class UserWrapper
    implements Serializable {
        private static final long serialVersionUID = 6546685548198253273L;
        private final String name;
        private final String role;
        private String userDescriptionAttribute;

        public UserWrapper(String authority, String role) {
            if (AuthorityType.getAuthorityType((String)authority) == AuthorityType.USER || AuthorityType.getAuthorityType((String)authority) == AuthorityType.GUEST) {
                NodeRef ref = CreateWebsiteWizard.this.getPersonService().getPerson(authority);
                String firstName = (String)((Object)CreateWebsiteWizard.this.getNodeService().getProperty(ref, ContentModel.PROP_FIRSTNAME));
                String lastName = (String)((Object)CreateWebsiteWizard.this.getNodeService().getProperty(ref, ContentModel.PROP_LASTNAME));
                this.name = firstName + (lastName != null ? " " + lastName : "");
            } else {
                this.name = authority.substring("GROUP_".length());
            }
            this.role = Application.getMessage(FacesContext.getCurrentInstance(), role);
            this.userDescriptionAttribute = this.buildUserDescriptionAttribute();
        }

        public String getName() {
            return this.name;
        }

        public String getRole() {
            return this.role;
        }

        public String getUserDescriptionAttribute() {
            if (StringUtils.isEmpty((String)this.userDescriptionAttribute)) {
                this.userDescriptionAttribute = this.buildUserDescriptionAttribute();
            }
            return this.userDescriptionAttribute;
        }

        public String getUserLabelAttribute() {
            StringBuilder builder = new StringBuilder("<b>");
            builder.append(Utils.encode((String)this.name));
            builder.append("</b>");
            return builder.toString();
        }

        private String buildUserDescriptionAttribute() {
            FacesContext fc = FacesContext.getCurrentInstance();
            StringBuilder attribute = new StringBuilder(128);
            attribute.append(DescriptionAttributeHelper.getTableBegin()).append(DescriptionAttributeHelper.getTableLine(fc, "roles", this.getRole())).append(DescriptionAttributeHelper.getTableEnd());
            return attribute.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WorkflowWrapper
    implements WorkflowConfiguration {
        private static final long serialVersionUID = -5570490335442743685L;
        private String name;
        private String title;
        private String description;
        private String filenamePattern;
        private String workflowDescriptionAttribute;
        private QName type;
        private Map<QName, Serializable> params;

        public WorkflowWrapper(String name, String title, String description) {
            this.name = name;
            this.title = title;
            this.description = description;
            this.workflowDescriptionAttribute = this.buildWorkflowDescriptionAttribute();
        }

        public WorkflowWrapper(String name, String title, String description, String filenamePattern) {
            this.name = name;
            this.title = title;
            this.description = description;
            this.filenamePattern = filenamePattern;
            this.workflowDescriptionAttribute = this.buildWorkflowDescriptionAttribute();
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String getTitle() {
            return this.title;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        public String getFilenamePattern() {
            return this.filenamePattern;
        }

        @Override
        public void setFilenamePattern(String filenamePattern) {
            this.filenamePattern = filenamePattern;
        }

        @Override
        public Map<QName, Serializable> getParams() {
            return this.params;
        }

        @Override
        public void setParams(Map<QName, Serializable> params) {
            this.params = params;
        }

        @Override
        public QName getType() {
            return this.type;
        }

        @Override
        public void setType(QName type) {
            this.type = type;
        }

        public String getWorkflowDescriptionAttribute() {
            if (StringUtils.isEmpty((String)this.workflowDescriptionAttribute)) {
                this.workflowDescriptionAttribute = this.buildWorkflowDescriptionAttribute();
            }
            return this.workflowDescriptionAttribute;
        }

        public String getWorkflowLabelAttribute() {
            StringBuilder builder = new StringBuilder("<b>");
            builder.append(Utils.encode((String)this.title));
            builder.append("</b>");
            return builder.toString();
        }

        private String buildWorkflowDescriptionAttribute() {
            FacesContext fc = FacesContext.getCurrentInstance();
            String workflowDescription = DescriptionAttributeHelper.getDescriptionNotEmpty(fc, this.getDescription());
            StringBuilder attribute = new StringBuilder(255);
            attribute.append(DescriptionAttributeHelper.getTableBegin());
            attribute.append(DescriptionAttributeHelper.getTableLine(fc, "description", workflowDescription, false));
            attribute.append(DescriptionAttributeHelper.getTableLine(fc, "website_filename_pattern", this.getFilenamePattern()));
            attribute.append(DescriptionAttributeHelper.getTableEnd());
            return attribute.toString();
        }
    }

    public static class PresentationTemplate
    implements Serializable {
        private static final long serialVersionUID = 5148139895329524483L;
        private RenderingEngineTemplate ret;
        private String title;
        private String description;
        private String outputPathPattern;

        public PresentationTemplate(RenderingEngineTemplate ret) {
            this(ret, null);
        }

        public PresentationTemplate(RenderingEngineTemplate ret, String outputPathPattern) {
            this.ret = ret;
            this.outputPathPattern = outputPathPattern;
        }

        public RenderingEngineTemplate getRenderingEngineTemplate() {
            return this.ret;
        }

        public String getTitle() {
            if (this.title == null) {
                this.title = this.ret.getName();
            }
            return this.title;
        }

        public String getDescription() {
            if (this.description == null) {
                this.description = this.ret.getDescription();
            }
            return this.description;
        }

        public String getOutputPathPattern() {
            if (this.outputPathPattern == null) {
                this.outputPathPattern = this.ret.getOutputPathPattern();
            }
            return this.outputPathPattern;
        }

        public void setOutputPathPattern(String outputPathPattern) {
            this.outputPathPattern = outputPathPattern;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FormWrapper
    implements Serializable {
        private static final long serialVersionUID = -1452145043222643362L;
        private Form form;
        private String title;
        private String description;
        private String formDescriptionAttribute;
        private WorkflowWrapper workflow;
        private String outputPathPattern;
        private List<PresentationTemplate> templates = null;

        FormWrapper(Form form) {
            this.form = form;
            this.title = form.getName();
            this.description = form.getDescription();
        }

        public Form getForm() {
            return this.form;
        }

        public String getName() {
            return this.form.getName();
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getFormDescriptionAttribute() {
            if (StringUtils.isEmpty((String)this.formDescriptionAttribute)) {
                this.formDescriptionAttribute = this.buildFormDescriptionAttribute();
            }
            return this.formDescriptionAttribute;
        }

        public String getFormLabelAttribute() {
            StringBuilder builder = new StringBuilder("<b>");
            builder.append(Utils.encode((String)this.getName()));
            builder.append("</b>");
            return builder.toString();
        }

        public WorkflowWrapper getWorkflow() {
            WorkflowDefinition wf = this.form.getDefaultWorkflow();
            if (this.workflow == null && wf != null) {
                this.workflow = new WorkflowWrapper(wf.name, wf.getTitle(), wf.getDescription());
            }
            return this.workflow;
        }

        public void setWorkflow(WorkflowWrapper workflow) {
            this.workflow = workflow;
        }

        public String getOutputPathPattern() {
            if (this.outputPathPattern == null) {
                this.outputPathPattern = this.form.getOutputPathPattern();
            }
            return this.outputPathPattern;
        }

        public void setOutputPathPattern(String outputPathPattern) {
            this.outputPathPattern = outputPathPattern;
        }

        public List<PresentationTemplate> getTemplates() {
            if (this.templates == null) {
                List<RenderingEngineTemplate> templates = this.form.getRenderingEngineTemplates();
                this.templates = new ArrayList<PresentationTemplate>(templates.size());
                for (RenderingEngineTemplate template : templates) {
                    this.templates.add(new PresentationTemplate(template));
                }
            }
            return this.templates;
        }

        public int getTemplatesSize() {
            return this.getTemplates() != null ? this.getTemplates().size() : 0;
        }

        public void addTemplate(PresentationTemplate template) {
            if (this.templates == null) {
                this.templates = new ArrayList<PresentationTemplate>(4);
            }
            this.templates.add(template);
        }

        public void setTemplates(List<PresentationTemplate> templates) {
            this.templates = templates;
        }

        private String buildFormDescriptionAttribute() {
            FacesContext fc = FacesContext.getCurrentInstance();
            StringBuilder attribute = new StringBuilder(255);
            String formDescription = DescriptionAttributeHelper.getDescriptionNotEmpty(fc, this.getDescription());
            String workflowTitle = this.getWorkflow() == null ? "<span style=\"font-style:italic\">" + Application.getMessage(fc, "none") + "</span>" : Utils.encode((String)this.getWorkflow().getTitle());
            attribute.append(DescriptionAttributeHelper.getTableBegin());
            attribute.append(DescriptionAttributeHelper.getTableLine(fc, "name", this.getName()));
            attribute.append(DescriptionAttributeHelper.getTableLine(fc, "title", this.getTitle()));
            attribute.append(DescriptionAttributeHelper.getTableLine(fc, "output_path_pattern", this.getOutputPathPattern()));
            attribute.append(DescriptionAttributeHelper.getTableLine(fc, "description", formDescription, false));
            attribute.append(DescriptionAttributeHelper.getTableLine(fc, "workflow", workflowTitle, false));
            attribute.append(DescriptionAttributeHelper.getTableEnd());
            return attribute.toString();
        }
    }
}

