/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.io.Serializable;
import org.alfresco.service.cmr.avm.deploy.DeploymentCallback;
import org.alfresco.service.cmr.avm.deploy.DeploymentEvent;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.web.ui.common.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeploymentMonitor
implements DeploymentCallback,
Serializable {
    private static final long serialVersionUID = 8167554931073708558L;
    private String id = "_depmon_" + Long.toString(System.currentTimeMillis()) + this.hashCode();
    private NodeRef website;
    private NodeRef targetServer;
    private String targetServerName;
    private String deployAttemptId;
    private String url;
    private String reason;
    private int snapshotVersion;
    private boolean started = false;
    private boolean finished = false;
    private boolean successful = false;
    private static Log logger = LogFactory.getLog(DeploymentMonitor.class);
    private static final String ID_PREFIX = "_depmon_";

    public DeploymentMonitor(NodeRef website, NodeRef server, int snapshotVersion, String serverName, String deployAttemptId, String url) {
        this.website = website;
        this.targetServer = server;
        this.snapshotVersion = snapshotVersion;
        this.targetServerName = serverName;
        this.deployAttemptId = deployAttemptId;
        this.url = url;
    }

    public void eventOccurred(DeploymentEvent event) {
        if (event.getType().equals((Object)DeploymentEvent.Type.START)) {
            this.started = true;
        } else if (event.getType().equals((Object)DeploymentEvent.Type.END)) {
            this.successful = true;
            this.finished = true;
        } else if (event.getType().equals((Object)DeploymentEvent.Type.FAILED)) {
            this.successful = false;
            this.finished = true;
            this.reason = event.getMessage();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.targetServerName + ": ERROR: " + this.reason));
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.targetServerName + ": " + event.getType() + " " + event.getDestination()));
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(super.toString());
        buffer.append(" (id=").append(this.id);
        buffer.append(" website=").append(this.website);
        buffer.append(" targetServer=").append(this.targetServer);
        buffer.append(" targetServerName=").append(this.targetServerName);
        buffer.append(" snapshotVersion=").append(this.snapshotVersion);
        buffer.append(" deployAttemptId=").append(this.deployAttemptId);
        buffer.append(" url=").append(this.url);
        buffer.append(" reason=").append(this.reason);
        buffer.append(" started=").append(this.started);
        buffer.append(" finished=").append(this.finished);
        buffer.append(" successful=").append(this.successful).append(")");
        return buffer.toString();
    }

    public String toXML() {
        StringBuilder buffer = new StringBuilder("<target-server id=\"");
        buffer.append(this.getId());
        buffer.append("\" name=\"");
        buffer.append(Utils.encode((String)this.targetServerName));
        buffer.append("\" server=\"");
        buffer.append(this.targetServer);
        buffer.append("\" attempt=\"");
        buffer.append(this.deployAttemptId);
        buffer.append("\" finished=\"");
        buffer.append(this.finished);
        buffer.append("\"");
        if (this.url != null) {
            buffer.append(" url=\"");
            buffer.append(Utils.encode((String)this.url));
            buffer.append("\"");
        }
        if (this.reason != null) {
            buffer.append(" reason=\"");
            buffer.append(Utils.encode((String)this.reason));
            buffer.append("\"");
        }
        if (this.finished) {
            buffer.append(" successful=\"");
            buffer.append(this.successful);
            buffer.append("\"");
        }
        buffer.append("/>");
        return buffer.toString();
    }

    public String getId() {
        return this.id;
    }

    public NodeRef getWebsite() {
        return this.website;
    }

    public NodeRef getTargetServer() {
        return this.targetServer;
    }

    public String getTargetServerName() {
        return this.targetServerName;
    }

    public int getSnapshotVersion() {
        return this.snapshotVersion;
    }

    public String getDeployAttemptId() {
        return this.deployAttemptId;
    }

    public String getUrl() {
        return this.url;
    }

    public String getReason() {
        return this.reason;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isSuccessful() {
        return this.successful;
    }
}

