/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.wcm.AVMNode;
import org.alfresco.web.bean.wcm.AVMUtil;
import org.alfresco.web.bean.wcm.CreateWebContentWizard;
import org.alfresco.web.bean.wcm.WebProject;
import org.alfresco.web.forms.Form;
import org.alfresco.web.forms.FormInstanceData;
import org.alfresco.web.forms.FormNotFoundException;
import org.alfresco.web.forms.Rendition;
import org.alfresco.web.forms.XMLUtil;
import org.alfresco.web.ui.common.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditWebContentWizard
extends CreateWebContentWizard {
    private static final long serialVersionUID = 439996926303151006L;
    private static final Log logger = LogFactory.getLog(EditWebContentWizard.class);
    private AVMNode avmNode;
    private Form form;
    protected Set<String> existingLocks = null;

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.avmNode = this.avmBrowseBean.getAvmActionNode();
        if (this.avmNode == null) {
            throw new IllegalArgumentException("Edit Form wizard requires action node context.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("path is " + this.avmNode.getPath()));
        }
        this.createdPath = AVMUtil.getCorrespondingPathInPreviewStore(this.avmNode.getPath());
        WebProject webProject = new WebProject(this.createdPath);
        try {
            this.formInstanceData = this.getFormsService().getFormInstanceData(-1, this.createdPath);
            this.formName = this.formInstanceData.getForm().getName();
            this.fileName = this.formInstanceData.getName();
            this.form = webProject.getForm(this.formName);
        }
        catch (FormNotFoundException fnfe) {
            Utils.addErrorMessage(fnfe.getMessage(), fnfe);
        }
        this.content = this.getAvmService().getContentReader(-1, this.createdPath).getContentString();
        this.mimeType = "text/xml";
        this.existingLocks = new HashSet<String>(4);
        String lock = this.getAvmLockingService().getLockOwner(AVMUtil.getStoreId(this.createdPath), AVMUtil.getStoreRelativePath(this.createdPath));
        if (lock != null) {
            this.existingLocks.add(this.createdPath);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Lock exists for xml instance " + this.createdPath + " at initialisation"));
            }
        }
        for (Rendition r : this.formInstanceData.getRenditions()) {
            String path = r.getPath();
            lock = this.getAvmLockingService().getLockOwner(AVMUtil.getStoreId(path), AVMUtil.getStoreRelativePath(path));
            if (lock == null) continue;
            this.existingLocks.add(path);
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Lock exists for rendition " + path + " at initialisation"));
        }
    }

    @Override
    public String cancel() {
        if (this.formInstanceData != null && this.renditions != null) {
            if (!this.existingLocks.contains(this.createdPath)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("removing form instance data lock from " + AVMUtil.getCorrespondingPathInMainStore(this.createdPath) + " as user chose to cancel and it wasn't present at initialisation"));
                }
                this.getAvmLockingService().removeLock(AVMUtil.getStoreId(this.createdPath), AVMUtil.getStoreRelativePath(this.createdPath));
            }
            for (Rendition r : this.renditions) {
                String path = r.getPath();
                if (this.existingLocks.contains(path)) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("removing lock from rendition " + AVMUtil.getCorrespondingPathInMainStore(path) + " as user chose to cancel and it wasn't present at initialisation"));
                }
                this.getAvmLockingService().removeLock(AVMUtil.getStoreId(path), AVMUtil.getStoreRelativePath(path));
            }
        }
        return super.cancel();
    }

    @Override
    public String back() {
        if ("content".equals(Application.getWizardManager().getCurrentStepName())) {
            this.formInstanceData = null;
            this.renditions = null;
        }
        return super.back();
    }

    @Override
    protected void saveContent() throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("saving " + this.createdPath));
        }
        String storeId = AVMUtil.getStoreId(this.createdPath);
        String storePath = AVMUtil.getStoreRelativePath(this.createdPath);
        String storeName = AVMUtil.getStoreName(this.createdPath);
        String lockOwner = this.getAvmLockingService().getLockOwner(storeId, storePath);
        Map lockData = this.getAvmLockingService().getLockData(storeId, storePath);
        if (lockOwner != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("transferring lock from " + (String)lockData.get("avm-store-name") + " to " + storeName));
            }
            lockData.put("avm-store-name", AVMUtil.getStoreName(this.createdPath));
            this.getAvmLockingService().modifyLock(storeId, storePath, lockOwner, storeId, storePath, lockData);
        }
        ContentWriter writer = this.getAvmService().getContentWriter(this.createdPath, true);
        this.content = XMLUtil.toString(this.getInstanceDataDocument(), false);
        writer.putContent(this.content);
        this.formInstanceData = this.getFormsService().getFormInstanceData(-1, this.createdPath);
        List<FormInstanceData.RegenerateResult> result = this.formInstanceData.regenerateRenditions();
        this.renditions = new LinkedList();
        for (FormInstanceData.RegenerateResult rr : result) {
            if (rr.getException() != null) {
                Utils.addErrorMessage("error regenerating rendition using " + rr.getRenderingEngineTemplate().getName() + ": " + rr.getException().getMessage(), rr.getException());
                String path = rr.getPath();
                if (rr.getLockOwner() != null) {
                    this.existingLocks.add(path);
                }
                if (!this.existingLocks.contains(path)) continue;
                String renditionStoreId = AVMUtil.getStoreId(path);
                String renditionStorePath = AVMUtil.getStoreRelativePath(path);
                String renditionStoreName = AVMUtil.getCorrespondingMainStoreName(AVMUtil.getStoreName(path));
                Map renditionlockData = this.getAvmLockingService().getLockData(AVMUtil.getStoreId(path), AVMUtil.getStoreRelativePath(path));
                renditionlockData.put("avm-store-name", renditionStoreName);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("transferring existing lock for " + path + " back to " + renditionStoreName));
                }
                this.getAvmLockingService().modifyLock(renditionStoreId, renditionStorePath, lockOwner, renditionStoreId, renditionStorePath, renditionlockData);
                continue;
            }
            Rendition r = rr.getRendition();
            this.renditions.add(r);
            String path = r.getPath();
            if (rr.getLockOwner() != null) {
                this.existingLocks.add(path);
            }
            String renditionStoreId = AVMUtil.getStoreId(path);
            String renditionStorePath = AVMUtil.getStoreRelativePath(path);
            String renditionStoreName = AVMUtil.getCorrespondingMainStoreName(AVMUtil.getStoreName(path));
            Map renditionlockData = this.getAvmLockingService().getLockData(AVMUtil.getStoreId(path), AVMUtil.getStoreRelativePath(path));
            renditionlockData.put("avm-store-name", renditionStoreName);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("transferring lock for " + path + " back to " + renditionStoreName));
            }
            this.getAvmLockingService().modifyLock(renditionStoreId, renditionStorePath, lockOwner, renditionStoreId, renditionStorePath, renditionlockData);
        }
    }

    @Override
    public boolean getEditMode() {
        return true;
    }

    @Override
    public boolean getSubmittable() {
        return !AVMUtil.isWorkflowStore(AVMUtil.getStoreName(this.createdPath));
    }

    @Override
    public Form getForm() {
        return this.form;
    }
}

