/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.CreateWebsiteWizard;
import org.alfresco.web.forms.Form;
import org.alfresco.web.forms.RenderingEngineTemplate;
import org.alfresco.web.ui.common.component.UIListItem;
import org.alfresco.web.ui.common.component.UISelectList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormTemplatesDialog
extends BaseDialogBean {
    private static final long serialVersionUID = 6383166841680919841L;
    private static final String COMPONENT_TEMPLATELIST = "template-list";
    private static final Log logger = LogFactory.getLog(FormTemplatesDialog.class);
    private transient AVMService avmService;
    protected CreateWebsiteWizard websiteWizard;
    private transient DataModel templatesDataModel = null;
    private List<CreateWebsiteWizard.PresentationTemplate> templates = null;
    private List<UIListItem> templateList = null;

    public void setAvmService(AVMService avmService) {
        this.avmService = avmService;
    }

    protected AVMService getAvmService() {
        if (this.avmService == null) {
            this.avmService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAVMService();
        }
        return this.avmService;
    }

    public void setCreateWebsiteWizard(CreateWebsiteWizard wizard) {
        this.websiteWizard = wizard;
    }

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.templatesDataModel = null;
        this.templates = new ArrayList<CreateWebsiteWizard.PresentationTemplate>(this.getActionForm().getTemplates().size());
        this.templates.addAll(this.getActionForm().getTemplates());
    }

    @Override
    public String getContainerDescription() {
        return MessageFormat.format(Application.getBundle(FacesContext.getCurrentInstance()).getString("form_template_templates_desc"), this.getActionForm().getName(), this.websiteWizard.getName());
    }

    public CreateWebsiteWizard.FormWrapper getActionForm() {
        return this.websiteWizard.getActionForm();
    }

    public DataModel getTemplatesDataModel() {
        if (this.templatesDataModel == null) {
            this.templatesDataModel = new ListDataModel();
        }
        if (this.templatesDataModel.getWrappedData() == null) {
            this.templatesDataModel.setWrappedData(this.templates);
        }
        return this.templatesDataModel;
    }

    public void setTemplatesDataModel(DataModel templatesDataModel) {
        this.templatesDataModel = templatesDataModel;
    }

    public List<UIListItem> getTemplatesList() {
        Form form = this.getActionForm().getForm();
        List<RenderingEngineTemplate> engines = form.getRenderingEngineTemplates();
        ArrayList<UIListItem> items = new ArrayList<UIListItem>(engines.size());
        for (RenderingEngineTemplate engine : engines) {
            CreateWebsiteWizard.PresentationTemplate wrapper = new CreateWebsiteWizard.PresentationTemplate(engine);
            UIListItem item = new UIListItem();
            item.setValue(wrapper);
            item.setLabel(wrapper.getTitle() + " (" + engine.getMimetypeForRendition() + ")");
            item.setDescription(wrapper.getDescription());
            item.setImage("/images/icons/template_large.gif");
            items.add(item);
        }
        this.templateList = items;
        return items;
    }

    public void addTemplate(ActionEvent event) {
        UISelectList selectList = (UISelectList)event.getComponent().findComponent(COMPONENT_TEMPLATELIST);
        int index = selectList.getRowIndex();
        if (index != -1) {
            CreateWebsiteWizard.PresentationTemplate template = (CreateWebsiteWizard.PresentationTemplate)this.templateList.get(index).getValue();
            this.templates.add(new CreateWebsiteWizard.PresentationTemplate(template.getRenderingEngineTemplate(), template.getOutputPathPattern()));
        }
    }

    public void removeTemplate(ActionEvent event) {
        CreateWebsiteWizard.PresentationTemplate wrapper = (CreateWebsiteWizard.PresentationTemplate)this.getTemplatesDataModel().getRowData();
        if (wrapper != null) {
            this.templates.remove(wrapper);
        }
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        List<CreateWebsiteWizard.PresentationTemplate> list = this.getActionForm().getTemplates();
        list.clear();
        for (CreateWebsiteWizard.PresentationTemplate wrapper : this.templates) {
            list.add(wrapper);
        }
        return outcome;
    }

    @Override
    public boolean getFinishButtonDisabled() {
        return false;
    }
}

