/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.ValueChangeEvent;
import javax.transaction.UserTransaction;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.context.IContextListener;
import org.alfresco.web.bean.dialog.FilterViewSupport;
import org.alfresco.web.bean.repository.MapNode;
import org.alfresco.web.bean.repository.QNameNodeMap;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.users.UserMembersBean;
import org.alfresco.web.bean.wcm.AVMUtil;
import org.alfresco.web.bean.wcm.BasePermissionsDialog;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.UIListItem;
import org.alfresco.web.ui.common.component.UIModeList;
import org.alfresco.web.ui.common.component.data.UIRichList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagePermissionsDialog
extends BasePermissionsDialog
implements IContextListener,
FilterViewSupport {
    private static final long serialVersionUID = -6980134441634707541L;
    private static final String MSG_MANAGE_PERMS_FOR = "manage_permissions_title";
    private static final String MSG_VIEW_PERMS_FOR = "view_permissions_title";
    private static final String LOCAL = "local";
    private static final String INHERITED = "inherited";
    private static final String MSG_CLOSE = "close";
    private String filterMode = "inherited";
    private transient PersonService personService;
    private UIRichList usersRichList = null;
    private boolean inheritParenSpacePermissions;

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    protected PersonService getPersonService() {
        if (this.personService == null) {
            this.personService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getPersonService();
        }
        return this.personService;
    }

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.contextUpdated();
        this.inheritParenSpacePermissions = this.getPermissionService().getInheritParentPermissions(this.getAvmBrowseBean().getAvmActionNode().getNodeRef());
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        return null;
    }

    public List<Map> getUsers() {
        boolean includeInherited = true;
        if (this.filterMode.equals(LOCAL)) {
            includeInherited = false;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        List<Map> personNodes = null;
        UserTransaction tx = null;
        try {
            tx = Repository.getUserTransaction(context, true);
            tx.begin();
            NodeRef actionNode = this.getAvmBrowseBean().getAvmActionNode().getNodeRef();
            Set permissions = this.getPermissionService().getAllSetPermissions(actionNode);
            Set<String> permsToDisplay = ManagePermissionsDialog.getPermissionsForType();
            Map<String, List<String>> permissionMap = this.getPerson(permissions, permsToDisplay);
            NodeRef parentRef = this.getNodeService().getPrimaryParent(actionNode).getParentRef();
            Map<String, List<String>> parentPermissionMap = this.getPerson(this.getPermissionService().getAllSetPermissions(parentRef), permsToDisplay);
            personNodes = new ArrayList<Map>(permissionMap.size());
            ArrayList<String> local = new ArrayList<String>();
            ArrayList<String> inh = new ArrayList<String>();
            for (String authority : permissionMap.keySet()) {
                local.clear();
                inh.clear();
                this.divisionPermissions(authority, permissionMap, parentPermissionMap, inh, local);
                if (AuthorityType.getAuthorityType((String)authority) == AuthorityType.GUEST || this.getPersonService().personExists(authority)) {
                    NodeRef nodeRef = this.getPersonService().getPerson(authority);
                    if (nodeRef == null) continue;
                    MapNode node = new MapNode(nodeRef);
                    if (includeInherited) {
                        this.addUserPermissions(node, context, inh, personNodes, nodeRef, true);
                    }
                    this.addUserPermissions(node, context, local, personNodes, nodeRef, false);
                    continue;
                }
                if (includeInherited) {
                    this.addGroupPermissions(authority, context, personNodes, inh, true);
                }
                this.addGroupPermissions(authority, context, personNodes, local, false);
            }
            tx.commit();
        }
        catch (InvalidNodeRefException refErr) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(context, "error_noderef"), refErr.getNodeRef()));
            personNodes = Collections.emptyList();
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception tex) {}
        }
        catch (Throwable err) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(context, "error_generic"), err.getMessage()), err);
            personNodes = Collections.emptyList();
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception tex) {
                // empty catch block
            }
        }
        return personNodes;
    }

    private void addGroupPermissions(String authority, FacesContext context, List<Map> personNodes, List<String> perms, boolean inherited) {
        if (perms == null || perms.size() == 0) {
            return;
        }
        HashMap<String, Object> node = new HashMap<String, Object>(5, 1.0f);
        if (authority.startsWith("GROUP_")) {
            node.put("fullName", authority.substring("GROUP_".length()));
        } else {
            node.put("fullName", authority);
        }
        node.put("userName", authority);
        node.put("id", authority);
        node.put("perms", UserMembersBean.roleListToString(context, perms));
        node.put("icon", "/images/icons/group.gif");
        node.put(INHERITED, inherited);
        personNodes.add(node);
    }

    private void addUserPermissions(MapNode node, FacesContext context, List<String> perms, List<Map> personNodes, NodeRef nodeRef, boolean inherited) {
        if (perms == null || perms.size() == 0) {
            return;
        }
        Map props = (Map)((QNameNodeMap)node.getProperties()).clone();
        props.put("fullName", (String)node.get("firstName") + ' ' + (String)node.get("lastName"));
        props.put("perms", UserMembersBean.roleListToString(context, perms));
        props.put("icon", "/images/icons/person.gif");
        props.put(INHERITED, inherited);
        personNodes.add(props);
    }

    private void divisionPermissions(String authority, Map<String, List<String>> person, Map<String, List<String>> parentPerson, List<String> inherited, List<String> local) {
        List<String> parentPerms = parentPerson.get(authority);
        List<String> perms = person.get(authority);
        if (parentPerms == null) {
            local.addAll(perms);
            return;
        }
        if (((Object)perms).equals(parentPerms)) {
            inherited.addAll(perms);
            return;
        }
        for (String perm : perms) {
            if (parentPerms.contains(perm)) {
                inherited.add(perm);
                continue;
            }
            local.add(perm);
        }
    }

    private Map<String, List<String>> getPerson(Set<AccessPermission> permissions, Set<String> permsToDisplay) {
        HashMap<String, List<String>> permissionMap = new HashMap<String, List<String>>(8, 1.0f);
        for (AccessPermission permission : permissions) {
            if (!permsToDisplay.contains(permission.getPermission()) || permission.getAccessStatus() != AccessStatus.ALLOWED || permission.getAuthorityType() != AuthorityType.USER && permission.getAuthorityType() != AuthorityType.GROUP && permission.getAuthorityType() != AuthorityType.GUEST && permission.getAuthorityType() != AuthorityType.EVERYONE) continue;
            String authority = permission.getAuthority();
            ArrayList<String> userPermissions = (ArrayList<String>)permissionMap.get(authority);
            if (userPermissions == null) {
                userPermissions = new ArrayList<String>(4);
                permissionMap.put(authority, userPermissions);
            }
            userPermissions.add(permission.getPermission());
        }
        return permissionMap;
    }

    public static Set<String> getPermissionsForType() {
        LinkedHashSet<String> permissions = new LinkedHashSet<String>(3);
        permissions.add("Read");
        permissions.add("Write");
        permissions.add("Delete");
        return permissions;
    }

    @Override
    public void areaChanged() {
    }

    @Override
    public void contextUpdated() {
        if (this.usersRichList != null) {
            this.usersRichList.setValue(null);
        }
    }

    @Override
    public void spaceChanged() {
    }

    @Override
    public void filterModeChanged(ActionEvent event) {
        UIModeList viewList = (UIModeList)event.getComponent();
        this.setFilterMode(viewList.getValue().toString());
        if (this.usersRichList != null) {
            this.usersRichList.setValue(null);
        }
    }

    @Override
    public List<UIListItem> getFilterItems() {
        FacesContext context = FacesContext.getCurrentInstance();
        ArrayList<UIListItem> items = new ArrayList<UIListItem>(2);
        UIListItem item1 = new UIListItem();
        item1.setValue(INHERITED);
        item1.setLabel(Application.getMessage(context, INHERITED));
        items.add(item1);
        UIListItem item2 = new UIListItem();
        item2.setValue(LOCAL);
        item2.setLabel(Application.getMessage(context, LOCAL));
        items.add(item2);
        return items;
    }

    @Override
    public String getFilterMode() {
        return this.filterMode;
    }

    @Override
    public void setFilterMode(String filterMode) {
        this.filterMode = filterMode;
        this.contextUpdated();
    }

    public UIRichList getUsersRichList() {
        return this.usersRichList;
    }

    public void setUsersRichList(UIRichList usersRichList) {
        this.usersRichList = usersRichList;
    }

    @Override
    public void restored() {
        super.restored();
        this.contextUpdated();
    }

    @Override
    public String getCancelButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), MSG_CLOSE);
    }

    @Override
    public boolean getFinishButtonDisabled() {
        return false;
    }

    @Override
    public Object getActionsContext() {
        return this;
    }

    @Override
    public String getContainerTitle() {
        FacesContext fc = FacesContext.getCurrentInstance();
        String pattern = Application.getMessage(fc, this.isRendered() ? MSG_MANAGE_PERMS_FOR : MSG_VIEW_PERMS_FOR);
        return MessageFormat.format(pattern, this.getAvmBrowseBean().getAvmActionNode().getName());
    }

    public boolean isRendered() {
        boolean result = false;
        String path = (String)AVMNodeConverter.ToAVMVersionPath((NodeRef)this.getAvmBrowseBean().getAvmActionNode().getNodeRef()).getSecond();
        if (!AVMUtil.isMainStore(AVMUtil.getStoreName(path))) {
            result = true;
        }
        return result;
    }

    public boolean isInheritParenSpacePermissions() {
        return this.inheritParenSpacePermissions;
    }

    public void setInheritParenSpacePermissions(boolean inheritParenSpacePermissions) {
        this.inheritParenSpacePermissions = inheritParenSpacePermissions;
        this.getPermissionService().setInheritParentPermissions(this.getAvmBrowseBean().getAvmActionNode().getNodeRef(), inheritParenSpacePermissions);
        this.contextUpdated();
    }

    public void inheritPermissionsValueChanged(ValueChangeEvent event) {
        boolean inheritPermissions = (Boolean)event.getNewValue();
        this.setInheritParenSpacePermissions(inheritPermissions);
    }
}

