/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.transaction.UserTransaction;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.service.cmr.avm.AVMNotFoundException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.wcm.sandbox.SandboxConstants;
import org.alfresco.wcm.util.WCMUtil;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.AVMBrowseBean;
import org.alfresco.web.bean.wcm.AVMUtil;
import org.alfresco.web.bean.wcm.DeploymentUtil;
import org.alfresco.web.bean.workflow.ManageTaskDialog;
import org.alfresco.web.ui.common.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManageReviewTaskDialog
extends ManageTaskDialog {
    private static final long serialVersionUID = 59524560340308134L;
    private static final String MSG_WEB_PRJ_DOES_NOT_EXIST = "error_webprj_does_not_exist";
    protected String store;
    protected String webapp;
    protected NodeRef webProjectRef;
    protected AVMBrowseBean avmBrowseBean;
    private transient PermissionService permissionService;
    private static final Log logger = LogFactory.getLog(ManageReviewTaskDialog.class);

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        FacesContext context = FacesContext.getCurrentInstance();
        UserTransaction tx = null;
        try {
            tx = Repository.getUserTransaction(context, true);
            tx.begin();
            this.store = this.workflowPackage.getStoreRef().getIdentifier();
            String wpStoreId = WCMUtil.getWebProjectStoreId((String)this.store);
            this.webProjectRef = this.getWebProjectService().getWebProjectNodeFromStore(WCMUtil.getWebProjectStoreId((String)this.store));
            if (this.webProjectRef == null) {
                String mesg = MessageFormat.format(Application.getMessage(context, MSG_WEB_PRJ_DOES_NOT_EXIST), wpStoreId);
                throw new AlfrescoRuntimeException(mesg);
            }
            tx.commit();
        }
        catch (Throwable e) {
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            Utils.addErrorMessage(this.formatErrorMessage(e), e);
        }
    }

    public String viewLinkReport() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Viewing link validation report for: " + AVMUtil.buildStoreWebappPath(this.store, this.webapp)));
        }
        HashMap<String, String> params = new HashMap<String, String>(3);
        params.put("store", this.store);
        params.put("webapp", this.webapp);
        params.put("compareToStaging", "true");
        Application.getDialogManager().setupParameters(params);
        return "dialog:linkValidation";
    }

    public String viewDeployReport() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Viewing deployment report for store: " + this.store));
        }
        HashMap<String, String> params = new HashMap<String, String>(3);
        params.put("store", this.store);
        Application.getDialogManager().setupParameters(params);
        return "dialog:viewDeploymentReport";
    }

    public String deploy() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Deploying workflow store: " + this.store));
        }
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("store", this.store);
        params.put("webproject", this.webProjectRef.toString());
        params.put("calledFromTaskDialog", Boolean.TRUE.toString());
        List<NodeRef> testServers = DeploymentUtil.findAllocatedTestServers(this.store);
        if (!testServers.isEmpty()) {
            params.put("updateTestServer", "true");
        }
        Application.getDialogManager().setupParameters(params);
        return "dialog:deployWebsite";
    }

    public String releaseTestServer() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Release test server for store: " + this.store));
        }
        HashMap<String, String> params = new HashMap<String, String>(3);
        params.put("store", this.store);
        Application.getDialogManager().setupParameters(params);
        return "dialog:releaseTestServer";
    }

    public void setAvmBrowseBean(AVMBrowseBean avmBrowseBean) {
        this.avmBrowseBean = avmBrowseBean;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    protected PermissionService getPermissionService() {
        if (this.permissionService == null) {
            this.permissionService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getPermissionService();
        }
        return this.permissionService;
    }

    public boolean getTestServersAvailable() {
        Boolean result = null;
        FacesContext context = FacesContext.getCurrentInstance();
        Map request = context.getExternalContext().getRequestMap();
        if (request.get("_alfBeenDeployedResult") == null) {
            List<NodeRef> testServers;
            result = Boolean.FALSE;
            if (this.webProjectRef != null && this.getPermissionService().hasPermission(this.webProjectRef, "ReadProperties").equals((Object)AccessStatus.ALLOWED) && (testServers = DeploymentUtil.findTestServers(this.webProjectRef, false)) != null) {
                result = new Boolean(testServers != null && testServers.size() > 0);
            }
            request.put("_alfBeenDeployedResult", result);
        } else {
            result = (Boolean)request.get("_alfBeenDeployedResult");
        }
        return result;
    }

    public boolean getDeployAttempted() {
        PropertyValue propVal = null;
        try {
            propVal = this.getAvmService().getStoreProperty(this.store, SandboxConstants.PROP_LAST_DEPLOYMENT_ID);
        }
        catch (AVMNotFoundException aVMNotFoundException) {
            // empty catch block
        }
        return propVal != null;
    }

    public boolean getTestServerAllocated() {
        List<NodeRef> testServers = DeploymentUtil.findAllocatedTestServers(this.store);
        return !testServers.isEmpty();
    }
}

