/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.wcm.AVMBrowseBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitorDeploymentDialog
extends BaseDialogBean {
    private static final long serialVersionUID = -2800892205678915972L;
    protected String outcome;
    protected NodeRef webProjectRef;
    protected AVMBrowseBean avmBrowseBean;
    private static final Log logger = LogFactory.getLog(MonitorDeploymentDialog.class);
    protected int versionToDeploy;
    protected String[] deployTo;
    protected String store;
    protected String deployMode;
    protected String calledFromTaskDialog;
    protected NodeRef websiteRef;

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        String webProject = parameters.get("webproject");
        this.webProjectRef = webProject == null ? this.avmBrowseBean.getWebsite().getNodeRef() : new NodeRef(webProject);
        String calledFromTaskDialog = parameters.get("calledFromTaskDialog");
        this.outcome = calledFromTaskDialog != null && calledFromTaskDialog.equals(Boolean.TRUE.toString()) ? "dialog:close:myalfresco" : "dialog:close:browseWebsite";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Initialising dialog to monitor deployment of " + this.webProjectRef.toString()));
        }
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        return outcome;
    }

    @Override
    protected String getDefaultCancelOutcome() {
        return this.outcome;
    }

    @Override
    public String getCancelButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), "close");
    }

    public void setAvmBrowseBean(AVMBrowseBean avmBrowseBean) {
        this.avmBrowseBean = avmBrowseBean;
    }

    public NodeRef getWebProjectRef() {
        return this.webProjectRef;
    }

    public String[] getDeployTo() {
        return this.deployTo;
    }

    public void setDeployTo(String[] deployTo) {
        this.deployTo = deployTo;
    }

    public String getDeployMode() {
        return this.deployMode;
    }

    public String getStore() {
        return this.store;
    }

    public int getSnapshotVersion() {
        return this.versionToDeploy;
    }
}

