/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm;

import java.text.MessageFormat;
import javax.faces.context.FacesContext;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avm.locking.AVMLockingService;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.AVMBrowseBean;
import org.alfresco.web.bean.wcm.AVMNode;
import org.alfresco.web.bean.wcm.AVMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UnlockFileDialog
extends BaseDialogBean {
    private static final long serialVersionUID = -2985826502913718770L;
    private static final Log logger = LogFactory.getLog(UnlockFileDialog.class);
    protected AVMService avmService;
    protected AVMLockingService lockingService;
    protected AVMBrowseBean avmBrowseBean;

    public void setAvmBrowseBean(AVMBrowseBean avmBrowseBean) {
        this.avmBrowseBean = avmBrowseBean;
    }

    public void setAvmService(AVMService avmService) {
        this.avmService = avmService;
    }

    protected AVMService getAvmService() {
        if (this.avmService == null) {
            this.avmService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAVMService();
        }
        return this.avmService;
    }

    public void setAvmLockingService(AVMLockingService lockingService) {
        this.lockingService = lockingService;
    }

    protected AVMLockingService getAvmLockingService() {
        if (this.lockingService == null) {
            this.lockingService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAVMLockingService();
        }
        return this.lockingService;
    }

    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        AVMNode node = this.avmBrowseBean.getAvmActionNode();
        if (node == null) {
            logger.warn((Object)"WARNING: unlock called without a current AVM Node!");
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Trying to unlock AVM node: " + node.getPath()));
            }
            this.getAvmLockingService().removeLock(this.avmBrowseBean.getWebProject().getStoreId(), AVMUtil.getStoreRelativePath(node.getPath()));
        }
        return outcome;
    }

    public boolean getFinishButtonDisabled() {
        return false;
    }

    public String getConfirmMessage() {
        String unlockConfirmMsg = Application.getMessage(FacesContext.getCurrentInstance(), "unlock_file_confirm");
        return MessageFormat.format(unlockConfirmMsg, this.avmBrowseBean.getAvmActionNode().getName());
    }
}

