/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.wcm.preview;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.util.Pair;
import org.alfresco.web.bean.wcm.preview.PreviewURIService;
import org.alfresco.web.bean.wcm.preview.VirtualisationServerPreviewURIService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreSpecificPreviewURIService
implements PreviewURIService {
    private final List<Pair<Pattern, PreviewURIService>> storeURIGenerators;
    private final PreviewURIService fallback;

    public StoreSpecificPreviewURIService(List<Pair<String, PreviewURIService>> storeURIGenerators) {
        this(storeURIGenerators, null);
    }

    public StoreSpecificPreviewURIService(List<Pair<String, PreviewURIService>> storeURIGenerators, PreviewURIService fallback) {
        ArrayList<Pair> compiledStoreURIGenerators = null;
        if (storeURIGenerators != null) {
            Iterator<Pair<String, PreviewURIService>> iter = storeURIGenerators.iterator();
            compiledStoreURIGenerators = new ArrayList<Pair>(storeURIGenerators.size());
            while (iter.hasNext()) {
                String regex;
                Pair<String, PreviewURIService> pair = iter.next();
                if (pair == null || (regex = (String)pair.getFirst()) == null || regex.trim().length() <= 0) continue;
                Pattern pattern = Pattern.compile(regex);
                compiledStoreURIGenerators.add(new Pair((Object)pattern, pair.getSecond()));
            }
        }
        this.storeURIGenerators = Collections.unmodifiableList(compiledStoreURIGenerators);
        this.fallback = fallback == null ? new VirtualisationServerPreviewURIService() : fallback;
    }

    @Override
    public String getPreviewURI(String storeId, String pathToAsset) {
        String result = null;
        boolean resultFound = false;
        if (this.storeURIGenerators != null) {
            for (Pair<Pattern, PreviewURIService> pair : this.storeURIGenerators) {
                Matcher matcher = ((Pattern)pair.getFirst()).matcher(storeId);
                if (!matcher.matches()) continue;
                result = ((PreviewURIService)pair.getSecond()).getPreviewURI(storeId, pathToAsset);
                resultFound = true;
                break;
            }
        }
        if (!resultFound) {
            result = this.fallback.getPreviewURI(storeId, pathToAsset);
        }
        return result;
    }
}

