/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.workflow;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.transaction.UserTransaction;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskDefinition;
import org.alfresco.service.cmr.workflow.WorkflowTaskQuery;
import org.alfresco.service.cmr.workflow.WorkflowTaskState;
import org.alfresco.service.cmr.workflow.WorkflowTransition;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.NavigationBean;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.repository.TransientMapNode;
import org.alfresco.web.bean.repository.TransientNode;
import org.alfresco.web.bean.repository.User;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.UIActionLink;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.ParameterCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowBean
implements Serializable {
    private static final long serialVersionUID = 2950475254440425384L;
    protected NavigationBean navigationBean;
    private transient NodeService nodeService;
    private transient WorkflowService workflowService;
    protected List<Node> tasks;
    protected List<Node> activeTasks;
    protected List<Node> pooledTasks;
    protected List<Node> completedTasks;
    private static final Log logger = LogFactory.getLog(WorkflowBean.class);
    public static final String BEAN_NAME = "WorkflowBean";

    public List<Node> getAllActiveTasks() {
        if (this.activeTasks == null) {
            FacesContext context = FacesContext.getCurrentInstance();
            User user = Application.getCurrentUser(context);
            String userName = user.getUserName();
            UserTransaction tx = null;
            try {
                tx = Repository.getUserTransaction(context, true);
                tx.begin();
                WorkflowTaskQuery query = new WorkflowTaskQuery();
                List tasks = this.getWorkflowService().queryTasks(query);
                this.activeTasks = new ArrayList<Node>(tasks.size());
                for (WorkflowTask task : tasks) {
                    TransientMapNode node = this.createTask(task);
                    this.activeTasks.add(node);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Added active task: " + node));
                }
                tx.commit();
            }
            catch (Throwable e) {
                try {
                    if (tx != null) {
                        tx.rollback();
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                Utils.addErrorMessage("Failed to get all active tasks: " + e.toString(), e);
            }
        }
        return this.activeTasks;
    }

    public List<Node> getPooledTasks() {
        if (this.pooledTasks == null) {
            FacesContext context = FacesContext.getCurrentInstance();
            User user = Application.getCurrentUser(context);
            String userName = user.getUserName();
            UserTransaction tx = null;
            try {
                tx = Repository.getUserTransaction(context, true);
                tx.begin();
                List tasks = this.getWorkflowService().getPooledTasks(userName);
                this.pooledTasks = new ArrayList<Node>(tasks.size());
                for (WorkflowTask task : tasks) {
                    TransientMapNode node = this.createTask(task);
                    this.pooledTasks.add(node);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Added pooled task: " + node));
                }
                tx.commit();
            }
            catch (Throwable e) {
                try {
                    if (tx != null) {
                        tx.rollback();
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                Utils.addErrorMessage("Failed to get pooled tasks: " + e.toString(), e);
            }
        }
        return this.pooledTasks;
    }

    public List<Node> getTasksToDo() {
        if (this.tasks == null) {
            FacesContext context = FacesContext.getCurrentInstance();
            User user = Application.getCurrentUser(context);
            String userName = user.getUserName();
            UserTransaction tx = null;
            try {
                tx = Repository.getUserTransaction(context, true);
                tx.begin();
                List tasks = this.getWorkflowService().getAssignedTasks(userName, WorkflowTaskState.IN_PROGRESS);
                this.tasks = new ArrayList<Node>(tasks.size());
                for (WorkflowTask task : tasks) {
                    TransientMapNode node = this.createTask(task);
                    this.tasks.add(node);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Added to do task: " + node));
                }
                tx.commit();
            }
            catch (Throwable e) {
                try {
                    if (tx != null) {
                        tx.rollback();
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                Utils.addErrorMessage("Failed to get to do tasks: " + e.toString(), e);
            }
        }
        return this.tasks;
    }

    public List<Node> getTasksCompleted() {
        if (this.completedTasks == null) {
            FacesContext context = FacesContext.getCurrentInstance();
            User user = Application.getCurrentUser(context);
            String userName = user.getUserName();
            UserTransaction tx = null;
            try {
                tx = Repository.getUserTransaction(context, true);
                tx.begin();
                List tasks = this.getWorkflowService().getAssignedTasks(userName, WorkflowTaskState.COMPLETED);
                this.completedTasks = new ArrayList<Node>(tasks.size());
                for (WorkflowTask task : tasks) {
                    TransientMapNode node = this.createTask(task);
                    this.completedTasks.add(node);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Added completed task: " + node));
                }
                tx.commit();
            }
            catch (Throwable e) {
                try {
                    if (tx != null) {
                        tx.rollback();
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                Utils.addErrorMessage("Failed to get completed tasks: " + e.toString(), e);
            }
        }
        return this.completedTasks;
    }

    public void setNavigationBean(NavigationBean navigationBean) {
        this.navigationBean = navigationBean;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    protected WorkflowService getWorkflowService() {
        if (this.workflowService == null) {
            this.workflowService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getWorkflowService();
        }
        return this.workflowService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    protected NodeService getNodeService() {
        if (this.nodeService == null) {
            this.nodeService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getNodeService();
        }
        return this.nodeService;
    }

    public void setupTaskDialog(ActionEvent event) {
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String id = params.get("id");
        String type = params.get("type");
        TransientNode node = new TransientNode(QName.createQName((String)type), id, null);
        this.navigationBean.setupDispatchContext(node);
        Application.getDialogManager().setupParameters(event);
    }

    public void setupTaskDialog(String id, String type) {
        ParameterCheck.mandatoryString((String)"Task ID", (String)id);
        ParameterCheck.mandatoryString((String)"Task Type", (String)type);
        TransientNode node = new TransientNode(QName.createQName((String)type), id, null);
        this.navigationBean.setupDispatchContext(node);
        HashMap<String, String> params = new HashMap<String, String>(2, 1.0f);
        params.put("id", id);
        params.put("type", type);
        Application.getDialogManager().setupParameters(params);
    }

    protected TransientMapNode createTask(WorkflowTask task) {
        WorkflowTaskDefinition taskDef = task.definition;
        TransientMapNode node = new TransientMapNode(taskDef.metadata.getName(), task.title, task.properties);
        node.getProperties().put(ContentModel.PROP_NAME.toString(), task.title);
        node.getProperties().put("type", node.getType().toString());
        node.getProperties().put("id", task.id);
        if (task.state.equals((Object)WorkflowTaskState.COMPLETED)) {
            String outcome = null;
            String transition = (String)task.properties.get(WorkflowModel.PROP_OUTCOME);
            if (transition != null) {
                WorkflowTransition[] transitions;
                for (WorkflowTransition trans : transitions = task.definition.node.transitions) {
                    if (!trans.id.equals(transition)) continue;
                    outcome = trans.title;
                    break;
                }
                if (outcome != null) {
                    node.getProperties().put("outcome", outcome);
                }
            }
            node.getProperties().put("workflowInstanceId", task.path.instance.id);
            node.getProperties().put("workflowTask", task);
        }
        return node;
    }
}

