/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.workflow;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowUtil {
    private static Log logger = LogFactory.getLog(WorkflowUtil.class);

    public static void approve(final NodeRef ref, final NodeService nodeService, CopyService copyService) throws AlfrescoRuntimeException {
        Node docNode = new Node(ref);
        if (!docNode.hasAspect(ApplicationModel.ASPECT_SIMPLE_WORKFLOW)) {
            throw new AlfrescoRuntimeException("Cannot approve a node that is not part of a workflow.");
        }
        Map<String, Object> props = docNode.getProperties();
        Boolean approveMove = (Boolean)props.get(ApplicationModel.PROP_APPROVE_MOVE.toString());
        NodeRef approveFolder = (NodeRef)props.get(ApplicationModel.PROP_APPROVE_FOLDER.toString());
        if (approveMove.booleanValue()) {
            nodeService.removeAspect(ref, ApplicationModel.ASPECT_SIMPLE_WORKFLOW);
            String qname = QName.createValidLocalName((String)docNode.getName());
            nodeService.moveNode(ref, approveFolder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)qname));
        } else {
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                public String doWork() throws Exception {
                    nodeService.removeAspect(ref, ApplicationModel.ASPECT_SIMPLE_WORKFLOW);
                    return null;
                }
            }, (String)AuthenticationUtil.getSystemUserName());
            String name = docNode.getName();
            String qname = QName.createValidLocalName((String)name);
            NodeRef newNode = copyService.copy(ref, approveFolder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)qname), true);
            nodeService.setProperty(newNode, ContentModel.PROP_NAME, (Serializable)((Object)name));
        }
        if (logger.isDebugEnabled()) {
            String movedCopied = approveMove != false ? "moved" : "copied";
            logger.debug((Object)("Node has been approved and " + movedCopied + " to folder with id of " + approveFolder.getId()));
        }
    }

    public static void reject(NodeRef ref, NodeService nodeService, CopyService copyService) throws AlfrescoRuntimeException {
        Node docNode = new Node(ref);
        if (!docNode.hasAspect(ApplicationModel.ASPECT_SIMPLE_WORKFLOW)) {
            throw new AlfrescoRuntimeException("Cannot reject a node that is not part of a workflow.");
        }
        Map<String, Object> props = docNode.getProperties();
        String rejectStep = (String)props.get(ApplicationModel.PROP_REJECT_STEP.toString());
        Boolean rejectMove = (Boolean)props.get(ApplicationModel.PROP_REJECT_MOVE.toString());
        NodeRef rejectFolder = (NodeRef)props.get(ApplicationModel.PROP_REJECT_FOLDER.toString());
        if (rejectStep == null && rejectMove == null && rejectFolder == null) {
            throw new AlfrescoRuntimeException("The workflow does not have a reject step defined.");
        }
        nodeService.removeAspect(ref, ApplicationModel.ASPECT_SIMPLE_WORKFLOW);
        if (rejectMove != null && rejectMove.booleanValue()) {
            String qname = QName.createValidLocalName((String)docNode.getName());
            nodeService.moveNode(ref, rejectFolder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)qname));
        } else {
            String name = docNode.getName();
            String qname = QName.createValidLocalName((String)name);
            NodeRef newNode = copyService.copy(ref, rejectFolder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)qname), true);
            nodeService.setProperty(newNode, ContentModel.PROP_NAME, (Serializable)((Object)name));
        }
        if (logger.isDebugEnabled()) {
            String movedCopied = rejectMove != false ? "moved" : "copied";
            logger.debug((Object)("Node has been rejected and " + movedCopied + " to folder with id of " + rejectFolder.getId()));
        }
    }

    public static Map<QName, Serializable> prepareTaskParams(Node node) {
        HashMap<QName, Serializable> params = new HashMap<QName, Serializable>();
        Map<String, Object> props = node.getProperties();
        for (String propName : props.keySet()) {
            QName propQName = Repository.resolveToQName(propName);
            params.put(propQName, (Serializable)props.get(propName));
        }
        Map<String, Map<String, AssociationRef>> assocs = node.getAddedAssociations();
        for (String assocName : assocs.keySet()) {
            QName assocQName = Repository.resolveToQName(assocName);
            Map<String, AssociationRef> addedAssocs = assocs.get(assocName);
            ArrayList<NodeRef> targets = new ArrayList<NodeRef>(addedAssocs.size());
            for (AssociationRef assoc : addedAssocs.values()) {
                targets.add(assoc.getTargetRef());
            }
            if (targets.size() <= 0) continue;
            params.put(assocQName, targets);
        }
        Map<String, Map<String, ChildAssociationRef>> childAssocs = node.getAddedChildAssociations();
        if (childAssocs.size() > 0 && logger.isWarnEnabled()) {
            logger.warn((Object)"Child associations are present but are not supported for workflow tasks, ignoring...");
        }
        return params;
    }
}

