/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.element.ConfigElementAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvancedSearchConfigElement
extends ConfigElementAdapter
implements Serializable {
    private static final long serialVersionUID = -6427054671579839728L;
    public static final String CONFIG_ELEMENT_ID = "advanced-search";
    private List<String> contentTypes = null;
    private List<String> folderTypes = null;
    private List<CustomProperty> customProps = null;

    public AdvancedSearchConfigElement() {
        super(CONFIG_ELEMENT_ID);
    }

    public AdvancedSearchConfigElement(String name) {
        super(name);
    }

    public List<ConfigElement> getChildren() {
        throw new ConfigException("Reading the advanced search config via the generic interfaces is not supported");
    }

    public ConfigElement combine(ConfigElement configElement) {
        AdvancedSearchConfigElement newElement = (AdvancedSearchConfigElement)configElement;
        AdvancedSearchConfigElement combinedElement = new AdvancedSearchConfigElement();
        if (this.contentTypes != null) {
            for (String type : this.contentTypes) {
                combinedElement.addContentType(type);
            }
        }
        if (this.folderTypes != null) {
            for (String type : this.folderTypes) {
                combinedElement.addFolderType(type);
            }
        }
        if (this.customProps != null) {
            for (CustomProperty property : this.customProps) {
                combinedElement.addCustomProperty(property);
            }
        }
        if (newElement.getContentTypes() != null) {
            for (String type : newElement.getContentTypes()) {
                combinedElement.addContentType(type);
            }
        }
        if (newElement.getFolderTypes() != null) {
            for (String type : newElement.getFolderTypes()) {
                combinedElement.addFolderType(type);
            }
        }
        if (newElement.getCustomProperties() != null) {
            for (CustomProperty property : newElement.getCustomProperties()) {
                combinedElement.addCustomProperty(property);
            }
        }
        return combinedElement;
    }

    public List<String> getContentTypes() {
        return this.contentTypes;
    }

    void setContentTypes(List<String> contentTypes) {
        this.contentTypes = contentTypes;
    }

    void addContentType(String contentType) {
        if (this.contentTypes == null) {
            this.contentTypes = new ArrayList<String>(3);
        }
        if (!this.contentTypes.contains(contentType)) {
            this.contentTypes.add(contentType);
        }
    }

    public List<String> getFolderTypes() {
        return this.folderTypes;
    }

    void setFolderTypes(List<String> folderTypes) {
        this.folderTypes = folderTypes;
    }

    void addFolderType(String folderType) {
        if (this.folderTypes == null) {
            this.folderTypes = new ArrayList<String>(3);
        }
        if (!this.folderTypes.contains(folderType)) {
            this.folderTypes.add(folderType);
        }
    }

    public List<CustomProperty> getCustomProperties() {
        return this.customProps;
    }

    void setCustomProperties(List<CustomProperty> customProps) {
        this.customProps = customProps;
    }

    void addCustomProperty(CustomProperty property) {
        if (this.customProps == null) {
            this.customProps = new ArrayList<CustomProperty>(3);
        }
        this.customProps.add(property);
    }

    public static class CustomProperty
    implements Serializable {
        private static final long serialVersionUID = 1457092137913897740L;
        public String Type;
        public String Aspect;
        public String Property;
        public String LabelId;

        CustomProperty(String type, String aspect, String property, String labelId) {
            this.Type = type;
            this.Aspect = aspect;
            this.Property = property;
            this.LabelId = labelId;
        }
    }
}

