/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config;

import java.util.Iterator;
import org.alfresco.web.config.NavigationConfigElement;
import org.dom4j.Element;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.xml.elementreader.ConfigElementReader;

public class NavigationElementReader
implements ConfigElementReader {
    public static final String ELEMENT_NAVIGATION = "navigation";
    public static final String ELEMENT_OVERRIDE = "override";
    public static final String ATTR_FROM_VIEWID = "from-view-id";
    public static final String ATTR_FROM_OUTCOME = "from-outcome";
    public static final String ATTR_TO_VIEWID = "to-view-id";
    public static final String ATTR_TO_OUTCOME = "to-outcome";

    public ConfigElement parse(Element element) {
        NavigationConfigElement configElement = null;
        if (element != null) {
            String name = element.getName();
            if (!ELEMENT_NAVIGATION.equals(name)) {
                throw new ConfigException("NavigationElementReader can only parse navigationelements, the element passed was '" + name + "'");
            }
            configElement = new NavigationConfigElement();
            Iterator items = element.elementIterator();
            while (items.hasNext()) {
                Element item = (Element)items.next();
                if (!ELEMENT_OVERRIDE.equals(item.getName())) continue;
                String fromViewId = item.attributeValue(ATTR_FROM_VIEWID);
                String fromOutcome = item.attributeValue(ATTR_FROM_OUTCOME);
                String toViewId = item.attributeValue(ATTR_TO_VIEWID);
                String toOutcome = item.attributeValue(ATTR_TO_OUTCOME);
                configElement.addOverride(fromViewId, fromOutcome, toViewId, toOutcome);
            }
        }
        return configElement;
    }
}

