/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.forms;

import java.io.Serializable;
import java.util.Calendar;
import java.util.HashMap;
import javax.faces.context.ExternalContext;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.model.WCMAppModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.MutableAuthenticationDao;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.TestWithUserUtils;
import org.alfresco.web.forms.FormImpl;
import org.alfresco.web.forms.FormsService;
import org.alfresco.web.forms.XMLUtil;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shale.test.mock.MockExternalContext;
import org.apache.shale.test.mock.MockFacesContext;
import org.apache.shale.test.mock.MockHttpServletRequest;
import org.apache.shale.test.mock.MockHttpServletResponse;
import org.apache.shale.test.mock.MockServletContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.StaticWebApplicationContext;
import org.w3c.dom.Document;

public class FormsTest
extends BaseSpringTest {
    private static final Log LOGGER = LogFactory.getLog(FormsTest.class);
    private static final String WEB_CLIENT_APPLICATION_CONTEXT = "classpath:alfresco/web-client-application-context.xml";
    private NodeService nodeService;
    private FormsService formsService;
    private MockForm mockForm;

    protected void onSetUpInTransaction() throws Exception {
        System.err.println("onSetUpInTransaction");
        super.onSetUpInTransaction();
        this.nodeService = (NodeService)this.applicationContext.getBean("dbNodeService");
        FormsTest.assertNotNull((Object)this.nodeService);
        FileFolderService fileFolderService = (FileFolderService)this.applicationContext.getBean("fileFolderService");
        FormsTest.assertNotNull((Object)fileFolderService);
        this.formsService = (FormsService)this.applicationContext.getBean("FormsService");
        FormsTest.assertNotNull((Object)this.formsService);
        MutableAuthenticationService authenticationService = (MutableAuthenticationService)this.applicationContext.getBean("authenticationService");
        authenticationService.clearCurrentSecurityContext();
        MutableAuthenticationDao authenticationDAO = (MutableAuthenticationDao)this.applicationContext.getBean("authenticationDao");
        StoreRef testStoreRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        NodeRef rootNodeRef = this.nodeService.getRootNode(testStoreRef);
        if (!authenticationDAO.userExists(AuthenticationUtil.getAdminUserName())) {
            authenticationService.createAuthentication(AuthenticationUtil.getAdminUserName(), "admin".toCharArray());
        }
        TestWithUserUtils.authenticateUser((String)AuthenticationUtil.getAdminUserName(), (String)"admin", (NodeRef)rootNodeRef, (AuthenticationService)authenticationService);
        MockExternalContext ec = new MockExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        StaticWebApplicationContext ac = new StaticWebApplicationContext();
        ac.setParent((ApplicationContext)this.applicationContext);
        this.applicationContext = ac;
        ec.getApplicationMap().put(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, this.applicationContext);
        new MockFacesContext((ExternalContext)ec);
        FileInfo folderInfo = fileFolderService.create(rootNodeRef, "test_form", WCMAppModel.TYPE_FORMFOLDER);
        HashMap props = new HashMap();
        this.nodeService.addAspect(folderInfo.getNodeRef(), WCMAppModel.ASPECT_FORM, props);
        this.mockForm = new MockForm(folderInfo.getNodeRef(), this.formsService);
    }

    protected String[] getConfigLocations() {
        return (String[])ArrayUtils.add((Object[])super.getConfigLocations(), (Object)WEB_CLIENT_APPLICATION_CONTEXT);
    }

    protected ConfigurableApplicationContext loadContext(Object key) throws Exception {
        return new ClassPathXmlApplicationContext((String[])key);
    }

    public void testOutputPathPatternForFormInstanceData() throws Exception {
        class OutputPathPatternTest {
            public final String expected;
            public final String pattern;
            public final Document xml;
            public final String name;
            public final String parentAVMPath;
            public final String webapp;

            public OutputPathPatternTest(String expected, String pattern, Document xml, String name, String parentAVMPath, String webapp) {
                this.expected = expected;
                this.pattern = pattern;
                this.xml = xml;
                this.name = name;
                this.parentAVMPath = parentAVMPath;
                this.webapp = webapp;
            }
        }
        OutputPathPatternTest[] opps;
        for (OutputPathPatternTest oppt : opps = new OutputPathPatternTest[]{new OutputPathPatternTest("avmstore:/www/avm_webapps/webapp/dir/foo.xml", "${name}.xml", XMLUtil.parse("<foo/>"), "foo", "avmstore:/www/avm_webapps/webapp/dir", "webapp"), new OutputPathPatternTest("avmstore:/www/avm_webapps/foo.xml", "/${name}.xml", XMLUtil.parse("<foo/>"), "foo", "avmstore:/www/avm_webapps/webapp/dir", "webapp"), new OutputPathPatternTest("avmstore:/www/avm_webapps/webapp/foo.xml", "/${webapp}/${name}.xml", XMLUtil.parse("<foo/>"), "foo", "avmstore:/www/avm_webapps/webapp/dir", "webapp"), new OutputPathPatternTest("avmstore:/www/avm_webapps/webapp/foo.xml", "/${webapp}/${name}.xml", XMLUtil.parse("<foo/>"), "foo", "avmstore:/www/avm_webapps/another_webapp/dir", "webapp"), new OutputPathPatternTest("avmstore:/www/avm_webapps/webapp/dir1/dir2/foo.xml", "/${webapp}/${cwd}/${name}.xml", XMLUtil.parse("<foo/>"), "foo", "avmstore:/www/avm_webapps/another_webapp/dir1/dir2", "webapp"), new OutputPathPatternTest("avmstore:/www/avm_webapps/webapp/dir/" + Calendar.getInstance().get(1) + "_foo.xml", "${date?string('yyyy')}_${name}.xml", XMLUtil.parse("<foo/>"), "foo", "avmstore:/www/avm_webapps/webapp/dir", "webapp"), new OutputPathPatternTest("avmstore:/www/avm_webapps/webapp/dir/foo.xml", "${xml.root_tag.name}.xml", XMLUtil.parse("<root_tag><name>foo</name></root_tag>"), "foo", "avmstore:/www/avm_webapps/webapp/dir", "webapp"), new OutputPathPatternTest("avmstore:/www/avm_webapps/webapp/dir/07.xml", "${xml.root_tag.date?date('yyyy-MM-dd')?string('MM')}.xml", XMLUtil.parse("<root_tag><date>1776-07-04</date></root_tag>"), "foo", "avmstore:/www/avm_webapps/webapp/dir", "webapp"), new OutputPathPatternTest("avmstore:/www/avm_webapps/webapp/dir/foo.xml", "${xml['foons:root_tag/foons:name']}.xml", XMLUtil.parse("<foons:root_tag xmlns:foons='bar'><foons:name>foo</foons:name></foons:root_tag>"), "foo", "avmstore:/www/avm_webapps/webapp/dir", "webapp"), new OutputPathPatternTest("avmstore:/www/avm_webapps/webapp/dir/foo.xml", "${xml[\"/*[name()='foons:root_tag']/*[name()='foons:name']\"]}.xml", XMLUtil.parse("<foons:root_tag xmlns:foons='bar'><foons:name>foo</foons:name></foons:root_tag>"), "foo", "avmstore:/www/avm_webapps/webapp/dir", "webapp"), new OutputPathPatternTest("avmstore:/www/avm_webapps/webapp/dir/foo.xml", "${xml['/foons:root_tag/foons:name']}.xml", XMLUtil.parse("<foons:root_tag xmlns:foons='bar'><foons:name>foo</foons:name></foons:root_tag>"), "foo", "avmstore:/www/avm_webapps/webapp/dir", "webapp"), new OutputPathPatternTest(null, "${xml.root_tag.name}", XMLUtil.parse("<foons:root_tag xmlns:foons='bar'><foons:name>foo</foons:name></foons:root_tag>"), "foo", "avmstore:/www/avm_webapps/webapp/dir", "webapp")}) {
            this.mockForm.setOutputPathPattern(oppt.pattern);
            if (oppt.expected == null) {
                try {
                    this.mockForm.getOutputPathForFormInstanceData(oppt.xml, oppt.name, oppt.parentAVMPath, oppt.webapp);
                    FormsTest.fail((String)("expected pattern " + oppt.pattern + " to fail"));
                }
                catch (Exception e) {}
                continue;
            }
            FormsTest.assertEquals((String)(oppt.pattern + " failed"), (String)oppt.expected, (String)this.mockForm.getOutputPathForFormInstanceData(oppt.xml, oppt.name, oppt.parentAVMPath, oppt.webapp));
        }
    }

    private static class MockForm
    extends FormImpl {
        MockForm(NodeRef folderNodeRef, FormsService formsService) {
            super(folderNodeRef, formsService);
        }

        public void setOutputPathPattern(String opp) {
            NodeService nodeService = this.getServiceRegistry().getNodeService();
            nodeService.setProperty(this.getNodeRef(), WCMAppModel.PROP_OUTPUT_PATH_PATTERN, (Serializable)((Object)opp));
        }
    }
}

