/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.forms.xforms;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.faces.context.FacesContext;
import org.alfresco.util.Pair;
import org.alfresco.web.app.Application;
import org.alfresco.web.forms.XMLUtil;
import org.alfresco.web.forms.xforms.FormBuilderException;
import org.alfresco.web.forms.xforms.SchemaUtil;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSAnnotation;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSMultiValueFacet;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.chiba.xml.dom.DOMUtil;
import org.chiba.xml.ns.NamespaceResolver;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Schema2XForms
implements Serializable {
    private static final long serialVersionUID = -2751398323635817643L;
    private static final Log LOGGER = LogFactory.getLog(Schema2XForms.class);
    private static final Pattern repeatableNamePattern = Pattern.compile("\\[.+\\]");
    private static final int LONG_LIST_SIZE = 5;
    private final String action;
    private final SubmitMethod submitMethod;
    private final String base;
    private final boolean formatCaption;
    private final Stack parentStack = new Stack();
    private final Map<String, Long> counter = new HashMap<String, Long>();
    private String targetNamespace;
    private TreeMap<String, TreeSet<XSTypeDefinition>> typeTree;

    public Schema2XForms(String action, SubmitMethod submitMethod, String base, boolean formatCaption) {
        this.reset();
        this.formatCaption = formatCaption;
        this.action = action;
        this.submitMethod = submitMethod;
        this.base = base;
    }

    public Pair<Document, XSModel> buildXForm(Document instanceDocument, Document schemaDocument, String rootElementName, ResourceBundle resourceBundle) throws FormBuilderException {
        XSElementDeclaration rootElementDecl;
        XSModel schema = SchemaUtil.parseSchema(schemaDocument, true);
        this.typeTree = SchemaUtil.buildTypeTree(schema);
        this.counter.clear();
        Document xformsDocument = this.createFormTemplate(rootElementName);
        Element formSection = (Element)xformsDocument.getDocumentElement().getLastChild();
        Element modelSection = (Element)xformsDocument.getDocumentElement().getElementsByTagNameNS("http://www.w3.org/2002/xforms", "model").item(0);
        Element importedSchemaDocumentElement = (Element)xformsDocument.importNode(schemaDocument.getDocumentElement(), true);
        importedSchemaDocumentElement.setAttributeNS(null, "id", "schema-1");
        NodeList nl = importedSchemaDocumentElement.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            String localName;
            Node current = nl.item(i);
            if (current.getNamespaceURI() == null || !current.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") || !(localName = current.getLocalName()).equals("include") && !localName.equals("import")) continue;
            importedSchemaDocumentElement.removeChild(current);
        }
        modelSection.appendChild(importedSchemaDocumentElement);
        StringList schemaNamespaces = schema.getNamespaces();
        HashMap<String, String> schemaNamespacesMap = new HashMap<String, String>();
        if (schemaNamespaces.getLength() != 0) {
            this.targetNamespace = schemaNamespaces.item(0);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("[buildXForm] using targetNamespace " + this.targetNamespace));
            }
            for (int i = 0; i < schemaNamespaces.getLength(); ++i) {
                if (schemaNamespaces.item(i) == null) continue;
                String prefix = Schema2XForms.addNamespace(xformsDocument.getDocumentElement(), schemaDocument.lookupPrefix(schemaNamespaces.item(i)), schemaNamespaces.item(i));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("[buildXForm] adding namespace " + schemaNamespaces.item(i) + " with prefix " + prefix + " to xform and default instance element"));
                }
                schemaNamespacesMap.put(prefix, schemaNamespaces.item(i));
            }
        }
        if ((rootElementDecl = schema.getElementDeclaration(rootElementName, this.targetNamespace)) == null) {
            throw new FormBuilderException("Invalid root element tag name [" + rootElementName + ", targetNamespace = " + this.targetNamespace + "]");
        }
        rootElementName = this.getElementName(rootElementDecl, xformsDocument);
        Element instanceElement = xformsDocument.createElementNS("http://www.w3.org/2002/xforms", "xf:instance");
        modelSection.appendChild(instanceElement);
        this.setXFormsId(instanceElement);
        Element defaultInstanceDocumentElement = xformsDocument.createElement(rootElementName);
        Schema2XForms.addNamespace(defaultInstanceDocumentElement, "xsi", "http://www.w3.org/2001/XMLSchema-instance");
        if (this.targetNamespace != null) {
            String targetNamespacePrefix = schemaDocument.lookupPrefix(this.targetNamespace);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("[buildXForm] adding target namespace " + this.targetNamespace + " with prefix " + targetNamespacePrefix + " to xform and default instance element"));
            }
            Schema2XForms.addNamespace(defaultInstanceDocumentElement, targetNamespacePrefix, this.targetNamespace);
            Schema2XForms.addNamespace(xformsDocument.getDocumentElement(), targetNamespacePrefix, this.targetNamespace);
        }
        Element prototypeInstanceElement = null;
        if (instanceDocument == null || instanceDocument.getDocumentElement() == null) {
            instanceElement.appendChild(defaultInstanceDocumentElement);
        } else {
            Element instanceDocumentElement = instanceDocument.getDocumentElement();
            if (!instanceDocumentElement.getNodeName().equals(rootElementName)) {
                throw new IllegalArgumentException("instance document root tag name invalid.  expected " + rootElementName + ", got " + instanceDocumentElement.getNodeName());
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"[buildXForm] importing rootElement from other document");
            }
            prototypeInstanceElement = xformsDocument.createElementNS("http://www.w3.org/2002/xforms", "xf:instance");
            modelSection.appendChild(prototypeInstanceElement);
            this.setXFormsId(prototypeInstanceElement, "instance_prototype");
            prototypeInstanceElement.appendChild(defaultInstanceDocumentElement);
        }
        Element rootGroup = this.addElement(xformsDocument, modelSection, defaultInstanceDocumentElement, formSection, schema, rootElementDecl, "/" + this.getElementName(rootElementDecl, xformsDocument), new SchemaUtil.Occurrence(1, 1), resourceBundle);
        if (rootGroup.getNodeName() != "xf:group") {
            throw new FormBuilderException("Expected root form element to be a xf:group, not a " + rootGroup.getNodeName() + ".  Ensure that " + this.getElementName(rootElementDecl, xformsDocument) + " is a concrete type that has no extensions.  " + "Types with extensions are not supported for " + "the root element of a form.");
        }
        this.setXFormsId(rootGroup, "alfresco-xforms-root-group");
        if (prototypeInstanceElement != null) {
            Schema2XForms.rebuildInstance(prototypeInstanceElement, instanceDocument, instanceElement, schemaNamespacesMap);
        }
        this.createSubmitElements(xformsDocument, modelSection, rootGroup);
        this.createTriggersForRepeats(xformsDocument, rootGroup);
        Comment comment = xformsDocument.createComment("This XForm was generated by " + this.getClass().getName() + " on " + new Date() + " from the '" + rootElementName + "' element of the '" + this.targetNamespace + "' XML Schema.");
        xformsDocument.getDocumentElement().insertBefore(comment, xformsDocument.getDocumentElement().getFirstChild());
        xformsDocument.normalizeDocument();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("[buildXForm] Returning XForm =\n" + XMLUtil.toString(xformsDocument)));
        }
        return new Pair((Object)xformsDocument, (Object)schema);
    }

    public void reset() {
        this.counter.clear();
    }

    public static void rebuildInstance(Node prototypeNode, Node oldInstanceNode, Node newInstanceNode, HashMap<String, String> schemaNamespaces) {
        JXPathContext prototypeContext = JXPathContext.newContext((Object)prototypeNode);
        prototypeContext.registerNamespace("alf", "http://www.alfresco.org");
        JXPathContext instanceContext = JXPathContext.newContext((Object)oldInstanceNode);
        instanceContext.registerNamespace("alf", "http://www.alfresco.org");
        for (String prefix : schemaNamespaces.keySet()) {
            prototypeContext.registerNamespace(prefix, schemaNamespaces.get(prefix));
            instanceContext.registerNamespace(prefix, schemaNamespaces.get(prefix));
        }
        Iterator it = prototypeContext.iteratePointers("*");
        while (it.hasNext()) {
            Document newInstanceDocument;
            boolean isPrototype;
            Element proto;
            block17: {
                List l;
                block16: {
                    Pointer p = (Pointer)it.next();
                    proto = (Element)p.getNode();
                    String path = p.asPath();
                    boolean bl = isPrototype = proto.hasAttributeNS("http://www.alfresco.org", "prototype") && proto.getAttributeNS("http://www.alfresco.org", "prototype").equals("true");
                    if (isPrototype) {
                        path = path.replaceAll("\\[(\\d+)\\]", "[position() >= $1]");
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)("[rebuildInstance] evaluating prototyped nodes " + path));
                        }
                    } else if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("[rebuildInstance] evaluating child node with positional path " + path));
                    }
                    newInstanceDocument = newInstanceNode.getOwnerDocument();
                    l = instanceContext.selectNodes(path);
                    if (!l.isEmpty()) break block16;
                    if (isPrototype) break block17;
                    LOGGER.debug((Object)("[rebuildInstance] copying in missing node " + proto.getNodeName() + " to " + XMLUtil.buildXPath(newInstanceNode, newInstanceDocument.getDocumentElement())));
                    Element clone = (Element)proto.cloneNode(true);
                    newInstanceNode.appendChild(clone);
                    if (!(oldInstanceNode instanceof Document)) break block17;
                    Schema2XForms.addNamespace(clone, "xsi", "http://www.w3.org/2001/XMLSchema-instance");
                    break block17;
                }
                for (Node old : l) {
                    Element oldEl = (Element)old;
                    Element clone = null;
                    String nSUri = oldEl.getNamespaceURI();
                    clone = nSUri == null ? newInstanceDocument.createElement(oldEl.getTagName()) : newInstanceDocument.createElementNS(nSUri, oldEl.getTagName());
                    newInstanceNode.appendChild(clone);
                    if (oldInstanceNode instanceof Document) {
                        Schema2XForms.addNamespace(clone, "xsi", "http://www.w3.org/2001/XMLSchema-instance");
                    }
                    boolean isEmpty = true;
                    for (Node n = old.getFirstChild(); n != null; n = n.getNextSibling()) {
                        if (n instanceof Text) {
                            clone.appendChild(newInstanceDocument.importNode(n, false));
                            isEmpty = false;
                            continue;
                        }
                        if (n instanceof Element) break;
                    }
                    if (oldEl.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "nil").equals("true")) {
                        clone.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:nil", "true");
                    }
                    NamedNodeMap attributes = proto.getAttributes();
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        Attr attribute = (Attr)attributes.item(i);
                        String localName = attribute.getLocalName();
                        if (localName == null) {
                            String name = attribute.getName();
                            if (oldEl.hasAttribute(name)) {
                                clone.setAttributeNode((Attr)newInstanceDocument.importNode(oldEl.getAttributeNode(name), false));
                                continue;
                            }
                            LOGGER.debug((Object)("[rebuildInstance] copying in missing attribute " + attribute.getNodeName() + " to " + XMLUtil.buildXPath(clone, newInstanceDocument.getDocumentElement())));
                            clone.setAttributeNode((Attr)attribute.cloneNode(false));
                            continue;
                        }
                        String namespace = attribute.getNamespaceURI();
                        if (!isEmpty && namespace.equals("http://www.w3.org/2001/XMLSchema-instance") && localName.equals("nil") || namespace.equals("http://www.alfresco.org") && localName.equals("prototype")) continue;
                        if (oldEl.hasAttributeNS(namespace, localName)) {
                            clone.setAttributeNodeNS((Attr)newInstanceDocument.importNode(oldEl.getAttributeNodeNS(namespace, localName), false));
                            continue;
                        }
                        LOGGER.debug((Object)("[rebuildInstance] copying in missing attribute " + attribute.getNodeName() + " to " + XMLUtil.buildXPath(clone, newInstanceDocument.getDocumentElement())));
                        clone.setAttributeNodeNS((Attr)attribute.cloneNode(false));
                    }
                    Schema2XForms.rebuildInstance(proto, oldEl, clone, schemaNamespaces);
                }
            }
            if (!isPrototype) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("[rebuildInstance] appending " + proto.getNodeName() + " to " + XMLUtil.buildXPath(newInstanceNode, newInstanceDocument.getDocumentElement())));
            }
            newInstanceNode.appendChild(proto.cloneNode(true));
        }
    }

    public static void removePrototypeNodes(Node instanceDocumentElement) {
        HashMap prototypes = new HashMap();
        NodeList children = instanceDocumentElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Element)) continue;
            String nodeName = children.item(i).getNodeName();
            if (!prototypes.containsKey(nodeName)) {
                prototypes.put(nodeName, new LinkedList());
            }
            ((LinkedList)prototypes.get(nodeName)).add((Element)children.item(i));
        }
        for (LinkedList l : prototypes.values()) {
            for (Element e : l) {
                if (e.hasAttributeNS("http://www.alfresco.org", "prototype")) {
                    assert ("true".equals(e.getAttributeNS("http://www.alfresco.org", "prototype")));
                    e.removeAttributeNS("http://www.alfresco.org", "prototype");
                    if (((Element)l.getLast()).equals(e)) {
                        e.getParentNode().removeChild(e);
                    }
                }
                if (e.getParentNode() == null) continue;
                Schema2XForms.removePrototypeNodes(e);
            }
        }
    }

    protected String setXFormsId(Element el) {
        return this.setXFormsId(el, null);
    }

    protected String setXFormsId(Element el, String id) {
        if (el.hasAttributeNS(null, "id")) {
            el.removeAttributeNS(null, "id");
        }
        if (id == null) {
            String name = el.getLocalName();
            Long l = this.counter.get(name);
            long count = l != null ? l : 0L;
            this.counter.put(name, new Long(count + 1L));
            id = name + "_" + count;
        }
        el.setAttributeNS(null, "id", id);
        return id;
    }

    private void resetXFormIds(Element newControl) {
        if (newControl.getNamespaceURI() != null && newControl.getNamespaceURI().equals("http://www.w3.org/2002/xforms")) {
            this.setXFormsId(newControl);
        }
        NodeList children = newControl.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            this.resetXFormIds((Element)child);
        }
    }

    protected void addChoicesForSelectControl(Document xForm, Element choicesElement, Map<String, XSAnnotation> choiceValues, ResourceBundle resourceBundle) {
        for (Map.Entry<String, XSAnnotation> choice : choiceValues.entrySet()) {
            Element item = this.createXFormsItem(xForm, this.createCaption(choice.getKey(), choice.getValue(), resourceBundle), choice.getKey());
            choicesElement.appendChild(item);
        }
    }

    protected Map<String, Element> addChoicesForSelectSwitchControl(Document xformsDocument, Element formSection, List<XSTypeDefinition> choiceValues, String typeBindId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"[addChoicesForSelectSwitchControl] values = ");
            for (XSTypeDefinition type : choiceValues) {
                LOGGER.debug((Object)("  - " + type.getName()));
            }
        }
        HashMap<String, Element> result = new HashMap<String, Element>();
        for (XSTypeDefinition type : choiceValues) {
            String textValue = type.getName();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("[addChoicesForSelectSwitchControl] processing " + textValue));
            }
            Element caseElement = xformsDocument.createElementNS("http://www.w3.org/2002/xforms", "xf:case");
            caseElement.appendChild(this.createLabel(xformsDocument, textValue));
            String caseId = this.setXFormsId(caseElement);
            result.put(textValue, caseElement);
            Element toggle = xformsDocument.createElementNS("http://www.w3.org/2002/xforms", "xf:toggle");
            this.setXFormsId(toggle);
            toggle.setAttributeNS("http://www.w3.org/2002/xforms", "xf:case", caseId);
            Element setValue = xformsDocument.createElementNS("http://www.w3.org/2002/xforms", "xf:setvalue");
            setValue.setAttributeNS("http://www.w3.org/2002/xforms", "xf:bind", typeBindId);
            setValue.appendChild(xformsDocument.createTextNode(textValue));
            formSection.appendChild(this.createTrigger(xformsDocument, null, typeBindId, textValue, toggle, setValue));
        }
        return result;
    }

    private static String extractPropertyFromAnnotation(String namespace, String elementName, XSAnnotation annotation, ResourceBundle resourceBundle) {
        if (annotation == null) {
            return null;
        }
        Document doc = XMLUtil.newDocument();
        annotation.writeAnnotation((Object)doc, (short)3);
        NodeList d = doc.getElementsByTagNameNS(namespace, elementName);
        if (d.getLength() == 0) {
            return null;
        }
        if (d.getLength() > 1) {
            LOGGER.warn((Object)("[extractPropertyFromAnnotation] expected exactly one value for " + namespace + ":" + elementName + ". found " + d.getLength()));
        }
        String result = DOMUtil.getTextNodeAsString((Node)d.item(0));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(namespace + ":" + elementName + " = " + result));
        }
        if (result.startsWith("${") && result.endsWith("}") && resourceBundle != null) {
            result = result.substring("${".length(), result.length() - "}".length());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("[extractPropertyFromAnnotation] looking up key " + result + " in bundle " + resourceBundle));
            }
            try {
                result = resourceBundle.getString(result);
            }
            catch (MissingResourceException mse) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("[extractPropertyFromAnnotation] unable to find key " + result), (Throwable)mse);
                }
                result = "$$" + result + "$$";
            }
        }
        return result;
    }

    private void addAttributeSet(Document xformsDocument, Element modelSection, Element defaultInstanceElement, Element formSection, XSModel schema, XSComplexTypeDefinition controlType, XSElementDeclaration owner, String pathToRoot, boolean checkIfExtension, ResourceBundle resourceBundle) throws FormBuilderException {
        XSObjectList attrUses = controlType.getAttributeUses();
        if (attrUses == null) {
            return;
        }
        for (int i = 0; i < attrUses.getLength(); ++i) {
            String newPathToRoot;
            String prefix;
            XSAttributeUse currentAttributeUse = (XSAttributeUse)attrUses.item(i);
            XSAttributeDeclaration currentAttribute = currentAttributeUse.getAttrDeclaration();
            String attributeName = currentAttributeUse.getName();
            if (attributeName == null || attributeName.length() == 0) {
                attributeName = currentAttributeUse.getAttrDeclaration().getName();
            }
            if (checkIfExtension && SchemaUtil.doesAttributeComeFromExtension(currentAttributeUse, controlType)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("[addAttributeSet] This attribute comes from an extension: recopy form controls. Model section =\n" + XMLUtil.toString(modelSection)));
                }
                NodeList binds = modelSection.getElementsByTagNameNS("http://www.w3.org/2002/xforms", "bind");
                String bindId = null;
                for (int j = 0; j < binds.getLength() && bindId == null; ++j) {
                    String name;
                    Element bind = (Element)binds.item(j);
                    String nodeset = bind.getAttributeNS("http://www.w3.org/2002/xforms", "nodeset");
                    if (nodeset == null || !(name = nodeset.substring(1)).equals(attributeName)) continue;
                    bindId = bind.getAttributeNS(null, "id");
                }
                Node control = null;
                if (bindId != null) {
                    JXPathContext context;
                    Pointer pointer;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("[addAttributeSet] bindId found: " + bindId));
                    }
                    if ((pointer = (context = JXPathContext.newContext((Object)formSection.getOwnerDocument())).getPointer("//*[@xf:bind='" + bindId + "']")) != null) {
                        control = (Element)pointer.getNode();
                    } else if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("[addAttributeSet] unable to resolve pointer for: //*[@xf:bind='" + bindId + "']"));
                    }
                }
                if (LOGGER.isDebugEnabled()) {
                    if (control == null) {
                        LOGGER.debug((Object)"[addAttributeSet] control = <not found>");
                    } else {
                        LOGGER.debug((Object)("[addAttributeSet] control = " + control.getTagName()));
                    }
                }
                if (control == null) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug((Object)"Corresponding control not found");
                    continue;
                }
                Element newControl = (Element)control.cloneNode(true);
                this.resetXFormIds(newControl);
                formSection.appendChild(newControl);
                continue;
            }
            String attrNamespace = currentAttribute.getNamespace();
            String namespacePrefix = "";
            if (attrNamespace != null && attrNamespace.length() > 0 && (prefix = NamespaceResolver.getPrefix((Element)xformsDocument.getDocumentElement(), (String)attrNamespace)) != null && prefix.length() > 0) {
                namespacePrefix = prefix + ":";
            }
            String string = pathToRoot == null || pathToRoot.length() == 0 ? "@" + namespacePrefix + currentAttribute.getName() : (newPathToRoot = pathToRoot.endsWith("/") ? pathToRoot + "@" + namespacePrefix + currentAttribute.getName() : pathToRoot + "/@" + namespacePrefix + currentAttribute.getName());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("[addAttributeSet] adding attribute " + attributeName + " at " + newPathToRoot));
            }
            try {
                String defaultValue;
                String string2 = defaultValue = currentAttributeUse.getConstraintType() == 0 ? null : currentAttributeUse.getConstraintValue();
                if (defaultValue == null && "boolean".equals(currentAttribute.getTypeDefinition().getName())) {
                    defaultValue = "false";
                }
                if (namespacePrefix.length() > 0) {
                    defaultInstanceElement.setAttributeNS(this.targetNamespace, attributeName, defaultValue);
                } else {
                    defaultInstanceElement.setAttribute(attributeName, defaultValue);
                }
            }
            catch (Exception e) {
                throw new FormBuilderException("error retrieving default value for attribute " + attributeName + " at " + newPathToRoot, e);
            }
            this.addSimpleType(xformsDocument, modelSection, formSection, schema, currentAttribute.getTypeDefinition(), currentAttributeUse, newPathToRoot, resourceBundle);
        }
    }

    private Element addComplexType(Document xformsDocument, Element modelSection, Element defaultInstanceElement, Element formSection, XSModel schema, XSComplexTypeDefinition controlType, XSElementDeclaration owner, String pathToRoot, SchemaUtil.Occurrence occurs, boolean relative, boolean checkIfExtension, ResourceBundle resourceBundle) throws FormBuilderException {
        Element groupElement;
        Element repeatSection;
        if (controlType == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("[addComplexType] addComplexType control type is null for pathToRoot = " + pathToRoot));
            }
            return null;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("[addComplexType] Start addComplexType for " + controlType.getName() + " (" + pathToRoot + ")," + " owner = " + (owner == null ? "null" : owner.getName())));
        }
        if ((repeatSection = this.addRepeatIfNecessary(xformsDocument, modelSection, groupElement = this.createGroup(xformsDocument, modelSection, formSection, owner, resourceBundle), (XSTypeDefinition)controlType, pathToRoot, occurs)) != groupElement) {
            groupElement.setAttributeNS("http://www.w3.org/2002/xforms", "xf:appearance", "repeated");
            relative = true;
        }
        if (controlType.getContentType() == 3 || controlType.getContentType() == 1 && controlType.getAttributeUses() != null && controlType.getAttributeUses().getLength() > 0) {
            XSTypeDefinition base = controlType.getBaseType();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("[addComplexType] Control type is mixed, base type = " + base.getName()));
            }
            if (base != null && base != controlType) {
                if (base.getTypeCategory() == 16) {
                    this.addSimpleType(xformsDocument, modelSection, repeatSection, schema, (XSTypeDefinition)((XSSimpleTypeDefinition)base), owner.getName(), (XSObject)owner, pathToRoot, occurs, resourceBundle);
                } else {
                    LOGGER.warn((Object)"[addComplexType] addComplexTypeChildren for mixed type with basic type complex!");
                }
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("[addComplexType] Control content type = " + controlType.getContentType()));
        }
        if (relative) {
            pathToRoot = "";
            modelSection = DOMUtil.getLastChildElement((Node)modelSection);
        }
        this.addAttributeSet(xformsDocument, modelSection, defaultInstanceElement, repeatSection, schema, controlType, owner, pathToRoot, checkIfExtension, resourceBundle);
        XSParticle particle = controlType.getParticle();
        if (particle != null) {
            XSTerm term = particle.getTerm();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("[addComplexType] Particle of " + controlType.getName() + " is" + (term instanceof XSModelGroup ? "" : " not") + " a group: " + term.getClass().getName()));
            }
            if (term instanceof XSModelGroup) {
                switch (((XSModelGroup)term).getCompositor()) {
                    case 2: {
                        LOGGER.warn((Object)("term " + term.getName() + " of particle " + particle.getName() + " of type " + controlType.getName() + " in " + owner.getName() + " describes a " + "xs" + ":choice which is not yet supported, adding it as a " + "xs" + ":sequence"));
                        break;
                    }
                    case 3: {
                        LOGGER.warn((Object)("term " + term.getName() + " of particle " + particle.getName() + " of type " + controlType.getName() + " in " + owner.getName() + " describes a " + "xs" + ":all which is not yet supported, adding it as a " + "xs" + ":sequence"));
                        break;
                    }
                }
                this.addGroup(xformsDocument, modelSection, defaultInstanceElement, repeatSection, schema, (XSModelGroup)term, controlType, owner, pathToRoot, new SchemaUtil.Occurrence(particle), checkIfExtension, resourceBundle);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("[addComplexType] End of addComplexType for " + controlType.getName()));
        }
        return groupElement;
    }

    private Element addElement(Document xformsDocument, Element modelSection, Element defaultInstanceElement, Element formSection, XSModel schema, XSElementDeclaration elementDecl, String pathToRoot, SchemaUtil.Occurrence occurs, ResourceBundle resourceBundle) throws FormBuilderException {
        TreeSet<XSTypeDefinition> compatibleTypes;
        XSTypeDefinition controlType;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("[addElement] adding element " + elementDecl + " at path " + pathToRoot));
        }
        if ((controlType = elementDecl.getTypeDefinition()) == null) {
            LOGGER.warn((Object)("WARNING!!! controlType is null for " + elementDecl + ", " + elementDecl.getName()));
            return null;
        }
        if (controlType.getTypeCategory() == 15 && ((XSComplexTypeDefinition)controlType).getContentType() == 1) {
            controlType = ((XSComplexTypeDefinition)controlType).getSimpleType();
        }
        if (controlType.getTypeCategory() == 16) {
            return this.addSimpleType(xformsDocument, modelSection, formSection, schema, (XSTypeDefinition)((XSSimpleTypeDefinition)controlType), elementDecl.getName(), (XSObject)elementDecl, pathToRoot, occurs, resourceBundle);
        }
        if (controlType.getTypeCategory() == 15 && "anyType".equals(controlType.getName())) {
            return this.addSimpleType(xformsDocument, modelSection, formSection, schema, (XSTypeDefinition)((XSComplexTypeDefinition)controlType), elementDecl.getName(), (XSObject)elementDecl, pathToRoot, occurs, resourceBundle);
        }
        if (controlType.getTypeCategory() != 15) {
            throw new FormBuilderException("Unsupported type [" + elementDecl.getType() + "] for node [" + controlType.getName() + "]");
        }
        boolean relative = true;
        String typeName = controlType.getName();
        boolean typeIsAbstract = ((XSComplexTypeDefinition)controlType).getAbstract();
        TreeSet<XSTypeDefinition> treeSet = compatibleTypes = typeName != null ? this.typeTree.get(typeName) : null;
        if (compatibleTypes == null && typeName != null && LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("[addElement] No compatible type found for " + typeName));
        }
        if (typeName != null && compatibleTypes != null) {
            relative = false;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("[addElement] compatible types for " + typeName + ":"));
                for (XSTypeDefinition compType : compatibleTypes) {
                    LOGGER.debug((Object)("[addElement]   compatible type name = " + compType.getName()));
                }
            }
            if (!typeIsAbstract && compatibleTypes.size() == 0) {
                relative = true;
            } else if (typeIsAbstract && compatibleTypes.size() == 1) {
                controlType = compatibleTypes.first();
                relative = true;
            } else if (typeIsAbstract && compatibleTypes.size() == 0) {
                relative = false;
            } else {
                return this.addElementWithMultipleCompatibleTypes(xformsDocument, modelSection, defaultInstanceElement, formSection, schema, elementDecl, compatibleTypes, pathToRoot, resourceBundle, occurs);
            }
        }
        if (!relative) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("[addElement] bind is not relative for " + elementDecl.getName()));
            }
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("[addElement] Adding empty bind for control " + controlType + " type " + typeName + " nodeset " + pathToRoot + " occurs " + occurs));
            }
            boolean isRepeated = this.isRepeated(occurs, controlType);
            Element bindElement = this.createBind(xformsDocument, pathToRoot + (isRepeated ? "[position() != last()]" : ""));
            modelSection.appendChild(bindElement);
            this.startBindElement(bindElement, schema, controlType, null, occurs);
        }
        return this.addComplexType(xformsDocument, modelSection, defaultInstanceElement, formSection, schema, (XSComplexTypeDefinition)controlType, elementDecl, pathToRoot, occurs, true, false, resourceBundle);
    }

    private Element addElementWithMultipleCompatibleTypes(Document xformsDocument, Element modelSection, Element defaultInstanceElement, Element formSection, XSModel schema, XSElementDeclaration elementDecl, TreeSet<XSTypeDefinition> compatibleTypes, String pathToRoot, ResourceBundle resourceBundle, SchemaUtil.Occurrence occurs) throws FormBuilderException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("[addElementWithMultipleCompatibleTypes] adding element " + elementDecl + " at path " + pathToRoot));
        }
        XSTypeDefinition controlType = elementDecl.getTypeDefinition();
        LinkedList<XSTypeDefinition> enumValues = new LinkedList<XSTypeDefinition>();
        if (!((XSComplexTypeDefinition)controlType).getAbstract()) {
            enumValues.add(controlType);
        }
        enumValues.addAll(compatibleTypes);
        boolean isRepeated = this.isRepeated(occurs, controlType);
        Element bindElement = this.createBind(xformsDocument, pathToRoot + "/@xsi:type");
        String bindId = bindElement.getAttributeNS(null, "id");
        modelSection.appendChild(bindElement);
        this.startBindElement(bindElement, schema, controlType, null, occurs);
        Element bindElement2 = this.createBind(xformsDocument, pathToRoot + (isRepeated ? "[position() != last()]" : ""));
        modelSection.appendChild(bindElement2);
        this.startBindElement(bindElement2, schema, controlType, null, occurs);
        Map<String, Element> caseTypes = this.addChoicesForSelectSwitchControl(xformsDocument, formSection, enumValues, bindId);
        Element switchElement = xformsDocument.createElementNS("http://www.w3.org/2002/xforms", "xf:switch");
        switchElement.setAttributeNS("http://www.w3.org/2002/xforms", "xf:bind", bindId);
        switchElement.setAttributeNS("http://www.w3.org/2002/xforms", "xf:appearance", "full");
        formSection.appendChild(switchElement);
        if (!((XSComplexTypeDefinition)controlType).getAbstract()) {
            Element firstCaseElement = caseTypes.get(controlType.getName());
            switchElement.appendChild(firstCaseElement);
            Element firstGroupElement = this.addComplexType(xformsDocument, modelSection, defaultInstanceElement, firstCaseElement, schema, (XSComplexTypeDefinition)controlType, elementDecl, pathToRoot, SchemaUtil.getOccurrence(elementDecl), true, false, resourceBundle);
            firstGroupElement.setAttributeNS("http://www.w3.org/2002/xforms", "xf:appearance", "");
        }
        defaultInstanceElement.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", ((XSComplexTypeDefinition)controlType).getAbstract() ? compatibleTypes.first().getName() : controlType.getName());
        defaultInstanceElement.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:nil", "true");
        for (XSTypeDefinition type : compatibleTypes) {
            String compatibleTypeName = type.getName();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(type == null ? "[addElementWithMultipleCompatibleTypes] compatible type is null!! type = " + compatibleTypeName + ", targetNamespace = " + this.targetNamespace : "[addElementWithMultipleCompatibleTypes] adding compatible type " + type.getName()));
            }
            if (type == null || type.getTypeCategory() != 15) continue;
            Element caseElement = caseTypes.get(type.getName());
            switchElement.appendChild(caseElement);
            Element groupElement = this.addComplexType(xformsDocument, modelSection, defaultInstanceElement, caseElement, schema, (XSComplexTypeDefinition)type, elementDecl, pathToRoot, SchemaUtil.getOccurrence(elementDecl), true, true, resourceBundle);
            groupElement.setAttributeNS("http://www.w3.org/2002/xforms", "xf:appearance", "");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("[addElementWithMultipleCompatibleTypes] Model section =\n" + XMLUtil.toString(bindElement2)));
            }
            NodeList binds = bindElement2.getElementsByTagNameNS("http://www.w3.org/2002/xforms", "bind");
            for (int i = 0; i < binds.getLength(); ++i) {
                String relevant;
                Element subBind = (Element)binds.item(i);
                String name = subBind.getAttributeNS("http://www.w3.org/2002/xforms", "nodeset");
                name = repeatableNamePattern.matcher(name).replaceAll("");
                if (!subBind.getParentNode().getAttributes().getNamedItem("id").getNodeValue().equals(bindElement2.getAttribute("id"))) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("[addElementWithMultipleCompatibleTypes] Testing sub-bind with nodeset " + name));
                }
                if (!SchemaUtil.isElementDeclaredIn(name, (XSComplexTypeDefinition)type, false) && !SchemaUtil.isAttributeDeclaredIn(name, (XSComplexTypeDefinition)type, false)) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("[addElementWithMultipleCompatibleTypes] Element/Attribute " + name + " declared in type " + type.getName() + ": adding relevant attribute"));
                }
                String newRelevant = "../@xsi:type='" + type.getName() + "'";
                if (this.typeTree.containsKey(type.getName())) {
                    for (XSTypeDefinition otherType : this.typeTree.get(type.getName())) {
                        newRelevant = newRelevant + " or ../@xsi:type='" + otherType.getName() + "'";
                    }
                }
                if ((relevant = subBind.getAttributeNS("http://www.w3.org/2002/xforms", "relevant")) != null && relevant.length() != 0) {
                    newRelevant = "(" + relevant + ") and " + newRelevant;
                }
                subBind.setAttributeNS("http://www.w3.org/2002/xforms", "xf:relevant", newRelevant);
            }
        }
        return switchElement;
    }

    private void addGroup(Document xformsDocument, Element modelSection, Element defaultInstanceElement, Element formSection, XSModel schema, XSModelGroup group, XSComplexTypeDefinition controlType, XSElementDeclaration owner, String pathToRoot, SchemaUtil.Occurrence occurs, boolean checkIfExtension, ResourceBundle resourceBundle) throws FormBuilderException {
        if (group == null) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("[addGroup] Start of addGroup, from owner = " + owner.getName() + " and controlType = " + controlType.getName()));
            LOGGER.debug((Object)("[addGroup] group before =\n" + XMLUtil.toString(formSection)));
        }
        Element repeatSection = this.addRepeatIfNecessary(xformsDocument, modelSection, formSection, owner.getTypeDefinition(), pathToRoot, occurs);
        XSObjectList particles = group.getParticles();
        for (int counter = 0; counter < particles.getLength(); ++counter) {
            XSParticle currentNode = (XSParticle)particles.item(counter);
            XSTerm term = currentNode.getTerm();
            SchemaUtil.Occurrence childOccurs = new SchemaUtil.Occurrence(currentNode);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("[addGroup] next term = " + term.getName() + ", occurs = " + childOccurs));
            }
            if (term instanceof XSModelGroup) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"[addGroup] term is a group");
                }
                this.addGroup(xformsDocument, modelSection, defaultInstanceElement, repeatSection, schema, (XSModelGroup)term, controlType, owner, pathToRoot, childOccurs, checkIfExtension, resourceBundle);
                continue;
            }
            if (term instanceof XSElementDeclaration) {
                XSElementDeclaration element = (XSElementDeclaration)term;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("[addGroup] term is an element declaration: " + term.getName()));
                }
                if (checkIfExtension && SchemaUtil.doesElementComeFromExtension(element, controlType)) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("[addGroup] This element comes from an extension: recopy form controls. Model Section =\n" + XMLUtil.toString(modelSection)));
                    }
                    NodeList binds = modelSection.getElementsByTagNameNS("http://www.w3.org/2002/xforms", "bind");
                    String bindId = null;
                    for (int i = 0; i < binds.getLength() && bindId == null; ++i) {
                        Element bind = (Element)binds.item(i);
                        String nodeset = bind.getAttributeNS("http://www.w3.org/2002/xforms", "nodeset");
                        if (nodeset == null || !nodeset.equals(element.getName())) continue;
                        bindId = bind.getAttributeNS(null, "id");
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("[addGroup] found bindId " + bindId + " for element " + element.getName()));
                    }
                    Node control = null;
                    if (bindId != null) {
                        JXPathContext context;
                        Pointer pointer;
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)("[addGroup] bindId found: " + bindId));
                        }
                        if ((pointer = (context = JXPathContext.newContext((Object)formSection.getOwnerDocument())).getPointer("//*[@xf:bind='" + bindId + "']")) != null) {
                            control = (Element)pointer.getNode();
                        } else if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)("[addGroup] unable to resolve pointer for: //*[@xf:bind='" + bindId + "']"));
                        }
                    }
                    if (LOGGER.isDebugEnabled()) {
                        if (control == null) {
                            LOGGER.debug((Object)"[addGroup] control = <not found>");
                        } else {
                            LOGGER.debug((Object)("[addGroup] control = " + control.getTagName()));
                        }
                    }
                    if (control == null) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)"Corresponding control not found");
                        }
                        this.addElementToGroup(xformsDocument, modelSection, defaultInstanceElement, repeatSection, schema, element, pathToRoot, childOccurs, resourceBundle);
                        continue;
                    }
                    Element newControl = (Element)control.cloneNode(true);
                    this.resetXFormIds(newControl);
                    repeatSection.appendChild(newControl);
                    continue;
                }
                this.addElementToGroup(xformsDocument, modelSection, defaultInstanceElement, repeatSection, schema, element, pathToRoot, childOccurs, resourceBundle);
                continue;
            }
            LOGGER.warn((Object)("Unhandled term " + term + " found in group from " + owner.getName() + " for pathToRoot = " + pathToRoot));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("[addGroup] group after =\n" + XMLUtil.toString(formSection)));
            LOGGER.debug((Object)("[addGroup] End of addGroup, from owner = " + owner.getName() + " and controlType = " + controlType.getName()));
        }
    }

    private void addElementToGroup(Document xformsDocument, Element modelSection, Element defaultInstanceElement, Element formSection, XSModel schema, XSElementDeclaration element, String pathToRoot, SchemaUtil.Occurrence occurs, ResourceBundle resourceBundle) throws FormBuilderException {
        Text value;
        String path;
        String elementName = this.getElementName(element, xformsDocument);
        String string = path = pathToRoot.length() == 0 ? elementName : pathToRoot + "/" + elementName;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("[addElementToGroup] Start addElement to group " + elementName + " at " + path + " parentStack " + this.parentStack));
        }
        if (this.parentStack.contains(element)) {
            throw new FormBuilderException("recursion detected at element " + elementName);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("[addElementToGroup] pushing element " + element + " onto parent stack"));
        }
        this.parentStack.push(element);
        Element newDefaultInstanceElement = xformsDocument.createElement(elementName);
        if (element.getConstraintType() != 0) {
            value = xformsDocument.createTextNode(element.getConstraintValue());
            newDefaultInstanceElement.appendChild(value);
        } else if ("boolean".equals(element.getTypeDefinition().getName())) {
            value = xformsDocument.createTextNode("false");
            newDefaultInstanceElement.appendChild(value);
        }
        this.addElement(xformsDocument, modelSection, newDefaultInstanceElement, formSection, schema, element, path, occurs, resourceBundle);
        Object poppedElement = this.parentStack.pop();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("[addElementToGroup] popped element " + poppedElement + " from parent stack"));
            LOGGER.debug((Object)("[addElementToGroup] adding " + (occurs.maximum == 1 ? 1 : occurs.minimum + 1) + " default instance element for " + elementName + " at path " + path));
        }
        if (this.isRepeated(occurs, element.getTypeDefinition())) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("[addElementToGroup] adding " + (occurs.minimum + 1) + " default instance elements for " + elementName + " at path " + path));
            }
            for (int i = 0; i < occurs.minimum + 1; ++i) {
                Element e = (Element)newDefaultInstanceElement.cloneNode(true);
                if (i == occurs.minimum) {
                    e.setAttributeNS("http://www.alfresco.org", "alf:prototype", "true");
                }
                defaultInstanceElement.appendChild(e);
            }
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("[addElementToGroup] adding one default instance element for " + elementName + " at path " + path));
            }
            if (occurs.minimum == 0) {
                newDefaultInstanceElement.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:nil", "true");
            }
            defaultInstanceElement.appendChild(newDefaultInstanceElement);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("[addGroup] End of addElementToGroup, group = " + elementName));
        }
    }

    private Element addRepeatIfNecessary(Document xformsDocument, Element modelSection, Element formSection, XSTypeDefinition controlType, String pathToRoot, SchemaUtil.Occurrence o) {
        if (o.isOptional() && (controlType instanceof XSSimpleTypeDefinition || "anyType".equals(controlType.getName())) || o.maximum == 1 && o.minimum == 1 || controlType instanceof XSComplexTypeDefinition && pathToRoot.equals("")) {
            return formSection;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("[addRepeatIfNecessary] for multiple element for type " + controlType.getName() + ", maxOccurs = " + o.maximum));
        }
        Element repeatSection = xformsDocument.createElementNS("http://www.w3.org/2002/xforms", "xf:repeat");
        Element bind = DOMUtil.getLastChildElement((Node)modelSection);
        String bindId = null;
        if (bind != null && bind.getLocalName() != null && "bind".equals(bind.getLocalName())) {
            bindId = bind.getAttributeNS(null, "id");
        } else {
            LOGGER.warn((Object)("[addRepeatIfNecessary] bind not found: " + bind + " (model selection name = " + modelSection.getNodeName() + ")"));
            bind = DOMUtil.getLastChildElement((Node)modelSection.getParentNode());
            if (bind != null && bind.getLocalName() != null && "bind".equals(bind.getLocalName())) {
                bindId = bind.getAttributeNS(null, "id");
            } else {
                LOGGER.warn((Object)"[addRepeatIfNecessary] bind really not found");
            }
        }
        repeatSection.setAttributeNS("http://www.w3.org/2002/xforms", "xf:bind", bindId);
        this.setXFormsId(repeatSection);
        repeatSection.setAttributeNS("http://www.w3.org/2002/xforms", "xf:appearance", "full");
        formSection.appendChild(repeatSection);
        Element group = xformsDocument.createElementNS("http://www.w3.org/2002/xforms", "xf:group");
        group.setAttributeNS("http://www.w3.org/2002/xforms", "xf:appearance", "repeated");
        this.setXFormsId(group);
        repeatSection.appendChild(group);
        return group;
    }

    private Element addSimpleType(Document xformsDocument, Element modelSection, Element formSection, XSModel schema, XSTypeDefinition controlType, String owningElementName, XSObject owner, String pathToRoot, SchemaUtil.Occurrence occurs, ResourceBundle resourceBundle) {
        Element repeatSection;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("[addSimpleType] for " + controlType.getName() + " (owningElementName = " + owningElementName + ")," + " occurs = [" + occurs + "]"));
            if (owner != null) {
                LOGGER.debug((Object)("[addSimpleType] owner is " + owner.getClass() + ", name is " + owner.getName()));
            }
        }
        boolean isRepeated = this.isRepeated(occurs, controlType);
        Element bindElement = this.createBind(xformsDocument, pathToRoot + (isRepeated ? "[position() != last()]" : ""));
        String bindId = bindElement.getAttributeNS(null, "id");
        modelSection.appendChild(bindElement);
        bindElement = this.startBindElement(bindElement, schema, controlType, owner, occurs);
        if (owner instanceof XSElementDeclaration && occurs.isRepeated()) {
            Element groupElement = this.createGroup(xformsDocument, modelSection, formSection, (XSElementDeclaration)owner, resourceBundle);
            groupElement.setAttributeNS("http://www.w3.org/2002/xforms", "xf:appearance", "repeated");
            formSection = groupElement;
        }
        if ((repeatSection = this.addRepeatIfNecessary(xformsDocument, modelSection, formSection, controlType, pathToRoot, occurs)) != formSection) {
            Element bindElement2 = this.createBind(xformsDocument, ".");
            String bindId2 = bindElement2.getAttributeNS(null, "id");
            bindElement.appendChild(bindElement2);
            bindElement = bindElement2;
            bindId = bindId2;
        }
        String caption = owner != null ? this.createCaption(owner, resourceBundle) : this.createCaption(owningElementName);
        Element formControl = this.createFormControl(xformsDocument, schema, caption, controlType, owner, bindId, bindElement, occurs, resourceBundle);
        repeatSection.appendChild(formControl);
        return formSection;
    }

    private Element addSimpleType(Document xformsDocument, Element modelSection, Element formSection, XSModel schema, XSSimpleTypeDefinition controlType, XSAttributeUse owningAttribute, String pathToRoot, ResourceBundle resourceBundle) {
        return this.addSimpleType(xformsDocument, modelSection, formSection, schema, (XSTypeDefinition)controlType, owningAttribute.getAttrDeclaration().getName(), (XSObject)owningAttribute, pathToRoot, new SchemaUtil.Occurrence(owningAttribute.getRequired() ? 1 : 0, 1), resourceBundle);
    }

    private Element createFormControl(Document xformsDocument, XSModel schema, String caption, XSTypeDefinition controlType, XSObject owner, String bindId, Element bindElement, SchemaUtil.Occurrence o, ResourceBundle resourceBundle) {
        Element formControl = null;
        formControl = controlType.getTypeCategory() == 16 && ((XSSimpleTypeDefinition)controlType).getItemType() != null ? this.createControlForListType(xformsDocument, (XSSimpleTypeDefinition)controlType, owner, caption, bindElement, resourceBundle) : (controlType.getTypeCategory() == 16 && ((XSSimpleTypeDefinition)controlType).isDefinedFacet((short)2048) ? this.createControlForEnumerationType(xformsDocument, (XSSimpleTypeDefinition)controlType, owner, caption, bindElement, resourceBundle) : (controlType.getTypeCategory() == 15 && "anyType".equals(controlType.getName()) ? this.createControlForAnyType(xformsDocument, caption, controlType) : this.createControlForAtomicType(xformsDocument, (XSSimpleTypeDefinition)controlType, owner, caption, resourceBundle)));
        formControl.setAttributeNS("http://www.w3.org/2002/xforms", "xf:bind", bindId);
        Element alertElement = xformsDocument.createElementNS("http://www.w3.org/2002/xforms", "xf:alert");
        formControl.appendChild(alertElement);
        this.setXFormsId(alertElement);
        String alert = Schema2XForms.extractPropertyFromAnnotation("http://www.alfresco.org", "alert", this.getAnnotation(owner), resourceBundle);
        if (alert == null) {
            alert = "Please provide a valid value for '" + caption + "'." + " '" + caption + "' is " + (o.minimum == 0 ? "an optional" : "a required") + " '" + this.createCaption(this.getXFormsTypeName(xformsDocument, schema, controlType)) + "' value.";
        }
        alertElement.appendChild(xformsDocument.createTextNode(alert));
        String hint = Schema2XForms.extractPropertyFromAnnotation("http://www.alfresco.org", "hint", this.getAnnotation(owner), resourceBundle);
        if (hint != null) {
            Element hintElement = xformsDocument.createElementNS("http://www.w3.org/2002/xforms", "xf:hint");
            formControl.appendChild(hintElement);
            this.setXFormsId(hintElement);
            hintElement.appendChild(xformsDocument.createTextNode(hint));
        }
        return formControl;
    }

    protected String getXFormsTypeName(Document xformsDocument, XSModel schema, XSTypeDefinition controlType) {
        Element context = xformsDocument.getDocumentElement();
        String typeName = controlType.getName();
        String typeNS = controlType.getNamespace();
        if (controlType.getTypeCategory() != 16 || typeName == null || typeName.length() == 0 || schema.getTypeDefinition(typeName, typeNS) == null || typeNS != null && "http://www.w3.org/2001/XMLSchema".equals(typeNS)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("[getXFormsTypeName] using built in type for " + typeName));
            }
            return SchemaUtil.getBuiltInTypeName(controlType);
        }
        String localTypeName = typeName;
        int index = typeName.indexOf(58);
        if (index > -1 && typeName.length() > index) {
            localTypeName = typeName.substring(index + 1);
        }
        String result = localTypeName;
        if (typeNS != null) {
            String prefix = NamespaceResolver.getPrefix((Element)context, (String)typeNS);
            if (prefix != null && prefix.length() != 0) {
                result = prefix + ":" + localTypeName;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("[getXFormsTypeName] resolved namespace prefix for uri " + typeNS + " to " + prefix + " using document element " + context));
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("[getXFormsTypeName] typeName = " + typeName + ", typeNS = " + typeNS + ", result = " + result));
        }
        return result;
    }

    private Document createFormTemplate(String formId) {
        Document xformsDocument = XMLUtil.newDocument();
        Element envelopeElement = xformsDocument.createElementNS("http://www.w3.org/1999/xhtml", "xhtml:html");
        xformsDocument.appendChild(envelopeElement);
        Schema2XForms.addNamespace(envelopeElement, "xhtml", "http://www.w3.org/1999/xhtml");
        Schema2XForms.addNamespace(envelopeElement, "xf", "http://www.w3.org/2002/xforms");
        Schema2XForms.addNamespace(envelopeElement, "ev", "http://www.w3.org/2001/xml-events");
        Schema2XForms.addNamespace(envelopeElement, "xsi", "http://www.w3.org/2001/XMLSchema-instance");
        Schema2XForms.addNamespace(envelopeElement, "alf", "http://www.alfresco.org");
        if (this.base != null && this.base.length() != 0) {
            envelopeElement.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:base", this.base);
        }
        Element modelElement = xformsDocument.createElementNS("http://www.w3.org/2002/xforms", "xf:model");
        modelElement.setAttributeNS("http://www.w3.org/2002/xforms", "xf:functions", "chiba:match");
        this.setXFormsId(modelElement);
        Element modelWrapper = xformsDocument.createElementNS("http://www.w3.org/1999/xhtml", "xhtml:head");
        modelWrapper.appendChild(modelElement);
        envelopeElement.appendChild(modelWrapper);
        Element formWrapper = xformsDocument.createElementNS("http://www.w3.org/1999/xhtml", "xhtml:body");
        envelopeElement.appendChild(formWrapper);
        return xformsDocument;
    }

    private Element createGroup(Document xformsDocument, Element modelSection, Element formSection, XSElementDeclaration owner, ResourceBundle resourceBundle) {
        Element result = xformsDocument.createElementNS("http://www.w3.org/2002/xforms", "xf:group");
        this.setXFormsId(result);
        String appearance = Schema2XForms.extractPropertyFromAnnotation("http://www.alfresco.org", "appearance", this.getAnnotation((XSObject)owner), resourceBundle);
        result.setAttributeNS("http://www.w3.org/2002/xforms", "xf:appearance", appearance == null || appearance.length() == 0 ? "full" : appearance);
        formSection.appendChild(result);
        result.appendChild(this.createLabel(xformsDocument, this.createCaption(owner, resourceBundle)));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("[createGroup] group =\n" + XMLUtil.toString(result)));
        }
        return result;
    }

    public String createCaption(String text, XSObject o, ResourceBundle resourceBundle) {
        return this.createCaption(text, this.getAnnotation(o), resourceBundle);
    }

    public String createCaption(String text, XSAnnotation annotation, ResourceBundle resourceBundle) {
        String s = Schema2XForms.extractPropertyFromAnnotation("http://www.alfresco.org", "label", annotation, resourceBundle);
        return s != null ? s : this.createCaption(text);
    }

    public String createCaption(String text) {
        if (!this.formatCaption) {
            return text;
        }
        if (text.equals(text.toUpperCase())) {
            text = text.toLowerCase();
        }
        String[] s = text.split("[-_\\ ]");
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < s.length; ++i) {
            if (i != 0) {
                result.append(' ');
            }
            if (s[i].length() > 1) {
                result.append(Character.toUpperCase(s[i].charAt(0)) + s[i].substring(1, s[i].length()));
                continue;
            }
            result.append(s[i]);
        }
        return result.toString();
    }

    public String createCaption(XSAttributeDeclaration attribute, ResourceBundle resourceBundle) {
        return this.createCaption(attribute.getName(), (XSObject)attribute, resourceBundle);
    }

    public String createCaption(XSAttributeUse attribute, ResourceBundle resourceBundle) {
        return this.createCaption(attribute.getAttrDeclaration().getName(), (XSObject)attribute, resourceBundle);
    }

    public String createCaption(XSElementDeclaration element, ResourceBundle resourceBundle) {
        return this.createCaption(element.getName(), (XSObject)element, resourceBundle);
    }

    public String createCaption(XSObject element, ResourceBundle resourceBundle) {
        if (element instanceof XSElementDeclaration) {
            return this.createCaption((XSElementDeclaration)element, resourceBundle);
        }
        if (element instanceof XSAttributeDeclaration) {
            return this.createCaption((XSAttributeDeclaration)element, resourceBundle);
        }
        if (element instanceof XSAttributeUse) {
            return this.createCaption((XSAttributeUse)element, resourceBundle);
        }
        LOGGER.warn((Object)("WARNING: createCaption: element is not an attribute nor an element: " + element.getClass().getName()));
        return null;
    }

    public Element createControlForAnyType(Document xformsDocument, String caption, XSTypeDefinition controlType) {
        Element control = xformsDocument.createElementNS("http://www.w3.org/2002/xforms", "xf:textarea");
        this.setXFormsId(control);
        control.setAttributeNS("http://www.w3.org/2002/xforms", "xf:appearance", "compact");
        control.appendChild(this.createLabel(xformsDocument, caption));
        return control;
    }

    public Element createControlForAtomicType(Document xformsDocument, XSSimpleTypeDefinition controlType, XSObject owner, String caption, ResourceBundle resourceBundle) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("[createControlForAtomicType] {name: " + controlType.getName() + ", numeric: " + controlType.getNumeric() + ", bounded: " + controlType.getBounded() + ", finite: " + controlType.getFinite() + ", ordered: " + controlType.getOrdered() + ", final: " + controlType.getFinal() + ", minInc: " + controlType.getLexicalFacetValue((short)256) + ", maxInc: " + controlType.getLexicalFacetValue((short)32) + ", minExc: " + controlType.getLexicalFacetValue((short)128) + ", maxExc: " + controlType.getLexicalFacetValue((short)64) + ", totalDigits: " + controlType.getLexicalFacetValue((short)512) + ", length: " + controlType.getLexicalFacetValue((short)1) + ", minLength: " + controlType.getLexicalFacetValue((short)2) + ", maxLength: " + controlType.getLexicalFacetValue((short)4) + ", fractionDigits: " + controlType.getLexicalFacetValue((short)1024) + ", builtInTypeName: " + SchemaUtil.getBuiltInTypeName((XSTypeDefinition)controlType) + ", builtInType: " + SchemaUtil.getBuiltInType((XSTypeDefinition)controlType) + "}"));
        }
        String appearance = Schema2XForms.extractPropertyFromAnnotation("http://www.alfresco.org", "appearance", this.getAnnotation(owner), resourceBundle);
        Element result = null;
        if (controlType.getNumeric()) {
            if (controlType.getBounded() && controlType.getLexicalFacetValue((short)32) != null && controlType.getLexicalFacetValue((short)256) != null) {
                result = xformsDocument.createElementNS("http://www.w3.org/2002/xforms", "xf:range");
                result.setAttributeNS("http://www.w3.org/2002/xforms", "xf:start", controlType.getLexicalFacetValue((short)256));
                result.setAttributeNS("http://www.w3.org/2002/xforms", "xf:end", controlType.getLexicalFacetValue((short)32));
            } else {
                result = xformsDocument.createElementNS("http://www.w3.org/2002/xforms", "xf:input");
            }
            if (controlType.isDefinedFacet((short)1024)) {
                String fractionDigits = controlType.getLexicalFacetValue((short)1024);
                if (fractionDigits == null || fractionDigits.length() == 0) {
                    short builtInType = SchemaUtil.getBuiltInType((XSTypeDefinition)controlType);
                    String string = fractionDigits = builtInType >= 30 && builtInType <= 42 ? "0" : null;
                }
                if (fractionDigits != null) {
                    result.setAttributeNS("http://www.alfresco.org", "alf:fractionDigits", fractionDigits);
                }
            }
            if (controlType.isDefinedFacet((short)512)) {
                result.setAttributeNS("http://www.alfresco.org", "alf:totalDigits", controlType.getLexicalFacetValue((short)512));
            }
        } else {
            switch (SchemaUtil.getBuiltInType((XSTypeDefinition)controlType)) {
                case 3: {
                    String[] values;
                    result = xformsDocument.createElementNS("http://www.w3.org/2002/xforms", "xf:select1");
                    for (String v : values = new String[]{"true", "false"}) {
                        Element item = this.createXFormsItem(xformsDocument, v, v);
                        result.appendChild(item);
                    }
                    break;
                }
                case 2: {
                    result = xformsDocument.createElementNS("http://www.w3.org/2002/xforms", "xf:textarea");
                    if (appearance != null && appearance.length() != 0) break;
                    appearance = "compact";
                    break;
                }
                case 18: {
                    result = xformsDocument.createElementNS("http://www.w3.org/2002/xforms", "xf:upload");
                    Element e = xformsDocument.createElementNS("http://www.w3.org/2002/xforms", "xf:filename");
                    this.setXFormsId(e);
                    result.appendChild(e);
                    e.setAttributeNS("http://www.w3.org/2002/xforms", "xf:ref", ".");
                    break;
                }
                default: {
                    Date d;
                    result = xformsDocument.createElementNS("http://www.w3.org/2002/xforms", "xf:input");
                    if ((appearance == null || appearance.length() == 0) && SchemaUtil.getBuiltInType((XSTypeDefinition)controlType) == 21) {
                        appearance = "full";
                    }
                    if (controlType.isDefinedFacet((short)1)) {
                        result.setAttributeNS("http://www.alfresco.org", "alf:length", controlType.getLexicalFacetValue((short)1));
                    } else if (controlType.isDefinedFacet((short)2) || controlType.isDefinedFacet((short)4)) {
                        if (controlType.isDefinedFacet((short)2)) {
                            result.setAttributeNS("http://www.alfresco.org", "alf:minLength", controlType.getLexicalFacetValue((short)2));
                        }
                        if (controlType.isDefinedFacet((short)4)) {
                            result.setAttributeNS("http://www.alfresco.org", "alf:maxLength", controlType.getLexicalFacetValue((short)4));
                        }
                    }
                    if (SchemaUtil.getBuiltInType((XSTypeDefinition)controlType) != 10) break;
                    String minInclusive = null;
                    String maxInclusive = null;
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    Calendar calendar = Calendar.getInstance();
                    if (controlType.isDefinedFacet((short)64)) {
                        minInclusive = controlType.getLexicalFacetValue((short)128);
                        try {
                            d = sdf.parse(minInclusive);
                            calendar.setTime(d);
                        }
                        catch (ParseException pe) {
                            LOGGER.error((Object)pe);
                        }
                        calendar.roll(5, true);
                        minInclusive = sdf.format(calendar.getTime());
                    } else if (controlType.isDefinedFacet((short)256)) {
                        minInclusive = controlType.getLexicalFacetValue((short)256);
                    }
                    if (controlType.isDefinedFacet((short)64)) {
                        maxInclusive = controlType.getLexicalFacetValue((short)64);
                        try {
                            d = sdf.parse(maxInclusive);
                            calendar.setTime(d);
                        }
                        catch (ParseException pe) {
                            LOGGER.error((Object)pe);
                        }
                        calendar.roll(5, false);
                        maxInclusive = sdf.format(calendar.getTime());
                    } else if (controlType.isDefinedFacet((short)32)) {
                        maxInclusive = controlType.getLexicalFacetValue((short)32);
                    }
                    if (minInclusive != null) {
                        result.setAttributeNS("http://www.alfresco.org", "alf:minInclusive", minInclusive);
                    }
                    if (maxInclusive == null) break;
                    result.setAttributeNS("http://www.alfresco.org", "alf:maxInclusive", maxInclusive);
                }
            }
        }
        this.setXFormsId(result);
        result.appendChild(this.createLabel(xformsDocument, caption));
        if (appearance != null && appearance.length() != 0) {
            result.setAttributeNS("http://www.w3.org/2002/xforms", "xf:appearance", appearance);
        }
        return result;
    }

    public Element createControlForEnumerationType(Document xformsDocument, XSSimpleTypeDefinition controlType, XSObject owner, String caption, Element bindElement, ResourceBundle resourceBundle) {
        StringList enumFacets = controlType.getLexicalEnumeration();
        if (enumFacets.getLength() <= 0) {
            return null;
        }
        Element control = xformsDocument.createElementNS("http://www.w3.org/2002/xforms", "xf:select1");
        this.setXFormsId(control);
        control.appendChild(this.createLabel(xformsDocument, caption));
        Element choices = xformsDocument.createElementNS("http://www.w3.org/2002/xforms", "xf:choices");
        this.setXFormsId(choices);
        XSObjectList mvFacets = controlType.getMultiValueFacets();
        if (mvFacets.getLength() != 1) {
            throw new RuntimeException("expected exactly one MultiValueFacet for " + controlType);
        }
        XSObjectList annotations = ((XSMultiValueFacet)mvFacets.item(0)).getAnnotations();
        LinkedHashMap<String, XSAnnotation> enumValues = new LinkedHashMap<String, XSAnnotation>(enumFacets.getLength());
        String nullValue = Application.getMessage(FacesContext.getCurrentInstance(), "please_select");
        enumValues.put(nullValue, null);
        for (int i = 0; i < enumFacets.getLength(); ++i) {
            enumValues.put(enumFacets.item(i), annotations.getLength() == enumFacets.getLength() ? (XSAnnotation)annotations.item(i) : null);
        }
        String appearance = Schema2XForms.extractPropertyFromAnnotation("http://www.alfresco.org", "appearance", this.getAnnotation(owner), resourceBundle);
        if (appearance == null || appearance.length() == 0) {
            appearance = enumFacets.getLength() < 5 ? "full" : "compact";
        }
        control.setAttributeNS("http://www.w3.org/2002/xforms", "xf:appearance", appearance);
        control.appendChild(choices);
        this.addChoicesForSelectControl(xformsDocument, choices, enumValues, resourceBundle);
        return control;
    }

    public Element createControlForListType(Document xformsDocument, XSSimpleTypeDefinition listType, XSObject owner, String caption, Element bindElement, ResourceBundle resourceBundle) {
        XSSimpleTypeDefinition controlType = listType.getItemType();
        StringList enumFacets = controlType.getLexicalEnumeration();
        if (enumFacets.getLength() <= 0) {
            return null;
        }
        Element control = xformsDocument.createElementNS("http://www.w3.org/2002/xforms", "xf:select");
        this.setXFormsId(control);
        control.appendChild(this.createLabel(xformsDocument, caption));
        XSObjectList mvFacets = controlType.getMultiValueFacets();
        if (mvFacets.getLength() != 1) {
            throw new RuntimeException("expected exactly one MultiValueFacet for " + controlType);
        }
        XSObjectList annotations = ((XSMultiValueFacet)mvFacets.item(0)).getAnnotations();
        LinkedHashMap<String, XSAnnotation> enumValues = new LinkedHashMap<String, XSAnnotation>(enumFacets.getLength());
        for (int i = 0; i < enumFacets.getLength(); ++i) {
            enumValues.put(enumFacets.item(i), annotations.getLength() == enumFacets.getLength() ? (XSAnnotation)annotations.item(i) : null);
        }
        String appearance = Schema2XForms.extractPropertyFromAnnotation("http://www.alfresco.org", "appearance", this.getAnnotation(owner), resourceBundle);
        if (appearance == null || appearance.length() == 0) {
            appearance = enumValues.size() < 5 ? "full" : "compact";
        }
        control.setAttributeNS("http://www.w3.org/2002/xforms", "xf:appearance", appearance);
        Element choices = xformsDocument.createElementNS("http://www.w3.org/2002/xforms", "xf:choices");
        this.setXFormsId(choices);
        control.appendChild(choices);
        this.addChoicesForSelectControl(xformsDocument, choices, enumValues, resourceBundle);
        return control;
    }

    private XSAnnotation getAnnotation(XSObject o) {
        return o instanceof XSElementDeclaration ? ((XSElementDeclaration)o).getAnnotation() : (o instanceof XSAttributeDeclaration ? ((XSAttributeDeclaration)o).getAnnotation() : (o instanceof XSAttributeUse ? ((XSAttributeUse)o).getAttrDeclaration().getAnnotation() : null));
    }

    public Element startBindElement(Element bindElement, XSModel schema, XSTypeDefinition controlType, XSObject owner, SchemaUtil.Occurrence o) {
        LinkedList<String> constraints = new LinkedList<String>();
        if (controlType instanceof XSSimpleTypeDefinition && ((XSSimpleTypeDefinition)controlType).getBuiltInKind() != 1) {
            String typeName = this.getXFormsTypeName(bindElement.getOwnerDocument(), schema, controlType);
            if (typeName != null && typeName.length() != 0) {
                bindElement.setAttributeNS("http://www.w3.org/2002/xforms", "xf:type", typeName);
            }
            if ((typeName = SchemaUtil.getBuiltInTypeName(controlType)) != null && typeName.length() != 0) {
                bindElement.setAttributeNS("http://www.alfresco.org", "alf:builtInType", typeName);
            }
            StringList lexicalPatterns = ((XSSimpleTypeDefinition)controlType).getLexicalPattern();
            for (int i = 0; lexicalPatterns != null && i < lexicalPatterns.getLength() && !"integer".equals(typeName); ++i) {
                String pattern = lexicalPatterns.item(i);
                if (o.isOptional()) {
                    pattern = "(" + pattern + ")?";
                }
                constraints.add("chiba:match(., '" + pattern + "',null)");
            }
            XSSimpleTypeDefinition simpleControlType = (XSSimpleTypeDefinition)controlType;
            if (simpleControlType.isDefinedFacet((short)4)) {
                constraints.add("string-length(.) <= " + simpleControlType.getLexicalFacetValue((short)4));
            }
            if (simpleControlType.isDefinedFacet((short)2)) {
                constraints.add("string-length(.) >= " + simpleControlType.getLexicalFacetValue((short)2));
            }
        }
        short constraintType = owner != null && owner instanceof XSElementDeclaration ? ((XSElementDeclaration)owner).getConstraintType() : (owner != null && owner instanceof XSAttributeDeclaration ? ((XSAttributeDeclaration)owner).getConstraintType() : (owner != null && owner instanceof XSAttributeUse ? ((XSAttributeUse)owner).getConstraintType() : (short)0));
        bindElement.setAttributeNS("http://www.w3.org/2002/xforms", "xf:readonly", (constraintType == 2) + "()");
        if (controlType instanceof XSSimpleTypeDefinition) {
            bindElement.setAttributeNS("http://www.w3.org/2002/xforms", "xf:required", (o.minimum != 0) + "()");
        } else if (controlType instanceof XSComplexTypeDefinition) {
            bindElement.setAttributeNS("http://www.w3.org/2002/xforms", "xf:required", "false()");
        }
        String nodeset = bindElement.getAttributeNS("http://www.w3.org/2002/xforms", "nodeset");
        if (o.minimum > 1) {
            constraints.add("count(../" + nodeset + ") >= " + o.minimum);
        }
        bindElement.setAttributeNS("http://www.w3.org/2002/xforms", "xf:minOccurs", String.valueOf(o.minimum));
        if (o.maximum > 1) {
            constraints.add("count(../" + nodeset + ") <= " + o.maximum);
        }
        bindElement.setAttributeNS("http://www.w3.org/2002/xforms", "xf:maxOccurs", o.isUnbounded() ? "unbounded" : String.valueOf(o.maximum));
        if (constraints.size() != 0) {
            bindElement.setAttributeNS("http://www.w3.org/2002/xforms", "xf:constraint", StringUtils.join((Object[])constraints.toArray(new String[constraints.size()]), (String)" and "));
        }
        return bindElement;
    }

    private String getElementName(XSElementDeclaration element, Document xformsDocument) {
        String elementName = element.getName();
        String namespace = element.getNamespace();
        if (namespace != null && namespace.length() != 0) {
            String prefix = NamespaceResolver.getPrefix((Element)xformsDocument.getDocumentElement(), (String)namespace);
            elementName = prefix + ":" + elementName;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("[getElementName] " + element.getName() + "," + namespace + " = " + elementName));
        }
        return elementName;
    }

    private static String addNamespace(Element e, String nsPrefix, String ns) {
        String prefix = NamespaceResolver.getPrefix((Element)e, (String)ns);
        if (prefix != null) {
            return prefix;
        }
        if (nsPrefix == null || e.hasAttributeNS("http://www.w3.org/2000/xmlns/", nsPrefix)) {
            int suffix = 1;
            while (e.hasAttributeNS("http://www.w3.org/2000/xmlns/", nsPrefix = "ns" + suffix)) {
                ++suffix;
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("[addNamespace] adding namespace " + ns + " with prefix " + nsPrefix + " to " + e.getNodeName()));
        }
        e.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + nsPrefix, ns);
        return nsPrefix;
    }

    private void createTriggersForRepeats(Document xformsDocument, Element rootGroup) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"[createTriggersForRepeats] start");
        }
        HashMap<String, Element> bindIdToBind = new HashMap<String, Element>();
        NodeList binds = xformsDocument.getElementsByTagNameNS("http://www.w3.org/2002/xforms", "bind");
        for (int i = 0; i < binds.getLength(); ++i) {
            Element b = (Element)binds.item(i);
            bindIdToBind.put(b.getAttributeNS(null, "id"), b);
        }
        NodeList repeats = xformsDocument.getElementsByTagNameNS("http://www.w3.org/2002/xforms", "repeat");
        HashMap<Element, Element> bindToRepeat = new HashMap<Element, Element>();
        for (int i = 0; i < repeats.getLength(); ++i) {
            Element r = (Element)repeats.item(i);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("[createTriggersForRepeats] processing repeat " + r.getAttributeNS(null, "id")));
            }
            Element bind = (Element)bindIdToBind.get(r.getAttributeNS("http://www.w3.org/2002/xforms", "bind"));
            bindToRepeat.put(bind, r);
            String xpath = "";
            do {
                if (xpath.length() != 0) {
                    xpath = '/' + xpath;
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("[createTriggersForRepeats] walking bind " + bind.getAttributeNS(null, "id")));
                }
                String s = bind.getAttributeNS("http://www.w3.org/2002/xforms", "nodeset");
                s = s.replaceAll("^([^\\[]+).*$", "$1");
                if (bindToRepeat.containsKey(bind) && !r.equals(bindToRepeat.get(bind))) {
                    s = s + "[index('" + ((Element)bindToRepeat.get(bind)).getAttributeNS(null, "id") + "')]";
                }
                xpath = s + xpath;
            } while ((bind = "xf:bind".equals(bind.getParentNode().getNodeName()) ? (Element)bind.getParentNode() : null) != null);
            this.createTriggersForRepeat(xformsDocument, rootGroup, r.getAttributeNS(null, "id"), xpath, r.getAttributeNS("http://www.w3.org/2002/xforms", "bind"));
        }
    }

    private Element createTrigger(Document xformsDocument, String id, String bindId, String label, Element ... actions) {
        Element trigger = xformsDocument.createElementNS("http://www.w3.org/2002/xforms", "xf:trigger");
        this.setXFormsId(trigger, id != null ? id : null);
        if (bindId != null) {
            trigger.setAttributeNS("http://www.w3.org/2002/xforms", "xf:bind", bindId);
        }
        trigger.appendChild(this.createLabel(xformsDocument, label));
        Element actionWrapper = xformsDocument.createElementNS("http://www.w3.org/2002/xforms", "xf:action");
        trigger.appendChild(actionWrapper);
        for (Element action : actions) {
            actionWrapper.appendChild(action);
            this.setXFormsId(action);
        }
        return trigger;
    }

    private void createTriggersForRepeat(Document xformsDocument, Element rootGroup, String repeatId, String nodeset, String bindId) {
        Element action = xformsDocument.createElementNS("http://www.w3.org/2002/xforms", "xf:insert");
        action.setAttributeNS("http://www.w3.org/2002/xforms", "xf:nodeset", nodeset);
        action.setAttributeNS("http://www.w3.org/2002/xforms", "xf:position", "before");
        action.setAttributeNS("http://www.w3.org/2002/xforms", "xf:at", "1");
        Element trigger_insert_before = this.createTrigger(xformsDocument, repeatId + "-insert_before", bindId, "insert at beginning", action);
        action = xformsDocument.createElementNS("http://www.w3.org/2002/xforms", "xf:insert");
        action.setAttributeNS("http://www.w3.org/2002/xforms", "xf:nodeset", nodeset);
        action.setAttributeNS("http://www.w3.org/2002/xforms", "xf:position", "after");
        action.setAttributeNS("http://www.w3.org/2002/xforms", "xf:at", "xf:index('" + repeatId + "')");
        Element trigger_insert_after = this.createTrigger(xformsDocument, repeatId + "-insert_after", bindId, "insert after selected", action);
        action = xformsDocument.createElementNS("http://www.w3.org/2002/xforms", "xf:delete");
        action.setAttributeNS("http://www.w3.org/2002/xforms", "xf:nodeset", nodeset);
        action.setAttributeNS("http://www.w3.org/2002/xforms", "xf:at", "xf:index('" + repeatId + "')");
        Element trigger_delete = this.createTrigger(xformsDocument, repeatId != null ? repeatId + "-delete" : null, bindId, "delete selected", action);
        rootGroup.appendChild(trigger_insert_before);
        rootGroup.appendChild(trigger_insert_after);
        rootGroup.appendChild(trigger_delete);
    }

    private Element createSubmissionElement(Document xformDocument, String id, boolean validate) {
        Element result = xformDocument.createElementNS("http://www.w3.org/2002/xforms", "xf:submission");
        this.setXFormsId(result, id);
        result.setAttributeNS("http://www.w3.org/2002/xforms", "xf:validate", validate ? "true" : "false");
        result.setAttributeNS("http://www.w3.org/2002/xforms", "xf:action", this.action == null ? "" : this.base + this.action);
        result.setAttributeNS("http://www.w3.org/2002/xforms", "xf:method", (this.submitMethod != null ? this.submitMethod : SubmitMethod.POST).toString());
        result.setAttributeNS("http://www.w3.org/2002/xforms", "xf:encoding", "UTF-8");
        return result;
    }

    private Element createSubmitControl(Document xformsDocument, Element submission, String id, String label) {
        Element result = xformsDocument.createElementNS("http://www.w3.org/2002/xforms", "xf:submit");
        result.setAttributeNS("http://www.w3.org/2002/xforms", "xf:submission", submission.getAttributeNS(null, "id"));
        this.setXFormsId(result, id);
        result.appendChild(this.createLabel(xformsDocument, label));
        return result;
    }

    private void createSubmitElements(Document xformsDocument, Element modelSection, Element rootGroup) {
        Element submission = this.createSubmissionElement(xformsDocument, "submission-validate", true);
        modelSection.appendChild(submission);
        Element submit = this.createSubmitControl(xformsDocument, submission, "submit", "Submit");
        rootGroup.appendChild(submit);
        submission = this.createSubmissionElement(xformsDocument, "submission-draft", false);
        modelSection.appendChild(submission);
        submit = this.createSubmitControl(xformsDocument, submission, "save-draft", "Save Draft");
        rootGroup.appendChild(submit);
    }

    private Element createXFormsItem(Document xformsDocument, String label, String value) {
        Element item = xformsDocument.createElementNS("http://www.w3.org/2002/xforms", "xf:item");
        this.setXFormsId(item);
        item.appendChild(this.createLabel(xformsDocument, label));
        Element e = xformsDocument.createElementNS("http://www.w3.org/2002/xforms", "xf:value");
        this.setXFormsId(e);
        e.appendChild(xformsDocument.createTextNode(value));
        item.appendChild(e);
        return item;
    }

    private Element createLabel(Document xformsDocument, String label) {
        Element e = xformsDocument.createElementNS("http://www.w3.org/2002/xforms", "xf:label");
        this.setXFormsId(e);
        e.appendChild(xformsDocument.createTextNode(label));
        return e;
    }

    private Element createBind(Document xformsDocument, String nodeset) {
        Element result = xformsDocument.createElementNS("http://www.w3.org/2002/xforms", "xf:bind");
        String id = this.setXFormsId(result);
        result.setAttributeNS("http://www.w3.org/2002/xforms", "xf:nodeset", nodeset);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("[createBind] created bind " + id + " for nodeset " + nodeset));
        }
        return result;
    }

    private boolean isRepeated(SchemaUtil.Occurrence occurs, XSTypeDefinition type) {
        if (occurs.isRepeated()) {
            return true;
        }
        boolean repeated = false;
        if (occurs.isOptional() && !(type instanceof XSSimpleTypeDefinition) && !"anyType".equals(type.getName())) {
            repeated = true;
        }
        return repeated;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SubmitMethod {
        POST("post"),
        GET("get"),
        PUT("put"),
        FORM_DATA_POST("form-data-post"),
        URL_ENCODED_POST("urlencoded-post");

        private final String value;

        private SubmitMethod(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

