/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.common.renderer;

import java.io.IOException;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import org.alfresco.web.app.Application;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.renderer.BaseRenderer;

public class DatePickerRenderer
extends BaseRenderer {
    private static final String FIELD_YEAR = "_year";
    private static final String FIELD_MONTH = "_month";
    private static final String FIELD_DAY = "_day";
    private static final String FIELD_HOUR = "_hour";
    private static final String FIELD_MINUTE = "_minute";
    private static final String FIELD_CMD = "_cmd";
    private static final int CMD_SET = 1;
    private static final int CMD_RESET = 2;
    private static final int CMD_TODAY = 3;

    public void decode(FacesContext context, UIComponent component) {
        try {
            String clientId = component.getClientId(context);
            Map params = context.getExternalContext().getRequestParameterMap();
            String cmd = (String)params.get(clientId + FIELD_CMD);
            if (cmd != null && cmd.length() > 0) {
                int action = Integer.parseInt(cmd);
                switch (action) {
                    case 2: {
                        ((EditableValueHolder)component).setSubmittedValue(null);
                        ((EditableValueHolder)component).setValue(null);
                        break;
                    }
                    default: {
                        int[] parts = new int[5];
                        Calendar date = Calendar.getInstance();
                        parts[0] = date.get(1);
                        parts[1] = date.get(2);
                        parts[2] = date.get(5);
                        parts[3] = date.get(11);
                        parts[4] = date.get(12);
                        ((EditableValueHolder)component).setSubmittedValue((Object)parts);
                        break;
                    }
                }
            } else {
                String year = (String)params.get(clientId + FIELD_YEAR);
                if (year != null) {
                    String month = (String)params.get(clientId + FIELD_MONTH);
                    String day = (String)params.get(clientId + FIELD_DAY);
                    String hour = (String)params.get(clientId + FIELD_HOUR);
                    String minute = (String)params.get(clientId + FIELD_MINUTE);
                    int[] parts = new int[]{Integer.parseInt(year), Integer.parseInt(month), Integer.parseInt(day), Integer.parseInt(hour), Integer.parseInt(minute)};
                    ((EditableValueHolder)component).setSubmittedValue((Object)parts);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object val) throws ConverterException {
        int[] parts = (int[])val;
        GregorianCalendar date = new GregorianCalendar(parts[0], parts[1], parts[2], parts[3], parts[4]);
        return date.getTime();
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (component.isRendered()) {
            Date date = null;
            String clientId = component.getClientId(context);
            ResponseWriter out = context.getResponseWriter();
            String cmdFieldName = clientId + FIELD_CMD;
            Boolean initIfNull = (Boolean)component.getAttributes().get("initialiseIfNull");
            int[] submittedValue = (int[])((EditableValueHolder)component).getSubmittedValue();
            if (submittedValue != null) {
                date = (Date)this.getConvertedValue(context, component, submittedValue);
            } else {
                Object value = ((ValueHolder)component).getValue();
                if (value instanceof Date) {
                    date = (Date)value;
                }
                if (date == null && initIfNull != null && initIfNull.booleanValue()) {
                    date = new Date();
                }
            }
            Boolean disabled = (Boolean)component.getAttributes().get("disabled");
            if (disabled == null) {
                disabled = Boolean.FALSE;
            }
            if (date != null) {
                Integer startYear = (Integer)component.getAttributes().get("startYear");
                int nStartYear = startYear != null ? startYear : new Date().getYear() + 1900 + 2;
                int nYearCount = 25;
                Integer yearCount = (Integer)component.getAttributes().get("yearCount");
                if (yearCount != null) {
                    nYearCount = yearCount;
                }
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(date);
                this.renderMenu(out, component, this.getDays(), calendar.get(5), clientId + FIELD_DAY);
                this.renderMenu(out, component, this.getMonths(), calendar.get(2), clientId + FIELD_MONTH);
                this.renderMenu(out, component, this.getYears(nStartYear, nYearCount), calendar.get(1), clientId + FIELD_YEAR);
                Boolean showTime = (Boolean)component.getAttributes().get("showTime");
                if (showTime == null) {
                    showTime = Boolean.FALSE;
                }
                out.write("&nbsp;");
                this.renderTimeElement(out, component, calendar.get(11), clientId + FIELD_HOUR, showTime);
                if (showTime.booleanValue()) {
                    out.write("&nbsp;:&nbsp;");
                }
                this.renderTimeElement(out, component, calendar.get(12), clientId + FIELD_MINUTE, showTime);
                out.write("&nbsp;");
                if (!disabled.booleanValue()) {
                    out.write("<input type=\"button\" onclick=\"");
                    out.write(Utils.generateFormSubmit(context, component, cmdFieldName, Integer.toString(3)));
                    out.write("\" value=\"");
                    out.write(Application.getMessage(context, "today"));
                    out.write("\">&nbsp;");
                    if (initIfNull != null && !initIfNull.booleanValue()) {
                        out.write("<input type=\"button\" onclick=\"");
                        out.write(Utils.generateFormSubmit(context, component, cmdFieldName, Integer.toString(2)));
                        out.write("\" value=\"");
                        out.write(Application.getMessage(context, "none"));
                        out.write("\">");
                    }
                }
            } else {
                out.write("<div style=\"padding: 3px;");
                if (!disabled.booleanValue()) {
                    out.write("\"><a href=\"#\" title=\"");
                    out.write(Application.getMessage(context, "click_to_set_date"));
                    out.write("\" onclick=\"");
                    out.write(Utils.generateFormSubmit(context, component, cmdFieldName, Integer.toString(1)));
                    out.write("\">");
                } else {
                    out.write(" color: #666666; font-style: italic;\">");
                }
                String noneLabel = (String)component.getAttributes().get("noneLabel");
                if (noneLabel == null || noneLabel.length() == 0) {
                    noneLabel = Application.getMessage(context, "none");
                }
                out.write(noneLabel);
                if (!disabled.booleanValue()) {
                    out.write("</a>");
                }
                out.write("</div>");
            }
            out.write("<input type=\"hidden\" ");
            DatePickerRenderer.outputAttribute(out, clientId, "id");
            DatePickerRenderer.outputAttribute(out, clientId, "name");
            String strValue = "";
            if (date != null) {
                strValue = date.toString();
            }
            DatePickerRenderer.outputAttribute(out, strValue, "value");
            out.write("/>");
        }
    }

    private void renderMenu(ResponseWriter out, UIComponent component, List items, int selected, String clientId) throws IOException {
        out.write("<select");
        DatePickerRenderer.outputAttribute(out, clientId, "name");
        if (component.getAttributes().get("styleClass") != null) {
            DatePickerRenderer.outputAttribute(out, component.getAttributes().get("styleClass"), "class");
        }
        if (component.getAttributes().get("style") != null) {
            DatePickerRenderer.outputAttribute(out, component.getAttributes().get("style"), "style");
        }
        if (component.getAttributes().get("disabled") != null) {
            DatePickerRenderer.outputAttribute(out, component.getAttributes().get("disabled"), "disabled");
        }
        out.write(">");
        for (SelectItem item : items) {
            Integer value = (Integer)item.getValue();
            out.write("<option");
            DatePickerRenderer.outputAttribute(out, value, "value");
            if (value == selected) {
                DatePickerRenderer.outputAttribute(out, "selected", "selected");
            }
            out.write(">");
            out.write(Utils.encode((String)item.getLabel()));
            out.write("</option>");
        }
        out.write("</select>");
    }

    private void renderTimeElement(ResponseWriter out, UIComponent component, int currentValue, String clientId, boolean showTime) throws IOException {
        out.write("<input");
        DatePickerRenderer.outputAttribute(out, clientId, "name");
        if (showTime) {
            out.write(" type='text' size='2' maxlength='2'");
            if (component.getAttributes().get("disabled") != null) {
                DatePickerRenderer.outputAttribute(out, component.getAttributes().get("disabled"), "disabled");
            }
            DatePickerRenderer.outputAttribute(out, clientId, "id");
            out.write(" onkeyup=\"checkButtonState();\" onchange=\"checkButtonState();\"");
        } else {
            out.write(" type='hidden'");
        }
        String strValue = Integer.toString(currentValue);
        if (strValue.length() == 1) {
            strValue = "0" + strValue;
        }
        DatePickerRenderer.outputAttribute(out, strValue, "value");
        out.write("/>");
    }

    private List getYears(int startYear, int yearCount) {
        ArrayList<SelectItem> years = new ArrayList<SelectItem>();
        for (int i = startYear; i > startYear - yearCount; --i) {
            Integer year = i;
            years.add(new SelectItem((Object)year, year.toString()));
        }
        return years;
    }

    private List getMonths() {
        Locale locale = Application.getLanguage(FacesContext.getCurrentInstance());
        if (locale == null) {
            locale = Locale.getDefault();
        }
        DateFormatSymbols dfs = new DateFormatSymbols(locale);
        String[] names = dfs.getMonths();
        ArrayList<SelectItem> months = new ArrayList<SelectItem>(12);
        for (int i = 0; i < 12; ++i) {
            Integer key = i;
            months.add(new SelectItem((Object)key, names[i]));
        }
        return months;
    }

    private List getDays() {
        ArrayList<SelectItem> days = new ArrayList<SelectItem>(31);
        for (int i = 1; i < 32; ++i) {
            Integer day = i;
            days.add(new SelectItem((Object)day, day.toString()));
        }
        return days;
    }
}

