/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.component;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.component.html.HtmlPanelGroup;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.ActionEvent;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.config.ActionsConfigElement;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.UIActionLink;
import org.alfresco.web.ui.repo.component.evaluator.ActionInstanceEvaluator;
import org.alfresco.web.ui.repo.component.evaluator.PermissionEvaluator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.shared_impl.taglib.UIComponentTagUtils;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.surf.util.URLEncoder;
import org.springframework.extensions.webscripts.ui.common.ConstantMethodBinding;
import org.springframework.extensions.webscripts.ui.common.component.SelfRenderingComponent;

public class UIActions
extends SelfRenderingComponent {
    private static final String ATTR_VALUE = "value";
    private static Log logger = LogFactory.getLog(UIActions.class);
    private static final String ATTR_SHOWLINK = "showLink";
    private static final String ATTR_STYLECLASS = "styleClass";
    private static final String ATTR_STYLE = "style";
    private static final String ACTION_CONTEXT = "actionContext";
    public static final String RENDERER_ACTIONLINK = "org.alfresco.faces.ActionLinkRenderer";
    public static final String COMPONENT_ACTIONLINK = "org.alfresco.faces.ActionLink";
    public static final String COMPONENT_PERMISSIONEVAL = "org.alfresco.faces.PermissionEvaluator";
    public static final String COMPONENT_ACTIONEVAL = "org.alfresco.faces.ActionInstanceEvaluator";
    public static final Class[] ACTION_CLASS_ARGS = new Class[]{ActionEvent.class};
    private transient Set<String> groups = new HashSet<String>(4);
    private static final String CONTEXTID_DEFAULT = "_default";
    private Boolean showLink = null;
    private String value = null;
    private Object context = null;
    private Integer verticalSpacing = null;
    private static short id = 0;

    public String getFamily() {
        return "org.alfresco.faces.Controls";
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.value = (String)values[1];
        this.showLink = (Boolean)values[2];
        this.verticalSpacing = (Integer)values[3];
        this.groups = new HashSet<String>(4);
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.value, this.showLink, this.verticalSpacing};
        return values;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        ActionsConfigElement actionConfig;
        Config config;
        String groupId;
        String contextId;
        if (!this.isRendered()) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("encodeBegin() for <r:actions/> Id: " + this.getId() + " groupId: " + this.getValue()));
        }
        Object actionContext = this.getContext();
        Map requestMap = this.getFacesContext().getExternalContext().getRequestMap();
        requestMap.put(ACTION_CONTEXT, actionContext);
        if (actionContext instanceof Node) {
            contextId = ((Node)actionContext).getType().toString();
            if (this.groups.contains(contextId)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("---already built component tree for actions contextId: " + contextId));
                }
                return;
            }
        } else {
            contextId = CONTEXTID_DEFAULT;
            if (this.groups.contains(contextId)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"---already built component tree for default actions.");
                }
                return;
            }
        }
        if ((groupId = this.getValue()) != null && groupId.length() != 0 && (config = actionContext instanceof Node ? org.alfresco.web.app.Application.getConfigService(context).getConfig(actionContext) : org.alfresco.web.app.Application.getConfigService(context).getGlobalConfig()) != null && (actionConfig = (ActionsConfigElement)config.getConfigElement("actions")) != null) {
            ActionsConfigElement.ActionGroup actionGroup = actionConfig.getActionGroup(groupId);
            if (actionGroup != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("-constructing ActionGroup: " + groupId + " for ContextId: " + contextId));
                }
                this.buildActionGroup(context, actionConfig, actionGroup, contextId);
            } else {
                logger.warn((Object)("Unable to find specified Action Group config ID: " + groupId));
            }
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext context) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        int verticalSpacing = this.getVerticalSpacing();
        if (verticalSpacing != 0) {
            out.write("<table cellspacing='");
            out.write(verticalSpacing);
            out.write("'");
            if (this.getAttributes().get(ATTR_STYLE) != null) {
                UIActions.outputAttribute((ResponseWriter)out, this.getAttributes().get(ATTR_STYLE), (String)ATTR_STYLE);
            }
            if (this.getAttributes().get(ATTR_STYLECLASS) != null) {
                UIActions.outputAttribute((ResponseWriter)out, this.getAttributes().get(ATTR_STYLECLASS), (String)"class");
            }
            out.write(">");
        }
        Map requestMap = this.getFacesContext().getExternalContext().getRequestMap();
        Object actionContext = requestMap.get(ACTION_CONTEXT);
        String contextId = CONTEXTID_DEFAULT;
        if (actionContext instanceof Node) {
            contextId = ((Node)actionContext).getType().toString();
        }
        for (UIComponent child : this.getChildren()) {
            if (!contextId.equals(child.getAttributes().get("contextId"))) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Rendering actions group for contextId: " + contextId));
            }
            Utils.encodeRecursive(context, child);
            break;
        }
        if (verticalSpacing != 0) {
            out.write("</table>");
        }
    }

    public void encodeEnd(FacesContext context) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("encodeEnd() for <r:actions/> Id: " + this.getId()));
        }
        Map requestMap = this.getFacesContext().getExternalContext().getRequestMap();
        requestMap.remove(ACTION_CONTEXT);
    }

    private void buildActionGroup(FacesContext context, ActionsConfigElement config, ActionsConfigElement.ActionGroup actionGroup, String contextId) throws IOException {
        Application facesApp = context.getApplication();
        ResourceBundle messages = org.alfresco.web.app.Application.getBundle(context);
        String style = (String)this.getAttributes().get(ATTR_STYLE);
        String styleClass = (String)this.getAttributes().get(ATTR_STYLECLASS);
        Boolean showLink = null;
        if (this.getAttributes().get(ATTR_SHOWLINK) != null) {
            showLink = (Boolean)this.getAttributes().get(ATTR_SHOWLINK);
        }
        HtmlPanelGroup wrapper = (HtmlPanelGroup)facesApp.createComponent("javax.faces.HtmlPanelGroup");
        wrapper.setId(UIActions.createUniqueId());
        wrapper.getAttributes().put("contextId", contextId);
        this.getChildren().add(wrapper);
        this.groups.add(contextId);
        for (String actionId : actionGroup) {
            List<String> deny;
            ActionsConfigElement.ActionDefinition actionDef;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("---processing ActionDefinition: " + actionId));
            }
            if ((actionDef = config.getActionDefinition(actionId)) == null) {
                throw new AlfrescoRuntimeException("Unable to find configured ActionDefinition Id: " + actionId);
            }
            Object currentParent = wrapper;
            PermissionEvaluator permEval = null;
            List<String> allow = actionDef.getAllowPermissions();
            if (allow != null && allow.size() != 0) {
                permEval = (PermissionEvaluator)facesApp.createComponent(COMPONENT_PERMISSIONEVAL);
                String condition = allow.get(0);
                if (allow.size() != 1) {
                    for (int i = 1; i < allow.size(); ++i) {
                        condition = condition + "," + allow.get(i);
                    }
                }
                permEval.setAllow(condition);
            }
            if ((deny = actionDef.getDenyPermissions()) != null && deny.size() != 0) {
                if (permEval == null) {
                    permEval = (PermissionEvaluator)facesApp.createComponent(COMPONENT_PERMISSIONEVAL);
                }
                String condition = deny.get(0);
                if (deny.size() != 1) {
                    for (int i = 1; i < deny.size(); ++i) {
                        condition = condition + "," + deny.get(i);
                    }
                }
                permEval.setDeny(condition);
            }
            if (permEval != null) {
                permEval.setId(UIActions.createUniqueId());
                permEval.setValueBinding(ATTR_VALUE, facesApp.createValueBinding("#{actionContext}"));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"-----adding PermissionEvaluator to action");
                }
                currentParent.getChildren().add(permEval);
                currentParent = permEval;
            }
            if (actionDef.Evaluator != null) {
                ActionInstanceEvaluator evaluator = (ActionInstanceEvaluator)facesApp.createComponent(COMPONENT_ACTIONEVAL);
                evaluator.setId(UIActions.createUniqueId());
                evaluator.setEvaluator(actionDef.Evaluator);
                evaluator.setValueBinding(ATTR_VALUE, facesApp.createValueBinding("#{actionContext}"));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"-----adding ActionEvaluator to action");
                }
                currentParent.getChildren().add(evaluator);
                currentParent = evaluator;
            }
            UIActionLink control = (UIActionLink)facesApp.createComponent(COMPONENT_ACTIONLINK);
            control.setRendererType(RENDERER_ACTIONLINK);
            control.setId(actionDef.getId() + UIActions.createUniqueId());
            if (actionDef.Action != null) {
                if (UIComponentTagUtils.isValueReference((String)actionDef.Action)) {
                    control.setAction(facesApp.createMethodBinding(actionDef.Action, null));
                } else {
                    control.setAction((MethodBinding)new ConstantMethodBinding(actionDef.Action));
                }
            }
            if (actionDef.ActionListener != null) {
                control.setActionListener(facesApp.createMethodBinding(actionDef.ActionListener, ACTION_CLASS_ARGS));
            }
            if (style != null) {
                control.getAttributes().put(ATTR_STYLE, style);
            } else if (actionDef.Style != null) {
                control.getAttributes().put(ATTR_STYLE, actionDef.Style);
            }
            if (styleClass != null) {
                control.getAttributes().put(ATTR_STYLECLASS, styleClass);
            } else if (actionDef.StyleClass != null) {
                control.getAttributes().put(ATTR_STYLECLASS, actionDef.StyleClass);
            }
            if (showLink != null) {
                control.setShowLink(showLink);
            } else {
                control.setShowLink(actionDef.ShowLink);
            }
            if (actionDef.Onclick != null) {
                if (UIComponentTagUtils.isValueReference((String)actionDef.Onclick)) {
                    control.setValueBinding("onclick", facesApp.createValueBinding(actionDef.Onclick));
                } else {
                    control.setOnclick(actionDef.Onclick);
                }
            }
            if (actionDef.Href != null) {
                if (UIComponentTagUtils.isValueReference((String)actionDef.Href)) {
                    control.setValueBinding("href", facesApp.createValueBinding(actionDef.Href));
                } else {
                    control.setHref(actionDef.Href);
                }
            } else if (actionDef.Script != null && actionDef.Script.length() != 0) {
                StringBuilder scriptHref = new StringBuilder(100);
                scriptHref.append("/command/script/execute");
                if (actionDef.Script.charAt(0) == '/') {
                    scriptHref.append("?scriptPath=");
                    scriptHref.append(URLEncoder.encode((String)actionDef.Script));
                } else {
                    NodeRef ref = new NodeRef(actionDef.Script);
                    scriptHref.append('/').append(ref.getStoreRef().getProtocol()).append('/').append(ref.getStoreRef().getIdentifier()).append('/').append(ref.getId());
                }
                control.setHref(scriptHref.toString());
            }
            control.setTarget(actionDef.Target);
            control.setImage(actionDef.Image);
            if (actionDef.TooltipMsg != null) {
                control.setTooltip(messages.getString(actionDef.TooltipMsg));
            } else if (actionDef.Tooltip != null) {
                if (UIComponentTagUtils.isValueReference((String)actionDef.Tooltip)) {
                    control.setValueBinding("tooltip", facesApp.createValueBinding(actionDef.Tooltip));
                } else {
                    control.setValue(actionDef.Tooltip);
                }
            }
            if (actionDef.LabelMsg != null) {
                control.setValue(messages.getString(actionDef.LabelMsg));
            } else if (actionDef.Label != null) {
                if (UIComponentTagUtils.isValueReference((String)actionDef.Label)) {
                    control.setValueBinding(ATTR_VALUE, facesApp.createValueBinding(actionDef.Label));
                } else {
                    control.setValue(actionDef.Label);
                }
            }
            Map<String, String> params = actionDef.getParams();
            if (params != null) {
                for (String name : params.keySet()) {
                    UIParameter param = (UIParameter)facesApp.createComponent("javax.faces.Parameter");
                    param.setId(UIActions.createUniqueId());
                    param.setName(name);
                    String value = params.get(name);
                    if (UIComponentTagUtils.isValueReference((String)value)) {
                        param.setValueBinding(ATTR_VALUE, facesApp.createValueBinding(value));
                    } else {
                        param.setValue((Object)value);
                    }
                    control.getChildren().add(param);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("-----adding UIActionLink component for: " + actionId));
            }
            currentParent.getChildren().add(control);
        }
    }

    public String getValue() {
        ValueBinding vb;
        if (this.value == null && (vb = this.getValueBinding(ATTR_VALUE)) != null) {
            this.value = (String)vb.getValue(this.getFacesContext());
        }
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Object getContext() {
        ValueBinding vb = this.getValueBinding("context");
        if (vb != null) {
            this.context = vb.getValue(this.getFacesContext());
        }
        return this.context;
    }

    public void setContext(Object context) {
        this.context = context;
    }

    public boolean getShowLink() {
        ValueBinding vb = this.getValueBinding(ATTR_SHOWLINK);
        if (vb != null) {
            this.showLink = (Boolean)vb.getValue(this.getFacesContext());
        }
        return this.showLink != null ? this.showLink : true;
    }

    public void setShowLink(boolean showLink) {
        this.showLink = showLink;
    }

    public int getVerticalSpacing() {
        ValueBinding vb = this.getValueBinding("verticalSpacing");
        if (vb != null) {
            this.verticalSpacing = (Integer)vb.getValue(this.getFacesContext());
        }
        return this.verticalSpacing != null ? this.verticalSpacing : 0;
    }

    public void setVerticalSpacing(int verticalSpacing) {
        this.verticalSpacing = verticalSpacing;
    }

    public void reset() {
        this.getChildren().clear();
        this.groups.clear();
    }

    private static String createUniqueId() {
        id = (short)(id + 1);
        return "id_" + Short.toString(id);
    }
}

