/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.component;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.CategoryBrowserBean;
import org.alfresco.web.bean.NavigationBean;
import org.alfresco.web.bean.ajax.CategoryBrowserPluginBean;
import org.alfresco.web.bean.search.SearchContext;
import org.alfresco.web.data.QuickSort;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.repo.component.UITree;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.ui.common.component.SelfRenderingComponent;

public class UICategoryBrowser
extends SelfRenderingComponent {
    private static final Log logger = LogFactory.getLog(UICategoryBrowser.class);
    public static final String COMPONENT_TYPE = "org.alfresco.faces.CategoryBrowser";
    private static final String AJAX_URL_START = "/ajax/invoke/CategoryBrowserPluginBean";
    private static final String SUBCATEGORIES_PARAM = "include-subcategories-checkbox";

    public String getFamily() {
        return COMPONENT_TYPE;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[2];
        values[0] = super.saveState(context);
        return values;
    }

    public void decode(FacesContext context) {
        String fieldId;
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String value = (String)requestMap.get(fieldId = this.getClientId(context));
        if (value != null && value.length() != 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Received post back: " + value));
            }
            String item = value;
            String subcategoriesStr = (String)requestMap.get(SUBCATEGORIES_PARAM);
            boolean includeSubcategories = "1".equals(subcategoriesStr);
            logger.debug((Object)("Bool\u00e9en = " + includeSubcategories));
            CategoryBrowserEvent event = new CategoryBrowserEvent((UIComponent)this, item, includeSubcategories);
            this.queueEvent((FacesEvent)event);
        }
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof CategoryBrowserEvent) {
            FacesContext context = FacesContext.getCurrentInstance();
            CategoryBrowserEvent categoryBrowseEvent = (CategoryBrowserEvent)event;
            NodeRef nodeClicked = new NodeRef(categoryBrowseEvent.getItem());
            boolean subcategories = categoryBrowseEvent.isIncludeSubcategories();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Selected category: " + nodeClicked + " subcategories? " + subcategories));
            }
            CategoryBrowserBean categoryBrowserBean = (CategoryBrowserBean)FacesHelper.getManagedBean(context, CategoryBrowserBean.BEAN_NAME);
            categoryBrowserBean.setCurrentCategory(nodeClicked);
            categoryBrowserBean.setIncludeSubcategories(subcategories);
            SearchContext categorySearch = categoryBrowserBean.generateCategorySearchContext();
            NavigationBean nb = (NavigationBean)FacesHelper.getManagedBean(context, "NavigationBean");
            nb.setSearchContext(categorySearch);
            context.getApplication().getNavigationHandler().handleNavigation(context, null, "category-browse");
        } else {
            super.broadcast(event);
        }
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        CategoryBrowserPluginBean categoryBrowserPluginBean = (CategoryBrowserPluginBean)FacesHelper.getManagedBean(context, "CategoryBrowserPluginBean");
        CategoryBrowserBean categoryBrowserBean = (CategoryBrowserBean)FacesHelper.getManagedBean(context, CategoryBrowserBean.BEAN_NAME);
        List<UITree.TreeNode> rootNodes = null;
        rootNodes = categoryBrowserPluginBean.getCategoryRootNodes();
        if (rootNodes != null && rootNodes.size() > 1) {
            QuickSort sorter = new QuickSort(rootNodes, "name", true, "case-insensitive");
            sorter.sort();
        }
        out.write("<div id=\"category-navigator\" class=\"navigator\">");
        String includeSub = Application.getMessage(context, "category_browser_plugin_include_subcategories");
        out.write("<input type='checkbox' id='include-subcategories-checkbox' name='include-subcategories-checkbox' value=1 " + (categoryBrowserBean.isIncludeSubcategories() ? "checked" : "") + "/>");
        out.write("<label for='include-subcategories-checkbox'>" + includeSub + "</label>");
        out.write("<script type=\"text/javascript\">");
        out.write("function treeNodeSelected(nodeRef) {");
        out.write(Utils.generateFormSubmit(context, (UIComponent)this, this.getClientId(context), "nodeRef", true, null));
        out.write("}</script>");
        out.write("<div class=\"navigatorPanelBody\">");
        UITree tree = (UITree)context.getApplication().createComponent("org.alfresco.faces.Tree");
        tree.setId("tree");
        tree.setRootNodes(rootNodes);
        tree.setRetrieveChildrenUrl("/ajax/invoke/CategoryBrowserPluginBean.retrieveChildren?");
        tree.setNodeCollapsedUrl("/ajax/invoke/CategoryBrowserPluginBean.nodeCollapsed?");
        tree.setNodeSelectedCallback("treeNodeSelected");
        tree.setNodeCollapsedCallback("informOfCollapse");
        Utils.encodeRecursive(context, (UIComponent)tree);
        out.write("</div>");
        out.write("</div>");
    }

    public void encodeChildren(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        for (UIComponent child : this.getChildren()) {
            Utils.encodeRecursive(context, child);
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    public static class CategoryBrowserEvent
    extends ActionEvent {
        private String item;
        private boolean includeSubcategories;

        public CategoryBrowserEvent(UIComponent component, String item, boolean include) {
            super(component);
            this.item = item;
            this.includeSubcategories = include;
        }

        public String getItem() {
            return this.item;
        }

        public boolean isIncludeSubcategories() {
            return this.includeSubcategories;
        }
    }
}

