/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.component;

import java.util.ArrayList;
import java.util.Collection;
import javax.faces.context.FacesContext;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.search.CategoryService;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.ui.repo.component.AbstractItemSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UICategorySelector
extends AbstractItemSelector {
    @Override
    public String getFamily() {
        return "org.alfresco.faces.CategorySelector";
    }

    @Override
    public String getDefaultLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), "select_category_prompt");
    }

    private static CategoryService getCategoryService(FacesContext context) {
        CategoryService service = Repository.getServiceRegistry(context).getCategoryService();
        if (service == null) {
            throw new IllegalStateException("Unable to obtain CategoryService bean reference.");
        }
        return service;
    }

    @Override
    public String getParentNodeId(FacesContext context) {
        String id = null;
        if (this.navigationId != null) {
            ChildAssociationRef parentRef = UICategorySelector.getFastNodeService(context).getPrimaryParent(new NodeRef(Repository.getStoreRef(), this.navigationId));
            Node parentNode = new Node(parentRef.getParentRef());
            DictionaryService dd = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getDictionaryService();
            if (!dd.isSubClass(parentNode.getType(), ContentModel.TYPE_CATEGORYROOT)) {
                id = parentRef.getParentRef().getId();
            }
        }
        return id;
    }

    @Override
    public Collection<NodeRef> getChildrenForNode(FacesContext context) {
        NodeRef nodeRef = new NodeRef(Repository.getStoreRef(), this.navigationId);
        Collection childRefs = UICategorySelector.getCategoryService(context).getChildren(nodeRef, CategoryService.Mode.SUB_CATEGORIES, CategoryService.Depth.IMMEDIATE);
        ArrayList<NodeRef> refs = new ArrayList<NodeRef>(childRefs.size());
        for (ChildAssociationRef childRef : childRefs) {
            refs.add(childRef.getChildRef());
        }
        return refs;
    }

    @Override
    public Collection<NodeRef> getRootChildren(FacesContext context) {
        Collection childRefs = UICategorySelector.getCategoryService(context).getCategories(Repository.getStoreRef(), ContentModel.ASPECT_GEN_CLASSIFIABLE, CategoryService.Depth.IMMEDIATE);
        ArrayList<NodeRef> refs = new ArrayList<NodeRef>(childRefs.size());
        for (ChildAssociationRef childRef : childRefs) {
            refs.add(childRef.getChildRef());
        }
        return refs;
    }

    @Override
    public String getItemIcon(FacesContext context, NodeRef ref) {
        return "/images/icons/category_small.gif";
    }
}

