/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.alfresco.web.app.Application;

public class UIMultiValueEditor
extends UIInput {
    private static final String MSG_SELECTED_ITEMS = "selected_items";
    private static final String MSG_NO_SELECTED_ITEMS = "no_selected_items";
    private static final String MSG_SELECT_ITEM = "select_an_item";
    public static final String ACTION_SEPARATOR = ";";
    public static final int ACTION_NONE = -1;
    public static final int ACTION_REMOVE = 0;
    public static final int ACTION_SELECT = 1;
    public static final int ACTION_ADD = 2;
    private Boolean addingNewItem = Boolean.FALSE;
    private Boolean readOnly;
    private Object lastItemAdded;
    private String selectItemMsg;
    private String selectedItemsMsg;
    private String noSelectedItemsMsg;

    public UIMultiValueEditor() {
        this.setRendererType("org.alfresco.faces.Selector");
    }

    public String getFamily() {
        return "org.alfresco.faces.MultiValueEditor";
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.lastItemAdded = values[1];
        this.readOnly = (Boolean)values[2];
        this.addingNewItem = (Boolean)values[3];
        this.selectItemMsg = (String)values[4];
        this.selectedItemsMsg = (String)values[5];
        this.noSelectedItemsMsg = (String)values[6];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.lastItemAdded, this.readOnly, this.addingNewItem, this.selectItemMsg, this.selectedItemsMsg, this.noSelectedItemsMsg};
        return values;
    }

    public Object getLastItemAdded() {
        ValueBinding vb = this.getValueBinding("lastItemAdded");
        if (vb != null) {
            this.lastItemAdded = vb.getValue(this.getFacesContext());
        }
        return this.lastItemAdded;
    }

    public void setLastItemAdded(Object lastItemAdded) {
        this.lastItemAdded = lastItemAdded;
    }

    public String getSelectedItemsMsg() {
        ValueBinding vb = this.getValueBinding("selectedItemsMsg");
        if (vb != null) {
            this.selectedItemsMsg = (String)vb.getValue(this.getFacesContext());
        }
        if (this.selectedItemsMsg == null) {
            this.selectedItemsMsg = Application.getMessage(this.getFacesContext(), MSG_SELECTED_ITEMS);
        }
        return this.selectedItemsMsg;
    }

    public void setSelectedItemsMsg(String selectedItemsMsg) {
        this.selectedItemsMsg = selectedItemsMsg;
    }

    public String getNoSelectedItemsMsg() {
        ValueBinding vb = this.getValueBinding("noSelectedItemsMsg");
        if (vb != null) {
            this.noSelectedItemsMsg = (String)vb.getValue(this.getFacesContext());
        }
        if (this.noSelectedItemsMsg == null) {
            this.noSelectedItemsMsg = Application.getMessage(this.getFacesContext(), MSG_NO_SELECTED_ITEMS);
        }
        return this.noSelectedItemsMsg;
    }

    public void setNoSelectedItemsMsg(String noSelectedItemsMsg) {
        this.noSelectedItemsMsg = noSelectedItemsMsg;
    }

    public String getSelectItemMsg() {
        ValueBinding vb = this.getValueBinding("selectItemMsg");
        if (vb != null) {
            this.selectItemMsg = (String)vb.getValue(this.getFacesContext());
        }
        if (this.selectItemMsg == null) {
            this.selectItemMsg = Application.getMessage(this.getFacesContext(), MSG_SELECT_ITEM);
        }
        return this.selectItemMsg;
    }

    public void setSelectItemMsg(String selectItemMsg) {
        this.selectItemMsg = selectItemMsg;
    }

    public boolean getReadOnly() {
        ValueBinding vb = this.getValueBinding("readOnly");
        if (vb != null) {
            this.readOnly = (Boolean)vb.getValue(this.getFacesContext());
        }
        if (this.readOnly == null) {
            this.readOnly = Boolean.FALSE;
        }
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean getAddingNewItem() {
        return this.addingNewItem;
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof MultiValueEditorEvent) {
            MultiValueEditorEvent assocEvent = (MultiValueEditorEvent)event;
            ArrayList<Object> items = (ArrayList<Object>)this.getValue();
            switch (assocEvent.Action) {
                case 1: {
                    this.addingNewItem = Boolean.TRUE;
                    break;
                }
                case 2: {
                    if (items == null) {
                        items = new ArrayList<Object>();
                        this.setSubmittedValue(items);
                    }
                    Object addedItem = null;
                    if (this.getRendererType().equals("org.alfresco.faces.Field")) {
                        UIInput childComponent = (UIInput)this.getChildren().get(0);
                        addedItem = childComponent.getSubmittedValue();
                        if (childComponent.getRendererType() != null && childComponent.getRendererType().equals("org.alfresco.faces.DatePickerRenderer")) {
                            int[] parts = (int[])addedItem;
                            GregorianCalendar date = new GregorianCalendar(parts[0], parts[1], parts[2], parts[3], parts[4]);
                            addedItem = date.getTime();
                        }
                        childComponent.setSubmittedValue(null);
                    } else {
                        addedItem = this.getLastItemAdded();
                        this.addingNewItem = Boolean.FALSE;
                        ValueBinding vb = this.getValueBinding("lastItemAdded");
                        if (vb != null) {
                            vb.setValue(FacesContext.getCurrentInstance(), null);
                        }
                    }
                    if (addedItem == null) break;
                    items.add(addedItem);
                    break;
                }
                case 0: {
                    items.remove(assocEvent.RemoveIndex);
                }
            }
        } else {
            super.broadcast(event);
        }
    }

    public void encodeChildren(FacesContext context) throws IOException {
        if (!this.getRendersChildren()) {
            super.encodeChildren(context);
        }
    }

    public boolean getRendersChildren() {
        if (this.getRendererType().equals("org.alfresco.faces.Field")) {
            return false;
        }
        return this.addingNewItem == false;
    }

    public static class MultiValueEditorEvent
    extends ActionEvent {
        public int Action;
        public int RemoveIndex;

        public MultiValueEditorEvent(UIComponent component, int action, int removeIndex) {
            super(component);
            this.Action = action;
            this.RemoveIndex = removeIndex;
        }
    }
}

