/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.component;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.alfresco.web.app.Application;
import org.alfresco.web.ui.common.Utils;

public class UIUserGroupPicker
extends UICommand {
    public static final int ACTION_NONE = -1;
    public static final int ACTION_EXPANDCOLLAPSE = 0;
    public static final int ACTION_SELECT = 1;
    private static String SELECTED_AUTHORITY = "_check";

    public UIUserGroupPicker() {
        this.setRendererType(null);
    }

    public String getFamily() {
        return "org.alfresco.faces.UserGroupPicker";
    }

    public void decode(FacesContext context) {
        String fieldId;
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String value = (String)requestMap.get(fieldId = this.getHiddenFieldName(context));
        if (value != null && value.length() != 0) {
            int sepIndex = value.indexOf(58);
            int action = Integer.parseInt(value.substring(0, sepIndex));
            String authority = value.substring(sepIndex + 1);
            PickerEvent event = new PickerEvent((UIComponent)this, action, authority);
            this.queueEvent((FacesEvent)event);
        }
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        ResourceBundle bundle = Application.getBundle(context);
        String clientId = this.getClientId(context);
        out.write("<table width=100% border=0 cellspacing=0 cellpadding=0 class='userGroupPickerList'>");
        List userGroups = (List)this.getValue();
        if (userGroups != null) {
            for (Map authority : userGroups) {
                String authorityId = (String)authority.get("id");
                out.write("<tr><td width=100%><table width=100% border=0 cellspacing=3 cellpadding=0><tr>");
                int width = 16;
                for (Map parent = (Map)authority.get("parent"); parent != null; parent = (Map)parent.get("parent")) {
                    width += 16;
                }
                out.write("<td width=");
                out.write(Integer.toString(width));
                out.write(" align=right>");
                boolean expanded = false;
                boolean isGroup = (Boolean)authority.get("isGroup");
                if (isGroup) {
                    expanded = (Boolean)authority.get("expanded");
                    String image = expanded ? "/images/icons/expanded.gif" : "/images/icons/collapsed.gif";
                    out.write(Utils.buildImageTag(context, image, 11, 11, "", this.generateFormSubmit(context, 0, authorityId)));
                }
                out.write("</td><td width=16>");
                boolean duplicate = (Boolean)authority.get("duplicate");
                if (!(duplicate || isGroup && expanded)) {
                    boolean selected = (Boolean)authority.get("selected");
                    out.write("<input type='checkbox' value='' name='");
                    out.write(clientId + ':' + SELECTED_AUTHORITY);
                    out.write("' onclick=\"");
                    out.write(this.generateFormSubmit(context, 1, authorityId));
                    out.write(34);
                    if (selected) {
                        out.write(" CHECKED");
                    }
                    out.write(62);
                }
                out.write("</td><td width=16>");
                out.write(Utils.buildImageTag(context, (String)authority.get("icon"), 16, 16, ""));
                out.write("</td><td>");
                if (duplicate) {
                    out.write("<span style='color:#93a8b2'>");
                }
                out.write(Utils.encode((String)((String)authority.get("fullName"))));
                out.write(" (");
                out.write((String)authority.get("roles"));
                out.write(")");
                if (duplicate) {
                    out.write("</span>");
                }
                out.write("</td>");
                out.write("</tr></table></td></tr>");
            }
        }
        out.write("</table>");
    }

    private String getHiddenFieldName(FacesContext context) {
        return this.getClientId(context);
    }

    private String generateFormSubmit(FacesContext context, int action, String authority) {
        return Utils.generateFormSubmit(context, (UIComponent)this, this.getHiddenFieldName(context), Integer.toString(action) + ':' + authority);
    }

    public static class PickerEvent
    extends ActionEvent {
        public String Authority;
        public int Action;

        public PickerEvent(UIComponent component, int action, String authority) {
            super(component);
            this.Action = action;
            this.Authority = authority;
        }
    }
}

