/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.component.evaluator;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.web.action.ActionEvaluator;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.ui.common.component.evaluator.BaseEvaluator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionInstanceEvaluator
extends BaseEvaluator {
    private static final String EVALUATOR_CACHE = "_alf_evaluator_cache";
    private ActionEvaluator evaluator;
    private String evaluatorClassName;

    @Override
    public boolean evaluate() {
        boolean result = false;
        try {
            Object obj = this.getValue();
            result = obj instanceof Node ? this.evaluateCachedResult((Node)obj) : this.getEvaluator().evaluate(obj);
        }
        catch (Exception err) {
            StringBuilder builder = new StringBuilder("Error during ActionInstanceEvaluator evaluation of ");
            builder.append(this.getEvaluator()).append(": ");
            String msg = err.getMessage();
            if (msg != null) {
                builder.append(msg);
            } else {
                StringWriter strWriter = new StringWriter();
                PrintWriter writer = new PrintWriter(strWriter);
                err.printStackTrace(writer);
                builder.append(strWriter.toString());
            }
            s_logger.warn((Object)builder.toString());
        }
        return result;
    }

    private boolean evaluateCachedResult(Node node) {
        ActionEvaluator evaluator = this.getEvaluator();
        String cacheKey = node.getNodeRef().toString() + '_' + evaluator.getClass().getName();
        Map<String, Boolean> cache = this.getEvaluatorResultCache();
        Boolean result = cache.get(cacheKey);
        if (result == null) {
            result = evaluator.evaluate(node);
            cache.put(cacheKey, result);
        }
        return result;
    }

    private Map<String, Boolean> getEvaluatorResultCache() {
        FacesContext fc = FacesContext.getCurrentInstance();
        HashMap cache = (HashMap)fc.getExternalContext().getRequestMap().get(EVALUATOR_CACHE);
        if (cache == null) {
            cache = new HashMap(64, 1.0f);
            fc.getExternalContext().getRequestMap().put(EVALUATOR_CACHE, cache);
        }
        return cache;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.evaluator = (ActionEvaluator)values[1];
        this.evaluatorClassName = (String)values[2];
    }

    @Override
    public Object saveState(FacesContext context) {
        return new Object[]{super.saveState(context), this.evaluator, this.evaluatorClassName};
    }

    public ActionEvaluator getEvaluator() {
        if (this.evaluator == null) {
            Object objEvaluator;
            try {
                Class<?> clazz = Class.forName(this.getEvaluatorClassName());
                objEvaluator = clazz.newInstance();
            }
            catch (Throwable err) {
                throw new AlfrescoRuntimeException("Unable to construct action evaluator: " + this.getEvaluatorClassName());
            }
            if (!(objEvaluator instanceof ActionEvaluator)) {
                throw new AlfrescoRuntimeException("Must implement ActionEvaluator interface: " + this.getEvaluatorClassName());
            }
            this.evaluator = (ActionEvaluator)objEvaluator;
        }
        return this.evaluator;
    }

    public void setEvaluator(ActionEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    public String getEvaluatorClassName() {
        ValueBinding vb = this.getValueBinding("evaluatorClassName");
        if (vb != null) {
            this.evaluatorClassName = (String)vb.getValue(this.getFacesContext());
        }
        return this.evaluatorClassName;
    }

    public void setEvaluatorClassName(String evaluatorClassName) {
        this.evaluatorClassName = evaluatorClassName;
    }
}

