/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.component.property;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.repository.User;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.repo.component.property.BaseAssociationEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UIAssociationEditor
extends BaseAssociationEditor {
    private static final Log logger = LogFactory.getLog(UIAssociationEditor.class);
    public static final String MSG_WARN_CANNOT_VIEW_TARGET_DETAILS = "warn_cannot_view_target_details";
    public static final String MSG_WARN_USER_WAS_DELETED = "warn_user_was_deleted";

    public String getFamily() {
        return "org.alfresco.faces.AssociationEditor";
    }

    protected void populateAssocationMaps(Node node, NodeService nodeService) {
        if (this.originalAssocs == null) {
            this.originalAssocs = new LinkedHashMap();
            List assocs = (List)node.getAssociations().get(this.associationName);
            if (assocs != null) {
                for (AssociationRef assoc : assocs) {
                    if (!nodeService.exists(assoc.getTargetRef())) continue;
                    this.originalAssocs.put(assoc.getTargetRef().toString(), assoc);
                }
            }
        }
        this.added = node.getAddedAssociations().get(this.associationName);
        if (this.added == null) {
            this.added = new LinkedHashMap();
            node.getAddedAssociations().put(this.associationName, this.added);
        }
        this.removed = node.getRemovedAssociations().get(this.associationName);
        if (this.removed == null) {
            this.removed = new LinkedHashMap();
            node.getRemovedAssociations().put(this.associationName, this.removed);
        }
    }

    protected void renderExistingAssociations(FacesContext context, ResponseWriter out, NodeService nodeService, boolean allowManyChildren) throws IOException {
        boolean itemsRendered = false;
        for (AssociationRef assoc : this.originalAssocs.values()) {
            if (this.removed.containsKey(assoc.getTargetRef().toString())) continue;
            this.renderExistingAssociation(context, out, nodeService, assoc.getTargetRef(), allowManyChildren);
            itemsRendered = true;
        }
        for (AssociationRef assoc : this.added.values()) {
            this.renderExistingAssociation(context, out, nodeService, assoc.getTargetRef(), allowManyChildren);
            itemsRendered = true;
        }
        if (!itemsRendered && allowManyChildren) {
            this.renderNone(context, out);
        }
    }

    protected void renderReadOnlyAssociations(FacesContext context, ResponseWriter out, NodeService nodeService) throws IOException {
        if (this.originalAssocs.size() > 0) {
            out.write("<table cellspacing='0' cellpadding='2' border='0'>");
            Iterator iter = this.originalAssocs.values().iterator();
            while (iter.hasNext()) {
                out.write("<tr><td>");
                AssociationRef assoc = (AssociationRef)iter.next();
                NodeRef targetNode = assoc.getTargetRef();
                if (nodeService.exists(targetNode)) {
                    if (ContentModel.TYPE_PERSON.equals((Object)nodeService.getType(targetNode))) {
                        out.write(Utils.encode((String)User.getFullNameAndUserId(nodeService, targetNode)));
                    } else if (ContentModel.TYPE_AUTHORITY_CONTAINER.equals((Object)nodeService.getType(targetNode))) {
                        String groupDisplayName = (String)((Object)nodeService.getProperty(targetNode, ContentModel.PROP_AUTHORITY_DISPLAY_NAME));
                        if (groupDisplayName == null || groupDisplayName.length() == 0) {
                            String group = (String)((Object)nodeService.getProperty(targetNode, ContentModel.PROP_AUTHORITY_NAME));
                            groupDisplayName = group.substring("GROUP_".length());
                        }
                        out.write(groupDisplayName);
                    } else {
                        String displayString = null;
                        try {
                            displayString = Repository.getDisplayPath(nodeService.getPath(targetNode)) + "/" + Repository.getNameForNode(nodeService, targetNode);
                        }
                        catch (AccessDeniedException ade) {
                            displayString = Application.getMessage(context, MSG_WARN_CANNOT_VIEW_TARGET_DETAILS);
                        }
                        out.write(Utils.encode((String)displayString));
                    }
                } else {
                    String message = Application.getMessage(context, MSG_WARN_USER_WAS_DELETED);
                    out.write(message);
                }
                out.write("</td></tr>");
            }
            out.write("</table>");
        }
    }

    protected void removeTarget(Node node, String targetRef) {
        if (node != null && targetRef != null) {
            Map<String, AssociationRef> added;
            QName assocQName = Repository.resolveToQName(this.associationName);
            AssociationRef newAssoc = new AssociationRef(null, node.getNodeRef(), assocQName, new NodeRef(targetRef));
            if (this.originalAssocs.containsKey(targetRef)) {
                Map<String, AssociationRef> removed = node.getRemovedAssociations().get(this.associationName);
                removed.put(targetRef, newAssoc);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Added association to " + targetRef + " to the removed list"));
                }
            }
            if ((added = node.getAddedAssociations().get(this.associationName)).containsKey(targetRef)) {
                added.remove(targetRef);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Removed association to " + targetRef + " from the added list"));
                }
            }
        }
    }

    protected void addTarget(Node node, String[] toAdd) {
        if (node != null && toAdd != null && toAdd.length > 0) {
            for (int x = 0; x < toAdd.length; ++x) {
                Map<String, AssociationRef> removed;
                String targetRef = toAdd[x];
                if (!this.originalAssocs.containsKey(targetRef)) {
                    QName assocQName = Repository.resolveToQName(this.associationName);
                    AssociationRef newAssoc = new AssociationRef(null, node.getNodeRef(), assocQName, new NodeRef(targetRef));
                    Map<String, AssociationRef> added = node.getAddedAssociations().get(this.associationName);
                    added.put(targetRef, newAssoc);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Added association to " + targetRef + " to the added list"));
                    }
                }
                if (!(removed = node.getRemovedAssociations().get(this.associationName)).containsKey(targetRef)) continue;
                removed.remove(targetRef);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Removed association to " + targetRef + " from the removed list"));
            }
        }
    }
}

