/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.repo.renderer;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.FacesEvent;
import javax.transaction.UserTransaction;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.renderer.BaseRenderer;
import org.alfresco.web.ui.repo.component.UINodePath;

public class NodePathLinkRenderer
extends BaseRenderer {
    public void decode(FacesContext context, UIComponent component) {
        String fieldId;
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String value = (String)requestMap.get(fieldId = NodePathLinkRenderer.getHiddenFieldName(context, component));
        if (value != null && value.startsWith(component.getClientId(context) + ':')) {
            String selectedNodeId = value.substring(component.getClientId(context).length() + 1);
            NodeRef ref = new NodeRef(Repository.getStoreRef(), selectedNodeId);
            UINodePath.PathElementEvent event = new UINodePath.PathElementEvent(component, ref);
            component.queueEvent((FacesEvent)event);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        Path path = null;
        NodeRef nodeRef = null;
        Object val = ((UINodePath)component).getValue();
        if (val instanceof NodeRef) {
            nodeRef = (NodeRef)val;
        } else if (val instanceof Path) {
            path = (Path)val;
        } else if (val != null) {
            throw new IllegalArgumentException("UINodePath component 'value' property must resolve to a NodeRef or Path.  Got a " + val.getClass().getName());
        }
        if (val != null) {
            boolean isBreadcrumb = false;
            Boolean breadcrumb = (Boolean)component.getAttributes().get("breadcrumb");
            if (breadcrumb != null) {
                isBreadcrumb = breadcrumb;
            }
            boolean isDisabled = false;
            Boolean disabled = (Boolean)component.getAttributes().get("disabled");
            if (disabled != null) {
                isDisabled = disabled;
            }
            boolean showLeaf = false;
            Boolean showLeafBool = (Boolean)component.getAttributes().get("showLeaf");
            if (showLeafBool != null) {
                showLeaf = showLeafBool;
            }
            NodeService service = NodePathLinkRenderer.getNodeService(context);
            UserTransaction tx = null;
            try {
                tx = Repository.getUserTransaction(FacesContext.getCurrentInstance(), true);
                tx.begin();
                if (path == null) {
                    path = service.getPath(nodeRef);
                }
                if (!isBreadcrumb || isDisabled) {
                    out.write(this.buildPathAsSingular(context, component, path, showLeaf, isDisabled));
                } else {
                    out.write(this.buildPathAsBreadcrumb(context, component, path, showLeaf));
                }
                tx.commit();
            }
            catch (InvalidNodeRefException refErr) {
                try {
                    if (tx != null) {
                        tx.rollback();
                    }
                }
                catch (Exception tex) {}
            }
            catch (AccessDeniedException accessErr) {
                try {
                    if (tx != null) {
                        tx.rollback();
                    }
                }
                catch (Exception tex) {}
            }
            catch (Throwable err) {
                try {
                    if (tx != null) {
                        tx.rollback();
                    }
                }
                catch (Exception tex) {
                    // empty catch block
                }
                throw new RuntimeException(err);
            }
        }
    }

    private String buildPathAsBreadcrumb(FacesContext context, UIComponent component, Path path, boolean showLeaf) {
        StringBuilder buf = new StringBuilder(1024);
        NodeService nodeService = NodePathLinkRenderer.getNodeService(context);
        PermissionService permissionService = NodePathLinkRenderer.getPermissionService(context);
        int size = showLeaf ? path.size() : path.size() - 1;
        for (int i = 0; i < size; ++i) {
            Path.Element element = path.get(i);
            String elementString = null;
            if (element instanceof Path.ChildAssocElement) {
                ChildAssociationRef elementRef = ((Path.ChildAssocElement)element).getRef();
                if (elementRef.getParentRef() != null) {
                    String name = null;
                    name = permissionService.hasPermission(elementRef.getChildRef(), "Read") == AccessStatus.ALLOWED ? nodeService.getProperty(elementRef.getChildRef(), ContentModel.PROP_NAME).toString() : elementRef.getQName().getLocalName();
                    elementString = this.renderPathElement(context, component, elementRef.getChildRef(), name);
                }
            } else {
                elementString = element.getElementString();
            }
            if (elementString == null) continue;
            buf.append("/");
            buf.append(elementString);
        }
        return buf.toString();
    }

    private String buildPathAsSingular(FacesContext context, UIComponent component, Path path, boolean showLeaf, boolean disabled) {
        StringBuilder buf = new StringBuilder(512);
        NodeService nodeService = NodePathLinkRenderer.getNodeService(context);
        PermissionService permissionService = NodePathLinkRenderer.getPermissionService(context);
        NodeRef lastElementRef = null;
        int size = showLeaf ? path.size() : path.size() - 1;
        int lastElementPos = showLeaf ? path.size() - 1 : path.size() - 2;
        for (int i = 0; i < size; ++i) {
            Path.Element element = path.get(i);
            String elementString = null;
            if (element instanceof Path.ChildAssocElement) {
                ChildAssociationRef elementRef = ((Path.ChildAssocElement)element).getRef();
                if (elementRef.getParentRef() != null) {
                    Object name = null;
                    elementString = permissionService.hasPermission(elementRef.getChildRef(), "Read") == AccessStatus.ALLOWED ? nodeService.getProperty(elementRef.getChildRef(), ContentModel.PROP_NAME).toString() : elementRef.getQName().getLocalName();
                }
                if (i == lastElementPos) {
                    lastElementRef = elementRef.getChildRef();
                }
            } else {
                elementString = element.getElementString();
            }
            if (elementString == null) continue;
            buf.append("/");
            buf.append(elementString);
        }
        if (!disabled && lastElementRef != null) {
            return this.renderPathElement(context, component, lastElementRef, buf.toString());
        }
        return buf.toString();
    }

    private String renderPathElement(FacesContext context, UIComponent control, NodeRef nodeRef, String label) {
        StringBuilder buf = new StringBuilder(256);
        buf.append("<a href='#' onclick=\"");
        String param = control.getClientId(context) + ':' + nodeRef.getId();
        buf.append(Utils.generateFormSubmit(context, control, NodePathLinkRenderer.getHiddenFieldName(context, control), param));
        buf.append('\"');
        Map attrs = control.getAttributes();
        if (attrs.get("style") != null) {
            buf.append(" style=\"").append(attrs.get("style")).append('\"');
        }
        if (attrs.get("styleClass") != null) {
            buf.append(" class=").append(attrs.get("styleClass"));
        }
        buf.append('>');
        buf.append(Utils.encode((String)label));
        buf.append("</a>");
        return buf.toString();
    }

    private static String getHiddenFieldName(FacesContext context, UIComponent component) {
        return Utils.getParentForm(context, component).getClientId(context) + ':' + "npath";
    }

    private static NodeService getNodeService(FacesContext context) {
        NodeService service = Repository.getServiceRegistry(context).getNodeService();
        if (service == null) {
            throw new IllegalStateException("Unable to obtain NodeService bean reference.");
        }
        return service;
    }

    private static PermissionService getPermissionService(FacesContext context) {
        PermissionService service = Repository.getServiceRegistry(context).getPermissionService();
        if (service == null) {
            throw new IllegalStateException("Unable to obtain PermissionService bean reference.");
        }
        return service;
    }
}

