/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.ui.wcm.component;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import javax.transaction.UserTransaction;
import org.alfresco.model.ContentModel;
import org.alfresco.model.WCMAppModel;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.wcm.sandbox.SandboxConstants;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.DeploymentUtil;
import org.alfresco.web.data.QuickSort;
import org.alfresco.web.ui.common.PanelGenerator;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.UIActionLink;
import org.alfresco.web.ui.repo.component.UIActions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.ui.common.component.SelfRenderingComponent;
import org.springframework.util.StringUtils;

public class UIDeploymentReports
extends SelfRenderingComponent {
    public static final String FILTER_DATE_TODAY = "today";
    public static final String FILTER_DATE_YESTERDAY = "yesterday";
    public static final String FILTER_DATE_WEEK = "week";
    public static final String FILTER_DATE_MONTH = "month";
    public static final String FILTER_DATE_ALL = "all";
    protected String store;
    protected String dateFilter;
    protected Boolean showPrevious;
    protected NodeRef attempt;
    private static final String MSG_ATTEMPT_DATE = "deploy_attempt_date";
    private static final String MSG_SERVERS = "deployed_to_servers";
    private static final String MSG_SNAPSHOT = "snapshot";
    private static final String MSG_SELECT_ATTEMPT = "select_deploy_attempt";
    private static Log logger = LogFactory.getLog(UIDeploymentReports.class);

    public String getFamily() {
        return "org.alfresco.faces.DeploymentReports";
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.store = (String)values[1];
        this.dateFilter = (String)values[2];
        this.showPrevious = (Boolean)values[3];
        this.attempt = (NodeRef)values[4];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.store, this.dateFilter, this.showPrevious, this.attempt};
        return values;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        UserTransaction tx = null;
        try {
            tx = Repository.getUserTransaction(FacesContext.getCurrentInstance(), true);
            tx.begin();
            String storeName = this.getValue();
            if (storeName == null) {
                throw new IllegalArgumentException("The store must be specified.");
            }
            boolean showPrevious = this.getShowPrevious();
            if (showPrevious) {
                this.renderPreviousReports(context, out, storeName);
            } else {
                this.renderAttempt(context, out, storeName);
            }
            tx.commit();
        }
        catch (Throwable err) {
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception tex) {
                // empty catch block
            }
            throw new RuntimeException(err);
        }
    }

    public String getValue() {
        ValueBinding vb = this.getValueBinding("value");
        if (vb != null) {
            this.store = (String)vb.getValue(this.getFacesContext());
        }
        return this.store;
    }

    public void setValue(String value) {
        this.store = value;
    }

    public String getDateFilter() {
        ValueBinding vb = this.getValueBinding("dateFilter");
        if (vb != null) {
            this.dateFilter = (String)vb.getValue(this.getFacesContext());
        }
        return this.dateFilter;
    }

    public void setDateFilter(String value) {
        this.dateFilter = value;
    }

    public boolean getShowPrevious() {
        ValueBinding vb = this.getValueBinding("showPrevious");
        if (vb != null) {
            this.showPrevious = (Boolean)vb.getValue(this.getFacesContext());
        }
        if (this.showPrevious == null) {
            this.showPrevious = Boolean.FALSE;
        }
        return this.showPrevious;
    }

    public void setShowPrevious(boolean showPrevious) {
        this.showPrevious = new Boolean(showPrevious);
    }

    public NodeRef getAttempt() {
        ValueBinding vb = this.getValueBinding("attempt");
        if (vb != null) {
            this.attempt = (NodeRef)vb.getValue(this.getFacesContext());
        }
        return this.attempt;
    }

    public void setAttempt(NodeRef value) {
        this.attempt = value;
    }

    protected void renderPreviousReports(FacesContext context, ResponseWriter out, String store) throws IOException {
        NodeService nodeService = Repository.getServiceRegistry(context).getNodeService();
        ResourceBundle bundle = org.alfresco.web.app.Application.getBundle(context);
        List<NodeRef> deployAttempts = null;
        String dateFilter = this.getDateFilter();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Rendering previous deployment reports for store '" + store + "' using dateFilter: " + dateFilter));
        }
        if (dateFilter == null || dateFilter.equals(FILTER_DATE_ALL)) {
            deployAttempts = DeploymentUtil.findDeploymentAttempts(store);
        } else {
            Date fromDate;
            Date toDate = new Date();
            if (FILTER_DATE_TODAY.equals(dateFilter)) {
                fromDate = toDate;
            } else if (FILTER_DATE_YESTERDAY.equals(dateFilter)) {
                toDate = fromDate = new Date(toDate.getTime() - 86400000L);
            } else if (FILTER_DATE_WEEK.equals(dateFilter)) {
                fromDate = new Date(toDate.getTime() - 604800000L);
            } else if (FILTER_DATE_MONTH.equals(dateFilter)) {
                fromDate = new Date(toDate.getTime() - 2592000000L);
            } else {
                throw new IllegalArgumentException("Unknown date filter mode: " + dateFilter);
            }
            deployAttempts = DeploymentUtil.findDeploymentAttempts(store, fromDate, toDate);
        }
        if (deployAttempts.size() > 0) {
            out.write("<table class='deployMoreReportsList' cellspacing='3' cellpadding='3' width='100%'>");
            out.write("<tr><th align='left'><nobr>");
            out.write(bundle.getString(MSG_ATTEMPT_DATE));
            out.write("</nobr></th><th align='left'><nobr>");
            out.write(bundle.getString(MSG_SERVERS));
            out.write("</nobr></th><th align='left'><nobr>");
            out.write(bundle.getString(MSG_SNAPSHOT));
            out.write("</th></tr>");
            ArrayList<DeploymentAttempt> orderedAttempts = new ArrayList<DeploymentAttempt>(deployAttempts.size());
            for (NodeRef attempt : deployAttempts) {
                Map props = nodeService.getProperties(attempt);
                String attemptId = (String)props.get(WCMAppModel.PROP_DEPLOYATTEMPTID);
                Date attemptTime = (Date)props.get(WCMAppModel.PROP_DEPLOYATTEMPTTIME);
                Integer version = (Integer)props.get(WCMAppModel.PROP_DEPLOYATTEMPTVERSION);
                List servers = (List)props.get(WCMAppModel.PROP_DEPLOYATTEMPTSERVERS);
                StringBuilder buffer = new StringBuilder();
                if (servers != null) {
                    for (String server : servers) {
                        if (buffer.length() != 0) {
                            buffer.append(", ");
                        }
                        buffer.append(Utils.encode((String)server));
                    }
                }
                orderedAttempts.add(new DeploymentAttempt(attempt, attemptId, attemptTime, buffer.toString(), version));
            }
            QuickSort sorter = new QuickSort(orderedAttempts, "date", false, "case-insensitive");
            sorter.sort();
            for (DeploymentAttempt attempt : orderedAttempts) {
                out.write("<tr><td><nobr>");
                Utils.encodeRecursive(context, (UIComponent)this.aquireViewAttemptAction(context, attempt));
                out.write("</nobr></td><td>");
                out.write(attempt.getServers());
                out.write("</td><td>");
                Integer version = attempt.getVersion();
                if (version != null) {
                    out.write(version.toString());
                    if (version == -1) {
                        out.write("&nbsp;(");
                        out.write(bundle.getString("current_working_version"));
                        out.write(")");
                    }
                }
                out.write("</td></tr>");
            }
            out.write("</table>");
        } else {
            out.write("<div class='deployServersInfo'>");
            out.write(org.alfresco.web.app.Application.getMessage(context, "no_deploy_attempts"));
            out.write("</div>\n");
        }
    }

    protected void renderAttempt(FacesContext context, ResponseWriter out, String store) throws IOException {
        NodeService nodeService = Repository.getServiceRegistry(context).getNodeService();
        ContentService contentService = Repository.getServiceRegistry(context).getContentService();
        AVMService avmService = Repository.getServiceRegistry(context).getAVMService();
        NodeRef attempt = this.getAttempt();
        if (attempt == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Rendering last deployment report for store: " + store));
            }
            PropertyValue val = avmService.getStoreProperty(store, SandboxConstants.PROP_LAST_DEPLOYMENT_ID);
            String attemptId = null;
            if (val != null) {
                attemptId = val.getStringValue();
            }
            if (attemptId == null || attemptId.length() == 0) {
                throw new IllegalStateException("Failed to retrieve deployment attempt id");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Retrieving deploymentattempt node with attempt id: " + attemptId));
            }
            attempt = DeploymentUtil.findDeploymentAttempt(attemptId);
        }
        if (attempt != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Rendering deployment reports for attempt: " + attempt));
            }
            out.write("<script type='text/javascript' src='");
            out.write(context.getExternalContext().getRequestContextPath());
            out.write("/scripts/ajax/deployment.js'></script>\n");
            List deployReportRefs = nodeService.getChildAssocs(attempt, (QNamePattern)WCMAppModel.ASSOC_DEPLOYMENTREPORTS, RegexQNamePattern.MATCH_ALL);
            if (deployReportRefs.size() > 0) {
                for (ChildAssociationRef ref : deployReportRefs) {
                    this.renderReport(context, out, ref.getChildRef(), nodeService, contentService);
                }
            } else {
                out.write("<div class='deployInProgress'><img src='");
                out.write(context.getExternalContext().getRequestContextPath());
                out.write("/images/icons/info_icon_large.gif' />&nbsp;");
                out.write(org.alfresco.web.app.Application.getMessage(context, "no_deploy_reports"));
                out.write("</div>\n");
            }
            out.write("\n<div style='padding-top:12px;'></div>\n");
        }
    }

    protected void renderReport(FacesContext context, ResponseWriter out, NodeRef deploymentReport, NodeService nodeService, ContentService contentService) throws IOException {
        Boolean success;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Rendering report: " + deploymentReport));
        }
        out.write("\n<div style='padding-top:8px;'></div>\n");
        PanelGenerator.generatePanelStart((Writer)out, context.getExternalContext().getRequestContextPath(), "lightstorm", "#eaeff2");
        Map serverProps = nodeService.getProperties(deploymentReport);
        Long serverId = (Long)serverProps.get(ContentModel.PROP_NODE_DBID);
        String server = (String)serverProps.get(WCMAppModel.PROP_DEPLOYSERVER);
        boolean showServerAddress = true;
        String serverName = (String)serverProps.get(WCMAppModel.PROP_DEPLOYSERVERNAMEUSED);
        if (serverName == null || serverName.length() == 0) {
            serverName = server;
            showServerAddress = false;
        }
        String deployType = "alfresco";
        if (server.startsWith("\\\\")) {
            deployType = "file";
        }
        String creator = (String)serverProps.get(ContentModel.PROP_CREATOR);
        Date startTime = (Date)serverProps.get(WCMAppModel.PROP_DEPLOYSTARTTIME);
        String started = "";
        if (startTime != null) {
            started = Utils.getDateTimeFormat(context).format(startTime);
        }
        Date endTime = (Date)serverProps.get(WCMAppModel.PROP_DEPLOYENDTIME);
        String finished = "";
        if (endTime != null) {
            finished = Utils.getDateTimeFormat(context).format(endTime);
        }
        if ((success = (Boolean)serverProps.get(WCMAppModel.PROP_DEPLOYSUCCESSFUL)) == null) {
            success = Boolean.FALSE;
        }
        String url = (String)serverProps.get(WCMAppModel.PROP_DEPLOYSERVERURLUSED);
        String username = (String)serverProps.get(WCMAppModel.PROP_DEPLOYSERVERUSERNAMEUSED);
        String source = (String)serverProps.get(WCMAppModel.PROP_DEPLOYSOURCEPATHUSED);
        String target = (String)serverProps.get(WCMAppModel.PROP_DEPLOYSERVERTARGETUSED);
        String excludes = (String)serverProps.get(WCMAppModel.PROP_DEPLOYEXCLUDESUSED);
        String failReason = (String)serverProps.get(WCMAppModel.PROP_DEPLOYFAILEDREASON);
        String content = "";
        ContentReader reader = contentService.getReader(deploymentReport, ContentModel.PROP_CONTENT);
        if (reader != null) {
            content = reader.getContentString();
            if (content != null) {
                content = Utils.encode((String)content);
                content = StringUtils.replace((String)content, (String)"\r\n", (String)"<br/>");
            } else {
                content = "";
            }
        }
        int snapshot = -1;
        Serializable snapshotObj = (Serializable)serverProps.get(WCMAppModel.PROP_DEPLOYVERSION);
        if (snapshotObj != null && snapshotObj instanceof Integer) {
            snapshot = (Integer)snapshotObj;
        }
        out.write("<table cellspacing='0' cellpadding='2' border='0' width='100%'>");
        out.write("<tr><td width='40' valign='top'><img src='");
        out.write(context.getExternalContext().getRequestContextPath());
        out.write("/images/icons/deploy_server_");
        out.write(deployType);
        out.write(".gif' /></td><td>");
        out.write("<div class='mainHeading'>");
        out.write(Utils.encode((String)serverName));
        out.write("</div><div style='margin-top: 3px; margin-bottom: 6px;'><img src='");
        out.write(context.getExternalContext().getRequestContextPath());
        out.write("/images/icons/deploy_");
        if (success.booleanValue()) {
            out.write("successful");
        } else {
            out.write("failed");
        }
        out.write(".gif' style='vertical-align: -4px;' />&nbsp;&nbsp;");
        if (success.booleanValue()) {
            out.write(org.alfresco.web.app.Application.getMessage(context, "deploy_successful"));
        } else {
            out.write(org.alfresco.web.app.Application.getMessage(context, "deploy_failed"));
        }
        out.write("</div>");
        if (!success.booleanValue() && failReason != null && failReason.length() > 0) {
            out.write("<div style='margin-top: 3px;'>");
            out.write(org.alfresco.web.app.Application.getMessage(context, "reason"));
            out.write(":&nbsp;");
            out.write(Utils.encode((String)failReason));
            out.write("</div>");
        }
        if (showServerAddress) {
            out.write("<div style='margin-top: 3px;'>");
            out.write(org.alfresco.web.app.Application.getMessage(context, "deploy_server"));
            out.write(":&nbsp;");
            out.write(Utils.encode((String)server));
            out.write("</div>");
        }
        out.write("<div style='margin-top: 3px;'>");
        out.write(org.alfresco.web.app.Application.getMessage(context, MSG_SNAPSHOT));
        out.write(":&nbsp;");
        out.write(Integer.toString(snapshot));
        out.write("</div>");
        out.write("<div style='margin-top: 3px;'>");
        out.write(org.alfresco.web.app.Application.getMessage(context, "deploy_started"));
        out.write(":&nbsp;");
        out.write(started);
        out.write("</div>");
        out.write("<div style='margin-top: 3px;'>");
        out.write(org.alfresco.web.app.Application.getMessage(context, "deploy_finished"));
        out.write(":&nbsp;");
        out.write(finished);
        out.write("</div>");
        out.write("<div style='margin-top: 3px;'>");
        out.write(org.alfresco.web.app.Application.getMessage(context, "deployed_by"));
        out.write(":&nbsp;");
        out.write(Utils.encode((String)creator));
        out.write("</div>");
        if (username != null) {
            out.write("<div style='margin-top: 3px;'>");
            out.write(org.alfresco.web.app.Application.getMessage(context, "deploy_server_username"));
            out.write(":&nbsp;");
            out.write(Utils.encode((String)username));
            out.write("</div>");
        }
        if (source != null) {
            out.write("<div style='margin-top: 3px;'>");
            out.write(org.alfresco.web.app.Application.getMessage(context, "deploy_server_source_path"));
            out.write(":&nbsp;");
            out.write(Utils.encode((String)source));
            out.write("</div>");
        }
        if (excludes != null) {
            out.write("<div style='margin-top: 3px;'>");
            out.write(org.alfresco.web.app.Application.getMessage(context, "deploy_server_excludes"));
            out.write(":&nbsp;");
            out.write(Utils.encode((String)excludes));
            out.write("</div>");
        }
        if (target != null) {
            out.write("<div style='margin-top: 3px;'>");
            out.write(org.alfresco.web.app.Application.getMessage(context, "deploy_server_target_name"));
            out.write(":&nbsp;");
            out.write(Utils.encode((String)target));
            out.write("</div>");
        }
        if (success.booleanValue() && url != null && url.length() > 0) {
            out.write("<div style='margin-top: 3px;'>");
            out.write(org.alfresco.web.app.Application.getMessage(context, "deploy_server_url"));
            out.write(":&nbsp;<a target='new' href='");
            out.write(url);
            out.write("'>");
            out.write(Utils.encode((String)url));
            out.write("</a></div>");
        }
        if (content.length() > 0) {
            out.write("<div style='margin-top: 6px;'><img src='");
            out.write(context.getExternalContext().getRequestContextPath());
            out.write("/images/icons/collapsed.gif' style='vertical-align: -1px; cursor: pointer;' class='collapsed' onclick=\"Alfresco.toggleDeploymentDetails(this, '");
            out.write(serverId.toString());
            out.write("');\" />&nbsp;");
            out.write(org.alfresco.web.app.Application.getMessage(context, "details"));
            out.write("</div>\n");
            out.write("<div id='");
            out.write(serverId.toString());
            out.write("-deployment-details' style='display: none; border: 1px dotted #eee; margin-left: 14px; margin-top: 4px; padding:3px;'>");
            out.write(content);
            out.write("</div>");
        }
        out.write("\n<div style='padding-top:6px;'></div>\n");
        out.write("</td></tr></table>");
        PanelGenerator.generatePanelEnd((Writer)out, context.getExternalContext().getRequestContextPath(), "lightstorm");
    }

    protected UIActionLink aquireViewAttemptAction(FacesContext context, DeploymentAttempt attempt) {
        UIActionLink action = null;
        String actionId = "va_" + attempt.getId();
        for (UIComponent component : this.getChildren()) {
            if (!actionId.equals(component.getId())) continue;
            action = (UIActionLink)component;
            break;
        }
        if (action == null) {
            Application facesApp = context.getApplication();
            action = (UIActionLink)facesApp.createComponent("org.alfresco.faces.ActionLink");
            action.setId(actionId);
            action.setValue(attempt.getDateAsString());
            action.setTooltip(org.alfresco.web.app.Application.getMessage(context, MSG_SELECT_ATTEMPT));
            action.setShowLink(true);
            action.setActionListener(facesApp.createMethodBinding("#{DialogManager.bean.attemptSelected}", UIActions.ACTION_CLASS_ARGS));
            UIParameter param1 = (UIParameter)facesApp.createComponent("javax.faces.Parameter");
            param1.setId(actionId + "_1");
            param1.setName("attemptRef");
            param1.setValue((Object)attempt.getNodeRef().toString());
            action.getChildren().add(param1);
            UIParameter param2 = (UIParameter)facesApp.createComponent("javax.faces.Parameter");
            param2.setId(actionId + "_2");
            param2.setName("attemptDate");
            param2.setValue((Object)attempt.getDateAsString());
            action.getChildren().add(param2);
            this.getChildren().add(action);
        }
        return action;
    }

    private class DeploymentAttempt {
        private NodeRef nodeRef;
        private String id;
        private Date date;
        private String servers;
        private Integer version;

        public DeploymentAttempt(NodeRef nodeRef, String id, Date date, String servers, Integer version) {
            this.nodeRef = nodeRef;
            this.id = id;
            this.date = date;
            this.servers = servers;
            this.version = version;
        }

        public NodeRef getNodeRef() {
            return this.nodeRef;
        }

        public String getId() {
            return this.id;
        }

        public String getServers() {
            return this.servers;
        }

        public Integer getVersion() {
            return this.version;
        }

        public Date getDate() {
            return this.date;
        }

        public String getDateAsString() {
            return Utils.getDateTimeFormat(FacesContext.getCurrentInstance()).format(this.date);
        }
    }
}

