/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.netcdf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetCDFParser
implements Parser {
    private final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.application((String)"application/x-netcdf"));

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return this.SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.writeStreamToMemory(stream, os);
        NetcdfFile ncFile = NetcdfFile.openInMemory((String)"", (byte[])os.toByteArray());
        for (Attribute attr : ncFile.getGlobalAttributes()) {
            String attrName = attr.getName();
            if (attr.getDataType().isString()) {
                metadata.add(attrName, attr.getStringValue());
                continue;
            }
            if (!attr.getDataType().isNumeric()) continue;
            metadata.add(attrName, String.valueOf(attr.getNumericValue().intValue()));
        }
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        this.parse(stream, handler, metadata, new ParseContext());
    }

    private void writeStreamToMemory(InputStream is, ByteArrayOutputStream os) throws TikaException {
        byte[] buf = new byte[512];
        try {
            while (is.read(buf, 0, 512) != -1) {
                os.write(buf);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TikaException(e.getMessage());
        }
    }
}

