/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.tck.atompub.client;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Validator;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Collection;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Link;
import org.apache.abdera.model.Service;
import org.apache.abdera.model.Workspace;
import org.apache.abdera.util.Constants;
import org.apache.chemistry.abdera.ext.CMISACLCapability;
import org.apache.chemistry.abdera.ext.CMISCapabilities;
import org.apache.chemistry.abdera.ext.CMISConstants;
import org.apache.chemistry.abdera.ext.CMISObject;
import org.apache.chemistry.abdera.ext.CMISRepositoryInfo;
import org.apache.chemistry.abdera.ext.CMISUriTemplate;
import org.apache.chemistry.abdera.ext.utils.CMISAppModel;
import org.apache.chemistry.tck.atompub.TCKMessageWriter;
import org.apache.chemistry.tck.atompub.client.CMISValidator;
import org.apache.chemistry.tck.atompub.http.Connection;
import org.apache.chemistry.tck.atompub.http.GetRequest;
import org.apache.chemistry.tck.atompub.http.PostRequest;
import org.apache.chemistry.tck.atompub.http.Request;
import org.apache.chemistry.tck.atompub.http.Response;
import org.apache.chemistry.tck.atompub.utils.ResourceLoader;
import org.apache.commons.codec.binary.Base64;
import org.junit.Assert;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMISClient {
    private TCKMessageWriter messageWriter;
    private String userId;
    private Connection connection;
    private boolean traceConnection;
    private String serviceUrl;
    private CMISAppModel appModel = new CMISAppModel();
    private CMISValidator cmisValidator = new CMISValidator();
    private boolean validate = true;
    private boolean failOnValidationError = false;
    private ResourceLoader templates = new ResourceLoader("/org/apache/chemistry/tck/atompub/templates/");
    private Service cmisService = null;
    private CMISRepositoryInfo cmisRepositoryInfo = null;
    private String defaultDocumentType = "cmis:document";
    private String defaultFolderType = "cmis:folder";
    private String defaultRelationshipType = "cmis:relationship";

    public CMISClient(String userId, Connection connection, String serviceUrl, TCKMessageWriter messageWriter) {
        this.userId = userId;
        this.connection = connection;
        this.serviceUrl = serviceUrl;
        this.messageWriter = messageWriter;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public void setFailOnValidationError(boolean failOnValidationError) {
        this.failOnValidationError = failOnValidationError;
    }

    public void setTrace(boolean trace) {
        this.traceConnection = trace;
    }

    public void setDefaultDocumentType(String defaultDocumentType) {
        this.defaultDocumentType = defaultDocumentType;
    }

    public void setDefaultFolderType(String defaultFolderType) {
        this.defaultFolderType = defaultFolderType;
    }

    public void setDefaultRelationshipType(String defaultRelationshipType) {
        this.defaultRelationshipType = defaultRelationshipType;
    }

    public String getUserId() {
        return this.userId;
    }

    public Service getRepository() throws Exception {
        return this.getRepository(false);
    }

    public Service getRepository(boolean refresh) throws Exception {
        if (refresh || this.cmisService == null) {
            GetRequest req = new GetRequest(this.serviceUrl);
            Response res = this.executeRequest(req, 200);
            String xml = res.getContentAsString();
            Assert.assertNotNull((Object)xml);
            Assert.assertTrue((xml.length() > 0 ? 1 : 0) != 0);
            this.cmisService = this.appModel.parseService((Reader)new StringReader(xml), null);
            Assert.assertNotNull((Object)this.cmisService);
        }
        return this.cmisService;
    }

    public CMISRepositoryInfo getRepositoryInfo() throws Exception {
        return this.getRepositoryInfo(false);
    }

    public CMISRepositoryInfo getRepositoryInfo(boolean refresh) throws Exception {
        if (refresh || this.cmisRepositoryInfo == null) {
            Service repo = this.getRepository(refresh);
            Workspace workspace = this.getWorkspace(repo);
            this.cmisRepositoryInfo = (CMISRepositoryInfo)workspace.getExtension(CMISConstants.REPOSITORY_INFO);
            Assert.assertNotNull((Object)this.cmisRepositoryInfo);
        }
        return this.cmisRepositoryInfo;
    }

    public CMISCapabilities getCapabilities() throws Exception {
        return this.getRepositoryInfo().getCapabilities();
    }

    public CMISACLCapability getACLCapability() throws Exception {
        return this.getRepositoryInfo().getACLCapability();
    }

    public Workspace getWorkspace() throws Exception {
        return (Workspace)this.getRepository(false).getWorkspaces().get(0);
    }

    public Workspace getWorkspace(Service service) {
        return (Workspace)service.getWorkspaces().get(0);
    }

    public Collection getCMISCollection(Workspace workspace, String collectionId) {
        List collections = workspace.getCollections();
        for (Collection collection : collections) {
            Element collectionType = collection.getFirstChild(CMISConstants.COLLECTION_TYPE);
            if (collectionType == null || !collectionId.equals(collectionType.getText())) continue;
            return collection;
        }
        return null;
    }

    public IRI getRootCollection(Workspace workspace) {
        Collection root = this.getCMISCollection(workspace, "root");
        Assert.assertNotNull((Object)root);
        IRI rootHREF = root.getHref();
        Assert.assertNotNull((Object)rootHREF);
        return rootHREF;
    }

    public IRI getCheckedOutCollection(Workspace workspace) {
        Collection root = this.getCMISCollection(workspace, "checkedout");
        Assert.assertNotNull((Object)root);
        IRI rootHREF = root.getHref();
        Assert.assertNotNull((Object)rootHREF);
        return rootHREF;
    }

    public IRI getTypesChildrenCollection(Workspace workspace) {
        Collection root = this.getCMISCollection(workspace, "types");
        Assert.assertNotNull((Object)root);
        IRI rootHREF = root.getHref();
        Assert.assertNotNull((Object)rootHREF);
        return rootHREF;
    }

    public IRI getQueryCollection(Workspace workspace) {
        Collection root = this.getCMISCollection(workspace, "query");
        Assert.assertNotNull((Object)root);
        IRI rootHREF = root.getHref();
        Assert.assertNotNull((Object)rootHREF);
        return rootHREF;
    }

    public CMISUriTemplate getUriTemplate(Workspace workspace, String templateType) {
        List templates = workspace.getExtensions(CMISConstants.URI_TEMPLATE);
        for (CMISUriTemplate template : templates) {
            if (!templateType.equals(template.getType())) continue;
            return template;
        }
        return null;
    }

    public CMISUriTemplate getObjectByIdUriTemplate(Workspace workspace) {
        return this.getUriTemplate(workspace, "objectbyid");
    }

    public CMISUriTemplate getObjectByPathUriTemplate(Workspace workspace) {
        return this.getUriTemplate(workspace, "objectbypath");
    }

    public CMISUriTemplate getQueryUriTemplate(Workspace workspace) {
        return this.getUriTemplate(workspace, "query");
    }

    public CMISUriTemplate getTypeByIdUriTemplate(Workspace workspace) {
        return this.getUriTemplate(workspace, "typebyid");
    }

    public Link getLink(Workspace workspace, String rel, String ... matchesMimetypes) {
        List links = workspace.getExtensions(Constants.LINK);
        ArrayList<Link> filteredLinks = new ArrayList<Link>(links.size());
        for (Link link : links) {
            if (!link.getRel().equals(rel)) continue;
            filteredLinks.add(link);
        }
        return this.getLink(filteredLinks, matchesMimetypes);
    }

    private Link getLink(List<Link> links, String ... matchesMimetypes) {
        if (links != null) {
            for (Link link : links) {
                MimeType mimetype = link.getMimeType();
                if (matchesMimetypes.length == 0) {
                    if (links.size() == 1) {
                        return link;
                    }
                    if (mimetype == null) {
                        return link;
                    }
                }
                String[] stringArray = matchesMimetypes;
                int n = matchesMimetypes.length;
                int n2 = 0;
                while (n2 < n) {
                    String matchesMimetype = stringArray[n2];
                    try {
                        MimeType mtMatchesMimetype = new MimeType(matchesMimetype);
                        String type = mimetype.getParameter("type");
                        if (type == null) {
                            if (mimetype != null && mimetype.getBaseType().equals(mtMatchesMimetype.getBaseType()) && mimetype.getSubType().equals(mtMatchesMimetype.getSubType())) {
                                return link;
                            }
                        } else {
                            String matchesType = mtMatchesMimetype.getParameter("type");
                            if (mimetype != null && mimetype.getBaseType().equals(mtMatchesMimetype.getBaseType()) && mimetype.getSubType().equals(mtMatchesMimetype.getSubType()) && type.equals(matchesType)) {
                                return link;
                            }
                        }
                    }
                    catch (MimeTypeParseException mimeTypeParseException) {
                        // empty catch block
                    }
                    ++n2;
                }
            }
        }
        return null;
    }

    public Link getLink(Entry entry, String rel, String ... matchesMimetypes) {
        return this.getLink(entry.getLinks(rel), matchesMimetypes);
    }

    public Link getChildrenLink(Entry entry) {
        return this.getLink(entry, "down", "application/atom+xml;type=feed");
    }

    public Link getDescendantsLink(Entry entry) {
        return this.getLink(entry, "down", "application/cmistree+xml");
    }

    public Link getFolderTreeLink(Entry entry) {
        return this.getLink(entry, "http://docs.oasis-open.org/ns/cmis/link/200908/foldertree", "application/atom+xml;type=feed");
    }

    public Link getObjectParentsLink(Entry entry) {
        return this.getLink(entry, "up", "application/atom+xml;type=feed");
    }

    public Link getFolderParentLink(Entry entry) {
        return this.getLink(entry, "up", "application/atom+xml;type=entry");
    }

    public List<Link> getRenditionLinks(Entry entry) {
        return entry.getLinks("alternate");
    }

    public Link getChangesLink(Workspace workspace) {
        return this.getLink(workspace, "http://docs.oasis-open.org/ns/cmis/link/200908/changes", "application/atom+xml;type=feed");
    }

    public Entry getEntry(IRI href) throws Exception {
        return this.getEntry(href, null);
    }

    public Entry getEntry(IRI href, Map<String, String> args) throws Exception {
        Request get = new GetRequest(href.toString()).setArgs(args);
        Response res = this.executeRequest(get, 200);
        String xml = res.getContentAsString();
        Entry entry = this.appModel.parseEntry((Reader)new StringReader(xml), null);
        Assert.assertNotNull((Object)entry);
        return entry;
    }

    public Feed getFeed(IRI href) throws Exception {
        return this.getFeed(href, null);
    }

    public Feed getFeed(IRI href, Map<String, String> args) throws Exception {
        Request get = new GetRequest(href.toString()).setArgs(args);
        Response res = this.executeRequest(get, 200);
        Assert.assertNotNull((Object)res);
        String xml = res.getContentAsString();
        Feed feed = this.appModel.parseFeed((Reader)new StringReader(xml), null);
        Assert.assertNotNull((Object)feed);
        return feed;
    }

    public Entry createFolder(IRI parent, String type, String name) throws Exception {
        return this.createFolder(parent, type, name, null);
    }

    public Entry createFolder(IRI parent, String type, String name, String atomEntryFile) throws Exception {
        type = type == null ? this.defaultFolderType : type;
        String createFolder = this.templates.load(atomEntryFile == null ? "createfolder.atomentry.xml" : atomEntryFile);
        createFolder = createFolder.replace("${NAME}", name);
        createFolder = createFolder.replace("${TYPE}", type);
        PostRequest req = new PostRequest(parent.toString(), createFolder, "application/atom+xml;type=entry");
        Response res = this.executeRequest(req, 201);
        Assert.assertNotNull((Object)res);
        String xml = res.getContentAsString();
        Entry entry = this.appModel.parseEntry((Reader)new StringReader(xml), null);
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((Object)name, (Object)entry.getTitle());
        CMISObject object = (CMISObject)entry.getExtension(CMISConstants.OBJECT);
        Assert.assertEquals((Object)"cmis:folder", (Object)object.getBaseTypeId().getStringValue());
        String testFolderHREF = res.getHeader("Location");
        Assert.assertNotNull((Object)testFolderHREF);
        return entry;
    }

    public Entry createDocument(IRI parent, String type, String name) throws Exception {
        return this.createDocument(parent, type, name, null);
    }

    public Entry createDocument(IRI parent, String type, String name, String atomEntryFile) throws Exception {
        return this.createDocument(parent, type, name, atomEntryFile, false);
    }

    public Entry createDocument(IRI parent, String type, String name, String atomEntryFile, boolean expectNoContent) throws Exception {
        return this.createDocument(parent, type, name, atomEntryFile, expectNoContent, name, null, null);
    }

    public Entry createDocument(IRI parent, String type, String name, String atomEntryFile, boolean expectNoContent, String content, String contentType, String contentPath) throws Exception {
        InputStream in;
        String string = type = type == null ? this.defaultDocumentType : type;
        String createFile = this.templates.load(atomEntryFile == null ? (contentPath == null ? "createdocument.atomentry.xml" : "createdocumentBase64.cmisatomentry.xml") : atomEntryFile);
        createFile = createFile.replace("${NAME}", name);
        createFile = createFile.replace("${TYPE}", type);
        createFile = createFile.replace("${CONTENTTYPE}", contentType == null ? "text" : contentType);
        Entry createEntry = this.appModel.parseEntry((Reader)new StringReader(createFile), null);
        MimeType mimeType = createEntry.getContentMimeType();
        if (content != null) {
            createFile = createFile.replace("${CONTENT}", mimeType == null || mimeType.getPrimaryType().equals("text") ? content : new String(Base64.encodeBase64((byte[])content.getBytes("UTF-8")), "8859_1"));
        }
        byte[] contentBytes = null;
        if (contentPath != null && (in = this.getClass().getResourceAsStream(String.valueOf('/') + contentPath)) != null) {
            int bytesRead;
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            byte[] buffer = new byte[1024];
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            in.close();
            out.close();
            contentBytes = out.toByteArray();
        }
        if (contentBytes == null) {
            contentBytes = name.getBytes("UTF-8");
        }
        createFile = createFile.replace("${CMISCONTENT}", new String(Base64.encodeBase64((byte[])contentBytes), "8859_1"));
        PostRequest req = new PostRequest(parent.toString(), createFile, "application/atom+xml;type=entry");
        Response res = this.executeRequest(req, 201);
        Assert.assertNotNull((Object)res);
        String xml = res.getContentAsString();
        Entry entry = this.appModel.parseEntry((Reader)new StringReader(xml), null);
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((Object)name, (Object)entry.getTitle());
        if (!expectNoContent) {
            Assert.assertNotNull((Object)entry.getContentSrc());
        }
        CMISObject object = (CMISObject)entry.getExtension(CMISConstants.OBJECT);
        Assert.assertEquals((Object)"cmis:document", (Object)object.getBaseTypeId().getStringValue());
        String testFileHREF = res.getHeader("Location");
        Assert.assertNotNull((Object)testFileHREF);
        return entry;
    }

    public Entry createRelationship(IRI parent, String type, String sourceId, String targetId) throws Exception {
        return this.createRelationship(parent, type, sourceId, targetId, "createrelationship.atomentry.xml");
    }

    public Entry createRelationship(IRI parent, String type, String sourceId, String targetId, String atomEntryFile) throws Exception {
        type = type == null ? this.defaultRelationshipType : type;
        String createFile = this.templates.load(atomEntryFile);
        createFile = createFile.replace("${NAME}", String.valueOf(sourceId) + "_" + targetId);
        createFile = createFile.replace("${RELTYPE}", type);
        createFile = createFile.replace("${SOURCEID}", sourceId);
        createFile = createFile.replace("${TARGETID}", targetId);
        PostRequest req = new PostRequest(parent.toString(), createFile, "application/atom+xml;type=entry");
        Response res = this.executeRequest(req, 201);
        Assert.assertNotNull((Object)res);
        String xml = res.getContentAsString();
        Entry entry = this.appModel.parseEntry((Reader)new StringReader(xml), null);
        Assert.assertNotNull((Object)entry);
        CMISObject object = (CMISObject)entry.getExtension(CMISConstants.OBJECT);
        Assert.assertEquals((Object)"cmis:relationship", (Object)object.getBaseTypeId().getStringValue());
        Assert.assertEquals((Object)targetId, (Object)object.getTargetId().getStringValue());
        String testFileHREF = res.getHeader("Location");
        Assert.assertNotNull((Object)testFileHREF);
        return entry;
    }

    public Entry moveObject(IRI destFolder, Entry atomEntry, String sourceFolderId) throws Exception {
        Response res = this.moveObjectRequest(destFolder, atomEntry, sourceFolderId, 201);
        Assert.assertNotNull((Object)res);
        String xml = res.getContentAsString();
        Entry entry = this.appModel.parseEntry((Reader)new StringReader(xml), null);
        return entry;
    }

    public Response moveObjectRequest(IRI destFolder, Entry atomEntry, String sourceFolderId, int expectedStatus) throws Exception {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("sourceFolderId", sourceFolderId);
        Request req = new PostRequest(destFolder.toString(), atomEntry.toString(), "application/atom+xml;type=entry").setArgs(args);
        Response res = this.executeRequest(req, expectedStatus);
        return res;
    }

    public Response executeRequest(Request req, int expectedStatus) throws IOException {
        return this.executeRequest(req, expectedStatus, expectedStatus);
    }

    public Response executeRequest(Request req, int expectedStatusMin, int expectedStatusMax) throws IOException {
        if (this.traceConnection) {
            this.messageWriter.trace("Request: " + req.getMethod() + " " + req.getFullUri() + (req.getBody() == null ? "" : "\n" + new String(req.getBody(), req.getEncoding())));
        }
        Response res = this.connection.executeRequest(req);
        if (this.traceConnection) {
            this.messageWriter.trace("Response: " + res.getStatus() + " " + req.getMethod() + " " + req.getFullUri() + (res.getContentAsString() == null ? "" : "\n" + res.getContentAsString()));
        }
        if (expectedStatusMin > -1) {
            int status = res.getStatus();
            if (expectedStatusMin == expectedStatusMax) {
                Assert.assertEquals((String)("Request status for " + req.getFullUri()), (long)expectedStatusMin, (long)status);
            } else {
                Assert.assertTrue((String)("Request status for " + req.getFullUri() + " was " + status + " but must be between " + expectedStatusMin + " and " + expectedStatusMax), (expectedStatusMin <= status && status <= expectedStatusMax ? 1 : 0) != 0);
            }
        }
        if (this.validate) {
            Validator mimetypeValidator = null;
            String contentType = res.getContentType();
            if (contentType != null) {
                try {
                    if (contentType.startsWith("application/atom+xml")) {
                        mimetypeValidator = this.getAtomValidator();
                    } else if (contentType.startsWith("application/atomsvc+xml") || contentType.startsWith("application/cmisacl+xml") || contentType.startsWith("application/cmisallowableactions+xml")) {
                        mimetypeValidator = this.getAppValidator();
                    }
                }
                catch (SAXException sAXException) {
                    // empty catch block
                }
                if (mimetypeValidator != null) {
                    try {
                        if (this.traceConnection) {
                            this.messageWriter.trace("Validating response of content type " + contentType);
                        }
                        String resXML = res.getContentAsString();
                        this.assertValid(resXML, mimetypeValidator);
                    }
                    catch (ParserConfigurationException e) {
                        throw new RuntimeException("Failed to validate", e);
                    }
                }
            }
        }
        return res;
    }

    public Validator getAppValidator() throws IOException, SAXException {
        return this.cmisValidator.getAppValidator();
    }

    public Validator getAtomValidator() throws IOException, SAXException {
        return this.cmisValidator.getCMISAtomValidator();
    }

    public void assertValid(String xml, Validator validator) throws IOException, ParserConfigurationException {
        block3: {
            if (this.validate) {
                try {
                    Document document = this.cmisValidator.getDocumentBuilder().parse(new InputSource(new StringReader(xml)));
                    validator.validate(new DOMSource(document));
                }
                catch (SAXException e) {
                    this.messageWriter.info("Failed Validation: " + this.cmisValidator.toString(e, null));
                    if (!this.failOnValidationError) break block3;
                    Assert.fail((String)this.cmisValidator.toString(e, xml));
                }
            }
        }
    }
}

