/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.tck.atompub.test.spec;

import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Link;
import org.apache.chemistry.tck.atompub.TCKTest;
import org.apache.chemistry.tck.atompub.http.GetRequest;
import org.apache.chemistry.tck.atompub.http.Response;
import org.junit.Assert;

public class CreateTest
extends TCKTest {
    public void testCreateFolder() throws Exception {
        Entry testFolder = this.fixture.getTestCaseFolder();
        Link childrenLink = this.client.getChildrenLink(testFolder);
        Assert.assertNotNull((Object)childrenLink);
        Feed children = this.client.getFeed(childrenLink.getHref());
        Assert.assertNotNull((Object)children);
        int entriesBefore = children.getEntries().size();
        Entry folder = this.client.createFolder(children.getSelfLink().getHref(), null, "testCreateFolder");
        Feed feedFolderAfter = this.client.getFeed(childrenLink.getHref());
        int entriesAfter = feedFolderAfter.getEntries().size();
        Assert.assertEquals((long)(entriesBefore + 1), (long)entriesAfter);
        Entry entry = feedFolderAfter.getEntry(folder.getId().toString());
        Assert.assertNotNull((Object)entry);
    }

    public void testCreateDocumentCMISContent() throws Exception {
        Entry testFolder = this.fixture.getTestCaseFolder();
        Link childrenLink = this.client.getChildrenLink(testFolder);
        Assert.assertNotNull((Object)childrenLink);
        Feed children = this.client.getFeed(childrenLink.getHref());
        Assert.assertNotNull((Object)children);
        int entriesBefore = children.getEntries().size();
        Entry document = this.client.createDocument(children.getSelfLink().getHref(), null, "testCreateDocumentCMISContent", "createdocumentBase64.cmisatomentry.xml", false, null, "text/plain", null);
        Response documentContentRes = this.client.executeRequest(new GetRequest(document.getContentSrc().toString()), 200);
        String resContent = documentContentRes.getContentAsString();
        Assert.assertEquals((Object)document.getTitle(), (Object)resContent);
        Feed feedFolderAfter = this.client.getFeed(childrenLink.getHref());
        int entriesAfter = feedFolderAfter.getEntries().size();
        Assert.assertEquals((long)(entriesBefore + 1), (long)entriesAfter);
        Entry entry = feedFolderAfter.getEntry(document.getId().toString());
        Assert.assertNotNull((Object)entry);
    }

    public void testCreateDocumentAtomContent() throws Exception {
        Entry testFolder = this.fixture.getTestCaseFolder();
        Link childrenLink = this.client.getChildrenLink(testFolder);
        Assert.assertNotNull((Object)childrenLink);
        Feed children = this.client.getFeed(childrenLink.getHref());
        Assert.assertNotNull((Object)children);
        int entriesBefore = children.getEntries().size();
        Entry document = this.client.createDocument(children.getSelfLink().getHref(), null, "testCreateDocumentAtomContent");
        Response documentContentRes = this.client.executeRequest(new GetRequest(document.getContentSrc().toString()), 200);
        String resContent = documentContentRes.getContentAsString();
        Assert.assertEquals((Object)document.getTitle(), (Object)resContent);
        Feed feedFolderAfter = this.client.getFeed(childrenLink.getHref());
        int entriesAfter = feedFolderAfter.getEntries().size();
        Assert.assertEquals((long)(entriesBefore + 1), (long)entriesAfter);
        Entry entry = feedFolderAfter.getEntry(document.getId().toString());
        Assert.assertNotNull((Object)entry);
    }

    public void testCreateDocumentAtomContentWithMimeType() throws Exception {
        Entry testFolder = this.fixture.getTestCaseFolder();
        Link childrenLink = this.client.getChildrenLink(testFolder);
        Assert.assertNotNull((Object)childrenLink);
        Feed children = this.client.getFeed(childrenLink.getHref());
        Assert.assertNotNull((Object)children);
        int entriesBefore = children.getEntries().size();
        Entry document = this.client.createDocument(children.getSelfLink().getHref(), null, "testCreateDocumentAtomContentWithMimeType", "createdocument.atomentry.xml", false, "testCreateDocumentAtomContentWithMimeType", "text/plain", null);
        Response documentContentRes = this.client.executeRequest(new GetRequest(document.getContentSrc().toString()), 200);
        String resContent = documentContentRes.getContentAsString();
        Assert.assertEquals((Object)document.getTitle(), (Object)resContent);
        Feed feedFolderAfter = this.client.getFeed(childrenLink.getHref());
        int entriesAfter = feedFolderAfter.getEntries().size();
        Assert.assertEquals((long)(entriesBefore + 1), (long)entriesAfter);
        Entry entry = feedFolderAfter.getEntry(document.getId().toString());
        Assert.assertNotNull((Object)entry);
    }

    public void testCreateAtomEntry() throws Exception {
        Entry testFolder = this.fixture.getTestCaseFolder();
        Link childrenLink = this.client.getChildrenLink(testFolder);
        Assert.assertNotNull((Object)childrenLink);
        Feed children = this.client.getFeed(childrenLink.getHref());
        Assert.assertNotNull((Object)children);
        int entriesBefore = children.getEntries().size();
        Entry document = this.client.createDocument(children.getSelfLink().getHref(), null, "I\u221a\u00b1t\u221a\u00b4rn\u221a\u00a2ti\u221a\u00a5n\u221a\u2020liz\u221a\u00b6ti\u221a\u220fn - 1.html", "createatomentry.atomentry.xml");
        Response documentContentRes = this.client.executeRequest(new GetRequest(document.getContentSrc().toString()), 200);
        String resContent = documentContentRes.getContentAsString();
        Assert.assertEquals((Object)document.getTitle(), (Object)resContent);
        Feed feedFolderAfter = this.client.getFeed(childrenLink.getHref());
        int entriesAfter = feedFolderAfter.getEntries().size();
        Assert.assertEquals((long)(entriesBefore + 1), (long)entriesAfter);
        Entry entry = feedFolderAfter.getEntry(document.getId().toString());
        Assert.assertNotNull((Object)entry);
    }
}

