/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.tck.atompub.test.spec;

import java.util.Collections;
import java.util.HashMap;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Link;
import org.apache.chemistry.abdera.ext.CMISCapabilities;
import org.apache.chemistry.tck.atompub.TCKSkipCapabilityException;
import org.apache.chemistry.tck.atompub.TCKTest;
import org.apache.chemistry.tck.atompub.fixture.AssertValidObjectParentsVisitor;
import org.apache.chemistry.tck.atompub.fixture.CMISTree;
import org.apache.chemistry.tck.atompub.fixture.EntryTree;
import org.apache.chemistry.tck.atompub.fixture.GatherRenditionsVisitor;
import org.junit.Assert;

public class FolderHierarchyTest
extends TCKTest {
    private void getFolderTreeDepthN(int depth, int getDepth) throws Exception {
        EntryTree folderTree = this.fixture.createTestTree("foldertree", depth, 2, null, null);
        Link treeLink = this.client.getFolderTreeLink(folderTree.entry);
        Assert.assertNotNull((Object)treeLink);
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("depth", "" + getDepth);
        Feed tree = this.client.getFeed(treeLink.getHref(), args);
        EntryTree constructedFoldersOnly = new EntryTree(folderTree, getDepth, false);
        CMISTree retrievedFoldersOnly = new CMISTree(folderTree, tree);
        Assert.assertTrue((boolean)constructedFoldersOnly.equalsTree(retrievedFoldersOnly));
        Assert.assertFalse((boolean)folderTree.equalsTree(retrievedFoldersOnly));
    }

    public void testGetFolderTreeMinusOne() throws Exception {
        this.getFolderTreeDepthN(3, -1);
    }

    public void testGetFolderTreeOne() throws Exception {
        this.getFolderTreeDepthN(3, 1);
    }

    public void testGetFolderTreeExactDepth() throws Exception {
        this.getFolderTreeDepthN(3, 3);
    }

    public void testGetFolderTreeOverDepth() throws Exception {
        this.getFolderTreeDepthN(3, 4);
    }

    public void testGetFolderTreeRenditions() throws Exception {
        this.testLinkRenditions("foldertree", "http://docs.oasis-open.org/ns/cmis/link/200908/foldertree", "application/atom+xml;type=feed");
    }

    private void testLinkRenditions(String name, String linkRel, String linkMimeType) throws Exception {
        final EntryTree folderTree = this.fixture.createTestTree(name, 3, 2, null, null);
        final Link treeLink = this.client.getLink(folderTree.entry, linkRel, linkMimeType);
        Assert.assertNotNull((Object)treeLink);
        GatherRenditionsVisitor visitor = new GatherRenditionsVisitor(this.client);
        visitor.testRenditions(folderTree, new GatherRenditionsVisitor.EntryGenerator(){

            public EntryTree getEntries(String renditionFilter) throws Exception {
                HashMap<String, String> args = new HashMap<String, String>();
                args.put("depth", "3");
                args.put("renditionFilter", renditionFilter);
                return new CMISTree(folderTree, FolderHierarchyTest.this.client.getFeed(treeLink.getHref(), args));
            }
        });
    }

    private void getDescendantsDepthN(int depth, int getDepth) throws Exception {
        EntryTree descendantsTree = this.fixture.createTestTree("descendants", depth, 2, null, null);
        Link descendantsLink = this.client.getDescendantsLink(descendantsTree.entry);
        Assert.assertNotNull((Object)descendantsLink);
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("depth", "" + getDepth);
        Feed descendants = this.client.getFeed(descendantsLink.getHref(), args);
        EntryTree constructedDescendantsOnly = new EntryTree(descendantsTree, getDepth);
        CMISTree retrievedDescendantsOnly = new CMISTree(descendantsTree, descendants);
        Assert.assertTrue((boolean)constructedDescendantsOnly.equalsTree(retrievedDescendantsOnly));
    }

    private void checkGetDescendantsCapability() throws TCKSkipCapabilityException, Exception {
        CMISCapabilities capabilities = this.client.getCapabilities();
        if (!capabilities.getDescendants()) {
            throw new TCKSkipCapabilityException("getDescendants", "true", "false");
        }
    }

    public void testGetDescendantsMinusOne() throws Exception {
        this.checkGetDescendantsCapability();
        this.getDescendantsDepthN(3, -1);
    }

    public void testGetDescendantsOne() throws Exception {
        this.checkGetDescendantsCapability();
        this.getDescendantsDepthN(3, 1);
    }

    public void testGetDescendantsExactDepth() throws Exception {
        this.checkGetDescendantsCapability();
        this.getDescendantsDepthN(3, 3);
    }

    public void testGetDescendantsOverDepth() throws Exception {
        this.checkGetDescendantsCapability();
        this.getDescendantsDepthN(3, 4);
    }

    public void testGetDescendantRenditions() throws Exception {
        this.checkGetDescendantsCapability();
        this.testLinkRenditions("descendants", "down", "application/cmistree+xml");
    }

    public void testGetObjectParents() throws Exception {
        EntryTree folder = this.fixture.createTestTree("children", 3, 2, null, null);
        folder.walkTree(new AssertValidObjectParentsVisitor(this.client));
    }

    public void testObjectParentRenditions() throws Exception {
        final EntryTree folder = this.fixture.createTestTree("children", 1, 1, null, null);
        EntryTree child = folder.children.get(0);
        final Link parentLink = this.client.getObjectParentsLink(child.entry);
        Assert.assertNotNull((Object)parentLink);
        GatherRenditionsVisitor visitor = new GatherRenditionsVisitor(this.client);
        visitor.testRenditions(folder, new GatherRenditionsVisitor.EntryGenerator(){

            public EntryTree getEntries(String renditionFilter) throws Exception {
                return new CMISTree(folder, FolderHierarchyTest.this.client.getFeed(parentLink.getHref(), Collections.singletonMap("renditionFilter", renditionFilter)));
            }
        });
    }
}

