/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.tck.atompub.test.spec;

import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Service;
import org.apache.chemistry.abdera.ext.CMISCapabilities;
import org.apache.chemistry.abdera.ext.CMISUriTemplate;
import org.apache.chemistry.tck.atompub.TCKSkipCapabilityException;
import org.apache.chemistry.tck.atompub.TCKTest;
import org.apache.chemistry.tck.atompub.http.GetRequest;
import org.junit.Assert;

public class RepositoryServiceTest
extends TCKTest {
    public void testRepository() throws Exception {
        Service service = this.client.getRepository();
        Assert.assertNotNull((Object)service);
    }

    public void testGetRootCollection() throws Exception {
        IRI rootHREF = this.client.getRootCollection(this.client.getWorkspace());
        this.client.executeRequest(new GetRequest(rootHREF.toString()), 200);
    }

    public void testObjectByIdURITemplate() throws Exception {
        CMISUriTemplate uriTemplate = this.client.getObjectByIdUriTemplate(this.client.getWorkspace());
        RepositoryServiceTest.assertNotNull((Object)uriTemplate);
        String template = uriTemplate.getTemplate();
        RepositoryServiceTest.assertNotNull((Object)template);
        this.assertTemplateVariables(template, new String[]{"id", "filter", "includeAllowableActions", "includePolicyIds", "includeRelationships", "includeACL", "renditionFilter"});
    }

    public void testObjectByPathURITemplate() throws Exception {
        CMISUriTemplate uriTemplate = this.client.getObjectByPathUriTemplate(this.client.getWorkspace());
        RepositoryServiceTest.assertNotNull((Object)uriTemplate);
        String template = uriTemplate.getTemplate();
        RepositoryServiceTest.assertNotNull((Object)template);
        this.assertTemplateVariables(template, new String[]{"path", "filter", "includeAllowableActions", "includePolicyIds", "includeRelationships", "includeACL", "renditionFilter"});
    }

    public void testTypeByIdURITemplate() throws Exception {
        CMISUriTemplate uriTemplate = this.client.getTypeByIdUriTemplate(this.client.getWorkspace());
        RepositoryServiceTest.assertNotNull((Object)uriTemplate);
        String template = uriTemplate.getTemplate();
        RepositoryServiceTest.assertNotNull((Object)template);
        this.assertTemplateVariables(template, new String[]{"id"});
    }

    public void testQueryURITemplate() throws Exception {
        CMISCapabilities capabilities = this.client.getCapabilities();
        String capability = capabilities.getQuery();
        RepositoryServiceTest.assertNotNull((Object)capability);
        if (capability.equals("none")) {
            throw new TCKSkipCapabilityException("query", "metadataonly or fulltextonly or bothseparate or bothcombined", capability);
        }
        CMISUriTemplate uriTemplate = this.client.getQueryUriTemplate(this.client.getWorkspace());
        RepositoryServiceTest.assertNotNull((Object)uriTemplate);
        String template = uriTemplate.getTemplate();
        RepositoryServiceTest.assertNotNull((Object)template);
        this.assertTemplateVariables(template, new String[]{"q", "searchAllVersions", "maxItems", "skipCount", "includeAllowableActions", "includeRelationships"});
    }

    private void assertTemplateVariables(String template, String[] variables) {
        String[] stringArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            String variable = stringArray[n2];
            RepositoryServiceTest.assertTrue((String)("template " + template + " contains variable " + variable), (boolean)template.contains("{" + variable + "}"));
            ++n2;
        }
    }
}

