/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.tck.atompub.test.spec;

import java.util.HashMap;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Link;
import org.apache.chemistry.abdera.ext.CMISConstants;
import org.apache.chemistry.abdera.ext.CMISObject;
import org.apache.chemistry.abdera.ext.CMISTypeDefinition;
import org.apache.chemistry.abdera.ext.CMISUriTemplate;
import org.apache.chemistry.tck.atompub.TCKTest;
import org.junit.Assert;

public class TypeDefinitionTest
extends TCKTest {
    public void testGetTypeDefinitionsBase() throws Exception {
        IRI typesHREF = this.client.getTypesChildrenCollection(this.client.getWorkspace());
        Feed types = this.client.getFeed(typesHREF);
        Assert.assertNotNull((Object)types);
        Feed typesWithProps = this.client.getFeed(typesHREF);
        Assert.assertNotNull((Object)typesWithProps);
        for (Entry type : types.getEntries()) {
            Entry retrievedType = this.client.getEntry(type.getSelfLink().getHref());
            Assert.assertEquals((Object)type.getId(), (Object)retrievedType.getId());
            Assert.assertEquals((Object)type.getTitle(), (Object)retrievedType.getTitle());
        }
    }

    public void testGetTypeDefinitionsChild() throws Exception {
        IRI typesHREF = this.client.getTypesChildrenCollection(this.client.getWorkspace());
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("type", "folder");
        args.put("includePropertyDefinitions", "true");
        args.put("maxItems", "5");
        while (typesHREF != null) {
            Feed types = this.client.getFeed(typesHREF, args);
            for (Entry type : types.getEntries()) {
                Entry retrievedType = this.client.getEntry(type.getSelfLink().getHref());
                Assert.assertEquals((Object)type.getId(), (Object)retrievedType.getId());
                Assert.assertEquals((Object)type.getTitle(), (Object)retrievedType.getTitle());
            }
            Link nextLink = types.getLink("next");
            typesHREF = nextLink != null ? nextLink.getHref() : null;
            args.remove("maxItems");
        }
    }

    public void testGetTypeDefinition() throws Exception {
        Entry document = this.fixture.createTestDocument("testGetEntryTypeDefinitionDoc");
        Assert.assertNotNull((Object)document);
        Entry folder = this.fixture.createTestFolder("testGetEntryTypeDefinitionFolder");
        Assert.assertNotNull((Object)folder);
        Entry testFolder = this.fixture.getTestCaseFolder();
        Link childrenLink = this.client.getChildrenLink(testFolder);
        Feed children = this.client.getFeed(childrenLink.getHref());
        for (Entry entry : children.getEntries()) {
            CMISObject entryObject = (CMISObject)entry.getExtension(CMISConstants.OBJECT);
            Assert.assertNotNull((Object)entryObject);
            Link typeLink = entry.getLink("describedby");
            Assert.assertNotNull((Object)typeLink);
            Entry type = this.client.getEntry(typeLink.getHref());
            Assert.assertNotNull((Object)type);
            CMISTypeDefinition entryType = (CMISTypeDefinition)type.getExtension(CMISConstants.TYPE_DEFINITION);
            Assert.assertNotNull((Object)entryType);
            TypeDefinitionTest.assertEquals((String)entryObject.getObjectTypeId().getStringValue(), (String)entryType.getId());
        }
    }

    public void testGetTypeDefinitionById() throws Exception {
        CMISUriTemplate typeByIdTemplate = this.client.getTypeByIdUriTemplate(this.client.getWorkspace());
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("id", "cmis:document");
        IRI typeByIdRequest = typeByIdTemplate.generateUri(variables);
        Entry typeById = this.client.getEntry(typeByIdRequest);
        Assert.assertNotNull((Object)typeById);
        CMISTypeDefinition typeDef = (CMISTypeDefinition)typeById.getExtension(CMISConstants.TYPE_DEFINITION);
        Assert.assertNotNull((Object)typeDef);
        Assert.assertEquals((Object)"cmis:document", (Object)typeDef.getId());
    }
}

