/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.test.mock;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.shale.test.mock.MockApplicationMap;
import org.apache.shale.test.mock.MockRequestMap;
import org.apache.shale.test.mock.MockSessionMap;

public class MockExternalContext
extends ExternalContext {
    private Map applicationMap = null;
    private ServletContext context = null;
    protected HttpServletRequest request = null;
    private Map requestMap = null;
    protected HttpServletResponse response = null;
    private Map sessionMap = null;
    private Map requestCookieMap = new HashMap();
    private Map requestParameterMap = new HashMap();

    public MockExternalContext(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        this.context = context;
        this.request = request;
        this.response = response;
        this.applicationMap = new MockApplicationMap(context);
        this.requestMap = new MockRequestMap(request);
    }

    public void addRequestCookieMap(Cookie cookie) {
        this.requestParameterMap.put(cookie.getName(), cookie);
    }

    public void setRequestCookieMap(Map map) {
        this.requestParameterMap = map;
    }

    public void addRequestParameterMap(String key, String value) {
        this.requestParameterMap.put(key, value);
    }

    public void setRequestParameterMap(Map map) {
        this.requestParameterMap = map;
    }

    public void dispatch(String requestURI) throws IOException, FacesException {
        throw new UnsupportedOperationException();
    }

    public String encodeActionURL(String sb) {
        return sb;
    }

    public String encodeNamespace(String aValue) {
        return aValue;
    }

    public String encodeResourceURL(String sb) {
        return sb;
    }

    public Map getApplicationMap() {
        return this.applicationMap;
    }

    public String getAuthType() {
        return this.request.getAuthType();
    }

    public Object getContext() {
        return this.context;
    }

    public String getInitParameter(String name) {
        return this.context.getInitParameter(name);
    }

    public Map getInitParameterMap() {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        Enumeration names = this.context.getInitParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            parameterMap.put(name, this.context.getInitParameter(name));
        }
        return Collections.unmodifiableMap(parameterMap);
    }

    public String getRemoteUser() {
        return this.request.getRemoteUser();
    }

    public Object getRequest() {
        return this.request;
    }

    public String getRequestContextPath() {
        return this.request.getContextPath();
    }

    public Map getRequestCookieMap() {
        return this.requestCookieMap;
    }

    public Map getRequestHeaderMap() {
        throw new UnsupportedOperationException();
    }

    public Map getRequestHeaderValuesMap() {
        throw new UnsupportedOperationException();
    }

    public Locale getRequestLocale() {
        return this.request.getLocale();
    }

    public Iterator getRequestLocales() {
        return new LocalesIterator(this.request.getLocales());
    }

    public Map getRequestMap() {
        return this.requestMap;
    }

    public Map getRequestParameterMap() {
        return this.requestParameterMap;
    }

    public Iterator getRequestParameterNames() {
        throw new UnsupportedOperationException();
    }

    public Map getRequestParameterValuesMap() {
        throw new UnsupportedOperationException();
    }

    public String getRequestPathInfo() {
        return this.request.getPathInfo();
    }

    public String getRequestServletPath() {
        return this.request.getServletPath();
    }

    public URL getResource(String path) throws MalformedURLException {
        return this.context.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        return this.context.getResourceAsStream(path);
    }

    public Set getResourcePaths(String path) {
        throw new UnsupportedOperationException();
    }

    public Object getResponse() {
        return this.response;
    }

    public Object getSession(boolean create) {
        return this.request.getSession(create);
    }

    public Map getSessionMap() {
        if (this.sessionMap == null) {
            HttpSession session = this.request.getSession(true);
            this.sessionMap = new MockSessionMap(session);
        }
        return this.sessionMap;
    }

    public Principal getUserPrincipal() {
        return this.request.getUserPrincipal();
    }

    public boolean isUserInRole(String role) {
        return this.request.isUserInRole(role);
    }

    public void log(String message) {
        this.context.log(message);
    }

    public void log(String message, Throwable throwable) {
        this.context.log(message, throwable);
    }

    public void redirect(String requestURI) throws IOException {
        throw new UnsupportedOperationException();
    }

    private class LocalesIterator
    implements Iterator {
        private Enumeration locales;

        public LocalesIterator(Enumeration locales) {
            this.locales = locales;
        }

        public boolean hasNext() {
            return this.locales.hasMoreElements();
        }

        public Object next() {
            return this.locales.nextElement();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

