/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.LRUMap;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;

public class SoftCache {
    private final LRUMap map;
    private final ReferenceQueue queue = new ReferenceQueue();

    public SoftCache() {
        this.map = new LRUMap();
    }

    public SoftCache(int initialSize, int maxSize) {
        this.map = new LRUMap(initialSize, maxSize);
    }

    public synchronized Object put(Object key, Object value) {
        if (key == null || value == null) {
            throw new IllegalArgumentException("Key and value must not be null");
        }
        this.ProcessQueue();
        SoftMapEntry obj = this.map.put(key, new SoftMapEntry(key, value, this.queue));
        return obj;
    }

    public synchronized Object get(Object key) {
        this.ProcessQueue();
        Object obj = null;
        SoftMapEntry entry = (SoftMapEntry)this.map.get(key);
        if (entry != null && (obj = entry.get()) == null) {
            this.map.remove(key);
        }
        return obj;
    }

    public synchronized Object remove(Object key) {
        return this.map.remove(key);
    }

    public synchronized void clear() {
        this.ProcessQueue();
        this.map.clear();
    }

    private void ProcessQueue() {
        SoftMapEntry entry;
        while ((entry = (SoftMapEntry)this.queue.poll()) != null) {
            this.map.remove(entry.getKey());
        }
    }

    private static class SoftMapEntry
    extends SoftReference {
        private final Object key;

        private SoftMapEntry(Object key, Object value, ReferenceQueue queue) {
            super(value, queue);
            this.key = key;
        }

        private Object getKey() {
            return this.key;
        }
    }
}

