/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.model;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import org.jibx.binding.model.BindingElement;
import org.jibx.binding.model.BindingHolder;
import org.jibx.binding.model.IncludeElement;
import org.jibx.binding.model.NamespaceElement;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallable;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.util.InsertionOrderedMap;

public class BindingDirectory {
    private final boolean m_forceClasses;
    private final boolean m_trackSource;
    private final boolean m_addConstructors;
    private final boolean m_inBinding;
    private final boolean m_outBinding;
    private final InsertionOrderedMap m_uriBindingMap;
    static /* synthetic */ Class class$org$jibx$binding$model$BindingElement;

    public BindingDirectory(boolean force, boolean track, boolean addcon, boolean in, boolean out) {
        this.m_forceClasses = force;
        this.m_trackSource = track;
        this.m_addConstructors = addcon;
        this.m_inBinding = in;
        this.m_outBinding = out;
        this.m_uriBindingMap = new InsertionOrderedMap();
    }

    public BindingHolder findBinding(String uri) {
        BindingHolder hold = (BindingHolder)this.m_uriBindingMap.get(uri);
        if (hold == null) {
            hold = new BindingHolder(uri, this.m_uriBindingMap.size() + 1, this);
            this.m_uriBindingMap.put(uri, hold);
            BindingElement binding = hold.getBinding();
            binding.setForceClasses(this.m_forceClasses);
            binding.setTrackSource(this.m_trackSource);
            binding.setAddConstructors(this.m_addConstructors);
            binding.setInBinding(this.m_inBinding);
            binding.setOutBinding(this.m_outBinding);
        }
        return hold;
    }

    public static boolean isEqual(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    public void addDependency(String uri, BindingHolder hold) {
        if (!BindingDirectory.isEqual(uri, hold.getNamespace())) {
            BindingHolder tohold = this.findBinding(uri);
            hold.addReference(tohold);
        }
    }

    public void finish() {
        ArrayList uris = this.getNamespaces();
        for (int i = 0; i < uris.size(); ++i) {
            String uri = (String)uris.get(i);
            BindingHolder holder = (BindingHolder)this.m_uriBindingMap.get(uri);
            holder.finish();
        }
    }

    public BindingHolder getBinding(String uri) {
        return (BindingHolder)this.m_uriBindingMap.get(uri);
    }

    public ArrayList getNamespaces() {
        return this.m_uriBindingMap.keyList();
    }

    private void addNamespaceDeclarations(String[] adduris, BindingElement binding) {
        int offset = -1;
        int nsnum = this.m_uriBindingMap.size();
        for (int i = 0; i < adduris.length; ++i) {
            String adduri = adduris[i];
            if (this.m_uriBindingMap.containsKey(adduri)) continue;
            ArrayList childs = binding.topChildren();
            if (offset < 0) {
                while (++offset < childs.size() && childs.get(offset) instanceof NamespaceElement) {
                }
            }
            NamespaceElement ns = new NamespaceElement();
            ns.setDefaultName("none");
            ns.setUri(adduri);
            ns.setPrefix("ns" + ++nsnum);
            childs.add(offset++, ns);
        }
    }

    private static boolean isAsciiAlpha(char chr) {
        return chr >= 'a' && chr <= 'z' || chr >= 'A' && chr <= 'Z';
    }

    private static boolean isAsciiNum(char chr) {
        return chr >= '0' && chr <= '9';
    }

    private static boolean isAsciiAlphaNum(char chr) {
        return BindingDirectory.isAsciiAlpha(chr) || BindingDirectory.isAsciiNum(chr);
    }

    public BindingHolder configureFiles(String name, String[] adduris, String pack) {
        BindingElement root;
        BindingHolder rhold;
        ArrayList uris = this.getNamespaces();
        if (uris.size() == 1) {
            rhold = (BindingHolder)this.m_uriBindingMap.get(uris.get(0));
            root = rhold.getBinding();
        } else {
            rhold = this.findBinding(null);
            root = rhold.getBinding();
            HashSet<String> nameset = new HashSet<String>();
            for (int i = 0; i < uris.size(); ++i) {
                String bindname;
                String uri = (String)uris.get(i);
                BindingHolder holder = (BindingHolder)this.m_uriBindingMap.get(uri);
                if (holder == rhold) continue;
                String raw = holder.getNamespace();
                if (raw == null) {
                    bindname = "nonamespaceBinding";
                } else {
                    int split = (raw = raw.replace('\\', '/')).indexOf("://");
                    if (split >= 0) {
                        raw = raw.substring(split + 3);
                    }
                    while (raw.endsWith("/")) {
                        raw = raw.substring(0, raw.length() - 1);
                    }
                    split = raw.indexOf(47);
                    if (split > 0 && raw.substring(0, split).indexOf(46) > 0) {
                        raw = raw.substring(split + 1);
                    }
                    StringBuffer buff = new StringBuffer();
                    int index = 0;
                    char chr = raw.charAt(0);
                    if (BindingDirectory.isAsciiAlpha(chr)) {
                        buff.append(chr);
                        index = 1;
                    } else {
                        buff.append('_');
                    }
                    boolean toupper = false;
                    while (index < raw.length()) {
                        if (BindingDirectory.isAsciiAlphaNum(chr = raw.charAt(index++))) {
                            if (toupper) {
                                chr = Character.toUpperCase(chr);
                                toupper = false;
                            }
                            buff.append(chr);
                            continue;
                        }
                        if (chr != '.') continue;
                        toupper = true;
                    }
                    buff.append("Binding");
                    bindname = buff.toString();
                }
                String uname = bindname.toLowerCase();
                int pass = 0;
                while (nameset.contains(uname)) {
                    bindname = bindname + pass;
                    uname = bindname.toLowerCase();
                }
                nameset.add(uname);
                holder.setFileName(bindname + ".xml");
                IncludeElement include = new IncludeElement();
                include.setIncludePath(holder.getFileName());
                rhold.addInclude(include);
            }
        }
        this.addNamespaceDeclarations(adduris, root);
        rhold.setFileName(name);
        int split = name.lastIndexOf(46);
        if (split > 0) {
            root.setName(name.substring(0, split));
        } else {
            root.setName(name);
        }
        root.setTargetPackage(pack);
        return rhold;
    }

    public void writeBindings(File dir) throws JiBXException, IOException {
        this.finish();
        IBindingFactory fact = org.jibx.runtime.BindingDirectory.getFactory(class$org$jibx$binding$model$BindingElement == null ? (class$org$jibx$binding$model$BindingElement = BindingDirectory.class$("org.jibx.binding.model.BindingElement")) : class$org$jibx$binding$model$BindingElement);
        IMarshallingContext ictx = fact.createMarshallingContext();
        ictx.setIndent(2);
        ArrayList uris = this.getNamespaces();
        for (int i = 0; i < uris.size(); ++i) {
            String uri = (String)uris.get(i);
            BindingHolder holder = (BindingHolder)this.m_uriBindingMap.get(uri);
            File file = new File(dir, holder.getFileName());
            ictx.setOutput(new FileOutputStream(file), null);
            ((IMarshallable)holder.getBinding()).marshal(ictx);
            ictx.getXmlWriter().flush();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

