/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.crypto.io.swing;

import de.schlichtherle.swing.EnhancedPanel;
import de.schlichtherle.swing.event.PanelEvent;
import de.schlichtherle.swing.event.PanelListener;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

public class PasswdOrFilePanel
extends JPanel {
    private static final String BUNDLE_NAME = "de/schlichtherle/crypto/io/swing/PasswdOrFilePanel";
    private static SoftReference fileChooser;
    private static File currentDirCache;
    private final ResourceBundle resources = ResourceBundle.getBundle("de/schlichtherle/crypto/io/swing/PasswdOrFilePanel");
    private JPanel cardPanel;
    private EnhancedPanel filePanel;
    public final JTextField pathname = new JTextField();
    private JLabel pathnameLabel;
    public final JToggleButton useKeyFile = new JToggleButton();

    static JFileChooser getFileChooser() {
        JFileChooser jFileChooser;
        SoftReference softReference = fileChooser;
        JFileChooser jFileChooser2 = jFileChooser = softReference != null ? (JFileChooser)softReference.get() : null;
        if (jFileChooser == null) {
            jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle(ResourceBundle.getBundle(BUNDLE_NAME).getString("fileChooser.title"));
            jFileChooser.setFileHidingEnabled(false);
            if (currentDirCache != null) {
                jFileChooser.setCurrentDirectory(currentDirCache);
            }
            fileChooser = new SoftReference<JFileChooser>(jFileChooser);
        }
        return jFileChooser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int readKey(String string, byte[] byArray) throws IOException {
        int n = 0;
        FileInputStream fileInputStream = new FileInputStream(string);
        try {
            int n2;
            do {
                if ((n2 = ((InputStream)fileInputStream).read(byArray, n, byArray.length - n)) >= 0) continue;
                break;
            } while ((n += n2) < byArray.length);
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
        return n;
    }

    public static char[] PKCS12BytesToChars(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2 >>>= 1];
        for (int i = 0; i < n2; ++i) {
            cArray[i] = (char)(byArray[n++] << 8 | byArray[n++] & 0xFF);
        }
        return cArray;
    }

    public PasswdOrFilePanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.cardPanel = new JPanel();
        this.filePanel = new EnhancedPanel();
        this.pathnameLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.cardPanel.setLayout(new CardLayout());
        this.filePanel.setLayout(new GridBagLayout());
        this.filePanel.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                PasswdOrFilePanel.this.filePanelComponentShown(componentEvent);
            }
        });
        this.filePanel.addPanelListener(new PanelListener(){

            public void ancestorWindowShown(PanelEvent panelEvent) {
                PasswdOrFilePanel.this.filePanelAncestorWindowShown(panelEvent);
            }

            public void ancestorWindowHidden(PanelEvent panelEvent) {
            }
        });
        this.pathnameLabel.setLabelFor(this.pathname);
        this.pathnameLabel.setText(this.resources.getString("pathnameLabel"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.filePanel.add((Component)this.pathnameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.filePanel.add((Component)this.pathname, gridBagConstraints);
        this.cardPanel.add((Component)this.filePanel, "file");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.cardPanel, gridBagConstraints);
        this.useKeyFile.setText(this.resources.getString("useKeyFile.yes"));
        this.useKeyFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PasswdOrFilePanel.this.useKeyFileActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.useKeyFile, gridBagConstraints);
    }

    private void filePanelAncestorWindowShown(PanelEvent panelEvent) {
        this.pathname.requestFocusInWindow();
        this.pathname.selectAll();
    }

    private void filePanelComponentShown(ComponentEvent componentEvent) {
        this.filePanelAncestorWindowShown(null);
    }

    public void setPasswdPanel(JPanel jPanel) {
        if (jPanel == null) {
            throw new NullPointerException();
        }
        this.cardPanel.add((Component)jPanel, "passwd");
        this.useKeyFileActionPerformed(null);
    }

    private void useKeyFileActionPerformed(ActionEvent actionEvent) {
        CardLayout cardLayout = (CardLayout)this.cardPanel.getLayout();
        if (this.useKeyFile.isSelected()) {
            cardLayout.show(this.cardPanel, "file");
            JFileChooser jFileChooser = PasswdOrFilePanel.getFileChooser();
            if (jFileChooser.showOpenDialog(this.getWindow()) == 0) {
                String string = jFileChooser.getSelectedFile().getPath();
                if (!this.pathname.getText().equals(string)) {
                    this.pathname.setText(string);
                }
                this.useKeyFile.setText(this.resources.getString("useKeyFile.no"));
            } else {
                this.useKeyFile.setSelected(false);
                cardLayout.show(this.cardPanel, "passwd");
            }
            currentDirCache = jFileChooser.getCurrentDirectory();
        } else {
            this.useKeyFile.setText(this.resources.getString("useKeyFile.yes"));
            cardLayout.show(this.cardPanel, "passwd");
        }
    }

    private Window getWindow() {
        return PasswdOrFilePanel.getWindow(this);
    }

    static final Window getWindow(Container container) {
        while (container != null && !(container instanceof Window)) {
            container = container.getParent();
        }
        return (Window)container;
    }
}

