/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.crypto.io.swing;

import de.schlichtherle.crypto.io.RandomAccessEncryptionSpecification;
import de.schlichtherle.crypto.io.swing.PasswdOrFilePanel;
import de.schlichtherle.crypto.io.swing.SwingPasswdManager;
import de.schlichtherle.swing.EnhancedPanel;
import de.schlichtherle.swing.event.PanelEvent;
import de.schlichtherle.swing.event.PanelListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class PasswdPanel
extends EnhancedPanel
implements RandomAccessEncryptionSpecification {
    private final ResourceBundle resources = ResourceBundle.getBundle("de/schlichtherle/crypto/io/swing/PasswdPanel");
    private final Color defaultForeground;
    private JCheckBox changePasswdRequested;
    private JLabel error;
    private JPasswordField passwd;
    private JLabel passwdLong;
    private PasswdOrFilePanel passwdOrFilePanel;
    private EnhancedPanel passwdPanel;
    private JLabel passwdShort;
    private static JTextPane pathname;

    public PasswdPanel() {
        this.initComponents();
        this.defaultForeground = pathname.getForeground();
        DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                PasswdPanel.this.setError(null);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                PasswdPanel.this.setError(null);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                PasswdPanel.this.setError(null);
            }
        };
        this.passwd.getDocument().addDocumentListener(documentListener);
        this.passwdOrFilePanel.pathname.getDocument().addDocumentListener(documentListener);
    }

    private void initComponents() {
        this.passwdPanel = new EnhancedPanel();
        this.passwdShort = new JLabel();
        this.passwd = new JPasswordField();
        this.passwdLong = new JLabel();
        pathname = new JTextPane();
        this.passwdOrFilePanel = new PasswdOrFilePanel();
        this.changePasswdRequested = new JCheckBox();
        this.error = new JLabel();
        this.passwdPanel.setLayout(new GridBagLayout());
        this.passwdPanel.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                PasswdPanel.this.passwdPanelComponentShown(componentEvent);
            }
        });
        this.passwdPanel.addPanelListener(new PanelListener(){

            public void ancestorWindowShown(PanelEvent panelEvent) {
                PasswdPanel.this.passwdPanelAncestorWindowShown(panelEvent);
            }

            public void ancestorWindowHidden(PanelEvent panelEvent) {
            }
        });
        this.passwdShort.setLabelFor(this.passwd);
        this.passwdShort.setText(this.resources.getString("passwdShort"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.passwdPanel.add((Component)this.passwdShort, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.passwdPanel.add((Component)this.passwd, gridBagConstraints);
        this.setLayout(new GridBagLayout());
        this.passwdLong.setLabelFor(pathname);
        this.passwdLong.setText(this.resources.getString("passwdLong"));
        this.passwdLong.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.passwdLong, gridBagConstraints);
        pathname.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        pathname.setEditable(false);
        pathname.setFont(this.getBoldFont());
        pathname.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 15, 0);
        this.add((Component)pathname, gridBagConstraints);
        this.passwdOrFilePanel.setPasswdPanel(this.passwdPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.add((Component)this.passwdOrFilePanel, gridBagConstraints);
        this.changePasswdRequested.setText(this.resources.getString("changePasswdRequested"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.add((Component)this.changePasswdRequested, gridBagConstraints);
        this.error.setForeground(Color.red);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.add((Component)this.error, gridBagConstraints);
    }

    private void passwdPanelAncestorWindowShown(PanelEvent panelEvent) {
        this.passwd.requestFocusInWindow();
        this.passwd.selectAll();
    }

    private void passwdPanelComponentShown(ComponentEvent componentEvent) {
        this.passwdPanelAncestorWindowShown(null);
    }

    private Font getBoldFont() {
        Font font = pathname.getFont();
        return new Font(font.getName(), 1, font.getSize());
    }

    public void setPathname(String string) {
        String string2 = SwingPasswdManager.lastPathname;
        if (string2 == null) {
            string2 = "";
        }
        if (!"".equals(string2) && !string2.equals(string)) {
            pathname.setForeground(Color.RED);
        } else {
            pathname.setForeground(this.defaultForeground);
        }
        pathname.setText(string);
    }

    public String getPathname() {
        return pathname.getText();
    }

    public char[] getPasswd() {
        if (this.passwdOrFilePanel.useKeyFile.isSelected()) {
            int n;
            byte[] byArray = new byte[512];
            try {
                Document document = this.passwdOrFilePanel.pathname.getDocument();
                n = PasswdOrFilePanel.readKey(document.getText(0, document.getLength()), byArray);
            }
            catch (BadLocationException badLocationException) {
                throw new AssertionError((Object)badLocationException);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.setError(this.resources.getString("keyFile.fileNotFoundException"));
                return null;
            }
            catch (IOException iOException) {
                this.setError(this.resources.getString("keyFile.ioException"));
                return null;
            }
            return PasswdOrFilePanel.PKCS12BytesToChars(byArray, 0, n);
        }
        return this.passwd.getPassword();
    }

    public void setChangePasswdRequested(boolean bl) {
        this.changePasswdRequested.setSelected(bl);
    }

    public boolean isChangePasswdRequested() {
        return this.changePasswdRequested.isSelected();
    }

    public void setError(String string) {
        this.error.setText(string);
    }
}

