/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.crypto.io.swing;

import de.schlichtherle.crypto.io.PasswdManager;
import de.schlichtherle.crypto.io.swing.NewPasswdPanel;
import de.schlichtherle.crypto.io.swing.PasswdPanel;
import java.awt.Toolkit;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class SwingPasswdManager
extends PasswdManager {
    static String lastPathname;
    private final ResourceBundle resources = ResourceBundle.getBundle("de/schlichtherle/crypto/io/swing/SwingPasswdManager");
    private PasswdPanel passwdPanel;
    private NewPasswdPanel newPasswdPanel;

    protected PasswdPanel getPasswdPanel() {
        if (this.passwdPanel == null) {
            this.passwdPanel = new PasswdPanel();
        }
        return this.passwdPanel;
    }

    protected NewPasswdPanel getNewPasswdPanel() {
        if (this.newPasswdPanel == null) {
            this.newPasswdPanel = new NewPasswdPanel();
        }
        return this.newPasswdPanel;
    }

    protected void passwdUnknown(PasswdManager.Parameters parameters) {
        PasswdPanel passwdPanel = this.getPasswdPanel();
        passwdPanel.setChangePasswdRequested(false);
        passwdPanel.setError(null);
    }

    protected void passwdWrong(PasswdManager.Parameters parameters) {
        this.getPasswdPanel().setError(this.resources.getString("passwdWrong"));
    }

    protected void promptParameters(final PasswdManager.Parameters parameters) {
        final PasswdPanel passwdPanel = this.getPasswdPanel();
        passwdPanel.setPathname(parameters.getResourceId());
        lastPathname = parameters.getResourceId();
        Thread.currentThread();
        Thread.interrupted();
        final Window window = SwingPasswdManager.getParentWindow();
        Runnable runnable = new Runnable(){

            public void run() {
                Toolkit.getDefaultToolkit().beep();
                int n = JOptionPane.showConfirmDialog(window, passwdPanel, SwingPasswdManager.this.resources.getString("passwdDialog.title"), 2, 3);
                if (!window.isVisible()) {
                    window.dispose();
                }
                if (n == 0) {
                    char[] cArray = passwdPanel.getPasswd();
                    SwingPasswdManager.nullify(parameters.passwd);
                    if (cArray != null) {
                        parameters.passwd = cArray;
                        parameters.promptNewPasswd = passwdPanel.isChangePasswdRequested();
                        parameters.promptPasswd = false;
                    } else {
                        parameters.passwd = null;
                        parameters.promptPasswd = true;
                    }
                } else {
                    parameters.passwd = null;
                    parameters.promptPasswd = false;
                }
            }
        };
        try {
            do {
                if (SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                    continue;
                }
                SwingUtilities.invokeAndWait(runnable);
            } while (parameters.promptPasswd);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new AssertionError((Object)invocationTargetException);
        }
    }

    protected void promptNewParameters(final PasswdManager.Parameters parameters) {
        final NewPasswdPanel newPasswdPanel = this.getNewPasswdPanel();
        newPasswdPanel.setPathname(parameters.getResourceId());
        lastPathname = parameters.getResourceId();
        if (parameters.keyStrength != -1) {
            newPasswdPanel.setKeyStrength(parameters.keyStrength);
        }
        newPasswdPanel.resetNewPasswd();
        newPasswdPanel.setError(null);
        final Window window = SwingPasswdManager.getParentWindow();
        Runnable runnable = new Runnable(){

            public void run() {
                Toolkit.getDefaultToolkit().beep();
                int n = JOptionPane.showConfirmDialog(window, newPasswdPanel, SwingPasswdManager.this.resources.getString("newPasswdDialog.title"), 2, 3);
                if (!window.isVisible()) {
                    window.dispose();
                }
                if (n == 0) {
                    char[] cArray = newPasswdPanel.getNewPasswd();
                    if (cArray != null) {
                        SwingPasswdManager.nullify(parameters.passwd);
                        parameters.passwd = cArray;
                        parameters.keyStrength = newPasswdPanel.getKeyStrength();
                        parameters.promptNewPasswd = false;
                    } else {
                        parameters.promptNewPasswd = true;
                    }
                } else {
                    parameters.promptNewPasswd = false;
                }
            }
        };
        try {
            do {
                if (SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                    continue;
                }
                SwingUtilities.invokeAndWait(runnable);
            } while (parameters.promptNewPasswd);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new AssertionError((Object)invocationTargetException);
        }
    }

    static void nullify(char[] cArray) {
        if (cArray != null) {
            Arrays.fill(cArray, '\u0000');
        }
    }

    static {
        Logger.getLogger("de.schlichtherle.crypto.io.swing.SwingPasswdManager").config("TrueZIP 5.1.1");
    }
}

