/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io;

import de.schlichtherle.io.File;
import de.schlichtherle.io.FileBusyException;
import de.schlichtherle.io.ZipBusyException;
import de.schlichtherle.io.ZipController;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileInputStream
extends FilterInputStream {
    private static InputStream createInputStream(java.io.File file) throws FileNotFoundException {
        if (file instanceof File) {
            File file2 = (File)file;
            if (file2.isZipFile() && (file2.isDirectory() || file2.exists() && !file2.isFile())) {
                throw new FileNotFoundException(file.getPath() + ": Cannot read (possibly inaccessible) ZIP compatible files!");
            }
            String string = file2.getEnclZipEntryName();
            if (string != null) {
                return FileInputStream.createInputStream(file2.getEnclZipFile().getZipController(), string, file2);
            }
        }
        return new java.io.FileInputStream(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InputStream createInputStream(ZipController zipController, String string, File file) throws FileNotFoundException {
        try {
            ZipController zipController2 = zipController;
            synchronized (zipController2) {
                return zipController.getInputStream(string);
            }
        }
        catch (ZipController.FalsePositiveEntryException falsePositiveEntryException) {
            return FileInputStream.createInputStream(zipController.enclController, File.catEntryName(zipController, string), file);
        }
        catch (ZipController.FalsePositiveNativeException falsePositiveNativeException) {
            return new java.io.FileInputStream(file);
        }
        catch (ZipBusyException zipBusyException) {
            throw new FileBusyException(file, zipBusyException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            FileNotFoundException fileNotFoundException = new FileNotFoundException(file.getPath());
            fileNotFoundException.initCause(iOException);
            throw fileNotFoundException;
        }
    }

    public FileInputStream(String string) throws FileNotFoundException {
        super(FileInputStream.createInputStream(File.getDefaultZipDetector().createFile(string)));
    }

    public FileInputStream(java.io.File file) throws FileNotFoundException {
        super(FileInputStream.createInputStream(file));
    }

    public int read(byte[] byArray) throws IOException {
        return this.in.read(byArray, 0, byArray.length);
    }
}

